/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text;

import clover.com.lowagie.text.Chunk;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.Element;
import clover.com.lowagie.text.ElementListener;
import clover.com.lowagie.text.MarkupAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class Rectangle
implements Element,
MarkupAttributes {
    public static final int UNDEFINED = -1;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int NO_BORDER = 0;
    public static final int BOX = 15;
    protected float llx;
    protected float lly;
    protected float urx;
    protected float ury;
    protected int border = -1;
    protected float borderWidth = -1.0f;
    protected Color color = null;
    protected Color background = null;
    protected float grayFill = 0.0f;
    protected int rotation = 0;
    protected Properties markupAttributes;

    public Rectangle(float f, float f2, float f3, float f4) {
        this.llx = f;
        this.lly = f2;
        this.urx = f3;
        this.ury = f4;
    }

    public Rectangle(float f, float f2) {
        this(0.0f, 0.0f, f, f2);
    }

    public Rectangle(Rectangle rectangle) {
        this(rectangle.left(), rectangle.bottom(), rectangle.right(), rectangle.top());
        this.llx = rectangle.llx;
        this.lly = rectangle.lly;
        this.urx = rectangle.urx;
        this.ury = rectangle.ury;
        this.rotation = rectangle.rotation;
        this.border = rectangle.border;
        this.borderWidth = rectangle.borderWidth;
        this.color = rectangle.color;
        this.background = rectangle.background;
        this.grayFill = rectangle.grayFill;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 30;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public Rectangle rectangle(float f, float f2) {
        Rectangle rectangle = new Rectangle(this);
        rectangle.setBorder(this.border);
        rectangle.setBorderWidth(this.borderWidth);
        rectangle.setBorderColor(this.color);
        rectangle.setBackgroundColor(this.background);
        rectangle.setGrayFill(this.grayFill);
        if (this.top() > f) {
            rectangle.setTop(f);
            rectangle.setBorder(this.border - (this.border & 1));
        }
        if (this.bottom() < f2) {
            rectangle.setBottom(f2);
            rectangle.setBorder(this.border - (this.border & 2));
        }
        return rectangle;
    }

    public Rectangle rotate() {
        Rectangle rectangle = new Rectangle(this.lly, this.llx, this.ury, this.urx);
        rectangle.rotation = this.rotation + 90;
        rectangle.rotation %= 360;
        return rectangle;
    }

    public void setLeft(float f) {
        this.llx = f;
    }

    public void setRight(float f) {
        this.urx = f;
    }

    public void setTop(float f) {
        this.ury = f;
    }

    public void setBottom(float f) {
        this.lly = f;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setBorderWidth(float f) {
        this.borderWidth = f;
    }

    public void setBorderColor(Color color) {
        this.color = color;
    }

    public void setBackgroundColor(Color color) {
        this.background = color;
    }

    public void setGrayFill(float f) {
        if (f >= 0.0f && (double)f <= 1.0) {
            this.grayFill = f;
        }
    }

    public float left() {
        return this.llx;
    }

    public float right() {
        return this.urx;
    }

    public float top() {
        return this.ury;
    }

    public float bottom() {
        return this.lly;
    }

    public float left(float f) {
        return this.llx + f;
    }

    public float right(float f) {
        return this.urx - f;
    }

    public float top(float f) {
        return this.ury - f;
    }

    public float bottom(float f) {
        return this.lly + f;
    }

    public float width() {
        return this.urx - this.llx;
    }

    public float height() {
        return this.ury - this.lly;
    }

    public boolean hasBorders() {
        return this.border > 0 && this.borderWidth > 0.0f;
    }

    public boolean hasBorder(int n) {
        return this.border != -1 && (this.border & n) == n;
    }

    public int border() {
        return this.border;
    }

    public float borderWidth() {
        return this.borderWidth;
    }

    public Color borderColor() {
        return this.color;
    }

    public Color backgroundColor() {
        return this.background;
    }

    public float grayFill() {
        return this.grayFill;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        ((Hashtable)this.markupAttributes).put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(((Hashtable)this.markupAttributes).get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

