/*
 * Decompiled with CFR 0.152.
 */
package clover.cenqua_com_licensing.atlassian.time.convert;

import clover.cenqua_com_licensing.atlassian.time.Chronology;
import clover.cenqua_com_licensing.atlassian.time.DateTimeZone;
import clover.cenqua_com_licensing.atlassian.time.chrono.BuddhistChronology;
import clover.cenqua_com_licensing.atlassian.time.chrono.GJChronology;
import clover.cenqua_com_licensing.atlassian.time.chrono.GregorianChronology;
import clover.cenqua_com_licensing.atlassian.time.chrono.ISOChronology;
import clover.cenqua_com_licensing.atlassian.time.chrono.JulianChronology;
import clover.cenqua_com_licensing.atlassian.time.convert.AbstractConverter;
import clover.cenqua_com_licensing.atlassian.time.convert.InstantConverter;
import clover.cenqua_com_licensing.atlassian.time.convert.PartialConverter;
import java.util.Calendar;
import java.util.GregorianCalendar;

final class CalendarConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final CalendarConverter INSTANCE = new CalendarConverter();
    static /* synthetic */ Class class$java$util$Calendar;

    protected CalendarConverter() {
    }

    public Chronology getChronology(Object object, Chronology chronology) {
        if (chronology != null) {
            return chronology;
        }
        Calendar calendar = (Calendar)object;
        DateTimeZone dateTimeZone = null;
        try {
            dateTimeZone = DateTimeZone.forTimeZone(calendar.getTimeZone());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        return this.getChronology((Object)calendar, dateTimeZone);
    }

    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        if (object.getClass().getName().endsWith(".BuddhistCalendar")) {
            return BuddhistChronology.getInstance(dateTimeZone);
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            long l = gregorianCalendar.getGregorianChange().getTime();
            if (l == Long.MIN_VALUE) {
                return GregorianChronology.getInstance(dateTimeZone);
            }
            if (l == Long.MAX_VALUE) {
                return JulianChronology.getInstance(dateTimeZone);
            }
            return GJChronology.getInstance(dateTimeZone, l, 4);
        }
        return ISOChronology.getInstance(dateTimeZone);
    }

    public long getInstantMillis(Object object, Chronology chronology) {
        Calendar calendar = (Calendar)object;
        return calendar.getTime().getTime();
    }

    public Class getSupportedType() {
        return class$java$util$Calendar == null ? (class$java$util$Calendar = CalendarConverter.class$("java.util.Calendar")) : class$java$util$Calendar;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

