/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.ImmutableMap;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavadocTagInfo {
    AUTHOR("@author", "author", Type.BLOCK, true, true){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157;
        }
    }
    ,
    CODE("{@code}", "code", Type.INLINE, true, true){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(aAst);
        }
    }
    ,
    DOC_ROOT("{@docRoot}", "docRoot", Type.INLINE, true, true){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(aAst);
        }
    }
    ,
    DEPRECATED("@deprecated", "deprecated", Type.BLOCK, false, false){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 155 || type == 161 || type == 10 && !ScopeUtils.isLocalVariableDef(aAst);
        }
    }
    ,
    EXCEPTION("@exception", "exception", Type.BLOCK, false, false){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 9 || type == 8;
        }
    }
    ,
    INHERIT_DOC("{@inheritDoc}", "inheritDoc", Type.INLINE, false, false){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 9 && !aAst.branchContains(64) && ScopeUtils.getScopeFromMods(aAst.findFirstToken(5)) != Scope.PRIVATE;
        }
    }
    ,
    LINK("{@link}", "link", Type.INLINE, true, true){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(aAst);
        }
    }
    ,
    LINKPLAIN("{@linkplain}", "linkplain", Type.INLINE, true, true){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(aAst);
        }
    }
    ,
    LITERAL("{@literal}", "literal", Type.INLINE, true, true){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(aAst);
        }
    }
    ,
    PARAM("@param", "param", Type.BLOCK, false, false){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 14 || type == 15 || type == 9 || type == 8;
        }
    }
    ,
    RETURN("@return", "return", Type.BLOCK, false, false){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            DetailAST returnType = aAst.findFirstToken(13);
            return type == 9 && returnType.getFirstChild().getType() != 49;
        }
    }
    ,
    SEE("@see", "see", Type.BLOCK, true, true){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(aAst);
        }
    }
    ,
    SERIAL("@serial", "serial", Type.BLOCK, true, false){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 10 && !ScopeUtils.isLocalVariableDef(aAst);
        }
    }
    ,
    SERIAL_DATA("@serialData", "serialData", Type.BLOCK, false, false){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            DetailAST methodNameAst = aAst.findFirstToken(58);
            String methodName = methodNameAst.getText();
            return type == 9 && ("writeObject".equals(methodName) || "readObject".equals(methodName) || "writeExternal".equals(methodName) || "readExternal".equals(methodName) || "writeReplace".equals(methodName) || "readResolve".equals(methodName));
        }
    }
    ,
    SERIAL_FIELD("@serialField", "serialField", Type.BLOCK, false, false){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            DetailAST varType = aAst.findFirstToken(13);
            return type == 10 && varType.getType() == 17 && "ObjectStreamField".equals(varType.getFirstChild().getText());
        }
    }
    ,
    SINCE("@since", "since", Type.BLOCK, true, true){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(aAst);
        }
    }
    ,
    THROWS("@throws", "throws", Type.BLOCK, false, false){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 9 || type == 8;
        }
    }
    ,
    VALUE("{@value}", "value", Type.INLINE, true, true){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157 || type == 9 || type == 8 || type == 10 && !ScopeUtils.isLocalVariableDef(aAst);
        }
    }
    ,
    VERSION("@version", "version", Type.BLOCK, true, true){

        public boolean isValidOn(DetailAST aAst) {
            int type = aAst.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157;
        }
    };

    private static final Map<String, JavadocTagInfo> TEXT_TO_TAG;
    private static final Map<String, JavadocTagInfo> NAME_TO_TAG;
    private final String mText;
    private final String mName;
    private final Type mType;
    private final boolean mValidInPackageHtml;
    private final boolean mValidInOverviewHtml;

    private JavadocTagInfo(String aText, String aName, Type aType, boolean aValidInPackageHtml, boolean aValidInOverviewHtml) {
        this.mText = aText;
        this.mName = aName;
        this.mType = aType;
        this.mValidInPackageHtml = aValidInPackageHtml;
        this.mValidInOverviewHtml = aValidInOverviewHtml;
    }

    public abstract boolean isValidOn(DetailAST var1);

    public boolean isValidInPackageHtml() {
        return this.mValidInPackageHtml;
    }

    public boolean isValidInOverviewHtml() {
        return this.mValidInOverviewHtml;
    }

    public String getText() {
        return this.mText;
    }

    public String getName() {
        return this.mName;
    }

    public Type getType() {
        return this.mType;
    }

    public static JavadocTagInfo fromText(String aText) {
        if (aText == null) {
            throw new NullPointerException("the text is null");
        }
        JavadocTagInfo tag = TEXT_TO_TAG.get(aText);
        if (tag == null) {
            throw new IllegalArgumentException("the text [" + aText + "] is not a valid Javadoc tag text");
        }
        return tag;
    }

    public static JavadocTagInfo fromName(String aName) {
        if (aName == null) {
            throw new NullPointerException("the name is null");
        }
        JavadocTagInfo tag = NAME_TO_TAG.get(aName);
        if (tag == null) {
            throw new IllegalArgumentException("the name [" + aName + "] is not a valid Javadoc tag name");
        }
        return tag;
    }

    public static boolean isValidName(String aName) {
        return NAME_TO_TAG.containsKey(aName);
    }

    public String toString() {
        return "text [" + this.mText + "] name [" + this.mName + "] type [" + (Object)((Object)this.mType) + "] validInPackageHtml [" + this.mValidInPackageHtml + "] validInOverviewHtml [" + this.mValidInOverviewHtml + "]";
    }

    static {
        ImmutableMap.Builder<String, JavadocTagInfo> textToTagBuilder = new ImmutableMap.Builder<String, JavadocTagInfo>();
        ImmutableMap.Builder<String, JavadocTagInfo> nameToTagBuilder = new ImmutableMap.Builder<String, JavadocTagInfo>();
        for (JavadocTagInfo tag : JavadocTagInfo.values()) {
            textToTagBuilder.put(tag.getText(), tag);
            nameToTagBuilder.put(tag.getName(), tag);
        }
        TEXT_TO_TAG = textToTagBuilder.build();
        NAME_TO_TAG = nameToTagBuilder.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BLOCK,
        INLINE;

    }
}

