/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.tracker;

import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.SourceArea;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.Enumerator;
import org.qedeq.kernel.xml.handler.common.SimpleHandler;
import org.qedeq.kernel.xml.tracker.LocationFoundException;
import org.qedeq.kernel.xml.tracker.SimpleXPath;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XPathLocationParser
extends SimpleHandler {
    private static final Class CLASS = XPathLocationParser.class;
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private final XMLReader reader;
    private final SimpleXPath find;
    private SimpleXPath current;
    private SimpleXPath summary;
    private File xmlFile;
    private final List elements;
    private int level;
    private SourcePosition startDelta;
    private SourcePosition endDelta;
    private SourcePosition start;
    private SourcePosition end;

    public static SourceArea findSourceArea(String address, SimpleXPath xpath, SourcePosition startDelta, SourcePosition endDelta, File file) {
        String method = "findSourceArea(String, SimpleXPath, SourcePosition, SourcePosition, File)";
        String message = "Could not find \"" + xpath + "\" within \"" + file + "\"";
        try {
            XPathLocationParser parser = new XPathLocationParser(xpath, startDelta, endDelta);
            parser.parse(file);
            if (parser.getStart() == null || parser.getEnd() == null) {
                Trace.fatal(CLASS, "findSourceArea(String, SimpleXPath, SourcePosition, SourcePosition, File)", message, null);
                if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("qedeq.test.xmlLocationFailures"))) {
                    throw new RuntimeException(message);
                }
                return new SourceArea(address);
            }
            return new SourceArea(address, parser.getStart(), parser.getEnd());
        }
        catch (ParserConfigurationException e) {
            Trace.fatal(CLASS, "findSourceArea(String, SimpleXPath, SourcePosition, SourcePosition, File)", message, e);
        }
        catch (SAXException e) {
            Trace.fatal(CLASS, "findSourceArea(String, SimpleXPath, SourcePosition, SourcePosition, File)", message, e);
        }
        catch (IOException e) {
            Trace.fatal(CLASS, "findSourceArea(String, SimpleXPath, SourcePosition, SourcePosition, File)", message, e);
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, "findSourceArea(String, SimpleXPath, SourcePosition, SourcePosition, File)", message, e);
        }
        return null;
    }

    public static SourceArea findSourceArea(File file, SimpleXPath xpath) {
        return XPathLocationParser.findSourceArea(file.toString(), xpath, null, null, file);
    }

    public XPathLocationParser(SimpleXPath xpath, SourcePosition startDelta, SourcePosition endDelta) throws ParserConfigurationException, SAXException {
        this.find = xpath;
        this.startDelta = startDelta;
        this.endDelta = endDelta;
        this.elements = new ArrayList(20);
        this.level = 0;
        String factoryImpl = System.getProperty("javax.xml.parsers.SAXParserFactory");
        if (factoryImpl == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        factory.setFeature(NAMESPACES_FEATURE_ID, false);
        factory.setFeature(VALIDATION_FEATURE_ID, false);
        SAXParser parser = factory.newSAXParser();
        this.reader = parser.getXMLReader();
        this.reader.setFeature(NAMESPACES_FEATURE_ID, false);
        this.reader.setFeature(VALIDATION_FEATURE_ID, false);
    }

    /*
     * Loose catch block
     */
    public final void parse(File file) throws IOException, SAXException {
        this.xmlFile = file;
        this.elements.clear();
        this.level = 0;
        FileInputStream stream = null;
        try {
            this.current = new SimpleXPath();
            this.summary = new SimpleXPath();
            this.reader.setContentHandler(this);
            stream = new FileInputStream(file);
            this.reader.parse(new InputSource(stream));
        }
        catch (LocationFoundException e) {
            IoUtility.close(stream);
        }
        catch (SAXException e2) {
            Trace.trace(CLASS, (Object)this, "parse", (Throwable)e2);
            throw e2;
            {
                catch (Throwable throwable) {
                    IoUtility.close(stream);
                    throw throwable;
                }
            }
        }
        IoUtility.close(stream);
    }

    public void endDocument() throws SAXException {
        this.elements.clear();
        this.level = 0;
    }

    public void startDocument() throws SAXException {
        this.elements.clear();
        this.level = 0;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        block19: {
            String method = "startElement(String, String, Attributes)";
            ++this.level;
            this.summary.addElement("*", this.addOccurence("*"));
            this.current.addElement(qName, this.addOccurence(qName));
            if (this.getLocator() == null) {
                throw new SAXException("Locator unexpectedly null");
            }
            if (this.find.matchesElements(this.current, this.summary)) {
                Trace.trace(CLASS, (Object)this, "startElement(String, String, Attributes)", "matching elements");
                Trace.param(CLASS, (Object)this, "startElement(String, String, Attributes)", qName, this.current);
                TextInput xml = null;
                XmlReader xmlReader = null;
                try {
                    xmlReader = new XmlReader(this.xmlFile);
                    xml = new TextInput(xmlReader);
                }
                catch (IOException io) {
                    Trace.fatal(CLASS, this, "startElement(String, String, Attributes)", "File \"" + this.xmlFile + "\" should be readable", io);
                    if (this.getLocator() == null) {
                        throw new SAXException("Locator unexpectedly null");
                    }
                    this.start = new SourcePosition(this.getLocator().getLineNumber(), this.getLocator().getColumnNumber());
                    return;
                }
                try {
                    xml.setRow(this.getLocator().getLineNumber());
                    xml.setColumn(this.getLocator().getColumnNumber());
                    if (this.startDelta != null) {
                        xml.skipWhiteSpace();
                        String cdata = "<![CDATA[";
                        String read = xml.readString("<![CDATA[".length());
                        int cdataLength = "<![CDATA[".equals(read) ? "<![CDATA[".length() : 0;
                        this.start = this.addDelta(xml, cdataLength, this.startDelta);
                        this.end = this.addDelta(xml, cdataLength, this.endDelta);
                        return;
                    }
                    try {
                        xml.skipBackToBeginOfXmlTag();
                    }
                    catch (RuntimeException e) {
                        Trace.trace(CLASS, (Object)this, "startElement(String, String, Attributes)", (Throwable)e);
                    }
                    this.start = new SourcePosition(xml.getRow(), xml.getColumn());
                    if (this.find.getAttribute() == null) break block19;
                    xml.read();
                    xml.readNextXmlName();
                    while (true) {
                        String tag;
                        xml.skipWhiteSpace();
                        int row = xml.getRow();
                        int col = xml.getColumn();
                        try {
                            tag = xml.readNextXmlName();
                        }
                        catch (IllegalArgumentException e) {
                            break;
                        }
                        if (tag.equals(this.find.getAttribute())) {
                            this.start = new SourcePosition(row, col);
                            xml.readNextAttributeValue();
                            this.end = new SourcePosition(xml.getRow(), xml.getColumn());
                            throw new LocationFoundException();
                        }
                        try {
                            xml.readNextAttributeValue();
                        }
                        catch (IllegalArgumentException e) {
                            break;
                        }
                    }
                    if (this.end == null) {
                        this.end = new SourcePosition(xml.getRow(), xml.getColumn());
                        throw new LocationFoundException();
                    }
                }
                finally {
                    IoUtility.close(xml);
                }
            }
        }
    }

    private SourcePosition addDelta(TextInput xml, int cdataLength, SourcePosition delta) {
        xml.setRow(this.getLocator().getLineNumber());
        xml.setColumn(this.getLocator().getColumnNumber());
        if (delta.getRow() == 1 && cdataLength > 0) {
            xml.addColumn(cdataLength + delta.getColumn() - 1);
        } else {
            xml.addPosition(delta);
        }
        return new SourcePosition(xml.getRow(), xml.getColumn());
    }

    private int addOccurence(String name) {
        Enumerator counter;
        while (this.level < this.elements.size()) {
            this.elements.remove(this.elements.size() - 1);
        }
        while (this.level > this.elements.size()) {
            this.elements.add(new HashMap());
        }
        Map levelMap = (Map)this.elements.get(this.level - 1);
        if (levelMap.containsKey(name)) {
            counter = (Enumerator)levelMap.get(name);
            counter.increaseNumber();
        } else {
            counter = new Enumerator(1);
            levelMap.put(name, counter);
        }
        return counter.getNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        block8: {
            String method = "endElement(String, String, Attributes)";
            --this.level;
            if (this.getLocator() == null) {
                this.current.deleteLastElement();
                this.summary.deleteLastElement();
                throw new SAXException("Locator unexpectly null");
            }
            if (!this.find.matchesElements(this.current, this.summary) || this.find.getAttribute() != null || this.startDelta != null) break block8;
            TextInput xml = null;
            XmlReader xmlReader = null;
            try {
                xmlReader = new XmlReader(this.xmlFile);
                xml = new TextInput(xmlReader);
            }
            catch (IOException io) {
                try {
                    Trace.fatal(CLASS, this, "endElement(String, String, Attributes)", "File \"" + this.xmlFile + "\" should be readable", io);
                    if (this.getLocator() == null) {
                        throw new SAXException("Locator unexpectedly null");
                    }
                    this.start = new SourcePosition(this.getLocator().getLineNumber(), this.getLocator().getColumnNumber());
                }
                catch (Throwable throwable) {
                    IoUtility.close(xmlReader);
                    throw throwable;
                }
                IoUtility.close(xmlReader);
                return;
            }
            IoUtility.close(xmlReader);
            try {
                xml.setRow(this.getLocator().getLineNumber());
                xml.setColumn(this.getLocator().getColumnNumber());
                this.end = new SourcePosition(xml.getRow(), xml.getColumn());
                throw new LocationFoundException();
            }
            catch (Throwable throwable) {
                IoUtility.close(xml);
                throw throwable;
            }
        }
        this.current.deleteLastElement();
        this.summary.deleteLastElement();
    }

    private SourcePosition getStart() {
        return this.start;
    }

    private SourcePosition getEnd() {
        return this.end;
    }
}

