/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.Enumerator;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.Author;
import org.qedeq.kernel.se.base.module.AuthorList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.Chapter;
import org.qedeq.kernel.se.base.module.ChapterList;
import org.qedeq.kernel.se.base.module.Existential;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FormalProofList;
import org.qedeq.kernel.se.base.module.Formula;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Header;
import org.qedeq.kernel.se.base.module.Import;
import org.qedeq.kernel.se.base.module.ImportList;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.Latex;
import org.qedeq.kernel.se.base.module.LatexList;
import org.qedeq.kernel.se.base.module.LinkList;
import org.qedeq.kernel.se.base.module.LiteratureItem;
import org.qedeq.kernel.se.base.module.LiteratureItemList;
import org.qedeq.kernel.se.base.module.Location;
import org.qedeq.kernel.se.base.module.LocationList;
import org.qedeq.kernel.se.base.module.ModusPonens;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proof;
import org.qedeq.kernel.se.base.module.ProofList;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.base.module.ReasonType;
import org.qedeq.kernel.se.base.module.Rename;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.Section;
import org.qedeq.kernel.se.base.module.SectionList;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.base.module.Subsection;
import org.qedeq.kernel.se.base.module.SubsectionList;
import org.qedeq.kernel.se.base.module.SubstFree;
import org.qedeq.kernel.se.base.module.SubstFunc;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.base.module.Term;
import org.qedeq.kernel.se.base.module.Universal;
import org.qedeq.kernel.se.base.module.UsedByList;
import org.qedeq.kernel.se.base.module.VariableList;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.se.visitor.QedeqNotNullTraverser;
import org.qedeq.kernel.xml.mapper.LocationFoundException;
import org.qedeq.kernel.xml.mapper.LocationNotFoundException;
import org.qedeq.kernel.xml.tracker.SimpleXPath;

public final class Context2SimpleXPath
extends AbstractModuleVisitor {
    private static final Class CLASS = Context2SimpleXPath.class;
    private QedeqNotNullTraverser traverser;
    private Qedeq qedeq;
    private final ModuleContext find;
    private SimpleXPath current;
    private final List elements;
    private int level;
    private boolean matching;
    private String matchingBegin;
    private SimpleXPath matchingPath;

    private Context2SimpleXPath(ModuleContext find, Qedeq qedeq) {
        this.qedeq = qedeq;
        this.traverser = new QedeqNotNullTraverser(find.getModuleLocation(), this);
        this.find = find;
        this.elements = new ArrayList(20);
    }

    public static SimpleXPath getXPath(ModuleContext find, Qedeq qedeq) throws ModuleDataException {
        Context2SimpleXPath converter = new Context2SimpleXPath(find, qedeq);
        return converter.find();
    }

    private final SimpleXPath find() throws ModuleDataException {
        String method = "find()";
        Trace.paramInfo(CLASS, (Object)this, "find()", "find", this.find);
        this.elements.clear();
        this.level = 0;
        this.current = new SimpleXPath();
        try {
            this.traverser.accept(this.qedeq);
        }
        catch (LocationFoundException e) {
            Trace.paramInfo(CLASS, (Object)this, "find()", "location found", this.current);
            return this.current;
        }
        Trace.param(CLASS, (Object)this, "find()", "level", this.level);
        Trace.info(CLASS, this, "find()", "location was not found");
        throw new LocationNotFoundException(this.find, "");
    }

    public final void visitEnter(Qedeq qedeq) throws ModuleDataException {
        this.enter("QEDEQ");
        String method = "visitEnter(Qedeq)";
        Trace.param(CLASS, (Object)this, "visitEnter(Qedeq)", "current", this.current);
        this.checkMatching("visitEnter(Qedeq)");
    }

    public final void visitLeave(Qedeq qedeq) {
        this.leave();
    }

    public final void visitEnter(Header header) throws ModuleDataException {
        this.enter("HEADER");
        String method = "visitEnter(Header)";
        Trace.param(CLASS, (Object)this, "visitEnter(Header)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Header)");
        this.traverser.setLocationWithinModule(context + ".getEmail()");
        this.current.setAttribute("email");
        this.checkIfFound();
    }

    public final void visitLeave(Header header) {
        this.leave();
    }

    public final void visitEnter(Specification specification) throws ModuleDataException {
        this.enter("SPECIFICATION");
        String method = "visitEnter(Specification)";
        Trace.param(CLASS, (Object)this, "visitEnter(Specification)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Specification)");
        this.traverser.setLocationWithinModule(context + ".getName()");
        this.current.setAttribute("name");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getRuleVersion()");
        this.current.setAttribute("ruleVersion");
        this.checkIfFound();
    }

    public final void visitLeave(Specification specification) {
        this.leave();
    }

    public final void visitEnter(LatexList latexList) throws ModuleDataException {
        String name;
        String method = "visitEnter(LatexList)";
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (context.endsWith(".getTitle()")) {
            name = "TITLE";
        } else if (context.endsWith(".getSummary()")) {
            name = "ABSTRACT";
        } else if (context.endsWith(".getIntroduction()")) {
            name = "INTRODUCTION";
        } else if (context.endsWith(".getName()")) {
            name = "NAME";
        } else if (context.endsWith(".getPrecedingText()")) {
            name = "PRECEDING";
        } else if (context.endsWith(".getSucceedingText()")) {
            name = "SUCCEEDING";
        } else if (context.endsWith(".getLatex()")) {
            name = "TEXT";
        } else if (context.endsWith(".getDescription()")) {
            name = "DESCRIPTION";
        } else if (context.endsWith(".getNonFormalProof()")) {
            name = null;
        } else if (context.endsWith(".getItem()")) {
            name = null;
        } else {
            throw new IllegalArgumentException("unknown LatexList " + context);
        }
        Trace.param(CLASS, (Object)this, "visitEnter(LatexList)", "name", name);
        if (name != null) {
            this.enter(name);
        }
        Trace.param(CLASS, (Object)this, "visitEnter(LatexList)", "current", this.current);
        this.checkMatching("visitEnter(LatexList)");
    }

    public final void visitLeave(LatexList latexList) {
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (!context.endsWith(".getNonFormalProof()") && !context.endsWith(".getItem()")) {
            this.leave();
        }
    }

    public final void visitEnter(Latex latex) throws ModuleDataException {
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (context.indexOf(".getAuthorList().get(") >= 0) {
            this.enter("NAME");
        }
        this.enter("LATEX");
        String method = "visitEnter(Latex)";
        Trace.param(CLASS, (Object)this, "visitEnter(Latex)", "current", this.current);
        this.checkMatching("visitEnter(Latex)");
        this.traverser.setLocationWithinModule(context + ".getLanguage()");
        this.current.setAttribute("language");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLatex()");
        this.current.setAttribute(null);
        this.checkIfFound();
    }

    public final void visitLeave(Latex latex) {
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (context.indexOf(".getAuthorList().get(") >= 0) {
            this.leave();
        }
        this.leave();
    }

    public final void visitEnter(LocationList locationList) throws ModuleDataException {
        this.enter("LOCATIONS");
        String method = "visitEnter(LocationList)";
        Trace.param(CLASS, (Object)this, "visitEnter(LocationList)", "current", this.current);
        this.checkMatching("visitEnter(LocationList)");
    }

    public final void visitLeave(LocationList locationList) {
        this.leave();
    }

    public final void visitEnter(Location location) throws ModuleDataException {
        this.enter("LOCATION");
        String method = "visitEnter(Location)";
        Trace.param(CLASS, (Object)this, "visitEnter(Location)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Location)");
        this.traverser.setLocationWithinModule(context + ".getLocation()");
        this.current.setAttribute("value");
        this.checkIfFound();
    }

    public final void visitLeave(Location location) {
        this.leave();
    }

    public final void visitEnter(AuthorList authorList) throws ModuleDataException {
        this.enter("AUTHORS");
        String method = "visitEnter(AuthorList)";
        Trace.param(CLASS, (Object)this, "visitEnter(AuthorList)", "current", this.current);
        this.checkMatching("visitEnter(AuthorList)");
    }

    public final void visitLeave(AuthorList authorList) {
        this.leave();
    }

    public final void visitEnter(Author author) throws ModuleDataException {
        this.enter("AUTHOR");
        String method = "visitEnter(Author)";
        Trace.param(CLASS, (Object)this, "visitEnter(Author)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Author)");
        this.traverser.setLocationWithinModule(context + ".getEmail()");
        this.current.setAttribute("email");
        this.checkIfFound();
    }

    public final void visitLeave(Author author) {
        this.leave();
    }

    public final void visitEnter(ImportList importList) throws ModuleDataException {
        this.enter("IMPORTS");
        String method = "visitEnter(ImportList)";
        Trace.param(CLASS, (Object)this, "visitEnter(ImportList)", "current", this.current);
        this.checkMatching("visitEnter(ImportList)");
    }

    public final void visitLeave(ImportList importList) {
        this.leave();
    }

    public final void visitEnter(Import imp) throws ModuleDataException {
        this.enter("IMPORT");
        String method = "visitEnter(Import)";
        Trace.param(CLASS, (Object)this, "visitEnter(Import)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Import)");
        this.traverser.setLocationWithinModule(context + ".getLabel()");
        this.current.setAttribute("label");
        this.checkIfFound();
    }

    public final void visitLeave(Import imp) {
        this.leave();
    }

    public final void visitEnter(UsedByList usedByList) throws ModuleDataException {
        this.enter("USEDBY");
        String method = "visitEnter(UsedByList)";
        Trace.param(CLASS, (Object)this, "visitEnter(UsedByList)", "current", this.current);
        this.checkMatching("visitEnter(UsedByList)");
    }

    public final void visitLeave(UsedByList usedByList) {
        this.leave();
    }

    public final void visitEnter(ChapterList chapterList) throws ModuleDataException {
        String method = "visitEnter(ChapterList)";
        this.checkMatching("visitEnter(ChapterList)");
    }

    public final void visitLeave(ChapterList chapterList) {
        this.traverser.setBlocked(false);
    }

    public final void visitEnter(Chapter chapter) throws ModuleDataException {
        this.enter("CHAPTER");
        String method = "visitEnter(Chapter)";
        Trace.param(CLASS, (Object)this, "visitEnter(Chapter)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Chapter)");
        this.traverser.setLocationWithinModule(context + ".getNoNumber()");
        this.current.setAttribute("noNumber");
        this.checkIfFound();
    }

    public final void visitLeave(Chapter chapter) {
        this.leave();
    }

    public final void visitEnter(SectionList sectionList) throws ModuleDataException {
        String method = "visitEnter(SectionList)";
        this.checkMatching("visitEnter(SectionList)");
    }

    public final void visitLeave(SectionList sectionList) {
        this.traverser.setBlocked(false);
    }

    public final void visitEnter(Section section) throws ModuleDataException {
        this.enter("SECTION");
        String method = "visitEnter(Section)";
        Trace.param(CLASS, (Object)this, "visitEnter(Section)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Section)");
        this.traverser.setLocationWithinModule(context + ".getNoNumber()");
        this.current.setAttribute("noNumber");
        this.checkIfFound();
    }

    public final void visitLeave(Section section) {
        this.leave();
    }

    public final void visitEnter(SubsectionList subsectionList) throws ModuleDataException {
        this.enter("SUBSECTIONS");
        String method = "visitEnter(SubsectionList)";
        Trace.param(CLASS, (Object)this, "visitEnter(SubsectionList)", "current", this.current);
        this.checkMatching("visitEnter(SubsectionList)");
    }

    public final void visitLeave(SubsectionList subsectionList) {
        this.leave();
    }

    public final void visitEnter(Subsection subsection) throws ModuleDataException {
        this.enter("SUBSECTION");
        String method = "visitEnter(Subsection)";
        Trace.param(CLASS, (Object)this, "visitEnter(Subsection)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Subsection)");
        this.traverser.setLocationWithinModule(context + ".getId()");
        this.current.setAttribute("id");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLevel()");
        this.current.setAttribute("level");
        this.checkIfFound();
    }

    public final void visitLeave(Subsection subsection) {
        this.leave();
    }

    public final void visitEnter(Node node) throws ModuleDataException {
        this.enter("NODE");
        String method = "visitEnter(Node)";
        Trace.param(CLASS, (Object)this, "visitEnter(Node)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Node)");
        this.traverser.setLocationWithinModule(context + ".getId()");
        this.current.setAttribute("id");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLevel()");
        this.current.setAttribute("level");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getNodeType()");
        this.current.setAttribute(null);
        this.checkIfFound();
    }

    public final void visitLeave(Node node) {
        this.leave();
    }

    public final void visitEnter(Axiom axiom) throws ModuleDataException {
        this.enter("AXIOM");
        String method = "visitEnter(Axiom)";
        Trace.param(CLASS, (Object)this, "visitEnter(Axiom)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Axiom)");
        this.traverser.setLocationWithinModule(context + ".getDefinedOperator()");
        this.current.setAttribute("definedOperator");
        this.checkIfFound();
    }

    public final void visitLeave(Axiom axiom) {
        this.leave();
    }

    public final void visitEnter(Proposition proposition) throws ModuleDataException {
        this.enter("THEOREM");
        String method = "visitEnter(Proposition)";
        Trace.param(CLASS, (Object)this, "visitEnter(Proposition)", "current", this.current);
        this.checkMatching("visitEnter(Proposition)");
    }

    public final void visitLeave(Proposition proposition) {
        this.leave();
    }

    public final void visitEnter(ProofList proofList) throws ModuleDataException {
        String method = "visitEnter(ProofList)";
        this.checkMatching("visitEnter(ProofList)");
    }

    public final void visitEnter(Proof proof) throws ModuleDataException {
        this.enter("PROOF");
        String method = "visitEnter(Proof)";
        Trace.param(CLASS, (Object)this, "visitEnter(Proof)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Proof)");
        this.traverser.setLocationWithinModule(context + ".getKind()");
        this.current.setAttribute("kind");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLevel()");
        this.current.setAttribute("level");
        this.checkIfFound();
    }

    public final void visitLeave(Proof proof) {
        this.leave();
    }

    public final void visitEnter(FormalProofList proofList) throws ModuleDataException {
        String method = "visitEnter(FormalProofList)";
        this.checkMatching("visitEnter(FormalProofList)");
    }

    public final void visitEnter(FormalProof proof) throws ModuleDataException {
        this.enter("FORMAL_PROOF");
        String method = "visitEnter(FormalProof)";
        Trace.param(CLASS, (Object)this, "visitEnter(FormalProof)", "current", this.current);
        this.checkMatching("visitEnter(FormalProof)");
    }

    public final void visitLeave(FormalProof proof) {
        this.leave();
    }

    public final void visitEnter(FormalProofLineList list) throws ModuleDataException {
        this.enter("LINES");
        String method = "visitEnter(FormalProofLineList)";
        Trace.param(CLASS, (Object)this, "visitEnter(FormalProofLineList)", "current", this.current);
        this.checkMatching("visitEnter(FormalProofLineList)");
    }

    public final void visitLeave(FormalProofLineList list) {
        this.leave();
    }

    public final void visitEnter(FormalProofLine line) throws ModuleDataException {
        this.enter("L");
        String method = "visitEnter(FormalProofLine)";
        Trace.param(CLASS, (Object)this, "visitEnter(FormalProofLine)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(FormalProofLine)");
        this.traverser.setLocationWithinModule(context + ".getLabel()");
        this.current.setAttribute("label");
        this.checkIfFound();
    }

    public final void visitLeave(FormalProofLine line) {
        this.leave();
    }

    public final void visitEnter(ReasonType reasonType) throws ModuleDataException {
        String method = "visitEnter(ReasonType)";
        Trace.param(CLASS, (Object)this, "visitEnter(ReasonType)", "current", this.current);
        this.checkMatching("visitEnter(ReasonType)");
    }

    public final void visitLeave(ReasonType reasonType) {
    }

    public final void visitEnter(Add reason) throws ModuleDataException {
        this.enter("ADD");
        String method = "visitEnter(Add)";
        Trace.param(CLASS, (Object)this, "visitEnter(Add)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Add)");
        this.traverser.setLocationWithinModule(context + ".getReference()");
        this.current.setAttribute("ref");
        this.checkIfFound();
    }

    public final void visitLeave(Add reason) {
        this.leave();
    }

    public final void visitEnter(ModusPonens reason) throws ModuleDataException {
        this.enter("MP");
        String method = "visitEnter(ModusPonens)";
        Trace.param(CLASS, (Object)this, "visitEnter(ModusPonens)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(ModusPonens)");
        this.traverser.setLocationWithinModule(context + ".getReference1()");
        this.current.setAttribute("ref1");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getReference2()");
        this.current.setAttribute("ref2");
        this.checkIfFound();
    }

    public final void visitLeave(ModusPonens reason) {
        this.leave();
    }

    public final void visitEnter(Rename reason) throws ModuleDataException {
        this.enter("RENAME");
        String method = "visitEnter(Add)";
        Trace.param(CLASS, (Object)this, "visitEnter(Add)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Add)");
        this.traverser.setLocationWithinModule(context + ".getReference()");
        this.current.setAttribute("ref");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getOccurrence()");
        this.current.setAttribute("occurrence");
        this.checkIfFound();
    }

    public final void visitLeave(Rename reason) {
        this.leave();
    }

    public final void visitEnter(SubstFree reason) throws ModuleDataException {
        this.enter("SUBST_FREE");
        String method = "visitEnter(SubstFree)";
        Trace.param(CLASS, (Object)this, "visitEnter(SubstFree)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(SubstFree)");
        this.traverser.setLocationWithinModule(context + ".getReference()");
        this.current.setAttribute("ref");
        this.checkIfFound();
        this.checkIfFound();
    }

    public final void visitLeave(SubstFree reason) {
        this.leave();
    }

    public final void visitEnter(SubstFunc reason) throws ModuleDataException {
        this.enter("SUBST_FUNVAR");
        String method = "visitEnter(SubstFunc)";
        Trace.param(CLASS, (Object)this, "visitEnter(SubstFunc)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(SubstFunc)");
        this.traverser.setLocationWithinModule(context + ".getReference()");
        this.current.setAttribute("ref");
        this.checkIfFound();
        this.checkIfFound();
    }

    public final void visitLeave(SubstFunc reason) {
        this.leave();
    }

    public final void visitEnter(SubstPred reason) throws ModuleDataException {
        this.enter("SUBST_PREDVAR");
        String method = "visitEnter(SubstPred)";
        Trace.param(CLASS, (Object)this, "visitEnter(SubstPred)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(SubstPred)");
        this.traverser.setLocationWithinModule(context + ".getReference()");
        this.current.setAttribute("ref");
        this.checkIfFound();
        this.checkIfFound();
    }

    public final void visitLeave(SubstPred reason) {
        this.leave();
    }

    public final void visitEnter(Existential reason) throws ModuleDataException {
        this.enter("EXISTENTIAL");
        String method = "visitEnter(Existential)";
        Trace.param(CLASS, (Object)this, "visitEnter(Existential)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Existential)");
        this.traverser.setLocationWithinModule(context + ".getReference()");
        this.current.setAttribute("ref");
        this.checkIfFound();
        this.checkIfFound();
    }

    public final void visitLeave(Existential reason) {
        this.leave();
    }

    public final void visitEnter(Universal reason) throws ModuleDataException {
        this.enter("UNIVERSAL");
        String method = "visitEnter(Universal)";
        Trace.param(CLASS, (Object)this, "visitEnter(Universal)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Universal)");
        this.traverser.setLocationWithinModule(context + ".getReference()");
        this.current.setAttribute("ref");
        this.checkIfFound();
        this.checkIfFound();
    }

    public final void visitLeave(Universal reason) {
        this.leave();
    }

    public final void visitEnter(InitialPredicateDefinition definition) throws ModuleDataException {
        this.enter("DEFINITION_PREDICATE_INITIAL");
        String method = "visitEnter(InitialPredicateDefinition)";
        Trace.param(CLASS, (Object)this, "visitEnter(InitialPredicateDefinition)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(InitialPredicateDefinition)");
        this.traverser.setLocationWithinModule(context + ".getArgumentNumber()");
        this.current.setAttribute("arguments");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getName()");
        this.current.setAttribute("name");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLatexPattern()");
        this.enter("LATEXPATTERN");
        if (this.find.getLocationWithinModule().equals(this.traverser.getCurrentContext().getLocationWithinModule())) {
            if (definition.getLatexPattern() == null) {
                this.leave();
            }
            throw new LocationFoundException(this.traverser.getCurrentContext());
        }
        this.leave();
    }

    public final void visitLeave(InitialPredicateDefinition definition) {
        this.leave();
    }

    public final void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        this.enter("DEFINITION_PREDICATE");
        String method = "visitEnter(PredicateDefinition)";
        Trace.param(CLASS, (Object)this, "visitEnter(PredicateDefinition)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(PredicateDefinition)");
        this.traverser.setLocationWithinModule(context + ".getArgumentNumber()");
        this.current.setAttribute("arguments");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getName()");
        this.current.setAttribute("name");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLatexPattern()");
        this.enter("LATEXPATTERN");
        if (this.find.getLocationWithinModule().equals(this.traverser.getCurrentContext().getLocationWithinModule())) {
            if (definition.getLatexPattern() == null) {
                this.leave();
            }
            throw new LocationFoundException(this.traverser.getCurrentContext());
        }
        this.leave();
    }

    public final void visitLeave(PredicateDefinition definition) {
        this.leave();
    }

    public final void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        this.enter("DEFINITION_FUNCTION");
        String method = "visitEnter(FunctionDefinition)";
        Trace.param(CLASS, (Object)this, "visitEnter(FunctionDefinition)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(FunctionDefinition)");
        this.traverser.setLocationWithinModule(context + ".getArgumentNumber()");
        this.current.setAttribute("arguments");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getName()");
        this.current.setAttribute("name");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLatexPattern()");
        this.enter("LATEXPATTERN");
        if (this.find.getLocationWithinModule().equals(this.traverser.getCurrentContext().getLocationWithinModule())) {
            if (definition.getLatexPattern() == null) {
                this.leave();
            }
            throw new LocationFoundException(this.traverser.getCurrentContext());
        }
        this.leave();
    }

    public final void visitLeave(FunctionDefinition definition) {
        this.leave();
    }

    public final void visitEnter(Rule rule) throws ModuleDataException {
        this.enter("RULE");
        String method = "visitEnter(Rule)";
        Trace.param(CLASS, (Object)this, "visitEnter(Rule)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Rule)");
        this.traverser.setLocationWithinModule(context + ".getName()");
        this.current.setAttribute("name");
        this.checkIfFound();
    }

    public final void visitLeave(Rule rule) {
        this.leave();
    }

    public final void visitEnter(LinkList linkList) throws ModuleDataException {
        String method = "visitEnter(LinkList)";
        Trace.param(CLASS, (Object)this, "visitEnter(LinkList)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(LinkList)");
        for (int i = 0; i < linkList.size(); ++i) {
            this.enter("LINK");
            if (linkList.get(i) != null) {
                this.traverser.setLocationWithinModule(context + ".get(" + i + ")");
                this.current.setAttribute("id");
                this.checkIfFound();
            }
            this.leave();
        }
    }

    public final void visitLeave(LinkList linkList) {
    }

    public final void visitEnter(Formula formula) throws ModuleDataException {
        this.enter("FORMULA");
        String method = "visitEnter(Formula)";
        Trace.param(CLASS, (Object)this, "visitEnter(Formula)", "current", this.current);
        this.checkMatching("visitEnter(Formula)");
    }

    public final void visitLeave(Formula formula) {
        this.leave();
    }

    public final void visitEnter(Term term) throws ModuleDataException {
        this.enter("TERM");
        String method = "visitEnter(Term)";
        Trace.param(CLASS, (Object)this, "visitEnter(Term)", "current", this.current);
        this.checkMatching("visitEnter(Term)");
    }

    public final void visitLeave(Term term) {
        this.leave();
    }

    public final void visitEnter(VariableList variableList) throws ModuleDataException {
        this.enter("VARLIST");
        String method = "visitEnter(VariableList)";
        Trace.param(CLASS, (Object)this, "visitEnter(VariableList)", "current", this.current);
        this.checkMatching("visitEnter(VariableList)");
    }

    public final void visitLeave(VariableList variableList) {
        this.leave();
    }

    public final void visitEnter(ElementList list) throws ModuleDataException {
        boolean firstIsAtom;
        String operator = list.getOperator();
        this.enter(operator);
        String method = "visitEnter(ElementList)";
        Trace.param(CLASS, (Object)this, "visitEnter(ElementList)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (context.startsWith(this.find.getLocationWithinModule())) {
            throw new LocationFoundException(this.find);
        }
        this.checkMatching("visitEnter(ElementList)");
        this.traverser.setLocationWithinModule(context + ".getOperator()");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context);
        boolean bl = firstIsAtom = list.size() > 0 && list.getElement(0).isAtom();
        if (firstIsAtom) {
            this.traverser.setLocationWithinModule(context + ".getElement(0)");
            if ("VAR".equals(operator) || "PREDVAR".equals(operator) || "FUNVAR".equals(operator)) {
                this.current.setAttribute("id");
                this.checkIfFound();
            } else if ("PREDCON".equals(operator) || "FUNCON".equals(operator)) {
                this.current.setAttribute("ref");
                this.checkIfFound();
            } else {
                this.current.setAttribute(null);
                Trace.info(CLASS, this, "visitEnter(ElementList)", "unknown operator " + operator);
                throw new LocationFoundException(this.traverser.getCurrentContext());
            }
        }
    }

    public final void visitLeave(ElementList list) {
        this.leave();
    }

    public final void visitEnter(LiteratureItemList list) throws ModuleDataException {
        this.enter("BIBLIOGRAPHY");
        String method = "visitEnter(LiteratureItemList)";
        Trace.param(CLASS, (Object)this, "visitEnter(LiteratureItemList)", "current", this.current);
        this.checkMatching("visitEnter(LiteratureItemList)");
    }

    public final void visitLeave(LiteratureItemList list) {
        this.leave();
    }

    public final void visitEnter(LiteratureItem item) throws ModuleDataException {
        this.enter("ITEM");
        String method = "visitEnter(LiteratureItem)";
        Trace.param(CLASS, (Object)this, "visitEnter(LiteratureItem)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(LiteratureItem)");
        this.traverser.setLocationWithinModule(context + ".getLabel()");
        this.current.setAttribute("label");
        this.checkIfFound();
    }

    public final void visitLeave(LiteratureItem item) {
        this.leave();
    }

    private final void checkIfFound() throws LocationFoundException {
        if (this.find.getLocationWithinModule().equals(this.traverser.getCurrentContext().getLocationWithinModule())) {
            throw new LocationFoundException(this.traverser.getCurrentContext());
        }
    }

    private final void checkMatching(String method) throws LocationNotFoundException, LocationFoundException {
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (this.find.getLocationWithinModule().startsWith(context)) {
            Trace.info(CLASS, this, method, "beginning matches");
            Trace.paramInfo(CLASS, (Object)this, method, "context", context);
            this.matching = true;
            this.matchingBegin = context;
            this.matchingPath = new SimpleXPath(this.current);
        } else {
            if (this.matching && !context.startsWith(this.matchingBegin)) {
                Trace.info(CLASS, this, method, "matching lost");
                Trace.paramInfo(CLASS, (Object)this, method, "last match     ", this.matchingBegin);
                Trace.paramInfo(CLASS, (Object)this, method, "current context", context);
                Trace.paramInfo(CLASS, (Object)this, method, "find context   ", this.find.getLocationWithinModule());
                if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("qedeq.test.xmlLocationFailures"))) {
                    throw new LocationNotFoundException(this.find, this.matchingBegin);
                }
                Trace.traceStack(CLASS, this, method);
                Trace.info(CLASS, this, method, "changing XPath to last matching one");
                this.current = this.matchingPath;
                throw new LocationFoundException(new ModuleContext(this.find.getModuleLocation(), this.matchingBegin));
            }
            this.traverser.setBlocked(true);
        }
        this.checkIfFound();
    }

    private final void enter(String element) {
        ++this.level;
        this.current.addElement(element, this.addOccurence(element));
    }

    private final void leave() {
        --this.level;
        this.current.deleteLastElement();
        this.traverser.setBlocked(false);
    }

    private final int addOccurence(String name) {
        Enumerator counter;
        while (this.level < this.elements.size()) {
            this.elements.remove(this.elements.size() - 1);
        }
        while (this.level > this.elements.size()) {
            this.elements.add(new HashMap());
        }
        Map levelMap = (Map)this.elements.get(this.level - 1);
        if (levelMap.containsKey(name)) {
            counter = (Enumerator)levelMap.get(name);
            counter.increaseNumber();
        } else {
            counter = new Enumerator(1);
            levelMap.put(name, counter);
        }
        return counter.getNumber();
    }
}

