/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.handler.module;

import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.dto.module.RuleVo;
import org.qedeq.kernel.xml.common.XmlSyntaxException;
import org.qedeq.kernel.xml.handler.common.AbstractSimpleHandler;
import org.qedeq.kernel.xml.handler.common.SimpleAttributes;
import org.qedeq.kernel.xml.handler.module.LatexListHandler;
import org.qedeq.kernel.xml.handler.module.ProofHandler;

public class RuleHandler
extends AbstractSimpleHandler {
    private final LatexListHandler descriptionHandler = new LatexListHandler(this, "DESCRIPTION");
    private final ProofHandler proofHandler = new ProofHandler(this);
    private RuleVo rule;

    public RuleHandler(AbstractSimpleHandler handler) {
        super(handler, "RULE");
    }

    public final void init() {
        this.rule = null;
    }

    public final Rule getRule() {
        return this.rule;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void startElement(String name, SimpleAttributes attributes) throws XmlSyntaxException {
        if (this.getStartTag().equals(name)) {
            this.rule = new RuleVo();
            if (null == attributes.getString("name")) throw XmlSyntaxException.createMissingAttributeException(name, "name");
            this.rule.setName(attributes.getString("name"));
            return;
        } else if ("LINK".equals(name)) {
            if (null == attributes.getString("id")) throw XmlSyntaxException.createMissingAttributeException(name, "id");
            this.rule.addLink(attributes.getString("id"));
            return;
        } else if (this.descriptionHandler.getStartTag().equals(name)) {
            this.changeHandler(this.descriptionHandler, name, attributes);
            return;
        } else {
            if (!this.proofHandler.getStartTag().equals(name)) throw XmlSyntaxException.createUnexpectedTagException(name);
            this.changeHandler(this.proofHandler, name, attributes);
        }
    }

    public final void endElement(String name) throws XmlSyntaxException {
        if (!this.getStartTag().equals(name) && !"LINK".equals(name)) {
            if (this.descriptionHandler.getStartTag().equals(name)) {
                this.rule.setDescription(this.descriptionHandler.getLatexList());
            } else if (this.proofHandler.getStartTag().equals(name)) {
                this.rule.addProof(this.proofHandler.getProof());
            } else {
                throw XmlSyntaxException.createUnexpectedTagException(name);
            }
        }
    }
}

