/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.dao;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.common.KernelServices;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.xml.dao.Qedeq2Xml;

public final class Xml2Xml
implements Plugin {
    private static final Class CLASS = Xml2Xml.class;

    private Xml2Xml() {
    }

    public static String generate(InternalKernelServices services, File from, File to) throws SourceFileExceptionList {
        String method = "generate(File, File)";
        File destination = null;
        try {
            if (to != null) {
                destination = to.getCanonicalFile();
            } else {
                String xml = from.getName();
                if (xml.toLowerCase(Locale.US).endsWith(".xml")) {
                    xml = xml.substring(0, xml.length() - 4);
                }
                destination = new File(from.getParentFile(), xml + "_.xml").getCanonicalFile();
            }
            return Xml2Xml.generate((KernelServices)services, IoUtility.toUrl(from), destination);
        }
        catch (IOException e) {
            Trace.fatal(CLASS, "Writing failed destionation", "generate(File, File)", e);
            throw services.createSourceFileExceptionList(892771000, "Writing of following QEDEQ module file failed: " + destination, to + "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generate(KernelServices services, URL from, File to) throws SourceFileExceptionList, IOException {
        String method = "generate(URL, File)";
        Trace.begin(CLASS, "generate(URL, File)");
        Trace.param(CLASS, "generate(URL, File)", "from", from);
        Trace.param(CLASS, "generate(URL, File)", "to", to);
        TextOutput printer = null;
        try {
            ModuleAddress address = services.getModuleAddress(from);
            KernelQedeqBo prop = (KernelQedeqBo)services.loadModule(address);
            if (prop.getLoadingState().isFailure()) {
                throw prop.getErrors();
            }
            IoUtility.createNecessaryDirectories(to);
            FileOutputStream outputStream = new FileOutputStream(to);
            printer = new TextOutput(to.getName(), outputStream, "UTF-8");
            Qedeq2Xml.print(new Xml2Xml(), prop, printer);
            String string = to.getCanonicalPath();
            return string;
        }
        finally {
            if (printer != null) {
                printer.close();
            }
            Trace.end(CLASS, "generate(URL, File)");
        }
    }

    public String getPluginId() {
        return CLASS.getName();
    }

    public String getPluginActionName() {
        return "Xml2Xml";
    }

    public String getPluginDescription() {
        return "transform XML QEDEQ module in a new XML file";
    }
}

