/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.se.base.module.LocationList;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleContext;

public class DefaultModuleAddress
implements ModuleAddress {
    private static final Class CLASS = DefaultModuleAddress.class;
    private final String url;
    private final String header;
    private final String path;
    private final String fileName;
    private final boolean relativeAddress;
    private final boolean fileAddress;
    private final String name;

    public DefaultModuleAddress(String u) throws MalformedURLException {
        this(u, (ModuleAddress)null);
    }

    public DefaultModuleAddress(URL u) throws MalformedURLException {
        this(u.toExternalForm(), (ModuleAddress)null);
    }

    public DefaultModuleAddress(File file) throws IOException {
        this(IoUtility.toUrl(file.getCanonicalFile()));
    }

    public DefaultModuleAddress() {
        this(true, "default");
    }

    public DefaultModuleAddress(boolean memory, String identifier) {
        if (!memory) {
            throw new IllegalArgumentException("memory must be true");
        }
        this.url = "memory:" + identifier;
        this.name = identifier;
        this.fileAddress = false;
        this.fileName = identifier;
        this.header = "memory:";
        this.path = "";
        this.relativeAddress = true;
    }

    public DefaultModuleAddress(String address, ModuleAddress parent) throws MalformedURLException {
        String mname;
        URL urmel;
        String method = "ModuleAddress(String, ModuleAddress)";
        if (address == null) {
            throw new NullPointerException();
        }
        try {
            urmel = parent != null ? new URL(new URL(parent.getUrl()), address) : new URL(address);
        }
        catch (MalformedURLException e) {
            Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "address=" + address);
            Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "parent=" + parent);
            Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", (Throwable)e);
            try {
                String newAddress = "file:" + address;
                urmel = parent != null ? new URL(new URL(parent.getUrl()), newAddress) : new URL(newAddress);
            }
            catch (MalformedURLException ex) {
                throw e;
            }
        }
        Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "protocol=" + urmel.getProtocol());
        this.url = urmel.toString();
        this.fileAddress = urmel.getProtocol().equalsIgnoreCase("file");
        String p = urmel.getFile();
        int position = p.lastIndexOf("/");
        if (position >= 0 && position + 1 < p.length()) {
            this.path = p.substring(0, position) + "/";
            this.fileName = p.substring(position + 1);
        } else {
            this.path = "";
            this.fileName = p;
        }
        Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "path=" + this.path);
        Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "fileName=" + this.fileName);
        boolean bl = this.relativeAddress = !this.path.startsWith("/");
        if (!this.fileName.endsWith(".xml")) {
            throw new MalformedURLException("file name doesn't end with \".xml\": " + this.fileName);
        }
        int positionBefore = this.fileName.lastIndexOf(".");
        this.name = mname = this.fileName.substring(0, positionBefore);
        int positionPath = this.url.lastIndexOf(this.path + this.fileName);
        if (positionPath < 0) {
            throw new IllegalArgumentException("couldn't determine begin of file path: " + this.url);
        }
        this.header = this.url.substring(0, positionPath);
    }

    public ModuleContext createModuleContext() {
        return new ModuleContext(this);
    }

    public String getHeader() {
        return this.header;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isRelativeAddress() {
        return this.relativeAddress;
    }

    public boolean isFileAddress() {
        return this.fileAddress;
    }

    public final String toString() {
        return this.url;
    }

    public final int hashCode() {
        return this.url.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof DefaultModuleAddress)) {
            return false;
        }
        return this.url.equals(((DefaultModuleAddress)object).url);
    }

    private static final String getModuleFileName(Specification spec) {
        return spec.getName() + ".xml";
    }

    public final ModuleAddress[] getModulePaths(Specification spec) throws IOException {
        String fileNameEnd = DefaultModuleAddress.getModuleFileName(spec);
        LocationList locations = spec.getLocationList();
        ModuleAddress[] result = new ModuleAddress[locations != null ? locations.size() : 0];
        for (int i = 0; i < result.length; ++i) {
            String file = locations.get(i).getLocation();
            if (file.equals(".")) {
                file = "";
            } else if (!file.endsWith("/")) {
                file = file + "/";
            }
            file = file + fileNameEnd;
            result[i] = new DefaultModuleAddress(file, this);
        }
        return result;
    }

    public static final String createRelativeAddress(String origin, String next) {
        if (origin.equals(next)) {
            return "";
        }
        try {
            URL urlOrgin = new URL(origin);
            URL urlNext = new URL(next);
            if (urlOrgin.getProtocol().equals(urlNext.getProtocol()) && urlOrgin.getHost().equals(urlNext.getHost()) && urlOrgin.getPort() == urlNext.getPort()) {
                String org = urlOrgin.getFile();
                String nex = urlNext.getFile();
                int i = -1;
                int j = 0;
                while (0 <= (i = org.indexOf("/", j)) && i >= 0 && nex.length() > i && org.substring(j, i).equals(nex.substring(j, i))) {
                    j = i + 1;
                }
                if (j > 0) {
                    i = j;
                    StringBuffer result = new StringBuffer(nex.length());
                    while (0 <= (i = org.indexOf("/", i))) {
                        ++i;
                        result.append("../");
                    }
                    result.append(nex.substring(j));
                    return result.toString();
                }
                return "/" + nex;
            }
            return urlNext.toString();
        }
        catch (MalformedURLException e) {
            return next;
        }
    }
}

