/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.unicode;

import java.io.IOException;
import java.util.ArrayList;
import org.qedeq.base.io.AbstractOutput;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.DateUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelNodeBo;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.Reference;
import org.qedeq.kernel.bo.service.unicode.Latex2UnicodeParser;
import org.qedeq.kernel.bo.service.unicode.ReferenceFinder;
import org.qedeq.kernel.bo.service.unicode.UnicodeException;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.Author;
import org.qedeq.kernel.se.base.module.AuthorList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.Chapter;
import org.qedeq.kernel.se.base.module.Existential;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Header;
import org.qedeq.kernel.se.base.module.Import;
import org.qedeq.kernel.se.base.module.ImportList;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.Latex;
import org.qedeq.kernel.se.base.module.LatexList;
import org.qedeq.kernel.se.base.module.LinkList;
import org.qedeq.kernel.se.base.module.LiteratureItem;
import org.qedeq.kernel.se.base.module.LiteratureItemList;
import org.qedeq.kernel.se.base.module.LocationList;
import org.qedeq.kernel.se.base.module.ModusPonens;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proof;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.base.module.Rename;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.Section;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.base.module.Subsection;
import org.qedeq.kernel.se.base.module.SubstFree;
import org.qedeq.kernel.se.base.module.SubstFunc;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.base.module.Universal;
import org.qedeq.kernel.se.base.module.UsedByList;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.visitor.QedeqNumbers;

public class Qedeq2UnicodeVisitor
extends ControlVisitor
implements ReferenceFinder {
    private static final Class CLASS = Qedeq2UnicodeVisitor.class;
    private AbstractOutput printer;
    private String language;
    private final boolean info;
    private String id;
    private String title;
    private String subContext = "";
    private int maxColumns;
    private boolean addWarnings;
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    private String[] formula = new String[0];
    private String[] reason = new String[0];
    private int formulaWidth = 60;
    private int reasonWidth = 35;

    public Qedeq2UnicodeVisitor(Plugin plugin, KernelQedeqBo prop, boolean info, int maximumColumn, boolean addWarnings) {
        super(plugin, prop);
        this.info = info;
        this.maxColumns = maximumColumn;
        this.addWarnings = addWarnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateUtf8(AbstractOutput printer, String language, String level) throws SourceFileExceptionList, IOException {
        this.printer = printer;
        this.printer.setColumns(this.maxColumns);
        if (this.maxColumns <= 0) {
            this.formulaWidth = 80;
            this.reasonWidth = 50;
        } else if (this.maxColumns <= 50) {
            this.printer.setColumns(50);
            this.formulaWidth = 21;
            this.reasonWidth = 21;
        } else if (this.maxColumns <= 100) {
            this.formulaWidth = (this.maxColumns - 8) * 50 / 100;
            this.reasonWidth = (this.maxColumns - 8) * 50 / 100;
        } else if (this.maxColumns <= 120) {
            this.reasonWidth = 46 + (this.maxColumns - 100) / 5;
            this.formulaWidth = this.maxColumns - 8 - this.reasonWidth;
        } else {
            this.reasonWidth = 50 + (this.maxColumns - 120) / 10;
            this.formulaWidth = this.maxColumns - 8 - this.reasonWidth;
        }
        this.language = language == null ? "en" : language;
        this.init();
        try {
            this.traverse();
        }
        finally {
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
        }
    }

    protected void init() {
        this.id = null;
        this.title = null;
        this.subContext = "";
    }

    public final void visitEnter(Qedeq qedeq) {
        if (this.printer instanceof TextOutput) {
            this.printer.println("================================================================================");
            this.printer.println("UTF-8-file     " + ((TextOutput)this.printer).getName());
            this.printer.println("Generated from " + this.getQedeqBo().getModuleAddress());
            this.printer.println("Generated at   " + DateUtility.getTimestamp());
            this.printer.println("================================================================================");
            this.printer.println();
            this.printer.println("If the characters of this document don't display correctly try opening this");
            this.printer.println("document within a webbrowser and if necessary change the encoding to");
            this.printer.println("Unicode (UTF-8)");
            this.printer.println();
            this.printer.println("Permission is granted to copy, distribute and/or modify this document");
            this.printer.println("under the terms of the GNU Free Documentation License, Version 1.2");
            this.printer.println("or any later version published by the Free Software Foundation;");
            this.printer.println("with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.");
            this.printer.println();
            this.printer.println();
            this.printer.println();
        }
    }

    public final void visitLeave(Qedeq qedeq) {
        this.printer.println();
    }

    public void visitEnter(Header header) {
        LatexList tit = header.getTitle();
        this.underlineBig(this.getLatexListEntry("getTitle()", tit));
        this.printer.println();
        AuthorList authors = this.getQedeqBo().getQedeq().getHeader().getAuthorList();
        StringBuffer authorList = new StringBuffer();
        for (int i = 0; i < authors.size(); ++i) {
            if (i > 0) {
                authorList.append("    \n");
                this.printer.println(", ");
            }
            Author author = authors.get(i);
            String name = author.getName().getLatex().trim();
            this.printer.print(name);
            authorList.append("    " + name);
            String email = author.getEmail();
            if (email == null || email.trim().length() <= 0) continue;
            authorList.append(" <" + email + ">");
        }
        this.printer.println();
        this.printer.println();
        String url = this.getQedeqBo().getUrl();
        if (url != null && url.length() > 0) {
            this.printer.println();
            if ("de".equals(this.language)) {
                this.printer.println("Die Quelle f\u00fcr dieses Dokument ist hier zu finden:");
            } else {
                if (!"en".equals(this.language)) {
                    this.printer.println("%%% TODO unknown language: " + this.language);
                }
                this.printer.println("The source for this document can be found here:");
            }
            this.printer.println();
            this.printer.println(url);
            this.printer.println();
        }
        this.printer.println();
        if ("de".equals(this.language)) {
            this.printer.println("Die vorliegende Publikation ist urheberrechtlich gesch\u00fctzt.");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Copyright by the authors. All rights reserved.");
        }
        String email = header.getEmail();
        if (email != null && email.length() > 0) {
            this.printer.println();
            this.printer.println();
            if ("de".equals(this.language)) {
                this.printer.println("Bei Fragen, Anregungen oder Bitte um Aufnahme in die Liste der abh\u00e4ngigen Module schicken Sie bitte eine EMail an die Adresse " + email);
                this.printer.println();
                this.printer.println();
                this.printer.println("Die Autoren dieses Dokuments sind:");
                this.printer.println();
                this.printer.println(authorList);
            } else {
                if (!"en".equals(this.language)) {
                    this.printer.println("%%% TODO unknown language: " + this.language);
                }
                this.printer.println("If you have any questions, suggestions or want to add something to the list of modules that use this one, please send an email to the address " + email);
                this.printer.println();
                this.printer.println();
                this.printer.println("The authors of this document are:");
                this.printer.println(authorList);
            }
            this.printer.println();
        }
        this.printer.println();
        this.printer.println();
    }

    private String getUrl(ModuleAddress address, Specification specification) {
        LocationList list = specification.getLocationList();
        if (list == null || list.size() <= 0) {
            return "";
        }
        try {
            return address.getModulePaths(specification)[0].getUrl();
        }
        catch (IOException e) {
            return "";
        }
    }

    public void visitEnter(Chapter chapter) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        if (numbers.isChapterNumbering()) {
            if ("de".equals(this.language)) {
                this.printer.println("Kapitel " + numbers.getChapterNumber() + " ");
            } else {
                this.printer.println("Chapter " + numbers.getChapterNumber() + " ");
            }
            this.printer.println();
            this.printer.println();
        }
        this.underlineBig(this.getLatexListEntry("getTitle()", chapter.getTitle()));
        this.printer.println();
        if (chapter.getIntroduction() != null) {
            this.printer.append(this.getLatexListEntry("getIntroduction()", chapter.getIntroduction()));
            this.printer.println();
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitLeave(Header header) {
        this.printer.println();
        this.printer.println("___________________________________________________");
        this.printer.println();
        this.printer.println();
    }

    public void visitLeave(Chapter chapter) {
        this.printer.println();
        this.printer.println("___________________________________________________");
        this.printer.println();
        this.printer.println();
    }

    public void visitEnter(Section section) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        StringBuffer buffer = new StringBuffer();
        if (numbers.isChapterNumbering()) {
            buffer.append(numbers.getChapterNumber());
        }
        if (numbers.isSectionNumbering()) {
            if (buffer.length() > 0) {
                buffer.append(".");
            }
            buffer.append(numbers.getSectionNumber());
        }
        if (buffer.length() > 0 && section.getTitle() != null) {
            buffer.append(" ");
        }
        buffer.append(this.getLatexListEntry("getTitle()", section.getTitle()));
        this.underline(buffer.toString());
        this.printer.println();
        if (section.getIntroduction() != null) {
            this.printer.append(this.getLatexListEntry("getIntroduction()", section.getIntroduction()));
            this.printer.println();
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitLeave(Section section) {
        this.printer.println();
    }

    public void visitEnter(Subsection subsection) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        StringBuffer buffer = new StringBuffer();
        if (numbers.isChapterNumbering()) {
            buffer.append(numbers.getChapterNumber());
        }
        if (numbers.isSectionNumbering()) {
            if (buffer.length() > 0) {
                buffer.append(".");
            }
            buffer.append(numbers.getSectionNumber());
        }
        if (buffer.length() > 0) {
            buffer.append(".");
        }
        buffer.append(numbers.getSubsectionNumber());
        if (buffer.length() > 0 && subsection.getTitle() != null) {
            buffer.append(" ");
        }
        if (subsection.getTitle() != null) {
            this.printer.print(buffer.toString());
            this.printer.print(this.getLatexListEntry("getTitle()", subsection.getTitle()));
        }
        if (subsection.getId() != null && this.info) {
            this.printer.print("  [" + subsection.getId() + "]");
        }
        if (subsection.getTitle() != null) {
            this.printer.println();
            this.printer.println();
        }
        this.printer.append(this.getLatexListEntry("getLatex()", subsection.getLatex()));
        this.printer.println();
        this.printer.println();
    }

    public void visitEnter(Node node) {
        if (node.getPrecedingText() != null) {
            this.printer.append(this.getLatexListEntry("getPrecedingText()", node.getPrecedingText()));
            this.printer.println();
            this.printer.println();
        }
        this.id = node.getId();
        this.title = null;
        if (node.getTitle() != null) {
            this.title = this.getLatexListEntry("getTitle()", node.getTitle());
        }
    }

    public void visitLeave(Node node) {
        if (node.getSucceedingText() != null) {
            this.printer.append(this.getLatexListEntry("getSucceedingText()", node.getSucceedingText()));
            this.printer.println();
            this.printer.println();
        }
        this.printer.println();
    }

    public void visitEnter(Axiom axiom) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        this.printer.print("Axiom " + numbers.getAxiomNumber());
        this.printer.print(" ");
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        this.printer.print("     ");
        this.printFormula(axiom.getFormula().getElement());
        this.printer.println();
        if (axiom.getDescription() != null) {
            this.printer.append(this.getLatexListEntry("getDescription()", axiom.getDescription()));
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitEnter(Proposition proposition) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        this.printer.print("Proposition " + numbers.getPropositionNumber());
        this.printer.print(" ");
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        this.printTopFormula(proposition.getFormula().getElement(), this.id);
        this.printer.println();
        if (proposition.getDescription() != null) {
            this.printer.append(this.getLatexListEntry("getDescription()", proposition.getDescription()));
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitEnter(Proof proof) {
        if ("de".equals(this.language)) {
            this.printer.println("Beweis:");
        } else {
            this.printer.println("Proof:");
        }
        this.printer.append(this.getLatexListEntry("getNonFormalProof()", proof.getNonFormalProof()));
        this.printer.println();
        this.printer.println("q.e.d.");
        this.printer.println();
    }

    public void visitEnter(FormalProof proof) {
        if ("de".equals(this.language)) {
            this.printer.println("Beweis (formal):");
        } else {
            this.printer.println("Proof (formal):");
        }
    }

    public void visitEnter(FormalProofLine line) {
        if (line.getLabel() != null) {
            this.printer.print(StringUtility.alignRight("(" + line.getLabel() + ")", 5) + " ");
        }
        if (line.getReasonType() != null && line.getReasonType().getReason() != null) {
            this.setReason(line.getReasonType().getReason().toString());
        } else {
            this.reason = new String[0];
        }
        this.formula = line.getFormula() != null ? this.getQedeqBo().getElement2Utf8().getUtf8(line.getFormula().getElement(), this.formulaWidth) : new String[0];
    }

    public void visitLeave(FormalProofLine line) {
        int to = Math.max(this.formula.length, this.reason.length);
        for (int i = 0; i < to; ++i) {
            this.printer.skipToColumn(6);
            if (i < this.formula.length) {
                this.printer.print(this.formula[i]);
            }
            if (i < this.reason.length) {
                this.printer.skipToColumn(8 + this.formulaWidth);
                this.printer.print(this.reason[i]);
            }
            this.printer.println();
        }
    }

    private void setReason(String reasonString) {
        ArrayList<String> list = new ArrayList<String>();
        for (int index = 0; index < reasonString.length(); index += this.reasonWidth) {
            list.add(StringUtility.substring(reasonString, index, this.reasonWidth));
        }
        this.reason = list.toArray(new String[0]);
    }

    private String getReference(String reference) {
        return this.getReference(reference, "getReference()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getReference(String reference, String subContext) {
        String context = this.getCurrentContext().getLocationWithinModule();
        try {
            this.getCurrentContext().setLocationWithinModule(context + "." + subContext);
            String string = this.getReferenceLink(reference, null, null);
            return string;
        }
        finally {
            this.getCurrentContext().setLocationWithinModule(context);
        }
    }

    public void visitEnter(ModusPonens r) throws ModuleDataException {
        String buffer = r.getName();
        boolean one = false;
        if (r.getReference1() != null) {
            buffer = buffer + " " + this.getReference(r.getReference1(), "getReference1()");
            one = true;
        }
        if (r.getReference1() != null) {
            if (one) {
                buffer = buffer + ",";
            }
            buffer = buffer + " " + this.getReference(r.getReference2(), "getReference2()");
        }
        this.setReason(buffer);
    }

    public void visitEnter(Add r) throws ModuleDataException {
        String buffer = r.getName();
        if (r.getReference() != null) {
            buffer = buffer + " " + this.getReference(r.getReference());
        }
        this.setReason(buffer);
    }

    public void visitEnter(Rename r) throws ModuleDataException {
        String buffer = r.getName();
        if (r.getOriginalSubjectVariable() != null) {
            buffer = buffer + " " + this.getQedeqBo().getElement2Utf8().getUtf8(r.getOriginalSubjectVariable());
        }
        if (r.getReplacementSubjectVariable() != null) {
            buffer = buffer + " by " + this.getQedeqBo().getElement2Utf8().getUtf8(r.getReplacementSubjectVariable());
        }
        if (r.getReference() != null) {
            buffer = buffer + " in " + this.getReference(r.getReference());
        }
        this.setReason(buffer);
    }

    public void visitEnter(SubstFree r) throws ModuleDataException {
        String buffer = r.getName();
        if (r.getSubjectVariable() != null) {
            buffer = buffer + " " + this.getQedeqBo().getElement2Utf8().getUtf8(r.getSubjectVariable());
        }
        if (r.getSubstituteTerm() != null) {
            buffer = buffer + " by " + this.getQedeqBo().getElement2Utf8().getUtf8(r.getSubstituteTerm());
        }
        if (r.getReference() != null) {
            buffer = buffer + " in " + this.getReference(r.getReference());
        }
        this.setReason(buffer);
    }

    public void visitEnter(SubstFunc r) throws ModuleDataException {
        String buffer = r.getName();
        if (r.getFunctionVariable() != null) {
            buffer = buffer + " " + this.getQedeqBo().getElement2Utf8().getUtf8(r.getFunctionVariable());
        }
        if (r.getSubstituteTerm() != null) {
            buffer = buffer + " by " + this.getQedeqBo().getElement2Utf8().getUtf8(r.getSubstituteTerm());
        }
        if (r.getReference() != null) {
            buffer = buffer + " in " + this.getReference(r.getReference());
        }
        this.setReason(buffer);
    }

    public void visitEnter(SubstPred r) throws ModuleDataException {
        String buffer = r.getName();
        if (r.getPredicateVariable() != null) {
            buffer = buffer + " " + this.getQedeqBo().getElement2Utf8().getUtf8(r.getPredicateVariable());
        }
        if (r.getSubstituteFormula() != null) {
            buffer = buffer + " by " + this.getQedeqBo().getElement2Utf8().getUtf8(r.getSubstituteFormula());
        }
        if (r.getReference() != null) {
            buffer = buffer + " in " + this.getReference(r.getReference());
        }
        this.setReason(buffer);
    }

    public void visitEnter(Existential r) throws ModuleDataException {
        String buffer = r.getName();
        if (r.getSubjectVariable() != null) {
            buffer = buffer + " with " + this.getQedeqBo().getElement2Utf8().getUtf8(r.getSubjectVariable());
        }
        if (r.getReference() != null) {
            buffer = buffer + " in " + this.getReference(r.getReference());
        }
        this.setReason(buffer);
    }

    public void visitEnter(Universal r) throws ModuleDataException {
        String buffer = r.getName();
        if (r.getSubjectVariable() != null) {
            buffer = buffer + " with " + this.getQedeqBo().getElement2Utf8().getUtf8(r.getSubjectVariable());
        }
        if (r.getReference() != null) {
            buffer = buffer + " in " + this.getReference(r.getReference());
        }
        this.setReason(buffer);
    }

    public void visitLeave(FormalProof proof) {
        this.printer.println();
        this.printer.println("q.e.d.");
        this.printer.println();
    }

    public void visitEnter(InitialPredicateDefinition definition) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        StringBuffer buffer = new StringBuffer();
        if ("de".equals(this.language)) {
            buffer.append("initiale ");
        } else {
            buffer.append("initial ");
        }
        buffer.append("Definition " + (numbers.getPredicateDefinitionNumber() + numbers.getFunctionDefinitionNumber()));
        this.printer.print(buffer.toString());
        this.printer.print(" ");
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        this.printer.print("     ");
        this.printer.println(this.getUtf8(definition.getPredCon()));
        this.printer.println();
        if (definition.getDescription() != null) {
            this.printer.append(this.getLatexListEntry("getDescription()", definition.getDescription()));
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitEnter(PredicateDefinition definition) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Definition " + (numbers.getPredicateDefinitionNumber() + numbers.getFunctionDefinitionNumber()));
        this.printer.print(buffer.toString());
        this.printer.print(" ");
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        this.printer.print("     ");
        this.printer.println(this.getUtf8(definition.getFormula().getElement()));
        this.printer.println();
        if (definition.getDescription() != null) {
            this.printer.append(this.getLatexListEntry("getDescription()", definition.getDescription()));
            this.printer.println();
            this.printer.println();
        }
    }

    public void visitEnter(InitialFunctionDefinition definition) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        StringBuffer buffer = new StringBuffer();
        if ("de".equals(this.language)) {
            buffer.append("initiale ");
        } else {
            buffer.append("initial ");
        }
        buffer.append("Definition " + (numbers.getPredicateDefinitionNumber() + numbers.getFunctionDefinitionNumber()));
        this.printer.print(buffer.toString());
        this.printer.print(" ");
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        this.printer.print("     ");
        this.printer.println(this.getUtf8(definition.getFunCon()));
        this.printer.println();
        if (definition.getDescription() != null) {
            this.printer.println(this.getLatexListEntry("getDescription()", definition.getDescription()));
            this.printer.println();
        }
    }

    public void visitEnter(FunctionDefinition definition) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Definition " + (numbers.getPredicateDefinitionNumber() + numbers.getFunctionDefinitionNumber()));
        this.printer.print(buffer.toString());
        this.printer.print(" ");
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        this.printer.print("     ");
        this.printer.println(this.getUtf8(definition.getFormula().getElement()));
        this.printer.println();
        if (definition.getDescription() != null) {
            this.printer.println(this.getLatexListEntry("getDescription()", definition.getDescription()));
            this.printer.println();
        }
    }

    public void visitEnter(Rule rule) {
        QedeqNumbers numbers = this.getCurrentNumbers();
        this.printer.print("\u2609 ");
        if ("de".equals(this.language)) {
            this.printer.print("Regel");
        } else {
            this.printer.print("Rule");
        }
        this.printer.print(" " + numbers.getRuleNumber());
        this.printer.print(" ");
        if (this.title != null && this.title.length() > 0) {
            this.printer.print(" (" + this.title + ")");
        }
        if (this.info) {
            this.printer.print("  [" + this.id + "]");
        }
        this.printer.println();
        this.printer.println();
        if (rule.getDescription() != null) {
            this.printer.append(this.getLatexListEntry("getDescription()", rule.getDescription()));
            this.printer.println();
            this.printer.println();
        }
        if (rule.getProofList() != null) {
            for (int i = 0; i < rule.getProofList().size(); ++i) {
                if ("de".equals(this.language)) {
                    this.printer.println("Beweis:");
                } else {
                    this.printer.println("Proof:");
                }
                this.printer.append(this.getLatexListEntry("getProofList().get(" + i + ")", rule.getProofList().get(i).getNonFormalProof()));
                this.printer.println();
                this.printer.println("q.e.d.");
                this.printer.println();
            }
        }
    }

    public void visitEnter(LinkList linkList) {
        if (linkList.size() <= 0) {
            return;
        }
        if ("de".equals(this.language)) {
            this.printer.println("Basierend auf: ");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Based on: ");
        }
        for (int i = 0; i < linkList.size(); ++i) {
            if (linkList.get(i) == null) continue;
            this.printer.print(" (" + linkList.get(i) + ")");
        }
        this.printer.println();
    }

    public void visitEnter(LiteratureItemList list) {
        this.printer.println();
        this.printer.println();
        if ("de".equals(this.language)) {
            this.underlineBig("Literaturverzeichnis");
        } else {
            this.underlineBig("Bibliography");
        }
        this.printer.println();
        this.printer.println();
        ImportList imports = this.getQedeqBo().getQedeq().getHeader().getImportList();
        if (imports != null && imports.size() > 0) {
            this.printer.println();
            this.printer.println();
            if ("de".equals(this.language)) {
                this.printer.println("Benutzte andere QEDEQ-Module:");
            } else {
                this.printer.println("Used other QEDEQ modules:");
            }
            this.printer.println();
            for (int i = 0; i < imports.size(); ++i) {
                Import imp = imports.get(i);
                this.printer.print("[" + imp.getLabel() + "] ");
                Specification spec = imp.getSpecification();
                this.printer.print(spec.getName());
                if (spec.getLocationList() != null && spec.getLocationList().size() > 0 && spec.getLocationList().get(0).getLocation().length() > 0) {
                    this.printer.print("  ");
                    this.printer.print(this.getUrl(this.getQedeqBo().getModuleAddress(), spec));
                }
                this.printer.println();
            }
            this.printer.println();
            this.printer.println();
            if ("de".equals(this.language)) {
                this.printer.println("Andere Referenzen:");
            } else {
                this.printer.println("Other references:");
            }
            this.printer.println();
        }
    }

    public void visitLeave(LiteratureItemList list) {
        UsedByList usedby = this.getQedeqBo().getQedeq().getHeader().getUsedByList();
        if (usedby != null && usedby.size() > 0) {
            this.printer.println();
            this.printer.println();
            if ("de".equals(this.language)) {
                this.printer.println("QEDEQ-Module, welche dieses hier verwenden:");
            } else {
                this.printer.println("QEDEQ modules that use this one:");
            }
            for (int i = 0; i < usedby.size(); ++i) {
                Specification spec = usedby.get(i);
                this.printer.print(spec.getName());
                String url = this.getUrl(this.getQedeqBo().getModuleAddress(), spec);
                if (url != null && url.length() > 0) {
                    this.printer.print("  ");
                    this.printer.print(url);
                }
                this.printer.println();
            }
            this.printer.println();
            this.printer.println();
        }
        this.printer.println();
    }

    public void visitEnter(LiteratureItem item) {
        this.printer.print("[" + item.getLabel() + "] ");
        this.printer.println(this.getLatexListEntry("getItem()", item.getItem()));
        this.printer.println();
    }

    private void printTopFormula(Element element, String mainLabel) {
        if (!element.isList() || !element.getList().getOperator().equals("AND")) {
            this.printer.print("     ");
            this.printFormula(element);
            return;
        }
        ElementList list = element.getList();
        for (int i = 0; i < list.size(); ++i) {
            String label = "";
            if (list.size() >= ALPHABET.length() * ALPHABET.length()) {
                label = "" + (i + 1);
            } else {
                if (list.size() > ALPHABET.length()) {
                    int div = i / ALPHABET.length();
                    label = "" + ALPHABET.charAt(div);
                }
                label = label + ALPHABET.charAt(i % ALPHABET.length());
            }
            this.printer.println("  (" + label + ")  " + this.getUtf8(list.getElement(i)));
        }
    }

    private void printFormula(Element element) {
        this.printer.println(this.getUtf8(element));
    }

    private String getUtf8(Element element) {
        return this.getUtf8(this.getQedeqBo().getElement2Latex().getLatex(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLatexListEntry(String method, LatexList list) {
        if (list == null) {
            return "";
        }
        if (method.length() > 0) {
            this.subContext = method;
        }
        try {
            int i;
            for (i = 0; i < list.size(); ++i) {
                if (!this.language.equals(list.get(i).getLanguage())) continue;
                if (method.length() > 0) {
                    this.subContext = method + ".get(" + i + ")";
                }
                String string = this.getUtf8(list.get(i));
                return string;
            }
            for (i = 0; i < list.size(); ++i) {
                if (list.get(i).getLanguage() != null) continue;
                if (method.length() > 0) {
                    this.subContext = method + ".get(" + i + ")";
                }
                String string = this.getUtf8(list.get(i));
                return string;
            }
            i = 0;
            if (i < list.size()) {
                if (method.length() > 0) {
                    this.subContext = method + ".get(" + i + ")";
                }
                String string = "MISSING! OTHER: " + this.getUtf8(list.get(i));
                return string;
            }
            String string = "MISSING!";
            return string;
        }
        finally {
            if (method.length() > 0) {
                this.subContext = "";
            }
        }
    }

    private ModuleContext getCurrentContext(SourcePosition startDelta, SourcePosition endDelta) {
        if (this.subContext.length() == 0) {
            return super.getCurrentContext();
        }
        ModuleContext c = new ModuleContext(super.getCurrentContext().getModuleLocation(), super.getCurrentContext().getLocationWithinModule() + "." + this.subContext, startDelta, endDelta);
        return c;
    }

    public void addWarning(int code, String msg, SourcePosition startDelta, SourcePosition endDelta) {
        Trace.param(CLASS, (Object)this, "addWarning", "msg", msg);
        if (this.addWarnings) {
            this.addWarning(new UnicodeException(code, msg, this.getCurrentContext(startDelta, endDelta)));
        }
    }

    public void addWarning(int code, String msg) {
        Trace.param(CLASS, (Object)this, "addWarning", "msg", msg);
        if (this.addWarnings) {
            this.addWarning(new UnicodeException(code, msg, this.getCurrentContext()));
        }
    }

    private String getUtf8(Latex latex) {
        if (latex == null || latex.getLatex() == null) {
            return "";
        }
        return this.getUtf8(latex.getLatex());
    }

    private String getUtf8(String latex) {
        if (latex == null) {
            return "";
        }
        return Latex2UnicodeParser.transform(this, latex, this.maxColumns);
    }

    private void underlineBig(String text) {
        this.printer.println(text);
        for (int i = 0; i < text.length(); ++i) {
            this.printer.print("\u2550");
        }
        this.printer.println();
    }

    private void underline(String text) {
        this.printer.println(text);
        for (int i = 0; i < text.length(); ++i) {
            this.printer.print("\u2015");
        }
        this.printer.println();
    }

    public String getReferenceLink(String reference, SourcePosition start, SourcePosition end) {
        Reference ref = this.getReference(reference, this.getCurrentContext(start, end), this.addWarnings, false);
        if (ref.isNodeLocalReference() && ref.isSubReference()) {
            return "(" + ref.getSubLabel() + ")";
        }
        if (ref.isNodeLocalReference() && ref.isProofLineReference()) {
            return "(" + ref.getProofLineLabel() + ")";
        }
        if (!ref.isExternal()) {
            return this.getNodeDisplay(ref.getNodeLabel(), ref.getNode()) + (ref.isSubReference() ? " (" + ref.getSubLabel() + ")" : "") + (ref.isProofLineReference() ? " (" + ref.getProofLineLabel() + ")" : "");
        }
        if (ref.isExternalModuleReference()) {
            return "[" + ref.getExternalQedeqLabel() + "]";
        }
        return this.getNodeDisplay(ref.getNodeLabel(), ref.getNode()) + (ref.isSubReference() ? " (" + ref.getSubLabel() + ")" : "") + (ref.isProofLineReference() ? " (" + ref.getProofLineLabel() + ")" : "") + (ref.isExternal() ? " [" + ref.getExternalQedeqLabel() + "]" : "");
    }

    private String getNodeDisplay(String label, KernelNodeBo kNode) {
        return this.getNodeDisplay(label, kNode, this.language);
    }
}

