/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.unicode;

import java.io.IOException;
import java.util.Map;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.StringOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.common.PluginExecutor;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.service.unicode.Qedeq2UnicodeVisitor;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public final class Qedeq2UnicodeTextExecutor
implements PluginExecutor {
    private static final Class CLASS = Qedeq2UnicodeTextExecutor.class;
    private StringOutput printer;
    private String language = "en";
    private final Qedeq2UnicodeVisitor visitor;
    private int maxColumns;

    Qedeq2UnicodeTextExecutor(Plugin plugin, KernelQedeqBo prop, Map parameters) {
        if (parameters != null) {
            this.language = (String)parameters.get("language");
            if (this.language == null) {
                this.language = "en";
            }
        }
        String infoString = null;
        String maxColumnsString = "0";
        if (parameters != null) {
            infoString = (String)parameters.get("info");
            if (infoString == null) {
                infoString = "false";
            }
            if ((maxColumnsString = (String)parameters.get("maximumColumn")) == null || maxColumnsString.length() == 0) {
                maxColumnsString = "80";
            }
        }
        boolean info = "true".equalsIgnoreCase(infoString);
        this.maxColumns = 0;
        try {
            this.maxColumns = Integer.parseInt(maxColumnsString.trim());
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.visitor = new Qedeq2UnicodeVisitor(plugin, prop, info, this.maxColumns, false);
    }

    public Object executePlugin() {
        String method = "executePlugin()";
        String ref = "\"" + IoUtility.easyUrl(this.visitor.getQedeqBo().getUrl()) + "\"";
        String result = "";
        try {
            QedeqLog.getInstance().logRequest("Show UTF-8 text for " + ref);
            result = this.generateUtf8(this.language, "1");
            QedeqLog.getInstance().logSuccessfulReply("UTF-8 text was shown for " + ref + "\"");
        }
        catch (SourceFileExceptionList e) {
            String msg = "Generation failed for " + ref;
            Trace.fatal(CLASS, this, "executePlugin()", msg, e);
            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
        }
        catch (IOException e) {
            String msg = "Generation failed for " + ref;
            Trace.fatal(CLASS, this, "executePlugin()", msg, e);
            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "executePlugin()", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", "unexpected problem: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        return result;
    }

    public String generateUtf8(String language, String level) throws SourceFileExceptionList, IOException {
        String lan = "en";
        if (language != null) {
            lan = language;
        }
        this.printer = new StringOutput();
        this.visitor.generateUtf8(this.printer, lan, level);
        return this.printer.toString();
    }

    public String getExecutionActionDescription() {
        return this.visitor.getExecutionActionDescription();
    }

    public double getExecutionPercentage() {
        return this.visitor.getExecutionPercentage();
    }
}

