/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.logic;

import java.util.Map;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.common.PluginExecutor;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.logic.FormulaCheckerFactoryImpl;
import org.qedeq.kernel.bo.logic.common.FormulaCheckerFactory;
import org.qedeq.kernel.bo.logic.common.FormulaUtility;
import org.qedeq.kernel.bo.logic.common.FunctionConstant;
import org.qedeq.kernel.bo.logic.common.FunctionKey;
import org.qedeq.kernel.bo.logic.common.LogicalCheckExceptionList;
import org.qedeq.kernel.bo.logic.common.PredicateConstant;
import org.qedeq.kernel.bo.logic.common.PredicateKey;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.service.logic.CheckRequiredModuleException;
import org.qedeq.kernel.bo.service.logic.ModuleConstantsExistenceCheckerImpl;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.Formula;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.ReasonType;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.se.common.IllegalModuleDataException;
import org.qedeq.kernel.se.common.LogicalModuleState;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.list.ElementSet;

public final class WellFormedCheckerExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = WellFormedCheckerExecutor.class;
    private ModuleConstantsExistenceCheckerImpl existence;
    private FormulaCheckerFactory checkerFactory = null;
    private Map parameters;

    WellFormedCheckerExecutor(Plugin plugin, KernelQedeqBo qedeq, Map parameters) {
        super(plugin, qedeq);
        String checkerFactoryClass;
        String method = "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)";
        this.parameters = parameters;
        String string = checkerFactoryClass = parameters != null ? (String)parameters.get("checkerFactory") : null;
        if (checkerFactoryClass != null && checkerFactoryClass.length() > 0) {
            try {
                Class<?> cl = Class.forName(checkerFactoryClass);
                this.checkerFactory = (FormulaCheckerFactory)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "FormulaCheckerFactory class not in class path: " + checkerFactoryClass, e);
            }
            catch (InstantiationException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "FormulaCheckerFactory class could not be instanciated: " + checkerFactoryClass, e);
            }
            catch (IllegalAccessException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "Programming error, access for instantiation failed for model: " + checkerFactoryClass, e);
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "Programming error, instantiation failed for model: " + checkerFactoryClass, e);
            }
        }
        if (this.checkerFactory == null) {
            this.checkerFactory = new FormulaCheckerFactoryImpl();
        }
    }

    private Map getParameters() {
        return this.parameters;
    }

    public Object executePlugin() {
        if (this.getQedeqBo().isChecked()) {
            return Boolean.TRUE;
        }
        QedeqLog.getInstance().logRequest("Check logical well formedness for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"");
        this.getServices().loadModule(this.getQedeqBo().getModuleAddress());
        if (!this.getQedeqBo().isLoaded()) {
            String msg = "Check of logical correctness failed for \"" + this.getQedeqBo().getUrl() + "\"";
            QedeqLog.getInstance().logFailureReply(msg, "Module could not even be loaded.");
            return Boolean.FALSE;
        }
        this.getServices().loadRequiredModules(this.getQedeqBo().getModuleAddress());
        if (!this.getQedeqBo().hasLoadedRequiredModules()) {
            String msg = "Check of logical well formedness failed for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            QedeqLog.getInstance().logFailureReply(msg, "Not all required modules could be loaded.");
            return Boolean.FALSE;
        }
        this.getQedeqBo().setLogicalProgressState(LogicalModuleState.STATE_EXTERNAL_CHECKING);
        DefaultSourceFileExceptionList sfl = new DefaultSourceFileExceptionList();
        KernelModuleReferenceList list = (KernelModuleReferenceList)this.getQedeqBo().getRequiredModules();
        for (int i = 0; i < list.size(); ++i) {
            Trace.trace(CLASS, (Object)"check(DefaultQedeqBo)", "checking label", list.getLabel(i));
            WellFormedCheckerExecutor checker = new WellFormedCheckerExecutor(this.getPlugin(), list.getKernelQedeqBo(i), this.getParameters());
            checker.executePlugin();
            if (list.getKernelQedeqBo(i).isChecked()) continue;
            CheckRequiredModuleException md = new CheckRequiredModuleException(11231, "import check failed: " + list.getQedeqBo(i).getModuleAddress(), list.getModuleContext(i));
            ((SourceFileExceptionList)sfl).add(this.getQedeqBo().createSourceFileException(this.getPlugin(), md));
        }
        if (((SourceFileExceptionList)sfl).size() > 0) {
            this.getQedeqBo().setLogicalFailureState(LogicalModuleState.STATE_EXTERNAL_CHECKING_FAILED, sfl);
            String msg = "Check of logical well formedness failed for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            QedeqLog.getInstance().logFailureReply(msg, ((Throwable)sfl).getMessage());
            return Boolean.FALSE;
        }
        this.getQedeqBo().setLogicalProgressState(LogicalModuleState.STATE_INTERNAL_CHECKING);
        this.getQedeqBo().setExistenceChecker(this.existence);
        try {
            this.traverse();
        }
        catch (SourceFileExceptionList e) {
            this.getQedeqBo().setLogicalFailureState(LogicalModuleState.STATE_INTERNAL_CHECKING_FAILED, e);
            String msg = "Check of logical well formedness failed for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            QedeqLog.getInstance().logFailureReply(msg, ((Throwable)sfl).getMessage());
            return Boolean.FALSE;
        }
        this.getQedeqBo().setChecked(this.existence);
        QedeqLog.getInstance().logSuccessfulReply("Check of logical well formedness successful for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"");
        return Boolean.TRUE;
    }

    public void traverse() throws SourceFileExceptionList {
        try {
            this.existence = new ModuleConstantsExistenceCheckerImpl(this.getQedeqBo());
        }
        catch (ModuleDataException me) {
            this.addError(me);
            throw this.getErrorList();
        }
        super.traverse();
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = axiom.getFormula();
            LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        } else {
            this.getNodeBo().setWellFormed(10);
        }
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        PredicateKey predicateKey = new PredicateKey(definition.getName(), definition.getArgumentNumber());
        if (this.existence.predicateExists(predicateKey)) {
            this.addError(new IllegalModuleDataException(40400, "predicate was already defined for this argument number: " + predicateKey, this.getCurrentContext()));
        } else if (definition.getFormula() == null) {
            this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an equivalence relation (with two parameters)", this.getCurrentContext()));
        } else {
            Element completeFormula = definition.getFormula().getElement();
            if (completeFormula == null) {
                this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an equivalence relation (with two parameters)", this.getCurrentContext()));
            } else {
                this.setLocationWithinModule(context + ".getFormula().getElement()");
                if (completeFormula.isAtom()) {
                    this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an equivalence relation (with two parameters)", this.getCurrentContext()));
                } else {
                    ElementList equi = completeFormula.getList();
                    String operator = equi.getOperator();
                    if (!operator.equals("EQUI") || equi.size() != 2) {
                        this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an equivalence relation (with two parameters)", this.getCurrentContext()));
                    } else {
                        this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(0)");
                        if (equi.getElement(0).isAtom()) {
                            this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an predicate constant as the first parameter", this.getCurrentContext()));
                        } else {
                            ElementList predicate = equi.getElement(0).getList();
                            if (predicate.getOperator() != "PREDCON") {
                                this.addError(new IllegalModuleDataException(30810, "a predicate definition needs an predicate constant as the first parameter", this.getCurrentContext()));
                            } else {
                                Element definingFormula = equi.getElement(1);
                                ElementSet free = FormulaUtility.getFreeSubjectVariables(definingFormula);
                                for (int i = 0; i < predicate.size(); ++i) {
                                    this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(0).getList().getElement(" + i + ")");
                                    if (i == 0) {
                                        if (!predicate.getElement(0).isAtom() || !EqualsUtility.equals(definition.getName(), predicate.getElement(0).getAtom().getString())) {
                                            this.addError(new IllegalModuleDataException(40720, "predicate name found is not as expected: " + StringUtility.quote(definition.getName()) + " - " + StringUtility.quote(predicate.getElement(0).getAtom().getString()), this.getCurrentContext()));
                                            continue;
                                        }
                                    } else if (!FormulaUtility.isSubjectVariable(predicate.getElement(i))) {
                                        this.addError(new IllegalModuleDataException(40500, "a subject variable was expected here, but we found: " + predicate.getElement(i), this.getCurrentContext()));
                                        continue;
                                    }
                                    this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1)");
                                    if (i == 0 || free.contains(predicate.getElement(i))) continue;
                                    this.addError(new IllegalModuleDataException(40510, "subject variable doesn't occur free in formula or term: " + predicate.getElement(i), this.getCurrentContext()));
                                }
                                this.setLocationWithinModule(context + ".getFormula().getElement()");
                                if (predicate.size() - 1 != free.size()) {
                                    this.addError(new IllegalModuleDataException(40520, "number of subject variables in definition not equal to number of free subject variables of formula or term", this.getCurrentContext()));
                                }
                                this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1)");
                                LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkFormula(definingFormula, this.getCurrentContext(), this.existence);
                                for (int i = 0; i < list.size(); ++i) {
                                    this.addError(list.get(i));
                                }
                                if (list.size() <= 0) {
                                    this.setLocationWithinModule(context + ".getFormula().getElement().getList()");
                                    PredicateConstant constant = new PredicateConstant(predicateKey, equi, this.getCurrentContext());
                                    this.setLocationWithinModule(context);
                                    if (this.existence.predicateExists(predicateKey)) {
                                        this.addError(new IllegalModuleDataException(40400, "predicate was already defined for this argument number: " + predicateKey, this.getCurrentContext()));
                                    } else {
                                        this.existence.add(constant);
                                        this.setLocationWithinModule(context + ".getFormula().getElement().getList()");
                                        LogicalCheckExceptionList errorlist = this.checkerFactory.createFormulaChecker().checkFormula(completeFormula, this.getCurrentContext(), this.existence);
                                        for (int i = 0; i < errorlist.size(); ++i) {
                                            this.addError(errorlist.get(i));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.setLocationWithinModule(context);
        if ("2".equals(predicateKey.getArguments()) && "equal".equals(predicateKey.getName())) {
            this.existence.setIdentityOperatorDefined(predicateKey.getName(), this.getQedeqBo(), this.getCurrentContext());
        }
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialPredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        PredicateKey predicateKey = new PredicateKey(definition.getName(), definition.getArgumentNumber());
        this.setLocationWithinModule(context);
        if (this.existence.predicateExists(predicateKey)) {
            this.addError(new IllegalModuleDataException(40400, "predicate was already defined for this argument number: " + predicateKey, this.getCurrentContext()));
        }
        this.existence.add(definition);
        if ("2".equals(predicateKey.getArguments()) && "equal".equals(predicateKey.getName())) {
            this.existence.setIdentityOperatorDefined(predicateKey.getName(), this.getQedeqBo(), this.getCurrentContext());
        }
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    public void visitLeave(InitialPredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialFunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        FunctionKey function = new FunctionKey(definition.getName(), definition.getArgumentNumber());
        if (this.existence.functionExists(function)) {
            this.addError(new IllegalModuleDataException(40400, "function was already defined for this argument number: " + function, this.getCurrentContext()));
        }
        this.existence.add(definition);
        this.setLocationWithinModule(context);
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    public void visitLeave(InitialFunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        FunctionKey function = new FunctionKey(definition.getName(), definition.getArgumentNumber());
        if (this.existence.functionExists(function)) {
            this.addError(new IllegalModuleDataException(40400, "function was already defined for this argument number: " + function, this.getCurrentContext()));
        } else if (definition.getFormula() == null) {
            this.addError(new IllegalModuleDataException(40730, "no definition formula for new function found", this.getCurrentContext()));
        } else {
            Formula formulaArgument = definition.getFormula();
            this.setLocationWithinModule(context + ".getFormula()");
            if (formulaArgument.getElement() == null || formulaArgument.getElement().isAtom()) {
                this.addError(new IllegalModuleDataException(40730, "no definition formula for new function found", this.getCurrentContext()));
            } else {
                ElementList formula = formulaArgument.getElement().getList();
                this.setLocationWithinModule(context + ".getFormula().getElement().getList()");
                if (!this.existence.identityOperatorExists()) {
                    this.addError(new IllegalModuleDataException(40530, "the identity operator must be defined firstly before you can define a function constant", this.getCurrentContext()));
                } else if (!"PREDCON".equals(formula.getOperator())) {
                    this.addError(new IllegalModuleDataException(40540, "a function definition must be an equal relation", this.getCurrentContext()));
                } else if (formula.size() != 3) {
                    this.addError(new IllegalModuleDataException(40540, "a function definition must be an equal relation", this.getCurrentContext()));
                } else if (!formula.getElement(0).isAtom()) {
                    this.addError(new IllegalModuleDataException(40540, "a function definition must be an equal relation", this.getCurrentContext()));
                } else if (!EqualsUtility.equals(this.existence.getIdentityOperator(), formula.getElement(0).getAtom().getString())) {
                    this.addError(new IllegalModuleDataException(40540, "a function definition must be an equal relation", this.getCurrentContext()));
                } else {
                    this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1)");
                    if (formula.getElement(1).isAtom()) {
                        this.addError(new IllegalModuleDataException(40550, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                    } else {
                        ElementList functionConstant = formula.getElement(1).getList();
                        if (!"FUNCON".equals(functionConstant.getOperator())) {
                            this.addError(new IllegalModuleDataException(40550, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                        } else {
                            this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1).getList()");
                            int size = functionConstant.size();
                            if (!("" + (size - 1)).equals(definition.getArgumentNumber())) {
                                this.addError(new IllegalModuleDataException(40550, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                            } else {
                                this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1).getList().getElement(0)");
                                if (!functionConstant.getElement(0).isAtom()) {
                                    this.addError(new IllegalModuleDataException(40550, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                                } else if (!EqualsUtility.equals(definition.getName(), functionConstant.getElement(0).getAtom().getString())) {
                                    this.addError(new IllegalModuleDataException(40550, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                                } else {
                                    this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(2)");
                                    if (formula.getElement(2).isAtom()) {
                                        this.addError(new IllegalModuleDataException(40560, "first operand of equal relation must be the new function constant", this.getCurrentContext()));
                                    } else {
                                        ElementList term = formula.getElement(2).getList();
                                        this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1)");
                                        ElementSet free = FormulaUtility.getFreeSubjectVariables(term);
                                        if (size - 1 != free.size()) {
                                            this.addError(new IllegalModuleDataException(40520, "number of subject variables in definition not equal to number of free subject variables of formula or term", this.getCurrentContext()));
                                        } else {
                                            if (functionConstant.getElement(0).isList() || !EqualsUtility.equals(function.getName(), functionConstant.getElement(0).getAtom().getString())) {
                                                // empty if block
                                            }
                                            for (int i = 1; i < size; ++i) {
                                                this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(1)" + ".getList().get(" + i + ")");
                                                if (!FormulaUtility.isSubjectVariable(functionConstant.getElement(i))) {
                                                    this.addError(new IllegalModuleDataException(40500, "a subject variable was expected here, but we found: " + functionConstant.getElement(i), this.getCurrentContext()));
                                                }
                                                if (free.contains(functionConstant.getElement(i))) continue;
                                                this.addError(new IllegalModuleDataException(40510, "subject variable doesn't occur free in formula or term: " + functionConstant.getElement(i), this.getCurrentContext()));
                                            }
                                            this.setLocationWithinModule(context + ".getFormula().getElement().getList().getElement(2)");
                                            LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkTerm(term, this.getCurrentContext(), this.existence);
                                            for (int i = 0; i < list.size(); ++i) {
                                                this.addError(list.get(i));
                                            }
                                            if (list.size() <= 0) {
                                                this.setLocationWithinModule(context + ".getFormula().getElement().getList()");
                                                this.existence.add(new FunctionConstant(function, formula, this.getCurrentContext()));
                                                LogicalCheckExceptionList listComplete = this.checkerFactory.createFormulaChecker().checkFormula(formulaArgument.getElement(), this.getCurrentContext(), this.existence);
                                                for (int i = 0; i < listComplete.size(); ++i) {
                                                    this.addError(listComplete.get(i));
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.setLocationWithinModule(context);
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.getNodeBo().setWellFormed(0);
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = proposition.getFormula();
            LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        } else {
            this.getNodeBo().setWellFormed(10);
        }
        if (proposition.getFormalProofList() != null) {
            for (int i = 0; i < proposition.getFormalProofList().size(); ++i) {
                FormalProofLineList list;
                FormalProof proof = proposition.getFormalProofList().get(i);
                if (proof == null || (list = proof.getFormalProofLineList()) == null) continue;
                for (int j = 0; j < list.size(); ++j) {
                    FormalProofLine line = list.get(j);
                    this.setLocationWithinModule(context + ".getFormalProofList().get(" + i + ").getFormalProofLineList().get(" + j + ")");
                    this.checkProofLine(line);
                }
            }
        }
        this.setLocationWithinModule(context);
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    private void checkProofLine(FormalProofLine line) {
        String context = this.getCurrentContext().getLocationWithinModule();
        LogicalCheckExceptionList elist = new LogicalCheckExceptionList();
        if (line != null) {
            ReasonType reasonType;
            Formula formula = line.getFormula();
            if (formula != null) {
                this.setLocationWithinModule(context + ".getFormula().getElement()");
                elist = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
                for (int k = 0; k < elist.size(); ++k) {
                    this.addError(elist.get(k));
                }
            }
            if ((reasonType = line.getReasonType()) != null) {
                if (reasonType.getSubstFree() != null && reasonType.getSubstFree().getSubstituteTerm() != null) {
                    this.setLocationWithinModule(context + ".getReasonType().getSubstFree().getSubstituteTerm()");
                    elist = this.checkerFactory.createFormulaChecker().checkTerm(reasonType.getSubstFree().getSubstituteTerm(), this.getCurrentContext(), this.existence);
                } else if (reasonType.getSubstPred() != null && reasonType.getSubstPred().getSubstituteFormula() != null) {
                    this.setLocationWithinModule(context + ".getReasonType().getSubstPred().getSubstituteFormula()");
                    elist = this.checkerFactory.createFormulaChecker().checkFormula(reasonType.getSubstPred().getSubstituteFormula(), this.getCurrentContext(), this.existence);
                } else if (reasonType.getSubstFunc() != null && reasonType.getSubstFunc().getSubstituteTerm() != null) {
                    this.setLocationWithinModule(context + ".getReasonType().getSubstFunc().getSubstituteTerm()");
                    elist = this.checkerFactory.createFormulaChecker().checkTerm(reasonType.getSubstFunc().getSubstituteTerm(), this.getCurrentContext(), this.existence);
                }
                for (int k = 0; k < elist.size(); ++k) {
                    this.addError(elist.get(k));
                }
            }
        }
    }

    public void visitLeave(Proposition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        if (rule == null) {
            return;
        }
        this.getNodeBo().setWellFormed(0);
        if (rule.getName() != null) {
            if ("SET_DEFINION_BY_FORMULA".equals(rule.getName())) {
                this.existence.setClassOperatorModule(this.getQedeqBo(), this.getCurrentContext());
            }
        } else {
            this.getNodeBo().setWellFormed(10);
        }
        if (!this.getNodeBo().isNotWellFormed()) {
            this.getNodeBo().setWellFormed(20);
        }
        this.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.setBlocked(false);
    }

    protected void addError(ModuleDataException me) {
        if (this.getNodeBo() != null) {
            this.getNodeBo().setWellFormed(10);
        }
        super.addError(me);
    }

    protected void addError(SourceFileException me) {
        if (this.getNodeBo() != null) {
            this.getNodeBo().setWellFormed(10);
        }
        super.addError(me);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }
}

