/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.logic;

import java.io.File;
import java.util.Map;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.YodaUtility;
import org.qedeq.kernel.bo.common.PluginExecutor;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.logic.ProofFinderFactoryImpl;
import org.qedeq.kernel.bo.logic.common.ProofFinder;
import org.qedeq.kernel.bo.logic.common.ProofFinderFactory;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.QedeqFileDao;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.common.LogicalModuleState;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.module.AddVo;
import org.qedeq.kernel.se.dto.module.FormalProofLineListVo;
import org.qedeq.kernel.se.dto.module.FormalProofLineVo;
import org.qedeq.kernel.se.dto.module.FormalProofVo;
import org.qedeq.kernel.se.dto.module.FormulaVo;
import org.qedeq.kernel.se.dto.module.PropositionVo;
import org.qedeq.kernel.se.dto.module.ReasonTypeVo;

public final class SimpleProofFinderExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = SimpleProofFinderExecutor.class;
    private ProofFinderFactory finderFactory = null;
    private FormalProofLineListVo validFormulas;
    private boolean noSave;
    private ProofFinder finder;

    SimpleProofFinderExecutor(Plugin plugin, KernelQedeqBo qedeq, Map parameters) {
        super(plugin, qedeq);
        String finderFactoryClass;
        String method = "SimpleProofFinderExecutor(Plugin, KernelQedeqBo, Map)";
        String string = finderFactoryClass = parameters != null ? (String)parameters.get("checkerFactory") : null;
        if (finderFactoryClass != null && finderFactoryClass.length() > 0) {
            try {
                Class<?> cl = Class.forName(finderFactoryClass);
                this.finderFactory = (ProofFinderFactory)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                Trace.fatal(CLASS, this, "SimpleProofFinderExecutor(Plugin, KernelQedeqBo, Map)", "ProofFinderFactory class not in class path: " + finderFactoryClass, e);
            }
            catch (InstantiationException e) {
                Trace.fatal(CLASS, this, "SimpleProofFinderExecutor(Plugin, KernelQedeqBo, Map)", "ProofFinderFactory class could not be instanciated: " + finderFactoryClass, e);
            }
            catch (IllegalAccessException e) {
                Trace.fatal(CLASS, this, "SimpleProofFinderExecutor(Plugin, KernelQedeqBo, Map)", "Programming error, access for instantiation failed for model: " + finderFactoryClass, e);
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "SimpleProofFinderExecutor(Plugin, KernelQedeqBo, Map)", "Programming error, instantiation failed for model: " + finderFactoryClass, e);
            }
        }
        if (this.finderFactory == null) {
            this.finderFactory = new ProofFinderFactoryImpl();
        }
        String noSaveString = null;
        if (parameters != null) {
            noSaveString = (String)parameters.get("noSave");
        }
        this.noSave = "true".equalsIgnoreCase(noSaveString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executePlugin() {
        this.getServices().checkModule(this.getQedeqBo().getModuleAddress());
        QedeqLog.getInstance().logRequest("Trying to create formal proofs for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"");
        try {
            this.validFormulas = new FormalProofLineListVo();
            this.traverse();
            QedeqLog.getInstance().logSuccessfulReply("Proof creation finished for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"");
        }
        catch (SourceFileExceptionList e) {
            String msg = "Proof creation not (fully?) successful for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
        }
        return Boolean.TRUE;
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        this.validFormulas.add(new FormalProofLineVo(new FormulaVo(this.getNodeBo().getFormula()), new ReasonTypeVo(new AddVo(this.getNodeBo().getNodeVo().getId()))));
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        this.validFormulas.add(new FormalProofLineVo(new FormulaVo(this.getNodeBo().getFormula()), new ReasonTypeVo(new AddVo(this.getNodeBo().getNodeVo().getId()))));
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialPredicateDefinition definition) throws ModuleDataException {
        this.setBlocked(true);
    }

    public void visitLeave(InitialPredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialFunctionDefinition definition) throws ModuleDataException {
        this.setBlocked(true);
    }

    public void visitLeave(InitialFunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        this.validFormulas.add(new FormalProofLineVo(new FormulaVo(this.getNodeBo().getFormula()), new ReasonTypeVo(new AddVo(this.getNodeBo().getNodeVo().getId()))));
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proposition.getFormalProofList() == null) {
            FormalProofLineList proof;
            try {
                this.finder = this.finderFactory.createProofFinder();
                proof = this.finder.findProof(proposition.getFormula().getElement(), this.validFormulas, this.getCurrentContext());
            }
            finally {
                this.finder = null;
            }
            try {
                Object state = YodaUtility.getFieldValue(this.getQedeqBo(), "stateManager");
                YodaUtility.executeMethod(state, "setLogicalState", new Class[]{LogicalModuleState.class}, new Object[]{LogicalModuleState.STATE_UNCHECKED});
                ((PropositionVo)proposition).addFormalProof(new FormalProofVo(proof));
                YodaUtility.executeMethod(state, "setErrors", new Class[]{SourceFileExceptionList.class}, new Object[]{null});
                ((PropositionVo)proposition).addFormalProof(new FormalProofVo(proof));
            }
            catch (Exception e) {
                String msg = "changing properties failed";
                Trace.fatal(CLASS, "visitEnter(Proposition)", "changing properties failed", e);
                QedeqLog.getInstance().logMessage("changing properties failed " + e.toString());
            }
            if (proof != null && !this.noSave) {
                File file = this.getServices().getLocalFilePath(this.getQedeqBo().getModuleAddress());
                try {
                    QedeqLog.getInstance().logMessage("Saving file \"" + file + "\"");
                    QedeqFileDao dao = this.getServices().getQedeqFileDao();
                    dao.saveQedeq(this.getQedeqBo(), file);
                    if (!this.getQedeqBo().getModuleAddress().isFileAddress()) {
                        QedeqLog.getInstance().logMessage("Only the the buffered file changed!");
                    }
                }
                catch (Exception e) {
                    String msg = "Saving file \"" + file + "\" failed";
                    Trace.fatal(CLASS, "visitEnter(Proposition)", msg, e);
                    QedeqLog.getInstance().logMessage(msg + " " + e.toString());
                }
            }
        } else {
            this.validFormulas.add(new FormalProofLineVo(new FormulaVo(this.getNodeBo().getFormula()), new ReasonTypeVo(new AddVo(this.getNodeBo().getNodeVo().getId()))));
        }
        this.setBlocked(true);
    }

    public void visitLeave(Proposition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        if (rule == null) {
            return;
        }
        this.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.setBlocked(false);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    public String getExecutionActionDescription() {
        String s = super.getExecutionActionDescription();
        if (this.finder == null) {
            return s;
        }
        return s + " " + this.finder.getExecutionActionDescription();
    }
}

