/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.logic;

import org.qedeq.kernel.bo.common.ModuleReferenceList;
import org.qedeq.kernel.bo.logic.common.ClassOperatorAlreadyExistsException;
import org.qedeq.kernel.bo.logic.common.FunctionConstant;
import org.qedeq.kernel.bo.logic.common.FunctionKey;
import org.qedeq.kernel.bo.logic.common.IdentityOperatorAlreadyExistsException;
import org.qedeq.kernel.bo.logic.common.PredicateConstant;
import org.qedeq.kernel.bo.logic.common.PredicateKey;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.ModuleConstantsExistenceChecker;
import org.qedeq.kernel.bo.service.logic.DefaultExistenceChecker;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;

public class ModuleConstantsExistenceCheckerImpl
extends DefaultExistenceChecker
implements ModuleConstantsExistenceChecker {
    private final KernelQedeqBo prop;
    private KernelQedeqBo classOperatorModule;
    private KernelQedeqBo identityOperatorModule;

    public ModuleConstantsExistenceCheckerImpl(KernelQedeqBo prop) throws ModuleDataException {
        this.prop = prop;
        this.init();
    }

    public final void init() throws ModuleDataException {
        this.clear();
        ModuleReferenceList list = this.prop.getRequiredModules();
        for (int i = 0; i < list.size(); ++i) {
            KernelQedeqBo bo = (KernelQedeqBo)list.getQedeqBo(i);
            if (bo.getExistenceChecker().identityOperatorExists()) {
                String identityOperator = list.getLabel(i) + "." + bo.getExistenceChecker().getIdentityOperator();
                this.setIdentityOperatorDefined(identityOperator, bo.getExistenceChecker().getIdentityOperatorModule(), list.getModuleContext(i));
            }
            if (!bo.getExistenceChecker().classOperatorExists()) continue;
            this.setClassOperatorModule(bo.getExistenceChecker().getClassOperatorModule(), list.getModuleContext(i));
        }
    }

    public boolean predicateExists(PredicateKey predicate) {
        String name = predicate.getName();
        String arguments = predicate.getArguments();
        int external = name.indexOf(46);
        if (external < 0) {
            return super.predicateExists(predicate);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        KernelQedeqBo newProp = (KernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return false;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().predicateExists(new PredicateKey(shortName, arguments));
    }

    public boolean functionExists(FunctionKey function) {
        String name = function.getName();
        String arguments = function.getArguments();
        int external = name.indexOf(".");
        if (external < 0) {
            return super.functionExists(function);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        KernelQedeqBo newProp = (KernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return false;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().functionExists(new FunctionKey(shortName, arguments));
    }

    public boolean isInitialPredicate(PredicateKey predicate) {
        String name = predicate.getName();
        String arguments = predicate.getArguments();
        int external = name.indexOf(46);
        if (external < 0) {
            return super.isInitialPredicate(predicate);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        KernelQedeqBo newProp = (KernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return false;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().isInitialPredicate(new PredicateKey(shortName, arguments));
    }

    public boolean isInitialFunction(FunctionKey function) {
        String name = function.getName();
        String arguments = function.getArguments();
        int external = name.indexOf(46);
        if (external < 0) {
            return super.isInitialFunction(function);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        KernelQedeqBo newProp = (KernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return false;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().isInitialFunction(new FunctionKey(shortName, arguments));
    }

    public PredicateConstant get(PredicateKey predicate) {
        String name = predicate.getName();
        String arguments = predicate.getArguments();
        int external = name.indexOf(46);
        if (external < 0) {
            return super.get(predicate);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        KernelQedeqBo newProp = (KernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return null;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().get(new PredicateKey(shortName, arguments));
    }

    public FunctionConstant get(FunctionKey function) {
        String name = function.getName();
        String arguments = function.getArguments();
        int external = name.indexOf(".");
        if (external < 0) {
            return super.get(function);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        KernelQedeqBo newProp = (KernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return null;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().get(new FunctionKey(shortName, arguments));
    }

    public KernelQedeqBo getQedeq(FunctionKey function) {
        String name = function.getName();
        String arguments = function.getArguments();
        int external = name.indexOf(".");
        if (external < 0) {
            if (this.functionExists(function)) {
                return this.prop;
            }
            return null;
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        KernelQedeqBo newProp = (KernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return newProp;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().getQedeq(new FunctionKey(shortName, arguments));
    }

    public KernelQedeqBo getQedeq(PredicateKey predicate) {
        String name = predicate.getName();
        String arguments = predicate.getArguments();
        int external = name.indexOf(".");
        if (external < 0) {
            if (this.predicateExists(predicate)) {
                return this.prop;
            }
            return null;
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        KernelQedeqBo newProp = (KernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return newProp;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().getQedeq(new PredicateKey(shortName, arguments));
    }

    public boolean classOperatorExists() {
        return this.classOperatorModule != null;
    }

    public void setIdentityOperatorDefined(String identityOperator, KernelQedeqBo identityOperatorModule, ModuleContext context) throws IdentityOperatorAlreadyExistsException {
        if (this.identityOperatorModule != null && identityOperatorModule != null) {
            if (!this.identityOperatorModule.equals(identityOperatorModule)) {
                throw new IdentityOperatorAlreadyExistsException(123476, "identity operator already defined with " + this.getIdentityOperator(), context);
            }
        } else {
            this.identityOperatorModule = identityOperatorModule;
            super.setIdentityOperatorDefined(identityOperator);
        }
    }

    public KernelQedeqBo getClassOperatorModule() {
        return this.classOperatorModule;
    }

    public KernelQedeqBo getIdentityOperatorModule() {
        return this.identityOperatorModule;
    }

    public void setClassOperatorModule(KernelQedeqBo classOperatorModule, ModuleContext context) throws ClassOperatorAlreadyExistsException {
        if (this.classOperatorModule != null && classOperatorModule != null) {
            if (!this.classOperatorModule.equals(classOperatorModule)) {
                throw new ClassOperatorAlreadyExistsException(123478, "class operator already defined within " + this.classOperatorModule.getUrl(), context);
            }
        } else {
            this.classOperatorModule = classOperatorModule;
        }
    }
}

