/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.logic;

import java.util.Map;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.common.PluginExecutor;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.logic.ProofCheckerFactoryImpl;
import org.qedeq.kernel.bo.logic.common.FormulaUtility;
import org.qedeq.kernel.bo.logic.common.FunctionKey;
import org.qedeq.kernel.bo.logic.common.LogicalCheckExceptionList;
import org.qedeq.kernel.bo.logic.common.PredicateKey;
import org.qedeq.kernel.bo.logic.common.ProofCheckerFactory;
import org.qedeq.kernel.bo.logic.common.ReferenceResolver;
import org.qedeq.kernel.bo.logic.proof.basic.ProofCheckException;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.Reference;
import org.qedeq.kernel.bo.service.logic.CheckRequiredModuleException;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.list.DefaultAtom;
import org.qedeq.kernel.se.dto.list.DefaultElementList;

public final class FormalProofCheckerExecutor
extends ControlVisitor
implements PluginExecutor,
ReferenceResolver {
    private static final Class CLASS = FormalProofCheckerExecutor.class;
    private ProofCheckerFactory checkerFactory = null;
    private Map parameters;

    FormalProofCheckerExecutor(Plugin plugin, KernelQedeqBo qedeq, Map parameters) {
        super(plugin, qedeq);
        String checkerFactoryClass;
        String method = "FormalProofCheckerExecutor(Plugin, KernelQedeqBo, Map)";
        this.parameters = parameters;
        String string = checkerFactoryClass = parameters != null ? (String)parameters.get("checkerFactory") : null;
        if (checkerFactoryClass != null && checkerFactoryClass.length() > 0) {
            try {
                Class<?> cl = Class.forName(checkerFactoryClass);
                this.checkerFactory = (ProofCheckerFactory)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                Trace.fatal(CLASS, this, "FormalProofCheckerExecutor(Plugin, KernelQedeqBo, Map)", "ProofCheckerFactory class not in class path: " + checkerFactoryClass, e);
            }
            catch (InstantiationException e) {
                Trace.fatal(CLASS, this, "FormalProofCheckerExecutor(Plugin, KernelQedeqBo, Map)", "ProofCheckerFactory class could not be instanciated: " + checkerFactoryClass, e);
            }
            catch (IllegalAccessException e) {
                Trace.fatal(CLASS, this, "FormalProofCheckerExecutor(Plugin, KernelQedeqBo, Map)", "Programming error, access for instantiation failed for model: " + checkerFactoryClass, e);
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "FormalProofCheckerExecutor(Plugin, KernelQedeqBo, Map)", "Programming error, instantiation failed for model: " + checkerFactoryClass, e);
            }
        }
        if (this.checkerFactory == null) {
            this.checkerFactory = new ProofCheckerFactoryImpl();
        }
    }

    private Map getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executePlugin() {
        QedeqLog.getInstance().logRequest("Check logical correctness for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"");
        this.getServices().checkModule(this.getQedeqBo().getModuleAddress());
        if (!this.getQedeqBo().isChecked()) {
            String msg = "Check of logical correctness failed for \"" + this.getQedeqBo().getUrl() + "\"";
            QedeqLog.getInstance().logFailureReply(msg, "Module is not even well formed.");
            return Boolean.FALSE;
        }
        DefaultSourceFileExceptionList sfl = new DefaultSourceFileExceptionList();
        KernelModuleReferenceList list = (KernelModuleReferenceList)this.getQedeqBo().getRequiredModules();
        for (int i = 0; i < list.size(); ++i) {
            Trace.trace(CLASS, (Object)"check(DefaultQedeqBo)", "checking label", list.getLabel(i));
            FormalProofCheckerExecutor checker = new FormalProofCheckerExecutor(this.getPlugin(), list.getKernelQedeqBo(i), this.getParameters());
            checker.executePlugin();
            if (!list.getKernelQedeqBo(i).hasErrors()) continue;
            this.addError(new CheckRequiredModuleException(11231, "import check failed: " + list.getQedeqBo(i).getModuleAddress(), list.getModuleContext(i)));
        }
        if (this.getQedeqBo().hasErrors()) {
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), sfl, null);
            String msg = "Check of logical correctness failed for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            QedeqLog.getInstance().logFailureReply(msg, ((Throwable)sfl).getMessage());
            return Boolean.FALSE;
        }
        try {
            this.traverse();
        }
        catch (SourceFileExceptionList e) {
            String msg = "Check of logical correctness failed for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            QedeqLog.getInstance().logFailureReply(msg, ((Throwable)sfl).getMessage());
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
        }
        QedeqLog.getInstance().logSuccessfulReply("Check of logical correctness successful for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"");
        return Boolean.TRUE;
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(20);
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(20);
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialPredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(20);
        this.setBlocked(true);
    }

    public void visitLeave(InitialPredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(InitialFunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(20);
        this.setBlocked(true);
    }

    public void visitLeave(InitialFunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(20);
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        if (!this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37250, "only nodes with well formed formulas can be checked", this.getCurrentContext()));
            return;
        }
        this.getNodeBo().setProved(0);
        if (proposition.getFormula() == null) {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37230, "proposition formula must not be null", this.getCurrentContext()));
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        boolean correctProofFound = false;
        if (proposition.getFormalProofList() != null) {
            for (int i = 0; i < proposition.getFormalProofList().size(); ++i) {
                FormalProofLineList list;
                FormalProof proof = proposition.getFormalProofList().get(i);
                if (proof == null || (list = proof.getFormalProofLineList()) == null) continue;
                this.setLocationWithinModule(context + ".getFormalProofList().get(" + i + ").getFormalProofLineList()");
                LogicalCheckExceptionList eList = this.checkerFactory.createProofChecker().checkProof(proposition.getFormula().getElement(), list, this.getCurrentContext(), this);
                if (!correctProofFound && eList.size() == 0) {
                    correctProofFound = true;
                }
                for (int j = 0; j < eList.size(); ++j) {
                    this.addError(eList.get(j));
                }
            }
        }
        this.setLocationWithinModule(context + ".getFormula()");
        if (correctProofFound) {
            this.getNodeBo().setProved(20);
        } else {
            this.getNodeBo().setProved(10);
            this.addError(new ProofCheckException(37240, "no correct formal proof found", this.getCurrentContext()));
        }
        this.setBlocked(true);
    }

    public void visitLeave(Proposition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        if (rule == null) {
            return;
        }
        if (this.getNodeBo().isWellFormed()) {
            this.getNodeBo().setProved(20);
        } else {
            this.getNodeBo().setProved(10);
        }
        this.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.setBlocked(false);
    }

    protected void addError(ModuleDataException me) {
        if (this.getNodeBo() != null) {
            this.getNodeBo().setWellFormed(10);
        }
        super.addError(me);
    }

    protected void addError(SourceFileException me) {
        if (this.getNodeBo() != null) {
            this.getNodeBo().setWellFormed(10);
        }
        super.addError(me);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    public boolean hasProvedFormula(String reference) {
        String method = "hasProvedFormula";
        Reference ref = this.getReference(reference, this.getCurrentContext(), false, false);
        if (ref == null) {
            Trace.info(CLASS, "hasProvedFormula", "ref == null");
            return false;
        }
        if (ref.isExternalModuleReference()) {
            Trace.info(CLASS, "hasProvedFormula", "ref is external module");
            return false;
        }
        if (!ref.isNodeReference()) {
            Trace.info(CLASS, "hasProvedFormula", "ref is no node reference");
            return false;
        }
        if (null == ref.getNode()) {
            Trace.info(CLASS, "hasProvedFormula", "ref node == null");
            return false;
        }
        if (ref.isSubReference()) {
            return false;
        }
        if (!ref.isProofLineReference()) {
            if (!ref.getNode().isProved()) {
                Trace.info(CLASS, "hasProvedFormula", "ref node is not marked as proved: " + reference);
            }
            if (!ref.getNode().isProved()) {
                return false;
            }
            if (!ref.getNode().hasFormula()) {
                Trace.info(CLASS, "hasProvedFormula", "node has no formula: " + reference);
                return false;
            }
            return ref.getNode().isProved();
        }
        Trace.info(CLASS, "hasProvedFormula", "proof line references are not ok!");
        return false;
    }

    public Element getNormalizedReferenceFormula(String reference) {
        if (!this.hasProvedFormula(reference)) {
            return null;
        }
        Reference ref = this.getReference(reference, this.getCurrentContext(), false, false);
        Element formula = ref.getNode().getFormula();
        return this.getNormalizedFormula(ref.getNode().getQedeqBo(), formula);
    }

    public Element getNormalizedFormula(Element formula) {
        return this.getNormalizedFormula(this.getQedeqBo(), formula);
    }

    private Element getNormalizedFormula(KernelQedeqBo qedeq, Element formula) {
        if (formula == null) {
            return null;
        }
        if (formula.isAtom()) {
            return new DefaultAtom(formula.getAtom().getString());
        }
        return this.getNormalizedFormula(qedeq, formula.getList());
    }

    private ElementList getNormalizedFormula(KernelQedeqBo qedeq, ElementList formula) {
        DefaultElementList result = new DefaultElementList(formula.getOperator());
        if (FormulaUtility.isPredicateConstant(formula)) {
            PredicateKey key = new PredicateKey(formula.getElement(0).getAtom().getString(), "" + (formula.getList().size() - 1));
            DefaultAtom atom = new DefaultAtom(qedeq.getExistenceChecker().get(key).getContext().getModuleLocation().getUrl() + "$" + key.getName());
            result.add(atom);
            for (int i = 1; i < formula.size(); ++i) {
                result.add(this.getNormalizedFormula(qedeq, formula.getElement(i)));
            }
        } else if (FormulaUtility.isFunctionConstant(formula)) {
            FunctionKey key = new FunctionKey(formula.getElement(0).getAtom().getString(), "" + (formula.getList().size() - 1));
            DefaultAtom atom = new DefaultAtom(qedeq.getExistenceChecker().get(key).getContext().getModuleLocation().getUrl() + "$" + key.getName());
            result.add(atom);
            for (int i = 1; i < formula.size(); ++i) {
                result.add(this.getNormalizedFormula(qedeq, formula.getElement(i)));
            }
        } else {
            for (int i = 0; i < formula.size(); ++i) {
                result.add(this.getNormalizedFormula(qedeq, formula.getElement(i)));
            }
        }
        return result;
    }
}

