/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.logic;

import java.util.HashMap;
import java.util.Map;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.logic.common.ExistenceChecker;
import org.qedeq.kernel.bo.logic.common.FunctionConstant;
import org.qedeq.kernel.bo.logic.common.FunctionKey;
import org.qedeq.kernel.bo.logic.common.PredicateConstant;
import org.qedeq.kernel.bo.logic.common.PredicateKey;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;

public class DefaultExistenceChecker
implements ExistenceChecker {
    private static final Class CLASS = DefaultExistenceChecker.class;
    private final Map initialPredicateDefinitions = new HashMap();
    private final Map predicateDefinitions = new HashMap();
    private final Map initialFunctionDefinitions = new HashMap();
    private final Map functionDefinitions = new HashMap();
    private boolean setDefinitionByFormula;
    private String identityOperator;

    public DefaultExistenceChecker() {
        this.clear();
    }

    public void clear() {
        Trace.trace(CLASS, (Object)this, "setClassOperatorExists", "clear");
        this.initialPredicateDefinitions.clear();
        this.predicateDefinitions.clear();
        this.initialFunctionDefinitions.clear();
        this.functionDefinitions.clear();
        this.identityOperator = null;
        this.setDefinitionByFormula = false;
    }

    public boolean predicateExists(PredicateKey predicate) {
        InitialPredicateDefinition initialDefinition = (InitialPredicateDefinition)this.initialPredicateDefinitions.get(predicate);
        if (initialDefinition != null) {
            return true;
        }
        return null != this.predicateDefinitions.get(predicate);
    }

    public boolean predicateExists(String name, int arguments) {
        PredicateKey predicate = new PredicateKey(name, "" + arguments);
        return this.predicateExists(predicate);
    }

    public boolean isInitialPredicate(PredicateKey predicate) {
        InitialPredicateDefinition initialDefinition = (InitialPredicateDefinition)this.initialPredicateDefinitions.get(predicate);
        return initialDefinition != null;
    }

    public void add(InitialPredicateDefinition initialDefinition) {
        PredicateKey predicate = new PredicateKey(initialDefinition.getName(), initialDefinition.getArgumentNumber());
        if (this.predicateExists(predicate)) {
            throw new IllegalArgumentException("predicate was already defined for this argument number: " + predicate);
        }
        this.initialPredicateDefinitions.put(predicate, initialDefinition);
    }

    public void add(PredicateConstant constant) {
        PredicateKey predicate = constant.getKey();
        if (this.predicateExists(predicate)) {
            throw new IllegalArgumentException("predicate was already defined for this argument number: " + predicate);
        }
        this.predicateDefinitions.put(predicate, constant);
    }

    public PredicateConstant get(PredicateKey predicate) {
        return (PredicateConstant)this.predicateDefinitions.get(predicate);
    }

    public PredicateConstant getPredicate(String name, int arguments) {
        PredicateKey predicate = new PredicateKey(name, "" + arguments);
        return this.get(predicate);
    }

    public boolean functionExists(FunctionKey function) {
        InitialFunctionDefinition initialDefinition = (InitialFunctionDefinition)this.initialFunctionDefinitions.get(function);
        if (initialDefinition != null) {
            return true;
        }
        return null != this.functionDefinitions.get(function);
    }

    public boolean functionExists(String name, int arguments) {
        FunctionKey function = new FunctionKey(name, "" + arguments);
        return this.functionExists(function);
    }

    public void add(FunctionConstant definition) {
        FunctionKey function = definition.getKey();
        if (this.functionDefinitions.get(function) != null) {
            throw new IllegalArgumentException("function was already defined for this argument number: " + function);
        }
        this.functionDefinitions.put(function, definition);
    }

    public void add(InitialFunctionDefinition initialDefinition) {
        FunctionKey predicate = new FunctionKey(initialDefinition.getName(), initialDefinition.getArgumentNumber());
        if (this.functionExists(predicate)) {
            throw new IllegalArgumentException("function was already defined for this argument number: " + predicate);
        }
        this.initialFunctionDefinitions.put(predicate, initialDefinition);
    }

    public FunctionConstant get(FunctionKey function) {
        return (FunctionConstant)this.functionDefinitions.get(function);
    }

    public FunctionConstant getFunction(String name, int arguments) {
        FunctionKey function = new FunctionKey(name, "" + arguments);
        return this.get(function);
    }

    public boolean isInitialFunction(FunctionKey function) {
        InitialFunctionDefinition initialDefinition = (InitialFunctionDefinition)this.initialFunctionDefinitions.get(function);
        return initialDefinition != null;
    }

    public boolean classOperatorExists() {
        return this.setDefinitionByFormula;
    }

    public boolean identityOperatorExists() {
        return this.identityOperator != null;
    }

    public String getIdentityOperator() {
        return this.identityOperator;
    }

    public void setIdentityOperatorDefined(String identityOperator) {
        Trace.param(CLASS, (Object)this, "setIdentityOperatorDefined", "identityOperator", identityOperator);
        this.identityOperator = identityOperator;
    }
}

