/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.latex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.DateUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.common.PluginExecutor;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelNodeBo;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.Reference;
import org.qedeq.kernel.bo.service.latex.LatexContentException;
import org.qedeq.kernel.bo.service.latex.QedeqBoDuplicateLanguageChecker;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.Author;
import org.qedeq.kernel.se.base.module.AuthorList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.Chapter;
import org.qedeq.kernel.se.base.module.Existential;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Header;
import org.qedeq.kernel.se.base.module.Import;
import org.qedeq.kernel.se.base.module.ImportList;
import org.qedeq.kernel.se.base.module.InitialFunctionDefinition;
import org.qedeq.kernel.se.base.module.InitialPredicateDefinition;
import org.qedeq.kernel.se.base.module.Latex;
import org.qedeq.kernel.se.base.module.LatexList;
import org.qedeq.kernel.se.base.module.LinkList;
import org.qedeq.kernel.se.base.module.LiteratureItem;
import org.qedeq.kernel.se.base.module.LiteratureItemList;
import org.qedeq.kernel.se.base.module.LocationList;
import org.qedeq.kernel.se.base.module.ModusPonens;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proof;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.base.module.Rename;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.Section;
import org.qedeq.kernel.se.base.module.SectionList;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.base.module.Subsection;
import org.qedeq.kernel.se.base.module.SubstFree;
import org.qedeq.kernel.se.base.module.SubstFunc;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.base.module.Universal;
import org.qedeq.kernel.se.base.module.UsedByList;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public final class Qedeq2LatexExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = Qedeq2LatexExecutor.class;
    private TextOutput printer;
    private String language;
    private final boolean info;
    private int chapterNumber;
    private int sectionNumber;
    private String id;
    private String title;
    private String subContext = "";
    private String reason;
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";

    public Qedeq2LatexExecutor(Plugin plugin, KernelQedeqBo prop, Map parameters) {
        super(plugin, prop);
        String infoString = null;
        if (parameters != null) {
            infoString = (String)parameters.get("info");
        }
        this.info = "true".equalsIgnoreCase(infoString);
    }

    public Object executePlugin() {
        String method = "executePlugin(QedeqBo, Map)";
        try {
            QedeqLog.getInstance().logRequest("Generate LaTeX from \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"");
            String[] languages = this.getQedeqBo().getSupportedLanguages();
            for (int j = 0; j < languages.length; ++j) {
                this.language = languages[j];
                String result = this.generateLatex(languages[j], "1").toString();
                if (languages[j] != null) {
                    QedeqLog.getInstance().logSuccessfulReply("LaTeX for language \"" + languages[j] + "\" was generated from \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\" into \"" + result + "\"");
                    continue;
                }
                QedeqLog.getInstance().logSuccessfulReply("LaTeX for default language was generated from \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\" into \"" + result + "\"");
            }
        }
        catch (SourceFileExceptionList e) {
            String msg = "Generation failed for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            Trace.fatal(CLASS, this, "executePlugin(QedeqBo, Map)", msg, e);
            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
        }
        catch (IOException e) {
            String msg = "Generation failed for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            Trace.fatal(CLASS, this, "executePlugin(QedeqBo, Map)", msg, e);
            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "executePlugin(QedeqBo, Map)", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Generation failed", "unexpected problem: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        return null;
    }

    public InputStream createLatex(String language, String level) throws SourceFileExceptionList, IOException {
        return new FileInputStream(this.generateLatex(language, level));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateLatex(String language, String level) throws SourceFileExceptionList, IOException {
        String method = "generateLatex(String, String)";
        this.language = language;
        try {
            this.getServices().loadRequiredModules(this.getQedeqBo().getModuleAddress());
            this.getServices().checkModule(this.getQedeqBo().getModuleAddress());
        }
        catch (Exception e) {
            Trace.trace(CLASS, "generateLatex(String, String)", e);
        }
        String tex = this.getQedeqBo().getModuleAddress().getFileName();
        if (tex.toLowerCase(Locale.US).endsWith(".xml")) {
            tex = tex.substring(0, tex.length() - 4);
        }
        if (language != null && language.length() > 0) {
            tex = tex + "_" + language;
        }
        File destination = new File(this.getServices().getConfig().getGenerationDirectory(), tex + ".tex").getCanonicalFile();
        this.init();
        try {
            this.printer = "de".equals(language) ? new TextOutput(this.getQedeqBo().getName(), new FileOutputStream(destination), "ISO-8859-1") : new TextOutput(this.getQedeqBo().getName(), new FileOutputStream(destination), "UTF-8");
            this.traverse();
        }
        finally {
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
            if (this.printer != null) {
                this.printer.flush();
                this.printer.close();
            }
        }
        if (this.printer != null && this.printer.checkError()) {
            throw this.printer.getError();
        }
        try {
            QedeqBoDuplicateLanguageChecker.check(this.getPlugin(), this.getQedeqBo());
        }
        catch (SourceFileExceptionList warnings) {
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), null, warnings);
        }
        return destination.getCanonicalFile();
    }

    protected void init() {
        this.chapterNumber = 0;
        this.sectionNumber = 0;
        this.id = null;
        this.title = null;
        this.subContext = "";
    }

    public final void visitEnter(Qedeq qedeq) {
        this.printer.println("% -*- TeX" + (this.language != null ? ":" + this.language.toUpperCase(Locale.US) : "") + " -*-");
        this.printer.println("%%% ====================================================================");
        this.printer.println("%%% @LaTeX-file    " + this.printer.getName());
        this.printer.println("%%% Generated from " + this.getQedeqBo().getModuleAddress());
        this.printer.println("%%% Generated at   " + DateUtility.getTimestamp());
        this.printer.println("%%% ====================================================================");
        this.printer.println();
        this.printer.println("%%% Permission is granted to copy, distribute and/or modify this document");
        this.printer.println("%%% under the terms of the GNU Free Documentation License, Version 1.2");
        this.printer.println("%%% or any later version published by the Free Software Foundation;");
        this.printer.println("%%% with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.");
        this.printer.println();
        this.printer.println("\\documentclass[a4paper,german,10pt,twoside]{book}");
        if ("de".equals(this.language)) {
            this.printer.println("\\usepackage[german]{babel}");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("\\usepackage[english]{babel}");
        }
        this.printer.println("\\usepackage{makeidx}");
        this.printer.println("\\usepackage{amsmath,amsthm,amssymb}");
        this.printer.println("\\usepackage{color}");
        this.printer.println("\\usepackage[bookmarks,bookmarksnumbered,bookmarksopen,");
        this.printer.println("   colorlinks,linkcolor=webgreen,pagebackref]{hyperref}");
        this.printer.println("\\definecolor{webgreen}{rgb}{0,.5,0}");
        this.printer.println("\\usepackage{graphicx}");
        this.printer.println("\\usepackage{xr}");
        this.printer.println("\\usepackage{epsfig,longtable}");
        this.printer.println("\\usepackage{tabularx}");
        this.printer.println();
        if ("de".equals(this.language)) {
            this.printer.println("\\newtheorem{thm}{Theorem}");
            this.printer.println("\\newtheorem{cor}[thm]{Korollar}");
            this.printer.println("\\newtheorem{lem}[thm]{Lemma}");
            this.printer.println("\\newtheorem{prop}[thm]{Proposition}");
            this.printer.println("\\newtheorem{ax}{Axiom}");
            this.printer.println("\\newtheorem{rul}{Regel}");
            this.printer.println();
            this.printer.println("\\theoremstyle{definition}");
            this.printer.println("\\newtheorem{defn}{Definition}");
            this.printer.println("\\newtheorem{idefn}[defn]{Initiale Definition}");
            this.printer.println();
            this.printer.println("\\theoremstyle{remark}");
            this.printer.println("\\newtheorem{rem}[thm]{Bemerkung}");
            this.printer.println("\\newtheorem*{notation}{Notation}");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("\\newtheorem{thm}{Theorem}");
            this.printer.println("\\newtheorem{cor}[thm]{Corollary}");
            this.printer.println("\\newtheorem{lem}[thm]{Lemma}");
            this.printer.println("\\newtheorem{prop}[thm]{Proposition}");
            this.printer.println("\\newtheorem{ax}{Axiom}");
            this.printer.println("\\newtheorem{rul}{Rule}");
            this.printer.println();
            this.printer.println("\\theoremstyle{definition}");
            this.printer.println("\\newtheorem{defn}{Definition}");
            this.printer.println("\\newtheorem{idefn}[defn]{Initial Definition}");
            this.printer.println();
            this.printer.println("\\theoremstyle{remark}");
            this.printer.println("\\newtheorem{rem}[thm]{Remark}");
            this.printer.println("\\newtheorem*{notation}{Notation}");
        }
        this.printer.println();
        this.printer.println("\\addtolength{\\textheight}{7\\baselineskip}");
        this.printer.println("\\addtolength{\\topmargin}{-5\\baselineskip}");
        this.printer.println();
        this.printer.println("\\setlength{\\parindent}{0pt}");
        this.printer.println();
        this.printer.println("\\frenchspacing \\sloppy");
        this.printer.println();
        this.printer.println("\\makeindex");
        this.printer.println();
        this.printer.println();
    }

    public final void visitLeave(Qedeq qedeq) {
        this.printer.println("\\addcontentsline{toc}{chapter}{\\indexname} \\printindex");
        this.printer.println();
        this.printer.println("\\end{document}");
        this.printer.println();
    }

    public void visitEnter(Header header) {
        LatexList tit = header.getTitle();
        this.printer.print("\\title{");
        this.printer.print(this.getLatexListEntry("getTitle()", tit));
        this.printer.println("}");
        this.printer.println("\\author{");
        AuthorList authors = this.getQedeqBo().getQedeq().getHeader().getAuthorList();
        StringBuffer authorList = new StringBuffer();
        for (int i = 0; i < authors.size(); ++i) {
            if (i > 0) {
                authorList.append(", ");
                this.printer.println(", ");
            }
            Author author = authors.get(i);
            String name = author.getName().getLatex().trim();
            this.printer.print(name);
            authorList.append(name);
            String email = author.getEmail();
            if (email == null || email.trim().length() <= 0) continue;
            authorList.append(" \\href{mailto:" + email + "}{" + email + "}");
        }
        this.printer.println();
        this.printer.println("}");
        this.printer.println();
        this.printer.println("\\begin{document}");
        this.printer.println();
        this.printer.println("\\maketitle");
        this.printer.println();
        this.printer.println("\\setlength{\\parskip}{5pt plus 2pt minus 1pt}");
        this.printer.println("\\mbox{}");
        this.printer.println("\\vfill");
        this.printer.println();
        String url = this.getQedeqBo().getUrl();
        if (url != null && url.length() > 0) {
            this.printer.println("\\par");
            if ("de".equals(this.language)) {
                this.printer.println("Die Quelle f{\"ur} dieses Dokument ist hier zu finden:");
            } else {
                if (!"en".equals(this.language)) {
                    this.printer.println("%%% TODO unknown language: " + this.language);
                }
                this.printer.println("The source for this document can be found here:");
            }
            this.printer.println("\\par");
            this.printer.println("\\url{" + url + "}");
            this.printer.println();
        }
        this.printer.println("\\par");
        if ("de".equals(this.language)) {
            this.printer.println("Die vorliegende Publikation ist urheberrechtlich gesch{\"u}tzt.");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Copyright by the authors. All rights reserved.");
        }
        String email = header.getEmail();
        if (email != null && email.length() > 0) {
            String emailUrl = "\\href{mailto:" + email + "}{" + email + "}";
            this.printer.println("\\par");
            if ("de".equals(this.language)) {
                this.printer.println("Bei Fragen, Anregungen oder Bitte um Aufnahme in die Liste der abh{\"a}ngigen Module schicken Sie bitte eine EMail an die Adresse " + emailUrl);
                this.printer.println();
                this.printer.println("\\par");
                this.printer.println("Die Autoren dieses Dokuments sind:");
                this.printer.println(authorList);
            } else {
                if (!"en".equals(this.language)) {
                    this.printer.println("%%% TODO unknown language: " + this.language);
                }
                this.printer.println("If you have any questions, suggestions or want to add something to the list of modules that use this one, please send an email to the address " + emailUrl);
                this.printer.println();
                this.printer.println("\\par");
                this.printer.println("The authors of this document are:");
                this.printer.println(authorList);
            }
            this.printer.println();
        }
        this.printer.println("\\setlength{\\parskip}{0pt}");
        this.printer.println("\\tableofcontents");
        this.printer.println();
        this.printer.println("\\setlength{\\parskip}{5pt plus 2pt minus 1pt}");
        this.printer.println();
    }

    private String getUrl(ModuleAddress address, Specification specification) {
        LocationList list = specification.getLocationList();
        if (list == null || list.size() <= 0) {
            return "";
        }
        try {
            return address.getModulePaths(specification)[0].getUrl();
        }
        catch (IOException e) {
            return "";
        }
    }

    public void visitEnter(Chapter chapter) {
        this.printer.print("\\chapter");
        if (chapter.getNoNumber() != null && chapter.getNoNumber().booleanValue()) {
            this.printer.print("*");
        }
        this.printer.print("{");
        this.printer.print(this.getLatexListEntry("getTitle()", chapter.getTitle()));
        String label = "chapter" + this.chapterNumber;
        this.printer.println("} \\label{" + label + "} \\hypertarget{" + label + "}{}");
        if (chapter.getNoNumber() != null && chapter.getNoNumber().booleanValue()) {
            this.printer.println("\\addcontentsline{toc}{chapter}{" + this.getLatexListEntry("getTitle()", chapter.getTitle()) + "}");
        }
        this.printer.println();
        if (chapter.getIntroduction() != null) {
            this.printer.println(this.getLatexListEntry("getIntroduction()", chapter.getIntroduction()));
            this.printer.println();
        }
    }

    public void visitLeave(Chapter chapter) {
        this.printer.println("%% end of chapter " + this.getLatexListEntry("getTitle()", chapter.getTitle()));
        this.printer.println();
        ++this.chapterNumber;
        this.sectionNumber = 0;
    }

    public void visitLeave(SectionList list) {
        this.printer.println();
    }

    public void visitEnter(Section section) {
        this.printer.print("\\section");
        if (section.getNoNumber() != null && section.getNoNumber().booleanValue()) {
            this.printer.print("*");
        }
        this.printer.print("{");
        this.printer.print(this.getLatexListEntry("getTitle()", section.getTitle()));
        String label = "chapter" + this.chapterNumber + "_section" + this.sectionNumber;
        this.printer.println("} \\label{" + label + "} \\hypertarget{" + label + "}{}");
        this.printer.println(this.getLatexListEntry("getIntroduction()", section.getIntroduction()));
        this.printer.println();
    }

    public void visitLeave(Section section) {
        ++this.sectionNumber;
    }

    public void visitEnter(Subsection subsection) {
        if (subsection.getTitle() != null) {
            this.printer.print("\\subsection{");
            this.printer.println(this.getLatexListEntry("getTitle()", subsection.getTitle()));
            this.printer.println("}");
        }
        if (subsection.getId() != null) {
            this.printer.println("\\label{" + subsection.getId() + "} \\hypertarget{" + subsection.getId() + "}{}");
        }
        this.printer.println(this.getLatexListEntry("getLatex()", subsection.getLatex()));
    }

    public void visitLeave(Subsection subsection) {
        this.printer.println();
        this.printer.println();
    }

    public void visitEnter(Node node) {
        this.printer.println("\\par");
        this.printer.println(this.getLatexListEntry("getPrecedingText()", node.getPrecedingText()));
        this.printer.println();
        this.id = node.getId();
        this.title = null;
        if (node.getTitle() != null) {
            this.title = this.getLatexListEntry("getTitle()", node.getTitle());
        }
    }

    public void visitLeave(Node node) {
        this.printer.println();
        this.printer.println(this.getLatexListEntry("getSucceedingText()", node.getSucceedingText()));
        this.printer.println();
        this.printer.println();
    }

    public void visitEnter(Axiom axiom) {
        this.printer.println("\\begin{ax}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printFormula(axiom.getFormula().getElement());
        this.printer.println(this.getLatexListEntry("getDescription()", axiom.getDescription()));
        this.printer.println("\\end{ax}");
    }

    public void visitEnter(Proposition proposition) {
        this.printer.println("\\begin{prop}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printTopFormula(proposition.getFormula().getElement(), this.id);
        this.printer.println(this.getLatexListEntry("getDescription()", proposition.getDescription()));
        this.printer.println("\\end{prop}");
    }

    public void visitEnter(Proof proof) {
        this.printer.println("\\begin{proof}");
        this.printer.println(this.getLatexListEntry("getNonFormalProof()", proof.getNonFormalProof()));
        this.printer.println("\\end{proof}");
    }

    public void visitEnter(FormalProof proof) {
        this.printer.println("\\begin{proof}");
    }

    public void visitEnter(FormalProofLineList lines) {
        this.printer.println("\\mbox{}\\\\");
        this.printer.println("\\begin{longtable}[h!]{r@{\\extracolsep{\\fill}}p{9cm}@{\\extracolsep{\\fill}}p{4cm}}");
    }

    public void visitLeave(FormalProofLineList lines) {
        this.printer.println(" & & \\qedhere");
        this.printer.println("\\end{longtable}");
    }

    public void visitEnter(FormalProofLine line) {
        if (line.getLabel() != null) {
            String display = this.getNodeBo().getNodeVo().getId() + ":" + line.getLabel();
            this.printer.print("\\label{" + display + "} \\hypertarget{" + display + "}{} \\mbox{\\emph{(" + line.getLabel() + ")}} ");
        }
        this.printer.print(" \\ &  \\ ");
        if (line.getFormula() != null) {
            this.printer.print("$");
            this.printer.print(this.getQedeqBo().getElement2Latex().getLatex(line.getFormula().getElement()));
            this.printer.print("$");
        }
        this.printer.print(" \\ &  \\ ");
        this.reason = line.getReasonType() != null && line.getReasonType().getReason() != null ? line.getReasonType().getReason().toString() : "";
    }

    public void visitLeave(FormalProofLine line) {
        if (this.reason.length() > 0) {
            this.printer.print("{\\tiny ");
            this.printer.print(this.reason);
            this.printer.print("}");
        }
        this.printer.println(" \\\\ ");
    }

    private String getReference(String reference) {
        return this.getReference(reference, "getReference()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getReference(String reference, String subContext) {
        String context = this.getCurrentContext().getLocationWithinModule();
        try {
            this.getCurrentContext().setLocationWithinModule(context + "." + subContext);
            String string = this.getReference(reference, null, null);
            return string;
        }
        finally {
            this.getCurrentContext().setLocationWithinModule(context);
        }
    }

    public void visitEnter(ModusPonens r) throws ModuleDataException {
        this.reason = r.getName();
        boolean one = false;
        if (r.getReference1() != null) {
            this.reason = this.reason + " " + this.getReference(r.getReference1(), "getReference1()");
            one = true;
        }
        if (r.getReference1() != null) {
            if (one) {
                this.reason = this.reason + ",";
            }
            this.reason = this.reason + " " + this.getReference(r.getReference2(), "getReference2()");
        }
    }

    public void visitEnter(Add r) throws ModuleDataException {
        this.reason = r.getName();
        if (r.getReference() != null) {
            this.reason = this.reason + " " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(Rename r) throws ModuleDataException {
        this.reason = r.getName();
        if (r.getOriginalSubjectVariable() != null) {
            this.reason = this.reason + " $" + this.getQedeqBo().getElement2Latex().getLatex(r.getOriginalSubjectVariable()) + "$";
        }
        if (r.getReplacementSubjectVariable() != null) {
            this.reason = this.reason + " by $" + this.getQedeqBo().getElement2Latex().getLatex(r.getReplacementSubjectVariable()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(SubstFree r) throws ModuleDataException {
        this.reason = r.getName();
        if (r.getSubjectVariable() != null) {
            this.reason = this.reason + " $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubjectVariable()) + "$";
        }
        if (r.getSubstituteTerm() != null) {
            this.reason = this.reason + " by $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubstituteTerm()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(SubstFunc r) throws ModuleDataException {
        this.reason = r.getName();
        if (r.getFunctionVariable() != null) {
            this.reason = this.reason + " $" + this.getQedeqBo().getElement2Latex().getLatex(r.getFunctionVariable()) + "$";
        }
        if (r.getSubstituteTerm() != null) {
            this.reason = this.reason + " by $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubstituteTerm()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(SubstPred r) throws ModuleDataException {
        this.reason = r.getName();
        if (r.getPredicateVariable() != null) {
            this.reason = this.reason + " $" + this.getQedeqBo().getElement2Latex().getLatex(r.getPredicateVariable()) + "$";
        }
        if (r.getSubstituteFormula() != null) {
            this.reason = this.reason + " by $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubstituteFormula()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(Existential r) throws ModuleDataException {
        this.reason = r.getName();
        if (r.getSubjectVariable() != null) {
            this.reason = this.reason + " with $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubjectVariable()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitEnter(Universal r) throws ModuleDataException {
        this.reason = r.getName();
        if (r.getSubjectVariable() != null) {
            this.reason = this.reason + " with $" + this.getQedeqBo().getElement2Latex().getLatex(r.getSubjectVariable()) + "$";
        }
        if (r.getReference() != null) {
            this.reason = this.reason + " in " + this.getReference(r.getReference());
        }
    }

    public void visitLeave(FormalProof proof) {
        this.printer.println("\\end{proof}");
    }

    public void visitEnter(InitialPredicateDefinition definition) {
        this.printer.println("\\begin{idefn}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printer.print("$$");
        this.printer.println(this.getLatex(definition.getPredCon()));
        this.printer.println("$$");
        this.printer.println(this.getLatexListEntry("getDescription()", definition.getDescription()));
        this.printer.println("\\end{idefn}");
    }

    public void visitEnter(PredicateDefinition definition) {
        this.printer.println("\\begin{defn}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printer.print("$$");
        this.printer.print(this.getLatex(definition.getFormula().getElement()));
        this.printer.println("$$");
        this.printer.println(this.getLatexListEntry("getDescription()", definition.getDescription()));
        this.printer.println("\\end{defn}");
    }

    public void visitEnter(InitialFunctionDefinition definition) {
        this.printer.println("\\begin{idefn}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printer.print("$$");
        this.printer.print(this.getLatex(definition.getFunCon()));
        this.printer.println("$$");
        this.printer.println(this.getLatexListEntry("getDescription()", definition.getDescription()));
        this.printer.println("\\end{defn}");
    }

    public void visitEnter(FunctionDefinition definition) {
        this.printer.println("\\begin{defn}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printer.print("$$");
        this.printer.print(this.getLatex(definition.getFormula().getElement()));
        this.printer.println("$$");
        this.printer.println("\\end{defn}");
    }

    public void visitLeave(FunctionDefinition definition) {
    }

    public void visitEnter(Rule rule) {
        this.printer.println("\\begin{rul}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        if (this.info) {
            this.printer.println("{\\tt \\tiny [\\verb]" + this.id + "]]}");
        }
        this.printer.println(this.getLatexListEntry("getDescription()", rule.getDescription()));
        this.printer.println("\\end{rul}");
        if (rule.getProofList() != null) {
            for (int i = 0; i < rule.getProofList().size(); ++i) {
                this.printer.println("\\begin{proof}");
                this.printer.println(this.getLatexListEntry("getProofList().get(" + i + ")", rule.getProofList().get(i).getNonFormalProof()));
                this.printer.println("\\end{proof}");
            }
        }
    }

    public void visitLeave(Rule rule) {
    }

    public void visitEnter(LinkList linkList) {
        if (linkList.size() <= 0) {
            return;
        }
        if ("de".equals(this.language)) {
            this.printer.println("Basierend auf: ");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Based on: ");
        }
        for (int i = 0; i < linkList.size(); ++i) {
            if (linkList.get(i) == null) continue;
            this.printer.print(" \\ref{" + linkList.get(i) + "}");
        }
        this.printer.println();
    }

    public void visitEnter(LiteratureItemList list) {
        this.printer.println("\\backmatter");
        this.printer.println();
        this.printer.println("\\begin{thebibliography}{99}");
        if ("de".equals(this.language)) {
            this.printer.println("\\addcontentsline{toc}{chapter}{Literaturverzeichnis}");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("\\addcontentsline{toc}{chapter}{Bibliography}");
        }
        ImportList imports = this.getQedeqBo().getQedeq().getHeader().getImportList();
        if (imports != null && imports.size() > 0) {
            this.printer.println();
            this.printer.println();
            this.printer.println("%% Used other QEDEQ modules:");
            for (int i = 0; i < imports.size(); ++i) {
                Import imp = imports.get(i);
                this.printer.print("\\bibitem{" + imp.getLabel() + "} ");
                Specification spec = imp.getSpecification();
                this.printer.print(this.getLatex(spec.getName()));
                if (spec.getLocationList() != null && spec.getLocationList().size() > 0 && spec.getLocationList().get(0).getLocation().length() > 0) {
                    this.printer.print(" ");
                    this.printer.print("\\url{" + this.getUrl(this.getQedeqBo().getModuleAddress(), spec) + "}");
                }
                this.printer.println();
            }
            this.printer.println();
            this.printer.println();
            this.printer.println("%% Other references:");
            this.printer.println();
        }
    }

    public void visitLeave(LiteratureItemList list) {
        UsedByList usedby = this.getQedeqBo().getQedeq().getHeader().getUsedByList();
        if (usedby != null && usedby.size() > 0) {
            this.printer.println();
            this.printer.println();
            this.printer.println("%% QEDEQ modules that use this one:");
            for (int i = 0; i < usedby.size(); ++i) {
                Specification spec = usedby.get(i);
                this.printer.print("\\bibitem{" + spec.getName() + "} ");
                this.printer.print(this.getLatex(spec.getName()));
                String url = this.getUrl(this.getQedeqBo().getModuleAddress(), spec);
                if (url != null && url.length() > 0) {
                    this.printer.print(" ");
                    this.printer.print("\\url{" + url + "}");
                }
                this.printer.println();
            }
            this.printer.println();
            this.printer.println();
        }
        this.printer.println("\\end{thebibliography}");
    }

    public void visitEnter(LiteratureItem item) {
        this.printer.print("\\bibitem{" + item.getLabel() + "} ");
        this.printer.println(this.getLatexListEntry("getItem()", item.getItem()));
        this.printer.println();
    }

    private void printTopFormula(Element element, String mainLabel) {
        if (!element.isList() || !element.getList().getOperator().equals("AND")) {
            this.printFormula(element);
            return;
        }
        ElementList list = element.getList();
        this.printer.println("\\mbox{}");
        this.printer.println("\\begin{longtable}{{@{\\extracolsep{\\fill}}p{0.9\\linewidth}l}}");
        for (int i = 0; i < list.size(); ++i) {
            String label = "";
            if (list.size() >= ALPHABET.length() * ALPHABET.length()) {
                label = "" + (i + 1);
            } else {
                if (list.size() > ALPHABET.length()) {
                    int div = i / ALPHABET.length();
                    label = "" + ALPHABET.charAt(div);
                }
                label = label + ALPHABET.charAt(i % ALPHABET.length());
            }
            this.printer.println("\\centering $" + this.getLatex(list.getElement(i)) + "$" + " & \\label{" + mainLabel + "/" + label + "} \\hypertarget{" + mainLabel + "/" + label + "}{} \\mbox{\\emph{(" + label + ")}} " + (i + 1 < list.size() ? "\\\\" : ""));
        }
        this.printer.println("\\end{longtable}");
    }

    private void printFormula(Element element) {
        this.printer.println("\\mbox{}");
        this.printer.println("\\begin{longtable}{{@{\\extracolsep{\\fill}}p{\\linewidth}}}");
        this.printer.println("\\centering $" + this.getLatex(element) + "$");
        this.printer.println("\\end{longtable}");
    }

    private String getLatex(Element element) {
        return this.getQedeqBo().getElement2Latex().getLatex(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLatexListEntry(String method, LatexList list) {
        if (list == null) {
            return "";
        }
        if (method.length() > 0) {
            this.subContext = method;
        }
        try {
            int i;
            for (i = 0; this.language != null && i < list.size(); ++i) {
                if (!this.language.equals(list.get(i).getLanguage())) continue;
                if (method.length() > 0) {
                    this.subContext = method + ".get(" + i + ")";
                }
                String string = this.getLatex(list.get(i));
                return string;
            }
            for (i = 0; i < list.size(); ++i) {
                if (list.get(i).getLanguage() != null) continue;
                if (method.length() > 0) {
                    this.subContext = method + ".get(" + i + ")";
                }
                String string = this.getLatex(list.get(i));
                return string;
            }
            i = 0;
            if (i < list.size()) {
                if (method.length() > 0) {
                    this.subContext = method + ".get(" + i + ")";
                }
                String string = "MISSING! OTHER: " + this.getLatex(list.get(i));
                return string;
            }
            String string = "MISSING!";
            return string;
        }
        finally {
            if (method.length() > 0) {
                this.subContext = "";
            }
        }
    }

    private String getLatex(Latex latex) {
        if (latex == null || latex.getLatex() == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(latex.getLatex());
        this.transformQref(result);
        return this.escapeUmlauts(result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformQref(StringBuffer result) {
        String method = "transformQref(StringBuffer)";
        StringBuffer buffer = new StringBuffer(result.toString());
        TextInput input = new TextInput(buffer);
        int last = 0;
        try {
            result.setLength(0);
            while (input.forward("\\qref{")) {
                SourcePosition startPosition = input.getSourcePosition();
                int start = input.getPosition();
                if (!input.forward("}")) {
                    this.addWarning(80007, "ending \"}\" for \"\\qref{\" not found within 1024 characters", startPosition, input.getSourcePosition());
                    continue;
                }
                String ref = input.getSubstring(start + "\\qref{".length(), input.getPosition()).trim();
                input.read();
                Trace.param(CLASS, (Object)this, "transformQref(StringBuffer)", "1 ref", ref);
                if (ref.length() == 0) {
                    this.addWarning(80008, "empty reference: \"\\qref{}\"", startPosition, input.getSourcePosition());
                    continue;
                }
                if (ref.length() > 1024) {
                    this.addWarning(80007, "ending \"}\" for \"\\qref{\" not found within 1024 characters", startPosition, input.getSourcePosition());
                    continue;
                }
                if (ref.indexOf("{") >= 0) {
                    this.addWarning(80007, "ending \"}\" for \"\\qref{\" not found within 1024 characters", startPosition, input.getSourcePosition());
                    continue;
                }
                int end = input.getPosition();
                SourcePosition endPosition = input.getSourcePosition();
                result.append(buffer.substring(last, start));
                result.append(this.getReference(ref, startPosition, endPosition));
                last = end;
            }
        }
        finally {
            IoUtility.close(input);
            if (last < buffer.length()) {
                result.append(buffer.substring(last));
            }
        }
    }

    private String getReference(String reference, SourcePosition start, SourcePosition end) {
        String method = "getReference(String, String)";
        Trace.param(CLASS, (Object)this, "getReference(String, String)", "2 reference", reference);
        Reference ref = this.getReference(reference, this.getCurrentContext(start, end), true, false);
        if (ref.isNodeLocalReference() && ref.isSubReference()) {
            return "\\hyperref[" + ref.getNodeLabel() + "/" + ref.getSubLabel() + "]{" + "(" + ref.getSubLabel() + ")" + "}";
        }
        if (ref.isNodeLocalReference() && ref.isProofLineReference()) {
            return "\\hyperref[" + ref.getNodeLabel() + "/" + ref.getProofLineLabel() + "]{" + "(" + ref.getProofLineLabel() + ")" + "}";
        }
        if (!ref.isExternal()) {
            return "\\hyperref[" + ref.getNodeLabel() + (ref.isSubReference() ? "/" + ref.getSubLabel() : "") + (ref.isProofLineReference() ? "!" + ref.getProofLineLabel() : "") + "]{" + this.getNodeDisplay(ref.getNodeLabel(), ref.getNode()) + (ref.isSubReference() ? " (" + ref.getSubLabel() + ")" : "") + (ref.isProofLineReference() ? " (" + ref.getProofLineLabel() + ")" : "") + "}";
        }
        if (ref.isExternalModuleReference()) {
            return "\\url{" + this.getPdfLink(ref.getExternalQedeq()) + "}~\\cite{" + ref.getExternalQedeqLabel() + "}";
        }
        return "\\hyperref{" + this.getPdfLink(ref.getExternalQedeq()) + "}{}{" + ref.getExternalQedeqLabel() + "." + ref.getNodeLabel() + (ref.isSubReference() ? "/" + ref.getSubLabel() : "") + (ref.isProofLineReference() ? "!" + ref.getProofLineLabel() : "") + "}{" + this.getNodeDisplay(ref.getNodeLabel(), ref.getNode()) + (ref.isSubReference() ? " (" + ref.getSubLabel() + ")" : "") + (ref.isProofLineReference() ? " (" + ref.getProofLineLabel() + ")" : "") + "}~\\cite{" + ref.getExternalQedeqLabel() + "}";
    }

    private String getNodeDisplay(String label, KernelNodeBo kNode) {
        return StringUtility.replace(this.getNodeDisplay(label, kNode, this.language), " ", "~");
    }

    public ModuleContext getCurrentContext(SourcePosition startDelta, SourcePosition endDelta) {
        if (this.subContext.length() == 0) {
            return super.getCurrentContext();
        }
        ModuleContext c = new ModuleContext(super.getCurrentContext().getModuleLocation(), super.getCurrentContext().getLocationWithinModule() + "." + this.subContext, startDelta, endDelta);
        return c;
    }

    private void addWarning(int code, String msg, SourcePosition startDelta, SourcePosition endDelta) {
        Trace.param(CLASS, (Object)this, "addWarning", "msg", msg);
        this.addWarning(new LatexContentException(code, msg, this.getCurrentContext(startDelta, endDelta)));
    }

    private String getPdfLink(KernelQedeqBo prop) {
        if (prop == null) {
            return "";
        }
        String url = prop.getUrl();
        int dot = url.lastIndexOf(".");
        if (prop.isSupportedLanguage(this.language)) {
            return url.substring(0, dot) + this.language + ".pdf";
        }
        String a = prop.getOriginalLanguage();
        return url.substring(0, dot) + (a.length() > 0 ? "_" + a : "") + ".pdf";
    }

    private String getLatex(String text) {
        StringBuffer buffer = new StringBuffer(text);
        StringUtility.replace(buffer, "\\", "\\textbackslash");
        StringUtility.replace(buffer, "$", "\\$");
        StringUtility.replace(buffer, "&", "\\&");
        StringUtility.replace(buffer, "%", "\\%");
        StringUtility.replace(buffer, "#", "\\#");
        StringUtility.replace(buffer, "_", "\\_");
        StringUtility.replace(buffer, "{", "\\{");
        StringUtility.replace(buffer, "}", "\\}");
        StringUtility.replace(buffer, "~", "\\textasciitilde");
        StringUtility.replace(buffer, "^", "\\textasciicircum");
        StringUtility.replace(buffer, "<", "\\textless");
        StringUtility.replace(buffer, ">", "\\textgreater");
        return this.escapeUmlauts(buffer.toString());
    }

    private String escapeUmlauts(String nearlyLatex) {
        if (nearlyLatex == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(nearlyLatex);
        StringUtility.deleteLineLeadingWhitespace(buffer);
        StringUtility.replace(buffer, "\u00fc", "{\\\"u}");
        StringUtility.replace(buffer, "\u00f6", "{\\\"o}");
        StringUtility.replace(buffer, "\u00e4", "{\\\"a}");
        StringUtility.replace(buffer, "\u00dc", "{\\\"U}");
        StringUtility.replace(buffer, "\u00d6", "{\\\"O}");
        StringUtility.replace(buffer, "\u00c4", "{\\\"A}");
        StringUtility.replace(buffer, "\u00df", "{\\ss}");
        return buffer.toString().trim();
    }
}

