/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.ArrayList;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.log.ModuleEventLog;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.ModuleConstantsExistenceChecker;
import org.qedeq.kernel.bo.module.ModuleLabels;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.bo.service.PluginResultManager;
import org.qedeq.kernel.se.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.se.common.DependencyState;
import org.qedeq.kernel.se.common.LoadingState;
import org.qedeq.kernel.se.common.LogicalModuleState;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.module.QedeqVo;

public class StateManager {
    private static final Class CLASS = StateManager.class;
    private final DefaultKernelQedeqBo bo;
    private int loadingCompleteness;
    private LoadingState loadingState;
    private DependencyState dependencyState;
    private LogicalModuleState logicalState;
    private PluginResultManager pluginResults;
    private SourceFileExceptionList errors;

    StateManager(DefaultKernelQedeqBo bo) {
        this.bo = bo;
        this.loadingState = LoadingState.STATE_UNDEFINED;
        this.loadingCompleteness = 0;
        this.dependencyState = DependencyState.STATE_UNDEFINED;
        this.logicalState = LogicalModuleState.STATE_UNCHECKED;
        this.pluginResults = new PluginResultManager();
    }

    public void delete() {
        this.checkIfDeleted();
        this.invalidateOtherDependentModulesToLoaded();
        this.setLoadingState(LoadingState.STATE_DELETED);
        this.bo.setQedeqVo(null);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(null);
        this.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.setLogicalState(LogicalModuleState.STATE_UNCHECKED);
        this.setErrors(null);
        ModuleEventLog.getInstance().removeModule(this.bo);
    }

    public boolean hasBasicFailures() {
        return this.loadingState.isFailure() || this.dependencyState.isFailure() || this.logicalState.isFailure();
    }

    public boolean hasErrors() {
        return this.hasBasicFailures() || this.getErrors() != null && this.getErrors().size() > 0;
    }

    public boolean hasWarnings() {
        return this.getWarnings() != null && this.getWarnings().size() > 0;
    }

    public void setLoadingCompleteness(int completeness) {
        this.loadingCompleteness = completeness;
    }

    public int getLoadingCompleteness() {
        return this.loadingCompleteness;
    }

    public LoadingState getLoadingState() {
        return this.loadingState;
    }

    public boolean isLoaded() {
        return this.loadingState == LoadingState.STATE_LOADED;
    }

    public void setLoadingProgressState(LoadingState state) {
        this.checkIfDeleted();
        if (state == LoadingState.STATE_LOADED) {
            throw new IllegalArgumentException("this state could only be set by calling method setLoaded");
        }
        if (state != LoadingState.STATE_DELETED && state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLoadingFailureState for " + state);
        }
        if (this.getLoadingState() == LoadingState.STATE_UNDEFINED) {
            this.setLoadingState(state);
            ModuleEventLog.getInstance().addModule(this.bo);
        }
        if (state == LoadingState.STATE_LOADING_FROM_BUFFER) {
            this.invalidateOtherDependentModulesToLoaded();
        }
        if (state == LoadingState.STATE_DELETED) {
            throw new IllegalArgumentException("call delete for " + state);
        }
        this.setLoadingState(state);
        this.bo.setQedeqVo(null);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(null);
        this.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.setLogicalState(LogicalModuleState.STATE_UNCHECKED);
        this.setErrors(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLoadingFailureState(LoadingState state, SourceFileExceptionList e) {
        if (e == null) {
            throw new NullPointerException("Exception must not be null");
        }
        this.checkIfDeleted();
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLoadingProgressState");
        }
        if (this.getLoadingState() == LoadingState.STATE_UNDEFINED) {
            this.setLoadingState(state);
            ModuleEventLog.getInstance().addModule(this.bo);
        }
        this.invalidateOtherDependentModulesToLoaded();
        this.bo.setQedeqVo(null);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(null);
        this.setLoadingState(state);
        this.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.setLogicalState(LogicalModuleState.STATE_UNCHECKED);
        this.setErrors(e);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLoaded(QedeqVo qedeq, ModuleLabels labels) {
        this.checkIfDeleted();
        if (qedeq == null) {
            throw new NullPointerException("Qedeq is null");
        }
        this.invalidateOtherDependentModulesToLoaded();
        this.setLoadingState(LoadingState.STATE_LOADED);
        this.bo.setQedeqVo(qedeq);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(labels);
        this.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.setLogicalState(LogicalModuleState.STATE_UNCHECKED);
        this.setErrors(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setDependencyProgressState(DependencyState state) {
        this.checkIfDeleted();
        if (!this.isLoaded() && state != DependencyState.STATE_UNDEFINED) {
            throw new IllegalStateException("module is not yet loaded");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setDependencyFailureState");
        }
        if (state == DependencyState.STATE_LOADED_REQUIRED_MODULES) {
            throw new IllegalArgumentException("this state could only be set by calling method setLoadedRequiredModules");
        }
        if (state == DependencyState.STATE_LOADING_REQUIRED_MODULES) {
            this.invalidateOtherDependentModulesToLoaded();
        }
        this.setLogicalState(LogicalModuleState.STATE_UNCHECKED);
        this.setDependencyState(state);
        this.bo.getKernelRequiredModules().clear();
        this.setErrors(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setDependencyFailureState(DependencyState state, SourceFileExceptionList e) {
        if (e == null) {
            throw new NullPointerException("Exception must not be null");
        }
        this.checkIfDeleted();
        if (!this.isLoaded()) {
            throw new IllegalStateException("module is not yet loaded");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLoadingProgressState");
        }
        this.invalidateOtherDependentModulesToLoadedRequired();
        this.setDependencyState(state);
        this.setErrors(e);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public DependencyState getDependencyState() {
        return this.dependencyState;
    }

    private void invalidateOtherDependentModulesToLoaded() {
        String method = "invalidateOtherDependModulesToLoaded";
        Trace.begin(CLASS, this, "invalidateOtherDependModulesToLoaded");
        Trace.param(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "bo", this.bo);
        if (this.hasLoadedRequiredModules()) {
            int i;
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            Trace.trace(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "begin list of dependent modules");
            ArrayList<KernelQedeqBo> list = new ArrayList<KernelQedeqBo>();
            for (i = 0; i < dependent.size(); ++i) {
                Trace.param(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "" + i, dependent.getKernelQedeqBo(i));
                list.add(dependent.getKernelQedeqBo(i));
            }
            Trace.trace(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "end list of dependent modules");
            for (i = 0; i < list.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)list.get(i);
                if (!dependent.contains(ref)) continue;
                ref.getStateManager().invalidateDependentModulesToLoaded();
            }
            list.clear();
            dependent.clear();
            KernelModuleReferenceList required = this.bo.getKernelRequiredModules();
            for (int i2 = 0; i2 < required.size(); ++i2) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)required.getKernelQedeqBo(i2);
                Trace.param(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "remove dependence from", ref);
                ref.getDependentModules().remove(this.bo);
            }
            required.clear();
        }
        Trace.end(CLASS, this, "invalidateOtherDependModulesToLoaded");
    }

    private void invalidateDependentModulesToLoaded() {
        String method = "invalidateDependentModulesToLoaded";
        Trace.begin(CLASS, this, "invalidateDependentModulesToLoaded");
        Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "bo", this.bo);
        if (this.hasLoadedRequiredModules()) {
            int i;
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            Trace.trace(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "begin list of dependent modules");
            ArrayList<KernelQedeqBo> list = new ArrayList<KernelQedeqBo>();
            for (i = 0; i < dependent.size(); ++i) {
                Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "" + i, dependent.getKernelQedeqBo(i));
                list.add(dependent.getKernelQedeqBo(i));
            }
            Trace.trace(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "end list of dependent modules");
            for (i = 0; i < list.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)list.get(i);
                if (!dependent.contains(ref)) continue;
                ref.getStateManager().invalidateDependentModulesToLoaded();
            }
            list.clear();
            dependent.clear();
            KernelModuleReferenceList required = this.bo.getKernelRequiredModules();
            for (int i2 = 0; i2 < required.size(); ++i2) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)required.getKernelQedeqBo(i2);
                Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "remove dependence from", ref);
                ref.getDependentModules().remove(this.bo);
            }
            required.clear();
            this.invalidateThisModule();
            this.setLoadingState(LoadingState.STATE_LOADED);
            ModuleEventLog.getInstance().stateChanged(this.bo);
        }
        Trace.end(CLASS, this, "invalidateDependentModulesToLoaded");
    }

    private void invalidateOtherDependentModulesToLoadedRequired() {
        if (this.isChecked()) {
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            for (int i = 0; i < dependent.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)dependent.getKernelQedeqBo(i);
                ref.getStateManager().invalidateDependentModulesToLoadedRequired();
            }
        }
    }

    private void invalidateDependentModulesToLoadedRequired() {
        if (this.isChecked()) {
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            for (int i = 0; i < dependent.size(); ++i) {
                DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)dependent.getKernelQedeqBo(i);
                ref.getStateManager().invalidateDependentModulesToLoadedRequired();
            }
            this.invalidateThisModule();
            this.setDependencyState(DependencyState.STATE_LOADED_REQUIRED_MODULES);
            ModuleEventLog.getInstance().stateChanged(this.bo);
        }
    }

    private void invalidateThisModule() {
        this.setLoadingState(LoadingState.STATE_LOADED);
        this.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.setLogicalState(LogicalModuleState.STATE_UNCHECKED);
        this.setErrors(null);
    }

    public boolean hasLoadedRequiredModules() {
        return this.isLoaded() && this.dependencyState == DependencyState.STATE_LOADED_REQUIRED_MODULES;
    }

    public void setLoadedRequiredModules(KernelModuleReferenceList required) {
        this.checkIfDeleted();
        if (!this.isLoaded()) {
            throw new IllegalStateException("Required modules can only be set if module is loaded.\"\nCurrently the status for the module\"" + this.bo.getName() + "\" is \"" + this.bo.getLoadingState() + "\"");
        }
        this.invalidateDependentModulesToLoadedRequired();
        for (int i = 0; i < required.size(); ++i) {
            DefaultKernelQedeqBo current = (DefaultKernelQedeqBo)required.getKernelQedeqBo(i);
            try {
                current.getDependentModules().add(required.getModuleContext(i), required.getLabel(i), this.bo);
                continue;
            }
            catch (ModuleDataException me) {
                throw new RuntimeException(me);
            }
        }
        this.setDependencyState(DependencyState.STATE_LOADED_REQUIRED_MODULES);
        this.setLogicalState(LogicalModuleState.STATE_UNCHECKED);
        this.setErrors(null);
        this.bo.getKernelRequiredModules().set(required);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setChecked(ModuleConstantsExistenceChecker checker) {
        this.checkIfDeleted();
        if (!this.hasLoadedRequiredModules()) {
            throw new IllegalStateException("Checked can only be set if all required modules are loaded.\"\nCurrently the status for the module\"" + this.bo.getName() + "\" is \"" + this.bo.getLoadingState() + "\"");
        }
        this.setLogicalState(LogicalModuleState.STATE_CHECKED);
        this.bo.setExistenceChecker(checker);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLogicalProgressState(LogicalModuleState state) {
        if (this.getDependencyState().getCode() < DependencyState.STATE_LOADED_REQUIRED_MODULES.getCode() && state != LogicalModuleState.STATE_UNCHECKED) {
            throw new IllegalArgumentException("this state could only be set if all required modules are loaded ");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLogicalFailureState");
        }
        if (state == LogicalModuleState.STATE_CHECKED) {
            throw new IllegalArgumentException("set with setChecked(ExistenceChecker)");
        }
        this.invalidateOtherDependentModulesToLoadedRequired();
        this.setLogicalState(state);
        this.setErrors(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLogicalFailureState(LogicalModuleState state, SourceFileExceptionList e) {
        if (!(this.isLoaded() && this.hasLoadedRequiredModules() || state == LogicalModuleState.STATE_UNCHECKED)) {
            throw new IllegalArgumentException("this state could only be set if all required modules are loaded ");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLogicalProgressState");
        }
        this.invalidateDependentModulesToLoadedRequired();
        this.setLogicalState(state);
        this.setErrors(e);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    private void checkIfDeleted() {
        if (this.getLoadingState() == LoadingState.STATE_DELETED) {
            throw new IllegalStateException("module is already deleted: " + this.bo.getUrl());
        }
    }

    public boolean isChecked() {
        return this.isLoaded() && this.hasLoadedRequiredModules() && this.logicalState == LogicalModuleState.STATE_CHECKED;
    }

    public LogicalModuleState getLogicalState() {
        return this.logicalState;
    }

    public String getStateDescription() {
        String result = "";
        if (this.loadingState == LoadingState.STATE_LOADING_FROM_WEB) {
            result = this.loadingState.getText() + " (" + this.loadingCompleteness + "%)";
        } else if (!this.isLoaded()) {
            result = this.loadingState.getText();
        } else if (!this.hasLoadedRequiredModules()) {
            if (this.dependencyState == DependencyState.STATE_UNDEFINED) {
                result = this.loadingState.getText();
            }
            result = this.dependencyState.getText();
        } else if (!this.isChecked()) {
            if (this.logicalState == LogicalModuleState.STATE_UNCHECKED) {
                result = this.dependencyState.getText();
            }
            result = this.logicalState.getText();
        } else {
            result = this.logicalState.getText();
        }
        String pluginState = this.pluginResults.getPluginStateDescription();
        if (pluginState.length() > 0) {
            result = result + "; " + pluginState;
        }
        return result;
    }

    protected void setLoadingState(LoadingState state) {
        this.loadingState = state;
    }

    protected void setDependencyState(DependencyState state) {
        this.dependencyState = state;
    }

    protected void setLogicalState(LogicalModuleState state) {
        this.logicalState = state;
    }

    public SourceFileExceptionList getErrors() {
        DefaultSourceFileExceptionList result = new DefaultSourceFileExceptionList(this.errors);
        result.add(this.pluginResults.getAllErrors());
        return result;
    }

    public SourceFileExceptionList getWarnings() {
        DefaultSourceFileExceptionList result = new DefaultSourceFileExceptionList();
        result.add(this.pluginResults.getAllWarnings());
        return result;
    }

    protected void setErrors(SourceFileExceptionList errors) {
        this.errors = errors;
        if (errors == null) {
            this.pluginResults = new PluginResultManager();
        }
    }

    public void addPluginResults(Plugin plugin, SourceFileExceptionList errors, SourceFileExceptionList warnings) {
        this.pluginResults.addResult(plugin, errors, warnings);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void removeAllPluginResults() {
        this.pluginResults.removeAllResults();
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void printDependencyTree() {
        this.printDependencyTree(0);
        System.out.println();
    }

    private void printDependencyTree(int tab) {
        System.out.println(StringUtility.getSpaces(tab) + this.bo.getName());
        int newTab = tab + this.bo.getName().length();
        KernelModuleReferenceList dependent = this.bo.getDependentModules();
        for (int i = 0; i < dependent.size(); ++i) {
            DefaultKernelQedeqBo ref = (DefaultKernelQedeqBo)dependent.getKernelQedeqBo(i);
            ref.getStateManager().printDependencyTree(newTab);
        }
    }
}

