/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.Iterator;
import java.util.Map;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.common.PluginExecutor;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.se.common.Plugin;

public class ServiceProcessImpl
implements ServiceProcess {
    private static final Class CLASS = ServiceProcessImpl.class;
    private final Plugin service;
    private final Thread thread;
    private final Map parameters;
    private long start;
    private long stop;
    private int state;
    private boolean blocked;
    private KernelQedeqBo qedeq;
    private double executionPercentage = 0.0;
    private String executionActionDescription = "not yet started";
    private PluginExecutor executor;

    public ServiceProcessImpl(Plugin service, Thread thread, KernelQedeqBo qedeq, Map parameters) {
        this.service = service;
        this.thread = thread;
        this.qedeq = qedeq;
        this.parameters = parameters;
        if (!thread.isAlive()) {
            throw new RuntimeException("thread is already dead");
        }
        this.start();
    }

    public ServiceProcessImpl(Plugin service, KernelQedeqBo qedeq, Map parameters) {
        this(service, Thread.currentThread(), qedeq, parameters);
    }

    public synchronized Plugin getService() {
        return this.service;
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    public synchronized QedeqBo getQedeq() {
        return this.qedeq;
    }

    public synchronized Map getParameters() {
        return this.parameters;
    }

    public synchronized PluginExecutor getExecutor() {
        return this.executor;
    }

    public synchronized void setExecutor(PluginExecutor executor) {
        this.executor = executor;
    }

    public synchronized String getParameterString() {
        StringBuffer buffer = new StringBuffer(30);
        int len = this.service.getPluginId().length() + 1;
        if (this.parameters != null) {
            Iterator e = this.parameters.entrySet().iterator();
            boolean notFirst = false;
            while (e.hasNext()) {
                Map.Entry entry = e.next();
                String key = String.valueOf(entry.getKey());
                if (!key.startsWith(this.service.getPluginId() + "$")) continue;
                if (notFirst) {
                    buffer.append(", ");
                } else {
                    notFirst = true;
                }
                key = key.substring(len);
                buffer.append(key);
                buffer.append("=");
                buffer.append(String.valueOf(entry.getValue()));
            }
        }
        return buffer.toString();
    }

    public synchronized long getStart() {
        return this.start;
    }

    public synchronized long getStop() {
        return this.stop;
    }

    private synchronized void start() {
        this.start = System.currentTimeMillis();
        this.executionActionDescription = "started";
    }

    private synchronized void stop() {
        this.stop = System.currentTimeMillis();
    }

    public synchronized void setSuccessState() {
        if (this.isRunning()) {
            this.state = 1;
            this.stop();
            this.executionActionDescription = "finished";
            this.executionPercentage = 100.0;
        }
    }

    public synchronized void setFailureState() {
        if (this.isRunning()) {
            this.state = -1;
            this.stop();
        }
    }

    public synchronized boolean isRunning() {
        if (this.state == 0) {
            if (!this.thread.isAlive()) {
                Trace.fatal(CLASS, this, "isRunning()", "Thread has unexpectly died", new RuntimeException());
                this.setFailureState();
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isBlocked() {
        if (this.isRunning()) {
            return this.blocked;
        }
        return false;
    }

    public synchronized void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public synchronized boolean wasSuccess() {
        return this.state == 1;
    }

    public synchronized boolean wasFailure() {
        return this.state == -1;
    }

    public synchronized void interrupt() {
        this.thread.interrupt();
        this.setFailureState();
    }

    public synchronized double getExecutionPercentage() {
        if ((this.isRunning() || this.isBlocked()) && this.executor != null) {
            this.executionPercentage = this.executor.getExecutionPercentage();
        }
        return this.executionPercentage;
    }

    public synchronized String getExecutionActionDescription() {
        if ((this.isRunning() || this.isBlocked()) && this.executor != null) {
            this.executionActionDescription = this.executor.getExecutionActionDescription();
        }
        return this.executionActionDescription;
    }
}

