/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.service.LoadRequiredModuleException;
import org.qedeq.kernel.se.base.module.Import;
import org.qedeq.kernel.se.base.module.ImportList;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public final class LoadDirectlyRequiredModules
extends ControlVisitor {
    private static final Class CLASS = LoadDirectlyRequiredModules.class;
    private final KernelModuleReferenceList required = new KernelModuleReferenceList();

    LoadDirectlyRequiredModules(Plugin plugin, KernelQedeqBo prop) {
        super(plugin, prop);
    }

    KernelModuleReferenceList load() throws SourceFileExceptionList {
        this.traverse();
        return this.required;
    }

    KernelModuleReferenceList getRequired() {
        return this.required;
    }

    public void visitEnter(Import imp) throws ModuleDataException {
        ModuleContext context = this.getCurrentContext();
        context.setLocationWithinModule(context.getLocationWithinModule() + ".getLabel()");
        try {
            KernelQedeqBo propNew = this.getQedeqBo().getKernelServices().loadModule(this.getQedeqBo().getModuleAddress(), imp.getSpecification());
            this.getRequired().addLabelUnique(context, imp.getLabel(), propNew);
            Trace.param(CLASS, "visitEnter(Import)", "adding context", this.getCurrentContext());
        }
        catch (SourceFileExceptionList e) {
            LoadRequiredModuleException me = new LoadRequiredModuleException(e.get(0).getErrorCode(), "import of module with label \"" + imp.getLabel() + "\" failed: " + e.get(0).getMessage(), context);
            this.addError(me);
            Trace.trace(CLASS, (Object)this, "visitEnter(Import)", (Throwable)e);
        }
    }

    public void visitLeave(ImportList imports) {
        this.setBlocked(true);
    }
}

