/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.SourceArea;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.base.utility.YodaUtility;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.common.KernelProperties;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.common.ServiceModule;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.QedeqFileDao;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.bo.service.KernelQedeqBoStorage;
import org.qedeq.kernel.bo.service.LoadRequiredModules;
import org.qedeq.kernel.bo.service.ModuleFileNotFoundException;
import org.qedeq.kernel.bo.service.ModuleLabelsCreator;
import org.qedeq.kernel.bo.service.PluginManager;
import org.qedeq.kernel.bo.service.QedeqVoBuilder;
import org.qedeq.kernel.bo.service.ServiceProcessManager;
import org.qedeq.kernel.bo.service.logic.FormalProofCheckerPlugin;
import org.qedeq.kernel.bo.service.logic.SimpleProofFinderPlugin;
import org.qedeq.kernel.bo.service.logic.WellFormedCheckerPlugin;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.common.DefaultModuleAddress;
import org.qedeq.kernel.se.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.se.common.LoadingState;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.config.QedeqConfig;
import org.qedeq.kernel.se.dto.module.QedeqVo;

public class DefaultInternalKernelServices
implements ServiceModule,
InternalKernelServices,
Plugin {
    private static final Class CLASS = DefaultInternalKernelServices.class;
    private static final Object MONITOR = new Object();
    private volatile int processCounter = 0;
    private KernelQedeqBoStorage modules;
    private final KernelProperties kernel;
    private final QedeqFileDao qedeqFileDao;
    private final PluginManager pluginManager;
    private final ServiceProcessManager processManager;
    private boolean validate = true;

    public DefaultInternalKernelServices(KernelProperties kernel, QedeqFileDao loader) {
        this.kernel = kernel;
        this.qedeqFileDao = loader;
        this.processManager = new ServiceProcessManager();
        this.pluginManager = new PluginManager(this.processManager);
        this.pluginManager.addPlugin("org.qedeq.kernel.bo.service.unicode.Qedeq2UnicodeTextPlugin");
        this.pluginManager.addPlugin("org.qedeq.kernel.bo.service.latex.Qedeq2LatexPlugin");
        this.pluginManager.addPlugin("org.qedeq.kernel.bo.service.unicode.Qedeq2Utf8Plugin");
        this.pluginManager.addPlugin(FormalProofCheckerPlugin.class.getName());
        this.pluginManager.addPlugin("org.qedeq.kernel.bo.service.heuristic.DynamicHeuristicCheckerPlugin");
        this.pluginManager.addPlugin(SimpleProofFinderPlugin.class.getName());
        loader.setServices(this);
    }

    public void startupServices() {
        this.modules = new KernelQedeqBoStorage();
        if (this.kernel.getConfig().isAutoReloadLastSessionChecked()) {
            this.autoReloadLastSessionChecked();
        }
    }

    public void shutdownServices() {
        this.processManager.terminateAndRemoveAllServiceProcesses();
        this.modules.removeAllModules();
        this.modules = null;
        Thread.interrupted();
    }

    public void autoReloadLastSessionChecked() {
        if (this.kernel.getConfig().isAutoReloadLastSessionChecked()) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String method = "autoReloadLastSessionChecked.thread.run()";
                    try {
                        Trace.begin(CLASS, this, "autoReloadLastSessionChecked.thread.run()");
                        QedeqLog.getInstance().logMessage("Trying to load previously successfully loaded modules.");
                        int number = DefaultInternalKernelServices.this.kernel.getConfig().getPreviouslyCheckedModules().length;
                        if (DefaultInternalKernelServices.this.loadPreviouslySuccessfullyLoadedModules()) {
                            QedeqLog.getInstance().logMessage("Loading of " + number + " previously successfully loaded module" + (number != 1 ? "s" : "") + " successfully done.");
                        } else {
                            QedeqLog.getInstance().logMessage("Loading of all previously successfully checked modules failed. " + number + " module" + (number != 1 ? "s" : "") + " were tried.");
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(CLASS, (Object)this, "autoReloadLastSessionChecked.thread.run()", (Throwable)e);
                    }
                    finally {
                        Trace.end(CLASS, this, "autoReloadLastSessionChecked.thread.run()");
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllModules() {
        while (true) {
            Object object = this;
            synchronized (object) {
                if (this.processCounter == 0) {
                    this.getModules().removeAllModules();
                    return;
                }
            }
            object = MONITOR;
            synchronized (object) {
                try {
                    MONITOR.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void removeModule(ModuleAddress address) {
        QedeqBo prop = this.getQedeqBo(address);
        if (prop != null) {
            this.removeModule(this.getModules().getKernelQedeqBo(this, address));
            if (this.validate) {
                this.modules.validateDependencies();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModule(DefaultKernelQedeqBo prop) {
        while (true) {
            Object object = this;
            synchronized (object) {
                if (this.processCounter == 0) {
                    prop.delete();
                    this.getModules().removeModule(prop);
                    return;
                }
            }
            object = MONITOR;
            synchronized (object) {
                try {
                    MONITOR.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void clearLocalBuffer() throws IOException {
        this.removeAllModules();
        File bufferDir = this.getBufferDirectory().getCanonicalFile();
        if (bufferDir.exists() && !IoUtility.deleteDir(bufferDir, new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".xml");
            }
        })) {
            throw new IOException("buffer could not be deleted: " + bufferDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QedeqBo loadModule(ModuleAddress address) {
        String method = "loadModule(ModuleAddress)";
        this.processInc();
        DefaultKernelQedeqBo prop = this.getModules().getKernelQedeqBo(this, address);
        try {
            DefaultKernelQedeqBo defaultKernelQedeqBo = prop;
            synchronized (defaultKernelQedeqBo) {
                block16: {
                    if (!prop.isLoaded()) break block16;
                    DefaultKernelQedeqBo defaultKernelQedeqBo2 = prop;
                    return defaultKernelQedeqBo2;
                }
                QedeqLog.getInstance().logRequest("Load module \"" + IoUtility.easyUrl(address.getUrl()) + "\"");
                if (prop.getModuleAddress().isFileAddress()) {
                    this.loadLocalModule(prop);
                } else {
                    try {
                        this.getCanonicalReadableFile(prop);
                    }
                    catch (ModuleFileNotFoundException e) {
                        this.saveQedeqFromWebToBuffer(prop);
                    }
                    this.loadBufferedModule(prop);
                }
                QedeqLog.getInstance().logSuccessfulReply("Module \"" + prop.getModuleAddress().getFileName() + "\" was successfully loaded.");
            }
        }
        catch (SourceFileExceptionList e) {
            Trace.trace(CLASS, (Object)this, "loadModule(ModuleAddress)", (Throwable)e);
            QedeqLog.getInstance().logFailureState("Loading of module failed!", IoUtility.easyUrl(address.getUrl()), e.toString());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "loadModule(ModuleAddress)", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Loading failed", e.getMessage());
        }
        finally {
            this.processDec();
        }
        return prop;
    }

    private void loadBufferedModule(DefaultKernelQedeqBo prop) throws SourceFileExceptionList {
        Qedeq qedeq;
        File localFile;
        prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_BUFFER);
        try {
            localFile = this.getCanonicalReadableFile(prop);
        }
        catch (ModuleFileNotFoundException e) {
            SourceFileExceptionList sfl = this.createSourceFileExceptionList(90700, "Loading module from file buffer failed.", prop.getUrl(), e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, sfl);
            throw sfl;
        }
        prop.setQedeqFileDao(this.getQedeqFileDao());
        try {
            qedeq = this.getQedeqFileDao().loadQedeq(prop, localFile);
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, sfl);
            throw sfl;
        }
        this.setCopiedQedeq(prop, qedeq);
    }

    private void loadLocalModule(DefaultKernelQedeqBo prop) throws SourceFileExceptionList {
        Qedeq qedeq;
        File localFile;
        prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_LOCAL_FILE);
        try {
            localFile = this.getCanonicalReadableFile(prop);
        }
        catch (ModuleFileNotFoundException e) {
            SourceFileExceptionList sfl = this.createSourceFileExceptionList(90710, "Loading module from local file failed.", prop.getUrl(), e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_LOCAL_FILE_FAILED, sfl);
            throw sfl;
        }
        prop.setQedeqFileDao(this.getQedeqFileDao());
        try {
            qedeq = this.getQedeqFileDao().loadQedeq(prop, localFile);
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_LOCAL_FILE_FAILED, sfl);
            throw sfl;
        }
        this.setCopiedQedeq(prop, qedeq);
    }

    private void setCopiedQedeq(DefaultKernelQedeqBo prop, Qedeq qedeq) throws SourceFileExceptionList {
        String method = "setCopiedQedeq(DefaultKernelQedeqBo, Qedeq)";
        prop.setLoadingProgressState(LoadingState.STATE_LOADING_INTO_MEMORY);
        QedeqVo vo = null;
        try {
            vo = QedeqVoBuilder.createQedeq(prop.getModuleAddress(), qedeq);
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "setCopiedQedeq(DefaultKernelQedeqBo, Qedeq)", "looks like a programming error", e);
            SourceFileExceptionList xl = this.createSourceFileExceptionList(90100, "Programming error occured.", prop.getModuleAddress().getUrl(), e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, xl);
            throw xl;
        }
        catch (ModuleDataException e) {
            if (e.getCause() != null) {
                Trace.fatal(CLASS, this, "setCopiedQedeq(DefaultKernelQedeqBo, Qedeq)", "looks like a programming error", e.getCause());
            } else {
                Trace.fatal(CLASS, this, "setCopiedQedeq(DefaultKernelQedeqBo, Qedeq)", "looks like a programming error", e);
            }
            SourceFileExceptionList xl = prop.createSourceFileExceptionList(this, e, qedeq);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, xl);
            throw xl;
        }
        prop.setQedeqVo(vo);
        ModuleLabelsCreator moduleNodesCreator = new ModuleLabelsCreator(this, prop);
        try {
            moduleNodesCreator.createLabels();
            prop.setLoaded(vo, moduleNodesCreator.getLabels(), moduleNodesCreator.getConverter(), moduleNodesCreator.getTextConverter());
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, sfl);
            throw sfl;
        }
    }

    private File getCanonicalReadableFile(QedeqBo prop) throws ModuleFileNotFoundException {
        File file;
        String method = "getCanonicalReadableFile(File)";
        File localFile = this.getLocalFilePath(prop.getModuleAddress());
        try {
            file = localFile.getCanonicalFile();
        }
        catch (IOException e) {
            Trace.trace(CLASS, (Object)this, "getCanonicalReadableFile(File)", (Throwable)e);
            throw new ModuleFileNotFoundException("file path not correct: " + localFile);
        }
        if (!file.canRead()) {
            Trace.trace(CLASS, (Object)this, "getCanonicalReadableFile(File)", "file not readable=" + file);
            throw new ModuleFileNotFoundException("file not readable: " + file);
        }
        return file;
    }

    /*
     * Exception decompiling
     */
    public KernelQedeqBo loadModule(ModuleAddress parent, Specification spec) throws SourceFileExceptionList {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ModuleAddress[] getAllLoadedModules() {
        return this.getModules().getAllLoadedModules();
    }

    public boolean loadRequiredModules(ModuleAddress address) {
        DefaultKernelQedeqBo prop = (DefaultKernelQedeqBo)this.loadModule(address);
        if (prop.hasBasicFailures()) {
            return false;
        }
        return LoadRequiredModules.loadRequired(this, prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadPreviouslySuccessfullyLoadedModules() {
        this.processInc();
        try {
            String[] list = this.kernel.getConfig().getPreviouslyCheckedModules();
            boolean errors = false;
            for (int i = 0; i < list.length; ++i) {
                try {
                    ModuleAddress address = this.getModuleAddress(list[i]);
                    QedeqBo prop = this.loadModule(address);
                    if (!prop.hasErrors()) continue;
                    errors = true;
                    continue;
                }
                catch (IOException e) {
                    Trace.fatal(CLASS, this, "loadPreviouslySuccessfullyLoadedModules", "internal error: saved URLs are malformed", e);
                    errors = true;
                }
            }
            boolean bl = !errors;
            return bl;
        }
        finally {
            this.processDec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAllModulesFromQedeq() {
        this.processInc();
        try {
            String prefix = "http://www.qedeq.org/" + this.kernel.getKernelVersionDirectory() + "/";
            String[] list = new String[]{prefix + "doc/math/qedeq_logic_v1.xml", prefix + "doc/math/qedeq_set_theory_v1.xml", prefix + "doc/project/qedeq_basic_concept.xml", prefix + "doc/project/qedeq_logic_language.xml", prefix + "sample/qedeq_sample1.xml", prefix + "sample/qedeq_sample2.xml", prefix + "sample/qedeq_sample3.xml", prefix + "sample/qedeq_sample4.xml", prefix + "sample/qedeq_error_sample_00.xml", prefix + "sample/qedeq_error_sample_01.xml", prefix + "sample/qedeq_error_sample_02.xml", prefix + "sample/qedeq_error_sample_03.xml", prefix + "sample/qedeq_error_sample_04.xml", prefix + "sample/qedeq_error_sample_05.xml", prefix + "sample/qedeq_error_sample_12.xml", prefix + "sample/qedeq_error_sample_13.xml", prefix + "sample/qedeq_error_sample_14.xml", prefix + "sample/qedeq_error_sample_15.xml", prefix + "sample/qedeq_error_sample_16.xml", prefix + "sample/qedeq_error_sample_17.xml", prefix + "sample/qedeq_error_sample_18.xml"};
            boolean errors = false;
            for (int i = 0; i < list.length; ++i) {
                try {
                    ModuleAddress address = this.getModuleAddress(list[i]);
                    QedeqBo prop = this.loadModule(address);
                    if (!prop.hasErrors()) continue;
                    errors = true;
                    continue;
                }
                catch (IOException e) {
                    Trace.fatal(CLASS, this, "loadPreviouslySuccessfullyLoadedModules", "internal error: saved URLs are malformed", e);
                    errors = true;
                }
            }
            boolean bl = !errors;
            return bl;
        }
        finally {
            this.processDec();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveQedeqFromWebToBuffer(DefaultKernelQedeqBo prop) throws SourceFileExceptionList {
        String method = "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)";
        Trace.begin(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)");
        if (!KernelContext.getInstance().isSetConnectionTimeOutSupported() && !IoUtility.isWebStarted()) {
            this.saveQedeqFromWebToBufferApache(prop);
            Trace.end(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)");
            return;
        }
        if (!IoUtility.isWebStarted()) {
            if (this.kernel.getConfig().getHttpProxyHost() != null) {
                System.setProperty("http.proxyHost", this.kernel.getConfig().getHttpProxyHost());
            }
            if (this.kernel.getConfig().getHttpProxyPort() != null) {
                System.setProperty("http.proxyPort", this.kernel.getConfig().getHttpProxyPort());
            }
            if (this.kernel.getConfig().getHttpNonProxyHosts() != null) {
                System.setProperty("http.nonProxyHosts", this.kernel.getConfig().getHttpNonProxyHosts());
            }
        }
        if (prop.getModuleAddress().isFileAddress()) {
            Trace.fatal(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", "tried to make a local copy for a local module", null);
            Trace.end(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)");
            return;
        }
        prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_WEB);
        FileOutputStream out = null;
        InputStream in = null;
        File f = this.getLocalFilePath(prop.getModuleAddress());
        try {
            int bytesRead;
            URLConnection connection;
            block28: {
                connection = new URL(prop.getUrl()).openConnection();
                if (connection instanceof HttpURLConnection) {
                    int responseCode;
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    if (KernelContext.getInstance().isSetConnectionTimeOutSupported()) {
                        try {
                            YodaUtility.executeMethod(httpConnection, "setConnectTimeout", new Class[]{Integer.TYPE}, new Object[]{new Integer(this.kernel.getConfig().getConnectTimeout())});
                        }
                        catch (NoSuchMethodException e) {
                            Trace.fatal(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", "URLConnection.setConnectTimeout was previously found", e);
                        }
                        catch (InvocationTargetException e) {
                            Trace.fatal(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", "URLConnection.setConnectTimeout throwed an error", e);
                        }
                    }
                    if (KernelContext.getInstance().isSetReadTimeoutSupported()) {
                        try {
                            YodaUtility.executeMethod(httpConnection, "setReadTimeout", new Class[]{Integer.TYPE}, new Object[]{new Integer(this.kernel.getConfig().getReadTimeout())});
                        }
                        catch (NoSuchMethodException e) {
                            Trace.fatal(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", "URLConnection.setReadTimeout was previously found", e);
                        }
                        catch (InvocationTargetException e) {
                            Trace.fatal(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", "URLConnection.setReadTimeout throwed an error", e);
                        }
                    }
                    if ((responseCode = httpConnection.getResponseCode()) == 200) {
                        in = httpConnection.getInputStream();
                        break block28;
                    } else {
                        String string;
                        in = httpConnection.getErrorStream();
                        String errorText = IoUtility.loadStreamWithoutException(in, 1000);
                        StringBuffer stringBuffer = new StringBuffer().append("Response code from HTTP server was ").append(responseCode);
                        if (errorText.length() > 0) {
                            string = "\nResponse  text from HTTP server was:\n" + errorText;
                            throw new IOException(stringBuffer.append(string).toString());
                        }
                        string = "";
                        throw new IOException(stringBuffer.append(string).toString());
                    }
                }
                Trace.paramInfo(CLASS, (Object)this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", "connection.getClass", connection.getClass().toString());
                in = connection.getInputStream();
            }
            if (!prop.getUrl().equals(connection.getURL().toString())) {
                throw new FileNotFoundException("\"" + prop.getUrl() + "\" was substituted by " + "\"" + connection.getURL() + "\" from server");
            }
            int maximum = connection.getContentLength();
            IoUtility.createNecessaryDirectories(f);
            out = new FileOutputStream(f);
            byte[] buffer = new byte[4096];
            int position = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                position += bytesRead;
                out.write(buffer, 0, bytesRead);
                if (maximum <= 0) continue;
                long completeness = position * 100 / maximum;
                if (completeness < 0L) {
                    completeness = 0L;
                }
                if (completeness > 100L) {
                    completeness = 100L;
                }
                prop.setLoadingCompleteness((int)completeness);
            }
            prop.setLoadingCompleteness(100);
        }
        catch (IOException e) {
            try {
                Trace.trace(CLASS, (Object)this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", (Throwable)e);
                IoUtility.close(out);
                out = null;
                try {
                    f.delete();
                }
                catch (Exception ex) {
                    Trace.trace(CLASS, (Object)this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", (Throwable)ex);
                }
                SourceFileExceptionList sfl = this.createSourceFileExceptionList(90720, "Loading module from web failed.", prop.getUrl(), e);
                prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_WEB_FAILED, sfl);
                Trace.trace(CLASS, (Object)this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)", "Couldn't access " + prop.getUrl());
                throw sfl;
            }
            catch (Throwable throwable) {
                IoUtility.close(out);
                IoUtility.close(in);
                Trace.end(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)");
                throw throwable;
            }
        }
        IoUtility.close(out);
        IoUtility.close(in);
        Trace.end(CLASS, this, "saveQedeqFromWebToBuffer(DefaultKernelQedeqBo)");
    }

    private void saveQedeqFromWebToBufferApache(DefaultKernelQedeqBo prop) throws SourceFileExceptionList {
        String method = "saveQedeqFromWebToBufferOld(DefaultKernelQedeqBo)";
        Trace.begin(CLASS, this, "saveQedeqFromWebToBufferOld(DefaultKernelQedeqBo)");
        if (prop.getModuleAddress().isFileAddress()) {
            Trace.fatal(CLASS, this, "saveQedeqFromWebToBufferOld(DefaultKernelQedeqBo)", "tried to make a local copy for a local module", null);
            Trace.end(CLASS, this, "saveQedeqFromWebToBufferOld(DefaultKernelQedeqBo)");
            return;
        }
        prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_WEB);
        File f = this.getLocalFilePath(prop.getModuleAddress());
        HttpClient client = new HttpClient();
        if (!IoUtility.isWebStarted() && this.kernel.getConfig().getHttpProxyHost() != null) {
            String pHost = this.kernel.getConfig().getHttpProxyHost();
            int pPort = 80;
            if (this.kernel.getConfig().getHttpProxyPort() != null) {
                try {
                    pPort = Integer.parseInt(this.kernel.getConfig().getHttpProxyPort());
                }
                catch (RuntimeException e) {
                    Trace.fatal(CLASS, this, "saveQedeqFromWebToBufferOld(DefaultKernelQedeqBo)", "proxy port not numeric: " + this.kernel.getConfig().getHttpProxyPort(), e);
                }
            }
            if (pHost.length() > 0) {
                client.getHostConfiguration().setProxy(pHost, pPort);
            }
        }
        GetMethod httpMethod = new GetMethod(prop.getUrl());
        try {
            httpMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            httpMethod.getParams().setSoTimeout(this.kernel.getConfig().getConnectTimeout());
            int statusCode = client.executeMethod((HttpMethod)httpMethod);
            if (statusCode != 200) {
                throw new FileNotFoundException("Problems loading: " + prop.getUrl() + "\n" + httpMethod.getStatusLine());
            }
            byte[] responseBody = httpMethod.getResponseBody();
            IoUtility.createNecessaryDirectories(f);
            IoUtility.saveFileBinary(f, responseBody);
            prop.setLoadingCompleteness(100);
        }
        catch (IOException e) {
            Trace.trace(CLASS, (Object)this, "saveQedeqFromWebToBufferOld(DefaultKernelQedeqBo)", (Throwable)e);
            try {
                f.delete();
            }
            catch (Exception ex) {
                Trace.trace(CLASS, (Object)this, "saveQedeqFromWebToBufferOld(DefaultKernelQedeqBo)", (Throwable)ex);
            }
            SourceFileExceptionList sfl = this.createSourceFileExceptionList(90720, "Loading module from web failed.", prop.getUrl(), e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_WEB_FAILED, sfl);
            Trace.trace(CLASS, (Object)this, "saveQedeqFromWebToBufferOld(DefaultKernelQedeqBo)", "Couldn't access " + prop.getUrl());
            throw sfl;
        }
        finally {
            httpMethod.releaseConnection();
            Trace.end(CLASS, this, "saveQedeqFromWebToBufferOld(DefaultKernelQedeqBo)");
        }
    }

    public final File getLocalFilePath(ModuleAddress address) {
        StringBuffer adr;
        URL url;
        String method = "getLocalFilePath(ModuleAddress)";
        try {
            url = new URL(address.getUrl());
        }
        catch (MalformedURLException e) {
            Trace.fatal(CLASS, this, "getLocalFilePath(ModuleAddress)", "Could not get local file path.", e);
            return null;
        }
        Trace.param(CLASS, (Object)this, "getLocalFilePath(ModuleAddress)", "protocol", url.getProtocol());
        Trace.param(CLASS, (Object)this, "getLocalFilePath(ModuleAddress)", "host", url.getHost());
        Trace.param(CLASS, (Object)this, "getLocalFilePath(ModuleAddress)", "port", url.getPort());
        Trace.param(CLASS, (Object)this, "getLocalFilePath(ModuleAddress)", "path", url.getPath());
        Trace.param(CLASS, (Object)this, "getLocalFilePath(ModuleAddress)", "file", url.getFile());
        if (address.isFileAddress()) {
            try {
                return IoUtility.toFile(url.getFile());
            }
            catch (IllegalArgumentException e) {
                Trace.fatal(CLASS, this, "getLocalFilePath(ModuleAddress)", "Loading failed of local file with URL=" + url, e);
                throw new RuntimeException(e);
            }
        }
        StringBuffer file = new StringBuffer(url.getFile());
        StringUtility.replace(file, "_", "_1");
        StringUtility.replace(file, "/", "_2");
        String encoded = file.toString();
        try {
            encoded = URLEncoder.encode(file.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Trace.trace(CLASS, "getLocalFilePath(ModuleAddress)", e);
        }
        file.setLength(0);
        file.append(encoded);
        StringUtility.replace(file, "#", "##");
        StringUtility.replace(file, "_2", "#");
        StringUtility.replace(file, "_1", "_");
        try {
            adr = new StringBuffer(new URL(url.getProtocol(), url.getHost(), url.getPort(), file.toString()).toExternalForm());
        }
        catch (MalformedURLException e) {
            Trace.fatal(CLASS, this, "getLocalFilePath(ModuleAddress)", "unexpected", e);
            throw new RuntimeException(e);
        }
        StringUtility.replace(adr, "://", "_");
        StringUtility.replace(adr, ":", "_");
        return new File(this.getBufferDirectory(), adr.toString());
    }

    private synchronized void processInc() {
        ++this.processCounter;
    }

    private synchronized void processDec() {
        --this.processCounter;
    }

    public File getBufferDirectory() {
        return this.kernel.getConfig().getBufferDirectory();
    }

    public File getGenerationDirectory() {
        return this.kernel.getConfig().getGenerationDirectory();
    }

    public KernelQedeqBo getKernelQedeqBo(ModuleAddress address) {
        return this.getModules().getKernelQedeqBo(this, address);
    }

    public QedeqBo getQedeqBo(ModuleAddress address) {
        return this.getModules().getKernelQedeqBo(this, address);
    }

    public ModuleAddress getModuleAddress(URL url) throws IOException {
        return new DefaultModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(String url) throws IOException {
        return new DefaultModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(File file) throws IOException {
        return new DefaultModuleAddress(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSource(ModuleAddress address) throws IOException {
        KernelQedeqBo bo = this.getKernelQedeqBo(address);
        if (bo.getLoadingState().equals(LoadingState.STATE_UNDEFINED) || bo.getLoadingState().equals(LoadingState.STATE_LOADING_FROM_WEB) || bo.getLoadingState().equals(LoadingState.STATE_LOADING_FROM_WEB_FAILED)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Reader reader = this.getQedeqFileDao().getModuleReader(bo);
        try {
            IoUtility.loadReader(reader, buffer);
        }
        finally {
            IoUtility.close(reader);
        }
        return buffer.toString();
    }

    public boolean checkModule(ModuleAddress address) {
        String method = "checkModule(ModuleAddress)";
        DefaultKernelQedeqBo prop = this.modules.getKernelQedeqBo(this, address);
        if (prop.isChecked()) {
            return true;
        }
        try {
            WellFormedCheckerPlugin checker = new WellFormedCheckerPlugin();
            checker.createExecutor(prop, null).executePlugin();
        }
        catch (RuntimeException e) {
            String msg = "Check of logical correctness failed for \"" + IoUtility.easyUrl(address.getUrl()) + "\"";
            Trace.fatal(CLASS, this, "checkModule(ModuleAddress)", msg, e);
            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
            throw e;
        }
        finally {
            if (this.validate) {
                this.modules.validateDependencies();
            }
        }
        return prop.isChecked();
    }

    public void addPlugin(String pluginClass) {
        this.pluginManager.addPlugin(pluginClass);
    }

    public Plugin[] getPlugins() {
        return this.pluginManager.getPlugins();
    }

    public Object executePlugin(String id, ModuleAddress address, Map parameters) {
        return this.pluginManager.executePlugin(id, this.getKernelQedeqBo(address), parameters);
    }

    public void clearAllPluginResults(ModuleAddress address) {
        this.pluginManager.clearAllPluginResults(this.getKernelQedeqBo(address));
    }

    public ServiceProcess[] getServiceProcesses() {
        return this.processManager.getServiceProcesses();
    }

    private KernelQedeqBoStorage getModules() {
        return this.modules;
    }

    public SourceFileExceptionList createSourceFileExceptionList(int code, String message, String address, IOException e) {
        return new DefaultSourceFileExceptionList(new SourceFileException(this, code, message, e, new SourceArea(address), null));
    }

    public SourceFileExceptionList createSourceFileExceptionList(int code, String message, String address, RuntimeException e) {
        return new DefaultSourceFileExceptionList(new SourceFileException(this, code, message, e, new SourceArea(address), null));
    }

    public SourceFileExceptionList createSourceFileExceptionList(int code, String message, String address, Exception e) {
        return new DefaultSourceFileExceptionList(new SourceFileException(this, code, message, e, new SourceArea(address), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSourceFileExceptionList(ModuleAddress address) {
        ArrayList<String> list;
        block11: {
            list = new ArrayList<String>();
            KernelQedeqBo bo = this.getKernelQedeqBo(address);
            SourceFileExceptionList sfl = bo.getErrors();
            if (sfl.size() > 0) {
                StringBuffer buffer = new StringBuffer();
                Reader reader = null;
                try {
                    reader = this.getQedeqFileDao().getModuleReader(bo);
                    IoUtility.loadReader(reader, buffer);
                }
                catch (IOException e) {
                    IoUtility.close(reader);
                    for (int i = 0; i < sfl.size(); ++i) {
                        list.add(sfl.get(i).getDescription());
                    }
                    break block11;
                }
                TextInput input = new TextInput(buffer);
                try {
                    input.setPosition(0);
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < sfl.size(); ++i) {
                        buf.setLength(0);
                        SourceFileException sf = sfl.get(i);
                        buf.append(sf.getDescription());
                        try {
                            if (sf.getSourceArea() != null && sf.getSourceArea().getStartPosition() != null) {
                                buf.append("\n");
                                input.setRow(sf.getSourceArea().getStartPosition().getRow());
                                buf.append(StringUtility.replace(input.getLine(), "\t", " "));
                                buf.append("\n");
                                StringBuffer whitespace = StringUtility.getSpaces(sf.getSourceArea().getStartPosition().getColumn() - 1);
                                buffer.append(whitespace);
                                buffer.append("^");
                            }
                        }
                        catch (Exception e) {
                            Trace.trace(CLASS, (Object)this, "getSourceFileExceptionList(ModuleAddress)", (Throwable)e);
                        }
                        list.add(buf.toString());
                    }
                }
                finally {
                    IoUtility.close(input);
                }
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String getPluginId() {
        return CLASS.getName();
    }

    public String getPluginActionName() {
        return "Basis";
    }

    public QedeqFileDao getQedeqFileDao() {
        return this.qedeqFileDao;
    }

    public String getPluginDescription() {
        return "provides basic services for loading QEDEQ modules";
    }

    public QedeqConfig getConfig() {
        return this.kernel.getConfig();
    }

    public String getKernelVersionDirectory() {
        return this.kernel.getKernelVersionDirectory();
    }

    public String getBuildId() {
        return this.kernel.getBuildId();
    }

    public String getDedication() {
        return this.kernel.getDedication();
    }

    public String getDescriptiveKernelVersion() {
        return this.kernel.getDescriptiveKernelVersion();
    }

    public String getKernelCodeName() {
        return this.kernel.getKernelCodeName();
    }

    public String getKernelVersion() {
        return this.kernel.getKernelVersion();
    }

    public String getMaximalRuleVersion() {
        return this.kernel.getMaximalRuleVersion();
    }

    public boolean isRuleVersionSupported(String ruleVersion) {
        return this.kernel.isRuleVersionSupported(ruleVersion);
    }

    public boolean isSetConnectionTimeOutSupported() {
        return this.kernel.isSetConnectionTimeOutSupported();
    }

    public boolean isSetReadTimeoutSupported() {
        return this.kernel.isSetReadTimeoutSupported();
    }
}

