/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.parser;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.parser.ClosingBracketMissingException;
import org.qedeq.kernel.bo.parser.EndSymbolNotFoundException;
import org.qedeq.kernel.bo.parser.MementoTextInput;
import org.qedeq.kernel.bo.parser.Operator;
import org.qedeq.kernel.bo.parser.ParserException;
import org.qedeq.kernel.bo.parser.SeparatorNotFoundException;
import org.qedeq.kernel.bo.parser.Term;
import org.qedeq.kernel.bo.parser.TermAtom;
import org.qedeq.kernel.bo.parser.TooFewArgumentsException;
import org.qedeq.kernel.bo.parser.TooMuchArgumentsException;
import org.qedeq.kernel.bo.parser.UnexpectedOperatorException;

public abstract class MathParser {
    private static final Class CLASS = MathParser.class;
    private MementoTextInput input;
    private List operators;

    public void setParameters(MementoTextInput input, List operators) {
        this.input = input;
        this.operators = operators;
    }

    public void setParameters(TextInput input, List operators) {
        this.setParameters(new MementoTextInput(input), operators);
    }

    public void setParameters(StringBuffer input, List operators) {
        this.setParameters(new TextInput(input), operators);
    }

    public void setParameters(String input, List operators) {
        this.setParameters(new TextInput(input), operators);
    }

    protected final List getOperators() {
        return this.operators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Term readTerm() throws ParserException {
        String method = "Term readTerm()";
        Trace.begin(CLASS, this, "Term readTerm()");
        try {
            Term term = this.readMaximalTerm(0);
            if (this.eot(this.getToken())) {
                this.readToken();
            }
            Term term2 = term;
            return term2;
        }
        finally {
            Trace.end(CLASS, this, "Term readTerm()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Term readMaximalTerm(int priority) throws ParserException {
        String method = "readMaximalTerm(int)";
        Trace.begin(CLASS, this, "readMaximalTerm(int)");
        Term term = null;
        try {
            if (this.eot(this.getToken())) {
                Trace.param(CLASS, (Object)this, "readMaximalTerm(int)", "return term", "null");
                Term term2 = null;
                return term2;
            }
            term = this.readPrefixTerm();
            Trace.param(CLASS, (Object)this, "readMaximalTerm(int)", "return term", (term = this.addNextInfixTerms(priority, term)) != null ? term.getQedeq() : "null");
            Term term3 = term;
            return term3;
        }
        finally {
            Trace.end(CLASS, this, "readMaximalTerm(int)");
        }
    }

    private Term addNextInfixTerms(int priority, Term initialTerm) throws ParserException {
        String method = "Term addNextInfixTerms(int, Term)";
        Trace.begin(CLASS, this, "Term addNextInfixTerms(int, Term)");
        Term term = initialTerm;
        try {
            Operator newOperator = null;
            Operator oldOperator = null;
            while (true) {
                Term term2;
                Term term3;
                this.markPosition();
                newOperator = this.readOperator();
                Trace.param(CLASS, (Object)this, "Term addNextInfixTerms(int, Term)", "newOperator", newOperator != null ? newOperator.getQedeq() : "null");
                if (newOperator == null || newOperator.getPriority() <= priority) {
                    Trace.trace(CLASS, (Object)this, "Term addNextInfixTerms(int, Term)", "newOperator is null or of less priority");
                    this.rewindPosition();
                    Trace.param(CLASS, (Object)this, "Term addNextInfixTerms(int, Term)", "read term", term != null ? term.getQedeq() : "null");
                    term3 = term;
                    return term3;
                }
                if (newOperator.isPrefix()) {
                    Trace.trace(CLASS, (Object)this, "Term addNextInfixTerms(int, Term)", "newOperator is prefix");
                    this.rewindPosition();
                    Trace.param(CLASS, (Object)this, "Term addNextInfixTerms(int, Term)", "read term", term != null ? term.getQedeq() : "null");
                    term3 = term;
                    return term3;
                }
                if (newOperator.isPostfix()) {
                    this.rewindPosition();
                    throw new IllegalArgumentException("Postfix Operators not yet supported");
                }
                this.clearMark();
                if (oldOperator == null || oldOperator.getPriority() >= newOperator.getPriority()) {
                    Trace.trace(CLASS, (Object)this, "Term addNextInfixTerms(int, Term)", "oldOperator is null or has more priority than new");
                    term2 = this.readMaximalTerm(newOperator.getPriority());
                    if (term2 == null) {
                        throw new TooFewArgumentsException(this.getPosition(), 2);
                    }
                    if (oldOperator == newOperator) {
                        if (oldOperator.getMax() != -1 && term.size() + 1 >= oldOperator.getMax()) {
                            throw new TooMuchArgumentsException(this.getPosition(), oldOperator, oldOperator.getMax());
                        }
                        Trace.trace(CLASS, (Object)this, "Term addNextInfixTerms(int, Term)", "new term is added to old term");
                        term.addArgument(term2);
                    } else {
                        Trace.trace(CLASS, (Object)this, "Term addNextInfixTerms(int, Term)", "old term is first argument of new operator");
                        term = new Term(newOperator, term);
                        term.addArgument(term2);
                    }
                } else {
                    Trace.trace(CLASS, (Object)this, "Term addNextInfixTerms(int, Term)", "oldOperator is not null or has less priority than new");
                    term2 = this.readMaximalTerm(newOperator.getPriority());
                    if (term2 == null) {
                        throw new TooFewArgumentsException(this.getPosition(), 2);
                    }
                    term = new Term(newOperator, term);
                    term.addArgument(term2);
                }
                oldOperator = newOperator;
            }
        }
        finally {
            Trace.end(CLASS, this, "Term addNextInfixTerms(int, Term)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Term readPrefixTerm() throws ParserException {
        String method = "readPrefixTerm()";
        Trace.begin(CLASS, this, "readPrefixTerm()");
        Term term = null;
        try {
            List readOperators = this.readOperators();
            if (readOperators != null && readOperators.size() > 0) {
                Trace.trace(CLASS, (Object)this, "readPrefixTerm()", "operators found");
                term = this.readPrefixOperator(readOperators);
            } else {
                Trace.trace(CLASS, (Object)this, "readPrefixTerm()", "no operators found");
                String token = this.getToken();
                if (token == null) {
                    Trace.param(CLASS, (Object)this, "readPrefixTerm()", "read term", "null");
                    Term term2 = null;
                    return term2;
                }
                if ("(".equals(token)) {
                    this.readToken();
                    Trace.trace(CLASS, (Object)this, "readPrefixTerm()", "start bracket found: " + token);
                    term = this.readMaximalTerm(0);
                    String lastToken = this.readToken();
                    if (!")".equals(lastToken)) {
                        throw new ClosingBracketMissingException(this.getPosition(), "(", lastToken);
                    }
                } else if ("[".equals(token)) {
                    this.readToken();
                    Trace.trace(CLASS, (Object)this, "readPrefixTerm()", "start bracket found: " + token);
                    term = this.readMaximalTerm(0);
                    String lastToken = this.readToken();
                    if (!"]".equals(lastToken)) {
                        throw new ClosingBracketMissingException(this.getPosition(), "[", lastToken);
                    }
                } else {
                    this.readToken();
                    Trace.param(CLASS, (Object)this, "readPrefixTerm()", "atom", token);
                    term = new Term(new TermAtom(token));
                }
            }
            Trace.param(CLASS, (Object)this, "readPrefixTerm()", "read term", term != null ? term.getQedeq() : "null");
            Term term3 = term;
            return term3;
        }
        finally {
            Trace.end(CLASS, this, "readPrefixTerm()");
        }
    }

    private Term readPrefixOperator(List operators) throws ParserException {
        Term term = null;
        this.markPosition();
        for (int number = 0; number < operators.size(); ++number) {
            String end;
            Term add;
            String separator;
            this.rewindPosition();
            this.markPosition();
            Operator operator = (Operator)operators.get(number);
            if (!operator.isPrefix()) {
                this.clearMark();
                throw new UnexpectedOperatorException(this.getPosition(), operator);
            }
            term = new Term(operator);
            if (operator.isFunction()) {
                if (operator.getMax() == 0) break;
                ArrayList list = this.readTupel();
                if (list == null) {
                    list = new ArrayList();
                }
                if (list.size() < operator.getMin()) {
                    if (number + 1 < operators.size()) continue;
                    this.clearMark();
                    throw new TooFewArgumentsException(this.getPosition(), operator.getMin());
                }
                if (operator.getMax() != -1 && list.size() > operator.getMax()) {
                    if (number + 1 < operators.size()) continue;
                    this.clearMark();
                    throw new TooMuchArgumentsException(this.getPosition(), operator, operator.getMax());
                }
                for (int i = 0; i < list.size(); ++i) {
                    term.addArgument((Term)list.get(i));
                }
                break;
            }
            int i = 0;
            while (i < operator.getMin()) {
                if (i > 0 && operator.getSeparatorSymbol() != null) {
                    separator = this.getToken();
                    if (!operator.getSeparatorSymbol().equals(separator)) {
                        if (number + 1 < operators.size()) continue;
                        this.clearMark();
                        throw new SeparatorNotFoundException(this.getPosition(), operator.getSeparatorSymbol());
                    }
                    this.readToken();
                }
                if ((add = this.readMaximalTerm(operator.getPriority())) == null) {
                    if (number + 1 < operators.size()) continue;
                    this.clearMark();
                    throw new TooFewArgumentsException(this.getPosition(), operator.getMin());
                }
                term.addArgument(add);
                ++i;
            }
            while (operator.getMax() == -1 || i < operator.getMax()) {
                if (i > 0 && operator.getSeparatorSymbol() != null) {
                    separator = this.getToken();
                    if (!operator.getSeparatorSymbol().equals(separator)) break;
                    this.readToken();
                }
                if (operator.getEndSymbol() != null) {
                    end = this.getToken();
                    if (operator.getEndSymbol().equals(end)) break;
                }
                add = null;
                this.markPosition();
                try {
                    add = this.readMaximalTerm(operator.getPriority());
                    this.clearMark();
                }
                catch (Exception e) {
                    this.rewindPosition();
                }
                if (add == null) break;
                term.addArgument(add);
                ++i;
            }
            if (operator.getEndSymbol() == null) break;
            end = this.getToken();
            if (!operator.getEndSymbol().equals(end)) {
                if (number + 1 < operators.size()) continue;
                this.clearMark();
                throw new EndSymbolNotFoundException(this.getPosition(), operator.getEndSymbol());
            }
            this.readToken();
            break;
        }
        this.clearMark();
        return term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List readTupel() throws ParserException {
        String method = "List readTupel()";
        Trace.begin(CLASS, this, "List readTupel()");
        try {
            String lastToken;
            String firstToken = this.getToken();
            if (!"(".equals(firstToken)) {
                Trace.trace(CLASS, (Object)this, "List readTupel()", "no start bracket found");
                List list = null;
                return list;
            }
            this.readToken();
            ArrayList<Term> list = new ArrayList<Term>();
            Term term = null;
            while (null != (term = this.readMaximalTerm(0))) {
                list.add(term);
                String separatorToken = this.getToken();
                if (!",".equals(separatorToken)) break;
                this.readToken();
            }
            if (!")".equals(lastToken = this.readToken())) {
                throw new ClosingBracketMissingException(this.getPosition(), ")", lastToken);
            }
            ArrayList<Term> arrayList = list;
            return arrayList;
        }
        finally {
            Trace.end(CLASS, this, "List readTupel()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Operator readOperator() {
        String method = "Operator readOperator()";
        Trace.begin(CLASS, this, "Operator readOperator()");
        try {
            this.markPosition();
            String token = this.readToken();
            if (token == null) {
                this.rewindPosition();
                Trace.trace(CLASS, (Object)this, "Operator readOperator()", "no operator found");
                Operator operator = null;
                return operator;
            }
            Operator operator = this.getOperator(token);
            if (operator == null) {
                this.rewindPosition();
                Trace.trace(CLASS, (Object)this, "Operator readOperator()", "no operator found");
                Operator operator2 = null;
                return operator2;
            }
            this.clearMark();
            Trace.param(CLASS, (Object)this, "Operator readOperator()", "operator", operator.getQedeq());
            Operator operator3 = operator;
            return operator3;
        }
        finally {
            Trace.end(CLASS, this, "Operator readOperator()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List readOperators() {
        String method = "List readOperators()";
        Trace.begin(CLASS, this, "List readOperators()");
        try {
            this.markPosition();
            String token = this.readToken();
            if (token == null) {
                this.rewindPosition();
                Trace.trace(CLASS, (Object)this, "List readOperators()", "no operators found");
                List list = null;
                return list;
            }
            List ops = this.getOperators(token);
            if (ops == null || ops.size() == 0) {
                this.rewindPosition();
                Trace.trace(CLASS, (Object)this, "List readOperators()", "no operators found");
                List list = null;
                return list;
            }
            this.clearMark();
            for (int i = 0; i < ops.size(); ++i) {
                Trace.param(CLASS, (Object)this, "List readOperators()", "operator[" + i + "]", ops.get(i));
            }
            List list = ops;
            return list;
        }
        finally {
            Trace.end(CLASS, this, "List readOperators()");
        }
    }

    protected abstract Operator getOperator(String var1);

    protected abstract List getOperators(String var1);

    protected abstract String readToken();

    public final String getToken() {
        this.markPosition();
        String result = this.readToken();
        this.rewindPosition();
        return result;
    }

    protected final void markPosition() {
        this.input.markPosition();
    }

    protected final long rewindPosition() {
        return this.input.rewindPosition();
    }

    protected final void clearMark() {
        this.input.clearMark();
    }

    private long getPosition() {
        return this.input.getPosition();
    }

    protected final int getChar() {
        return this.input.getChar();
    }

    protected final int readChar() {
        return this.input.read();
    }

    protected abstract boolean eot(String var1);

    public final boolean eof() {
        return this.input.isEmpty();
    }

    public final int getRewindStackSize() {
        return this.input.getRewindStackSize();
    }
}

