/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.module;

import java.util.HashMap;
import java.util.Map;
import org.qedeq.kernel.bo.common.ModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelNodeBo;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.common.IllegalModuleDataException;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.dto.module.NodeVo;
import org.qedeq.kernel.se.visitor.QedeqNumbers;

public final class ModuleLabels {
    private ModuleReferenceList references = new KernelModuleReferenceList();
    private final Map label2Bo;
    private final Map label2Context;
    private final Map predicateDefinitions = new HashMap();
    private final Map predicateContexts = new HashMap();
    private final Map functionDefinitions = new HashMap();
    private final Map functionContexts = new HashMap();

    public ModuleLabels() {
        this.label2Bo = new HashMap();
        this.label2Context = new HashMap();
    }

    public void setModuleReferences(ModuleReferenceList references) {
        this.references = references;
    }

    public ModuleReferenceList getReferences() {
        return this.references;
    }

    public final void addNode(ModuleContext context, NodeVo node, KernelQedeqBo qedeq, QedeqNumbers data) throws IllegalModuleDataException {
        ModuleContext con = new ModuleContext(context);
        if (null == node.getId()) {
            throw new IllegalModuleDataException(10001, "An id was not defined.", con, null, null);
        }
        this.checkLabelIntern(con, node.getId());
        this.label2Context.put(node.getId(), con);
        KernelNodeBo nodeBo = new KernelNodeBo(node, context, qedeq, data);
        this.label2Bo.put(node.getId(), nodeBo);
    }

    public final void addLabel(ModuleContext context, String label) throws IllegalModuleDataException {
        ModuleContext con = new ModuleContext(context);
        this.checkLabelIntern(con, label);
        this.label2Context.put(label, con);
    }

    private final void checkLabelIntern(ModuleContext context, String label) throws IllegalModuleDataException {
        if (this.label2Context.containsKey(label)) {
            throw new IllegalModuleDataException(10002, "Id or label defined more than once: \"" + label + "\"", context, (ModuleContext)this.label2Context.get(label), null);
        }
    }

    public final KernelNodeBo getNode(String id) {
        return (KernelNodeBo)this.label2Bo.get(id);
    }

    public final boolean isNode(String id) {
        return this.label2Bo.get(id) != null;
    }

    public final boolean isModule(String id) {
        return this.label2Bo.get(id) == null && this.label2Context.get(id) != null;
    }

    public void addPredicate(PredicateDefinition definition, ModuleContext context) {
        String identifier = definition.getName() + "_" + definition.getArgumentNumber();
        this.getPredicateDefinitions().put(identifier, definition);
        this.predicateContexts.put(identifier, new ModuleContext(context));
    }

    public PredicateDefinition getPredicate(String name, int argumentNumber) {
        return (PredicateDefinition)this.getPredicateDefinitions().get(name + "_" + argumentNumber);
    }

    public ModuleContext getPredicateContext(String name, int argumentNumber) {
        return new ModuleContext((ModuleContext)this.predicateContexts.get(name + "_" + argumentNumber));
    }

    public void addFunction(FunctionDefinition definition, ModuleContext context) {
        String identifier = definition.getName() + "_" + definition.getArgumentNumber();
        this.getFunctionDefinitions().put(identifier, definition);
        this.functionContexts.put(identifier, new ModuleContext(context));
    }

    public FunctionDefinition getFunction(String name, int argumentNumber) {
        return (FunctionDefinition)this.getFunctionDefinitions().get(name + "_" + argumentNumber);
    }

    public ModuleContext getFunctionContext(String name, int argumentNumber) {
        return new ModuleContext((ModuleContext)this.functionContexts.get(name + "_" + argumentNumber));
    }

    public Map getPredicateDefinitions() {
        return this.predicateDefinitions;
    }

    public Map getFunctionDefinitions() {
        return this.functionDefinitions;
    }
}

