/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.module;

import org.qedeq.base.io.SourceArea;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.kernel.bo.module.DefaultReference;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.KernelNodeBo;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.Reference;
import org.qedeq.kernel.bo.module.ReferenceLinkException;
import org.qedeq.kernel.bo.module.RuntimeVisitorException;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.module.NodeVo;
import org.qedeq.kernel.se.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.se.visitor.QedeqNotNullTraverser;
import org.qedeq.kernel.se.visitor.QedeqNumbers;

public abstract class ControlVisitor
extends AbstractModuleVisitor {
    private static final Class CLASS = ControlVisitor.class;
    private final Plugin plugin;
    private final KernelQedeqBo prop;
    private final QedeqNotNullTraverser traverser;
    private DefaultSourceFileExceptionList errorList;
    private DefaultSourceFileExceptionList warningList;

    protected ControlVisitor(KernelQedeqBo prop) {
        this.prop = prop;
        this.plugin = (Plugin)((Object)this);
        this.traverser = new QedeqNotNullTraverser(prop.getModuleAddress(), this);
    }

    protected ControlVisitor(Plugin plugin, KernelQedeqBo prop) {
        this.plugin = plugin;
        this.prop = prop;
        this.traverser = new QedeqNotNullTraverser(prop.getModuleAddress(), this);
    }

    public KernelQedeqBo getQedeqBo() {
        return this.prop;
    }

    public KernelNodeBo getNodeBo() {
        Node node = this.traverser.getNode();
        if (node == null) {
            return null;
        }
        return this.getQedeqBo().getLabels().getNode(node.getId());
    }

    public void traverse() throws SourceFileExceptionList {
        if (this.getQedeqBo().getQedeq() == null) {
            this.addWarning(new SourceFileException(this.getPlugin(), 90500, "QEDEQ module couldn't be loaded.", new IllegalArgumentException(), new SourceArea(this.getQedeqBo().getModuleAddress().getUrl()), null));
            return;
        }
        try {
            this.traverser.accept(this.getQedeqBo().getQedeq());
        }
        catch (ModuleDataException me) {
            this.addError(me);
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "traverse", "looks like a programming error", e);
            this.addError(new RuntimeVisitorException(this.getCurrentContext(), e));
        }
        if (this.errorList != null && this.errorList.size() > 0) {
            throw this.errorList;
        }
    }

    public ModuleContext getCurrentContext() {
        return this.traverser.getCurrentContext();
    }

    protected void addError(ModuleDataException me) {
        this.addError(this.prop.createSourceFileException(this.getPlugin(), me));
    }

    protected void addError(SourceFileException sf) {
        if (this.errorList == null) {
            this.errorList = new DefaultSourceFileExceptionList(sf);
        } else {
            this.errorList.add(sf);
        }
    }

    public SourceFileExceptionList getErrorList() {
        return this.errorList;
    }

    protected void addWarning(ModuleDataException me) {
        this.addWarning(this.prop.createSourceFileException(this.getPlugin(), me));
    }

    private void addWarning(SourceFileException sf) {
        if (this.warningList == null) {
            this.warningList = new DefaultSourceFileExceptionList(sf);
        } else {
            this.warningList.add(sf);
        }
    }

    public SourceFileExceptionList getWarningList() {
        return this.warningList;
    }

    protected void setBlocked(boolean blocked) {
        this.traverser.setBlocked(blocked);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getExecutionActionDescription() {
        return this.traverser.getVisitAction();
    }

    public double getExecutionPercentage() {
        return this.traverser.getVisitPercentage();
    }

    public QedeqNumbers getCurrentNumbers() {
        return this.traverser.getCurrentNumbers();
    }

    public InternalKernelServices getServices() {
        return this.prop.getKernelServices();
    }

    public Reference getReference(String reference, ModuleContext context, boolean addWarning, boolean addError) {
        String[] split2;
        KernelNodeBo node = this.getNodeBo();
        DefaultReference fallback = new DefaultReference(node, null, "", null, (reference != null ? reference : "") + "?", "", "");
        if (reference == null || reference.length() <= 0) {
            return fallback;
        }
        if (reference.indexOf("!") >= 0 && reference.indexOf("/") >= 0) {
            if (addWarning) {
                this.addWarning(new ReferenceLinkException(90512, "reference can not contain sub reference and proof line reference simultaneously: \"" + reference + "\"", context));
            }
            if (addError) {
                this.addError(new ReferenceLinkException(90512, "reference can not contain sub reference and proof line reference simultaneously: \"" + reference + "\"", context));
            }
        }
        if (node != null && node.isProofLineLabel(reference)) {
            return new DefaultReference(node, null, "", node, node.getNodeVo().getId(), "", reference);
        }
        if (this.getQedeqBo().getLabels().isNode(reference)) {
            return new DefaultReference(node, null, "", this.getQedeqBo().getLabels().getNode(reference), reference, "", "");
        }
        if (this.getQedeqBo().getLabels().isModule(reference)) {
            return new DefaultReference(node, (KernelQedeqBo)this.getQedeqBo().getLabels().getReferences().getQedeqBo(reference), reference, null, "", "", "");
        }
        String moduleLabel = "";
        String nodeLabel = "";
        String lineLabel = "";
        String subLabel = "";
        String[] split = StringUtility.split(reference, ".");
        if (split.length <= 1 || split.length > 2) {
            if (split.length == 1) {
                nodeLabel = split[0];
            } else if (split.length > 2) {
                if (addWarning) {
                    this.addWarning(new ReferenceLinkException(610011, "node reference has more than one dots: \"" + reference + "\"", context));
                }
                if (addError) {
                    this.addError(new ReferenceLinkException(610011, "node reference has more than one dots: \"" + reference + "\"", context));
                }
                return fallback;
            }
        } else {
            moduleLabel = split[0];
            nodeLabel = split[1];
        }
        if (nodeLabel.indexOf("!") >= 0) {
            split2 = StringUtility.split(nodeLabel, "!");
            if (split2.length != 2) {
                if (addWarning) {
                    this.addWarning(new ReferenceLinkException(610013, "node reference must have only one proof line reference: \"" + reference + "\"", context));
                }
                if (addError) {
                    this.addError(new ReferenceLinkException(610013, "node reference must have only one proof line reference: \"" + reference + "\"", context));
                }
            }
            nodeLabel = split2[0];
            if (split.length > 1) {
                lineLabel = split2[1];
            }
        }
        if (nodeLabel.indexOf("/") >= 0) {
            split2 = StringUtility.split(nodeLabel, "/");
            if (split2.length != 2) {
                if (addWarning) {
                    this.addWarning(new ReferenceLinkException(610013, "node reference must have only one sub reference: \"" + reference + "\"", context));
                }
                if (addError) {
                    this.addError(new ReferenceLinkException(610013, "node reference must have only one sub reference: \"" + reference + "\"", context));
                }
            }
            nodeLabel = split2[0];
            if (split.length > 1) {
                subLabel = split2[1];
            }
        }
        KernelQedeqBo module = null;
        KernelNodeBo eNode = null;
        eNode = moduleLabel != null && moduleLabel.length() > 0 ? ((module = this.getQedeqBo().getKernelRequiredModules().getKernelQedeqBo(moduleLabel)) != null ? module.getLabels().getNode(nodeLabel) : null) : this.getQedeqBo().getLabels().getNode(nodeLabel);
        if (moduleLabel != null && moduleLabel.length() > 0 && module == null) {
            if (addWarning) {
                this.addWarning(new ReferenceLinkException(6100017, "module reference not found for: \"" + reference + "\"", context));
            }
            if (addError) {
                this.addError(new ReferenceLinkException(6100017, "module reference not found for: \"" + reference + "\"", context));
            }
            return new DefaultReference(node, module, moduleLabel + "?", eNode, nodeLabel, subLabel, lineLabel);
        }
        if (eNode == null) {
            if (addWarning) {
                this.addWarning(new ReferenceLinkException(610007, "node reference not found for: \"" + reference + "\"", context));
            }
            if (addError) {
                this.addError(new ReferenceLinkException(610007, "node reference not found for: \"" + reference + "\"", context));
            }
            return new DefaultReference(node, module, moduleLabel, eNode, nodeLabel + "?", subLabel, lineLabel);
        }
        return new DefaultReference(node, module, moduleLabel, eNode, nodeLabel, subLabel, lineLabel);
    }

    public String getNodeDisplay(String label, KernelNodeBo kNode, String language) {
        String display = label;
        if (kNode == null) {
            return display;
        }
        QedeqNumbers data = kNode.getNumbers();
        NodeVo node = kNode.getNodeVo();
        if (node.getNodeType() instanceof Axiom) {
            display = "de".equals(language) ? "Axiom" : "axiom";
            display = display + " " + data.getAxiomNumber();
        } else if (node.getNodeType() instanceof Proposition) {
            display = "de".equals(language) ? "Proposition" : "proposition";
            display = display + " " + data.getPropositionNumber();
        } else if (node.getNodeType() instanceof FunctionDefinition) {
            display = "de".equals(language) ? "Definition" : "definition";
            display = display + " " + (data.getPredicateDefinitionNumber() + data.getFunctionDefinitionNumber());
        } else if (node.getNodeType() instanceof PredicateDefinition) {
            display = "de".equals(language) ? "Definition" : "definition";
            display = display + " " + (data.getPredicateDefinitionNumber() + data.getFunctionDefinitionNumber());
        } else if (node.getNodeType() instanceof Rule) {
            display = "de".equals(language) ? "Regel" : "rule";
            display = display + " " + data.getRuleNumber();
        } else {
            display = "de".equals(language) ? "Unbekannt " + node.getId() : "unknown " + node.getId();
        }
        return display;
    }
}

