/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.proof.finder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.qedeq.kernel.bo.logic.common.FormulaUtility;
import org.qedeq.kernel.bo.logic.common.ProofFinder;
import org.qedeq.kernel.bo.logic.proof.finder.ModusPonensBo;
import org.qedeq.kernel.bo.logic.proof.finder.ProofFinderUtility;
import org.qedeq.kernel.bo.logic.proof.finder.SubstPredBo;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.Reason;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.dto.list.DefaultElementList;
import org.qedeq.kernel.se.dto.list.ElementSet;
import org.qedeq.kernel.se.visitor.InterruptException;

public class ProofFinderImpl
implements ProofFinder {
    private List lines;
    private List reasons;
    private ElementSet allPredVars;
    private int mpLast;
    private Element goalFormula;

    public FormalProofLineList findProof(Element formula, FormalProofLineList proof, ModuleContext context) throws InterruptException {
        int i;
        this.goalFormula = formula;
        this.lines = new ArrayList();
        this.reasons = new ArrayList();
        this.allPredVars = new ElementSet();
        for (int i2 = 0; i2 < proof.size(); ++i2) {
            Reason r = proof.get(i2).getReasonType().getReason();
            if (!(r instanceof Add)) continue;
            this.lines.add(proof.get(i2).getFormula().getElement());
            this.reasons.add(r);
            this.allPredVars.union(FormulaUtility.getPropositionVariables(proof.get(i2).getFormula().getElement()));
        }
        String max = "A";
        Iterator j = this.allPredVars.iterator();
        while (j.hasNext()) {
            ElementList v = (ElementList)j.next();
            String name = v.getElement(0).getAtom().getString();
            if (-1 != max.compareTo(name)) continue;
            max = name;
        }
        max = (char)(max.charAt(0) + '\u0001') + "";
        System.out.println(max);
        this.allPredVars.add(FormulaUtility.createPredicateVariable(max));
        for (i = 0; i < this.lines.size(); ++i) {
            ProofFinderUtility.printUtf8Line(this.lines, this.reasons, i);
        }
        System.out.println("Goal: ");
        ProofFinderUtility.println(formula);
        i = 0;
        while (i < this.lines.size() && this.lines.size() < 2147482647) {
            try {
                this.tryModusPonensAll();
                if (Thread.interrupted()) {
                    throw new InterruptException(context);
                }
                this.trySubstitution(i++);
            }
            catch (ProofFoundException e) {
                System.out.println("proof found. lines: " + this.lines.size());
                return ProofFinderUtility.shortenProof(this.lines, this.reasons);
            }
        }
        System.out.println("proof not found. lines: " + this.lines.size());
        return null;
    }

    private void tryModusPonensAll() throws ProofFoundException {
        int until = this.lines.size();
        for (int i = 0; i < until; ++i) {
            int j;
            Element first = (Element)this.lines.get(i);
            if (!FormulaUtility.isImplication(first)) continue;
            int n = j = i < this.mpLast ? this.mpLast : 0;
            while (j < until) {
                if (((Object)first.getList().getElement(0)).equals((Element)this.lines.get(j))) {
                    ModusPonensBo mp = new ModusPonensBo(i, j);
                    this.addFormula(first.getList().getElement(1), mp);
                }
                ++j;
            }
        }
        this.mpLast = until;
    }

    private void trySubstitution(int i) throws ProofFoundException {
        Element f = (Element)this.lines.get(i);
        ElementSet vars = FormulaUtility.getPredicateVariables(f);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            ElementList var = (ElementList)iter.next();
            Iterator all = this.allPredVars.iterator();
            while (all.hasNext()) {
                ElementList subst = (ElementList)all.next();
                if (var.equals(subst)) continue;
                Element created = FormulaUtility.replaceOperatorVariable(f, var, subst);
                this.addFormula(created, new SubstPredBo(i, var, subst));
            }
            this.createReplacement(i, f, var, "OR", true);
            this.createReplacement(i, f, var, "OR", false);
        }
    }

    private void createReplacement(int i, Element f, ElementList var, String operator, boolean left) throws ProofFoundException {
        Iterator a = this.allPredVars.iterator();
        while (a.hasNext()) {
            ElementList var2 = (ElementList)a.next();
            DefaultElementList subst = new DefaultElementList(operator);
            if (left) {
                subst.add(var);
                subst.add(var2);
            } else {
                subst.add(var2);
                subst.add(var);
            }
            Element created = FormulaUtility.replaceOperatorVariable(f, var, subst);
            this.addFormula(created, new SubstPredBo(i, var, subst));
        }
    }

    private void addFormula(Element formula, Reason reason) throws ProofFoundException {
        if (!this.lines.contains(formula)) {
            this.lines.add(formula);
            this.reasons.add(reason);
            if (((Object)this.goalFormula).equals(formula)) {
                throw new ProofFoundException();
            }
            if ((this.lines.size() - 1) % 1000 == 0) {
                ProofFinderUtility.printUtf8Line(this.lines, this.reasons, this.lines.size() - 1);
            }
        }
    }

    public String getExecutionActionDescription() {
        return ProofFinderUtility.getUtf8Line(this.lines, this.reasons, this.lines.size() - 1);
    }

    private static class ProofFoundException
    extends Exception {
        private ProofFoundException() {
        }
    }
}

