/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.qedeq.kernel.bo.logic.model.Entity;
import org.qedeq.kernel.bo.logic.model.Function;
import org.qedeq.kernel.bo.logic.model.Model;
import org.qedeq.kernel.bo.logic.model.ModelFunctionConstant;
import org.qedeq.kernel.bo.logic.model.ModelPredicateConstant;
import org.qedeq.kernel.bo.logic.model.Predicate;

public abstract class DynamicModel
implements Model {
    public static final Predicate FALSE = new Predicate(0, 99, "F", "always false"){

        public boolean calculate(Entity[] entities) {
            return false;
        }
    };
    public static final Predicate TRUE = new Predicate(0, 99, "T", "always true"){

        public boolean calculate(Entity[] entities) {
            return true;
        }
    };
    public static final Predicate EVEN = new Predicate(0, 99, "| 2", "is even"){

        public boolean calculate(Entity[] entities) {
            boolean result = true;
            for (int i = 0; i < entities.length; ++i) {
                result &= entities[i].getValue() % 2 == 0;
            }
            return result;
        }
    };
    public static final Predicate LESS = new Predicate(0, 99, "<", "less"){

        public boolean calculate(Entity[] entities) {
            boolean result = true;
            for (int i = 0; i < entities.length - 1; ++i) {
                result &= entities[i].getValue() < entities[i + 1].getValue();
            }
            return result;
        }
    };
    public static final Predicate NOT_LESS = Predicate.not(LESS);
    public static final Predicate EQUAL = new Predicate(0, 99, "=", "equal"){

        public boolean calculate(Entity[] entities) {
            boolean result = true;
            for (int i = 0; i < entities.length - 1; ++i) {
                result &= entities[i].getValue() == entities[i + 1].getValue();
            }
            return result;
        }
    };
    public static final Predicate NOT_EQUAL = Predicate.not(EQUAL);
    private final String name;
    private final List entities;
    private final Vector functionPool;
    private final Vector predicatePool;
    private final Map predicateConstants;
    private final Map functionConstants;

    public DynamicModel(String name) {
        this.name = name;
        this.entities = new ArrayList();
        this.functionPool = new Vector();
        this.predicatePool = new Vector();
        this.predicateConstants = new HashMap();
        this.predicateConstants.put(new ModelPredicateConstant("TRUE", 0), TRUE);
        this.predicateConstants.put(new ModelPredicateConstant("FALSE", 0), FALSE);
        this.predicateConstants.put(new ModelPredicateConstant("equal", 2), EQUAL);
        this.predicateConstants.put(new ModelPredicateConstant("notEqual", 2), NOT_EQUAL);
        this.functionConstants = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public abstract String getDescription();

    public void addPredicateConstant(ModelPredicateConstant constant, Predicate predicate) {
        this.predicateConstants.put(constant, predicate);
    }

    public void addFunctionConstant(ModelFunctionConstant constant, Function function) {
        this.functionConstants.put(constant, function);
    }

    protected void addEntity(Entity entity) {
        if (this.entities.size() != entity.getValue()) {
            throw new RuntimeException("entity value should have been " + this.entities.size() + " but was " + entity.getValue());
        }
        this.entities.add(entity);
    }

    public int getEntitiesSize() {
        return this.entities.size();
    }

    public Entity getEntity(int number) {
        return (Entity)this.entities.get(number);
    }

    public int getPredicateSize(int size) {
        if (this.predicatePool.size() <= size) {
            return 0;
        }
        List list = (List)this.predicatePool.get(size);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public Predicate getPredicate(int size, int number) {
        List predicateForSize = (List)this.predicatePool.get(size);
        return (Predicate)predicateForSize.get(number);
    }

    public void addPredicate(int size, Predicate predicate) {
        if (this.getPredicateSize(size) == 0 && this.predicatePool.size() <= size) {
            for (int i = this.predicatePool.size(); i <= size; ++i) {
                this.predicatePool.add(new ArrayList());
            }
        }
        List list = (List)this.predicatePool.get(size);
        list.add(predicate);
    }

    public Predicate getPredicateConstant(ModelPredicateConstant con) {
        return (Predicate)this.predicateConstants.get(con);
    }

    public int getFunctionSize(int size) {
        if (this.functionPool.size() <= size) {
            return 0;
        }
        List list = (List)this.functionPool.get(size);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public Function getFunction(int size, int number) {
        List functionForSize = (List)this.functionPool.get(size);
        return (Function)functionForSize.get(number);
    }

    public void addFunction(int size, Function function) {
        if (this.getFunctionSize(size) == 0 && this.functionPool.size() <= size) {
            for (int i = this.functionPool.size(); i <= size; ++i) {
                this.functionPool.add(new ArrayList());
            }
        }
        List list = (List)this.functionPool.get(size);
        list.add(function);
    }

    public Function getFunctionConstant(ModelFunctionConstant con) {
        return (Function)this.functionConstants.get(con);
    }

    public abstract Entity comprehension(Entity[] var1);
}

