/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.SourceArea;
import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.utility.StringUtility;

public class TextInput
extends InputStream {
    public static final int EOF = -1;
    public static final char CR = '\n';
    private static final String MARKER = "#####";
    private final StringBuffer source;
    private int lineNumber = 0;
    private int column = 0;
    private int position = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextInput(Reader reader) throws IOException {
        try {
            int c;
            if (reader == null) {
                throw new NullPointerException("no null pointer as argument accepted");
            }
            this.source = new StringBuffer();
            while (-1 != (c = reader.read())) {
                this.source.append((char)c);
            }
        }
        finally {
            IoUtility.close(reader);
        }
    }

    public TextInput(StringBuffer source) {
        if (source == null) {
            throw new NullPointerException("no null pointer as argument accepted");
        }
        this.source = source;
    }

    public TextInput(String source) {
        if (source == null) {
            throw new NullPointerException("no null pointer as argument accepted");
        }
        this.source = new StringBuffer(source);
    }

    public TextInput(File file, String encoding) throws IOException {
        if (file == null) {
            throw new NullPointerException("no null pointer as argument accepted");
        }
        this.source = new StringBuffer();
        IoUtility.loadFile(file, this.source, encoding);
    }

    public final int read() {
        if (this.position >= this.source.length()) {
            return -1;
        }
        if (this.getChar() == 10) {
            ++this.lineNumber;
            this.column = 0;
        } else {
            ++this.column;
        }
        return this.source.charAt(this.position++);
    }

    public final int readInverse() {
        char c;
        if (this.position <= 0) {
            return -1;
        }
        if ((c = this.source.charAt(--this.position)) == '\n') {
            --this.lineNumber;
            int pos = this.source.lastIndexOf("\n", this.position - 1);
            this.column = pos < 0 ? this.position : this.position - 1 - pos;
        } else {
            --this.column;
            if (this.column < 0) {
                throw new IllegalStateException("column less then 0");
            }
        }
        return c;
    }

    public final String readString(int number) {
        int c;
        StringBuffer result = new StringBuffer(number);
        for (int i = 0; i < number && (c = this.read()) != -1; ++i) {
            result.append((char)c);
        }
        return result.toString();
    }

    public final void forward(int number) {
        int c;
        for (int i = 0; i < number && (c = this.read()) != -1; ++i) {
        }
    }

    public final boolean forward(String search) {
        int pos = this.source.indexOf(search, this.position);
        if (pos < 0) {
            this.setPosition(this.getMaximumPosition());
            return false;
        }
        this.setPosition(pos);
        return true;
    }

    public final int getChar() {
        if (this.position >= this.source.length()) {
            return -1;
        }
        return this.source.charAt(this.position);
    }

    public final int getChar(int skip) {
        if (this.position + skip < 0 || this.position + skip >= this.source.length()) {
            return -1;
        }
        return this.source.charAt(this.position + skip);
    }

    public final String getSubstring(int from, int to) {
        int f;
        int l = this.source.length();
        int n = from < 0 ? 0 : (f = from > l ? l : from);
        int t = to < 0 ? 0 : (to > l ? l : to);
        return this.source.substring(f, t);
    }

    public final String asString() {
        return this.source.toString();
    }

    public final void replace(int from, int to, String replacement) {
        this.source.replace(from, to, replacement);
        if (this.position > from && this.position < to) {
            this.setPosition(from + replacement.length());
        } else if (this.position > from) {
            this.setPosition(this.position - to + from + replacement.length());
        }
    }

    public final void skipWhiteSpace() {
        while (!this.isEmpty() && Character.isWhitespace((char)this.getChar())) {
            this.read();
        }
    }

    public final void skipWhiteSpaceInverse() {
        while (this.getPosition() > 0 && Character.isWhitespace((char)this.getChar(-1))) {
            this.readInverse();
        }
    }

    public final void skipBackToBeginOfXmlTag() {
        if (60 == this.getChar()) {
            return;
        }
        boolean quoted = false;
        do {
            if (-1 == this.readInverse()) {
                throw new IllegalArgumentException("begin of xml tag not found");
            }
            if (34 != this.getChar()) continue;
            boolean bl = quoted = !quoted;
        } while (quoted || 60 != this.getChar());
    }

    public final void skipForwardToEndOfXmlTag() {
        if (62 == this.getChar()) {
            return;
        }
        boolean quoted = false;
        while (62 != this.getChar()) {
            if (34 == this.getChar()) {
                boolean bl = quoted = !quoted;
            }
            if (quoted || -1 != this.read()) continue;
            throw new IllegalArgumentException("end of xml tag not found");
        }
        this.read();
    }

    public final String readNextXmlName() {
        this.skipWhiteSpace();
        if (this.isEmpty() || 61 == this.getChar() || 62 == this.getChar()) {
            throw new IllegalArgumentException("begin of attribute expected");
        }
        StringBuffer buffer = new StringBuffer();
        while (!this.isEmpty() && 61 != this.getChar() && 62 != this.getChar() && !Character.isWhitespace((char)this.getChar())) {
            buffer.append((char)this.read());
        }
        return buffer.toString();
    }

    public final String readNextAttributeValue() {
        this.skipWhiteSpace();
        if (this.isEmpty() || 61 != this.getChar()) {
            throw new IllegalArgumentException("\"=\" expected");
        }
        this.read();
        this.skipWhiteSpace();
        if (this.isEmpty() || 62 == this.getChar()) {
            throw new IllegalArgumentException("attribute value expected");
        }
        StringBuffer buffer = new StringBuffer();
        if (34 == this.getChar()) {
            this.read();
            while (!this.isEmpty() && 34 != this.getChar()) {
                buffer.append((char)this.read());
            }
            if (34 != this.getChar()) {
                throw new IllegalArgumentException("\" expected");
            }
            this.read();
        } else {
            while (!this.isEmpty() && 62 != this.getChar() && !Character.isWhitespace((char)this.getChar())) {
                buffer.append((char)this.read());
            }
        }
        return StringUtility.unescapeXml(buffer.toString());
    }

    public final boolean isEmpty() {
        return this.position >= this.source.length();
    }

    public final boolean isEmpty(int skip) {
        return this.position + skip >= this.source.length();
    }

    public final String readLetterDigitString() {
        this.skipWhiteSpace();
        if (this.isEmpty() || !Character.isLetterOrDigit((char)this.getChar())) {
            this.read();
            throw new IllegalArgumentException("letter or digit expected");
        }
        StringBuffer buffer = new StringBuffer();
        while (!this.isEmpty() && Character.isLetterOrDigit((char)this.getChar())) {
            buffer.append((char)this.read());
        }
        return buffer.toString();
    }

    public final String readCounter() {
        this.skipWhiteSpace();
        if (this.isEmpty()) {
            throw new IllegalArgumentException("integer expected");
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getChar() == 45) {
            buffer.append(this.read());
        }
        int begin = this.getPosition();
        if (!Character.isDigit((char)this.getChar())) {
            throw new IllegalArgumentException("digit expected");
        }
        while (!this.isEmpty() && Character.isDigit((char)this.getChar())) {
            buffer.append((char)this.read());
        }
        if (buffer.length() >= 2 && ('0' == buffer.charAt(0) || '-' == buffer.charAt(0) && '0' == buffer.charAt(1))) {
            this.setPosition(begin);
            throw new IllegalArgumentException("no leading zeros allowed");
        }
        return buffer.toString();
    }

    public final String readQuoted() {
        this.skipWhiteSpace();
        if (this.isEmpty() || this.read() != 34) {
            throw new IllegalArgumentException("\" expected");
        }
        StringBuffer unquoted = new StringBuffer();
        while (true) {
            if (this.isEmpty()) {
                throw new IllegalArgumentException("ending \" expected");
            }
            char c = (char)this.read();
            if (c != '\"') {
                unquoted.append(c);
                continue;
            }
            if (this.isEmpty() || this.getChar() != 34) break;
            unquoted.append((char)this.read());
        }
        return unquoted.toString();
    }

    public final int getRow() {
        return this.lineNumber + 1;
    }

    public final int getColumn() {
        return this.column + 1;
    }

    public final String getLine() {
        int max;
        int min;
        for (min = this.position - 1; min >= 0 && this.source.charAt(min) != '\n'; --min) {
        }
        for (max = this.position; max < this.source.length() && this.source.charAt(max) != '\n'; ++max) {
        }
        if (min + 1 >= max) {
            return "";
        }
        return this.source.substring(min + 1, max);
    }

    public final int getPosition() {
        return this.position;
    }

    public final SourcePosition getSourcePosition() {
        return new SourcePosition(this.getRow(), this.getColumn());
    }

    public final int getMaximumPosition() {
        return this.source.length();
    }

    public final void setPosition(int position) {
        block5: {
            block4: {
                if (position < this.source.length()) break block4;
                this.position = this.source.length();
                break block5;
            }
            if (this.position == position) break block5;
            if (position < this.position) {
                this.position = 0;
                this.lineNumber = 0;
                this.column = 0;
                for (int i = 0; i < position; ++i) {
                    this.read();
                }
            } else {
                for (int i = this.position; i < position; ++i) {
                    this.read();
                }
            }
        }
    }

    public final void setPosition(SourcePosition position) {
        this.setRow(position.getRow());
        this.setColumn(position.getColumn());
    }

    public final void addPosition(SourcePosition delta) {
        this.addRow(delta.getRow() - 1);
        this.addColumn(delta.getColumn() - 1);
    }

    public final void setRow(int row) {
        int r = row;
        if (r <= 0) {
            r = 1;
        }
        if (this.getRow() == r) {
            return;
        }
        if (this.getPosition() >= this.source.length() && this.getRow() >= r) {
            return;
        }
        if (this.getRow() > r) {
            this.position = 0;
            this.lineNumber = 0;
            this.column = 0;
        }
        int i = 0;
        while (this.getRow() < r) {
            if (-1 == this.read()) {
                return;
            }
            ++i;
        }
    }

    public final SourcePosition getPosition(int find) {
        int r = 0;
        int c = 0;
        for (int i = 0; i < this.source.length() && i < find; ++i) {
            if ('\n' == this.source.charAt(i)) {
                ++r;
                c = 0;
                continue;
            }
            ++c;
        }
        return new SourcePosition(r + 1, c + 1);
    }

    public final int getPosition(SourcePosition position) {
        int find = 0;
        int r = 0;
        while (++r < position.getRow() && -1 < (find = this.source.indexOf("\n", find))) {
        }
        if (find < 0) {
            find = this.source.length();
        }
        if ((find += position.getColumn()) > this.source.length()) {
            find = this.source.length();
        }
        return find;
    }

    public final String getSourceArea(SourceArea area) {
        return this.source.substring(this.getPosition(area.getStartPosition()), this.getPosition(area.getEndPosition()));
    }

    public final void addRow(int number) {
        this.setRow(this.getRow() + number);
    }

    public final void setColumn(int column) {
        int c = column;
        if (c <= 0) {
            c = 1;
        }
        if (this.getColumn() == c) {
            return;
        }
        if (this.getColumn() > c) {
            do {
                --this.position;
                --this.column;
            } while (this.getColumn() > c);
            return;
        }
        while (this.getChar() != 10 && this.getChar() != -1 && this.getColumn() < c) {
            this.read();
        }
    }

    public final void addColumn(int number) {
        this.setColumn(this.getColumn() + number);
    }

    public final String showLinePosition() {
        String line = this.getLine();
        StringBuffer buffer = new StringBuffer();
        int col = this.getColumn() - 1;
        if (col > 0) {
            if (col < line.length()) {
                buffer.append(line.substring(0, col));
            } else {
                buffer.append(line);
            }
        }
        buffer.append(MARKER);
        if (col < line.length()) {
            buffer.append(line.substring(col));
        }
        return buffer.toString();
    }
}

