/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.util;

import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class MenuHelper {
    private MenuHelper() {
    }

    public static boolean isQuitInOSMenu() {
        return false;
    }

    public static JMenu createMenu(String text, char mnemonic) {
        JMenu menu = new JMenu(text);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    public static JMenuItem createMenuItem(String text) {
        return new JMenuItem(text);
    }

    public static JMenuItem createMenuItem(String text, char mnemonic) {
        return new JMenuItem(text, mnemonic);
    }

    public static JMenuItem createMenuItem(String text, char mnemonic, KeyStroke key) {
        JMenuItem menuItem = new JMenuItem(text, mnemonic);
        menuItem.setAccelerator(key);
        return menuItem;
    }

    public static JMenuItem createMenuItem(String text, Icon icon) {
        return new JMenuItem(text, icon);
    }

    public static JMenuItem createMenuItem(String text, Icon icon, char mnemonic) {
        JMenuItem menuItem = new JMenuItem(text, icon);
        menuItem.setMnemonic(mnemonic);
        return menuItem;
    }

    public static JMenuItem createMenuItem(String text, Icon icon, char mnemonic, KeyStroke key) {
        JMenuItem menuItem = MenuHelper.createMenuItem(text, icon, mnemonic);
        menuItem.setAccelerator(key);
        return menuItem;
    }

    public static JRadioButtonMenuItem createRadioButtonMenuItem(String text, boolean selected) {
        return new JRadioButtonMenuItem(text, selected);
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(String text, boolean selected) {
        return new JCheckBoxMenuItem(text, selected);
    }

    public static boolean isAboutInOSMenu() {
        return false;
    }

    public static JRadioButtonMenuItem createRadioItem(final String text, boolean enabled, boolean selected) {
        JRadioButtonMenuItem item = MenuHelper.createRadioButtonMenuItem(text, selected);
        item.setEnabled(enabled);
        item.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JRadioButtonMenuItem source = (JRadioButtonMenuItem)e.getSource();
                source.setText(text);
            }
        });
        return item;
    }

    public static JCheckBoxMenuItem createCheckItem(final String text, boolean enabled, boolean selected) {
        JCheckBoxMenuItem item = MenuHelper.createCheckBoxMenuItem(text, selected);
        item.setEnabled(enabled);
        item.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
                source.setText(text);
            }
        });
        return item;
    }
}

