/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.util;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.qedeq.base.io.ResourceLoaderUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.main.GuiOptions;

public final class GuiHelper {
    private static final Class CLASS = GuiHelper.class;
    private static Color lineHighlighterBackgroundColor = new Color(232, 242, 254);
    private static Color markedAndHiglightedBackgroundColor = new Color(232, 242, 254, 128);
    private static Color errorTextBackgroundColor = new Color(180, 206, 255);
    private static Color warningTextBackgroundColor = new Color(255, 255, 190);
    private static final int DEFAULT_EMPTY_BORDER_PIXEL_X = 10;
    private static final int DEFAULT_EMPTY_BORDER_PIXEL_Y = 10;

    private GuiHelper() {
    }

    public static void configureUI(GuiOptions options) {
        UIManager.put("ClassLoader", CLASS.getClassLoader());
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        Options.setUseNarrowButtons((boolean)options.isUseNarrowButtons());
        Options.setTabIconsEnabled((boolean)options.isTabIconsEnabled());
        UIManager.put("jgoodies.popupDropShadowEnabled", options.isPopupDropShadowEnabled());
        UIManager.put("TextArea.disabledBackground", UIManager.get("TextArea.background"));
        UIManager.put("ToolTip.font", new FontUIResource("Lucida Sans Unicode", 0, UIManager.getFont("ToolTip.font").getSize()));
        LookAndFeel selectedLaf = options.getSelectedLookAndFeel();
        if (selectedLaf instanceof PlasticLookAndFeel) {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)options.getSelectedTheme());
            PlasticLookAndFeel.setTabStyle((String)options.getPlasticTabStyle());
            PlasticLookAndFeel.setHighContrastFocusColorsEnabled((boolean)options.isPlasticHighContrastFocusEnabled());
        } else if (selectedLaf.getClass() == MetalLookAndFeel.class) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        JRadioButton radio = new JRadioButton();
        radio.getUI().uninstallUI(radio);
        JCheckBox checkBox = new JCheckBox();
        checkBox.getUI().uninstallUI(checkBox);
        try {
            UIManager.setLookAndFeel(selectedLaf);
        }
        catch (Exception e) {
            Trace.trace((Class)CLASS, (String)"configureUI", (String)"Can't change L&F", (Throwable)e);
        }
    }

    public static AbstractButton createToolBarButton(String iconName, String toolTipText) {
        JButton button = new JButton(GuiHelper.readImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    public static AbstractButton createToolBarButton(String iconName, String toolTipText, ActionListener action, KeyStroke keyStroke) {
        AbstractButton button = GuiHelper.createToolBarButton(iconName, toolTipText);
        button.registerKeyboardAction(action, keyStroke, 2);
        return button;
    }

    public static AbstractButton createToolBarRadioButton(String iconName, String toolTipText) {
        JToggleButton button = new JToggleButton(GuiHelper.readImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    public static ImageIcon readImageIcon(String filename) {
        URL url = ResourceLoaderUtility.getResourceUrl((String)("images/" + filename));
        if (url == null) {
            Trace.fatal((Class)CLASS, (String)"readImageIcon", (String)("image icon not found: images/" + filename), (Throwable)new RuntimeException());
            return null;
        }
        return new ImageIcon(url);
    }

    public static Color getLineHighlighterBackgroundColor() {
        return lineHighlighterBackgroundColor;
    }

    public static Color getErrorTextBackgroundColor() {
        return errorTextBackgroundColor;
    }

    public static Color getWarningTextBackgroundColor() {
        return warningTextBackgroundColor;
    }

    public static Color getCurrentAndMarkedBackgroundColor() {
        return markedAndHiglightedBackgroundColor;
    }

    public static void paintCurrentLineBackground(Graphics g, JTextComponent c, Color col) {
        Rectangle r;
        if (c.getSelectionStart() != c.getSelectionEnd()) {
            return;
        }
        try {
            r = c.modelToView(c.getCaretPosition());
        }
        catch (BadLocationException couldNotHappen) {
            throw new RuntimeException(couldNotHappen);
        }
        g.setColor(col);
        g.fillRect(0, r.y, c.getWidth(), r.height);
    }

    public static JComponent addSpaceAndAlignRight(JPanel panel) {
        JPanel withSpace = new JPanel();
        withSpace.add(panel);
        JPanel alignRight = new JPanel();
        alignRight.setLayout(new FlowLayout(2));
        alignRight.add(withSpace);
        return alignRight;
    }

    public static int getEmptyBoderPixelsX() {
        return 10;
    }

    public static int getEmptyBorderPixelsY() {
        return 10;
    }

    public static Border getEmptyBorder() {
        return BorderFactory.createEmptyBorder(GuiHelper.getEmptyBorderPixelsY(), GuiHelper.getEmptyBoderPixelsX(), GuiHelper.getEmptyBorderPixelsY(), GuiHelper.getEmptyBoderPixelsX());
    }

    public static Border getEmptyBorderStackable() {
        return BorderFactory.createEmptyBorder(GuiHelper.getEmptyBorderPixelsY() / 2, GuiHelper.getEmptyBoderPixelsX(), GuiHelper.getEmptyBorderPixelsY() / 2, GuiHelper.getEmptyBoderPixelsX());
    }

    public static void calcColumnWidths(JTable table) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int margin = columns.getColumnMargin();
        int rowCount = data.getRowCount();
        int totalWidth = 0;
        for (int i = columns.getColumnCount() - 1; i >= 0; --i) {
            TableColumn column = columns.getColumn(i);
            int columnIndex = column.getModelIndex();
            int width = -1;
            TableCellRenderer h = column.getHeaderRenderer();
            if (h == null) {
                h = defaultHeaderRenderer;
            }
            if (h != null) {
                Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, i);
                width = c.getPreferredSize().width;
            }
            for (int row = rowCount - 1; row >= 0; --row) {
                TableCellRenderer r = table.getCellRenderer(row, i);
                Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, i);
                width = Math.max(width, c.getPreferredSize().width);
            }
            if (width >= 0) {
                column.setPreferredWidth(width + margin);
            }
            totalWidth += column.getPreferredWidth();
        }
    }

    public static JComponent addSpaceAndTitle(JPanel panel, String title) {
        JPanel withSpace = new JPanel();
        withSpace.setBorder(GuiHelper.getEmptyBorderStackable());
        withSpace.add(panel);
        withSpace.setLayout(new GridLayout(0, 1));
        JPanel withTitle = new JPanel();
        withTitle.setBorder(BorderFactory.createTitledBorder(title));
        withTitle.add(withSpace);
        withTitle.setLayout(new GridLayout(0, 1));
        return withTitle;
    }
}

