/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import org.qedeq.base.io.SourceArea;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.gui.se.control.SelectionListener;
import org.qedeq.gui.se.element.CPTextArea;
import org.qedeq.gui.se.util.CurrentLineHighlighterUtility;
import org.qedeq.gui.se.util.DocumentMarker;
import org.qedeq.gui.se.util.DocumentMarkerPainter;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public class QedeqPane
extends JPanel
implements SelectionListener {
    private static final Class CLASS = QedeqPane.class;
    private QedeqBo prop = null;
    private JTextArea qedeq = new CPTextArea(false){

        public String getToolTipText(MouseEvent e) {
            int j;
            if (QedeqPane.this.errorMarker == null || QedeqPane.this.warningMarker == null) {
                this.setToolTipText(null);
                return super.getToolTipText();
            }
            TextUI mapper = QedeqPane.this.qedeq.getUI();
            int i = mapper.viewToModel(QedeqPane.this.qedeq, e.getPoint());
            List errNos = QedeqPane.this.errorMarker.getBlockNumbersForOffset(i);
            List warningNos = QedeqPane.this.warningMarker.getBlockNumbersForOffset(i);
            if (errNos.size() == 0 && warningNos.size() == 0) {
                this.setToolTipText(null);
                return super.getToolTipText(e);
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("<html>");
            for (j = 0; j < errNos.size(); ++j) {
                if (j > 0) {
                    buffer.append("<br>");
                }
                buffer.append(QedeqPane.this.prop.getErrors().get(((Integer)errNos.get(j)).intValue()).getMessage());
            }
            for (j = 0; j < warningNos.size(); ++j) {
                if (j > 0) {
                    buffer.append("<br>");
                }
                buffer.append(QedeqPane.this.prop.getWarnings().get(((Integer)warningNos.get(j)).intValue()).getMessage());
            }
            buffer.append("</html>");
            this.setToolTipText(buffer.toString());
            return this.getToolTipText();
        }
    };
    private DocumentMarker errorMarker;
    private DocumentMarker warningMarker;

    public QedeqPane() {
        super(false);
        this.setupView();
        this.updateView();
    }

    public void setupView() {
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        vp.add(this.qedeq);
        this.setLayout(new BorderLayout(0, 0));
        this.add(scroller);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.qedeq.setEditable(false);
        this.qedeq.setToolTipText("");
        this.qedeq.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.qedeq.setLineWrap(true);
    }

    public synchronized void setModel(QedeqBo prop) {
        Trace.trace((Class)CLASS, (Object)this, (String)"setModel", (Object)prop);
        if (!EqualsUtility.equals((Object)this.prop, (Object)prop)) {
            this.prop = prop;
            Runnable setModel = new Runnable(){

                public void run() {
                    QedeqPane.this.updateView();
                }
            };
            SwingUtilities.invokeLater(setModel);
        }
    }

    public void setLineWrap(boolean wrap) {
        this.qedeq.setLineWrap(wrap);
    }

    public boolean getLineWrap() {
        return this.qedeq.getLineWrap();
    }

    public synchronized void updateView() {
        Trace.begin((Class)CLASS, (Object)this, (String)"updateView");
        if (this.prop != null) {
            try {
                this.qedeq.setText(KernelContext.getInstance().getSource(this.prop.getModuleAddress()));
                CurrentLineHighlighterUtility.install(this.qedeq);
                this.qedeq.setLineWrap(this.getLineWrap());
                if (this.prop.getModuleAddress().isFileAddress()) {
                    this.qedeq.setEditable(true);
                } else {
                    this.qedeq.setEditable(false);
                }
                this.qedeq.setBackground(UIManager.getColor("TextArea.background"));
                this.qedeq.setCaretPosition(0);
                this.qedeq.getCaret().setSelectionVisible(true);
                this.warningMarker = new DocumentMarker(this.qedeq, new DocumentMarkerPainter(GuiHelper.getWarningTextBackgroundColor()));
                SourceFileExceptionList pw = this.prop.getWarnings();
                if (pw != null) {
                    for (int i = 0; i < pw.size(); ++i) {
                        if (pw.get(i).getSourceArea() != null) {
                            try {
                                SourceArea sa = pw.get(i).getSourceArea();
                                if (sa == null) continue;
                                int from = sa.getStartPosition().getRow() - 1;
                                int to = sa.getEndPosition().getRow() - 1;
                                this.warningMarker.addMarkedBlock(from, sa.getStartPosition().getColumn() - 1, to, sa.getEndPosition().getColumn() - 1);
                            }
                            catch (BadLocationException e) {
                                Trace.fatal((Class)CLASS, (Object)this, (String)"updateView", (String)"Programming error?", (Throwable)e);
                            }
                            continue;
                        }
                        this.warningMarker.addEmptyBlock();
                    }
                }
                this.errorMarker = new DocumentMarker(this.qedeq, new DocumentMarkerPainter(GuiHelper.getErrorTextBackgroundColor()));
                SourceFileExceptionList pe = this.prop.getErrors();
                if (pe != null) {
                    for (int i = 0; i < pe.size(); ++i) {
                        if (pe.get(i).getSourceArea() != null) {
                            try {
                                SourceArea sa = pe.get(i).getSourceArea();
                                if (sa == null) continue;
                                int from = sa.getStartPosition().getRow() - 1;
                                int to = sa.getEndPosition().getRow() - 1;
                                this.errorMarker.addMarkedBlock(from, sa.getStartPosition().getColumn() - 1, to, sa.getEndPosition().getColumn() - 1);
                            }
                            catch (BadLocationException e) {
                                Trace.fatal((Class)CLASS, (Object)this, (String)"updateView", (String)"Programming error?", (Throwable)e);
                            }
                            continue;
                        }
                        this.errorMarker.addEmptyBlock();
                    }
                }
                Trace.trace((Class)CLASS, (Object)this, (String)"updateView", (Object)"Text updated");
            }
            catch (IOException ioException) {
                this.qedeq.setEditable(false);
                this.qedeq.setText("");
                Trace.trace((Class)CLASS, (Object)this, (String)"updateView", (Throwable)ioException);
            }
        } else {
            this.errorMarker = null;
            this.warningMarker = null;
            CurrentLineHighlighterUtility.uninstall(this.qedeq);
            this.qedeq.setEditable(false);
            this.qedeq.setText("");
            Trace.end((Class)CLASS, (Object)this, (String)"updateView");
        }
        this.repaint();
    }

    public final String getEditedQedeq() {
        if (this.qedeq.isEditable()) {
            return this.qedeq.getText();
        }
        throw new IllegalStateException("no editable QEDEQ text");
    }

    public final boolean isContentChanged() {
        return !this.qedeq.isEditable();
    }

    public synchronized void selectError(int error, SourceFileException sf) {
        if (this.errorMarker != null) {
            this.requestFocus();
            this.qedeq.requestFocus();
            this.qedeq.setCaretPosition(this.errorMarker.getLandmarkOffsetForBlock(error));
        } else {
            Trace.paramInfo((Class)CLASS, (String)"selectError", (String)"errorMarker", (Object)"null");
        }
    }

    public synchronized void selectWarning(int warning, SourceFileException sf) {
        int block = warning;
        if (this.warningMarker != null) {
            this.requestFocus();
            this.qedeq.requestFocus();
            this.qedeq.setCaretPosition(this.warningMarker.getLandmarkOffsetForBlock(block));
        } else {
            Trace.paramInfo((Class)CLASS, (String)"selectWarning", (String)"warningMarker", (Object)"null");
        }
    }
}

