/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.base.utility.YodaUtility;
import org.qedeq.gui.se.pane.ProcessListModel;
import org.qedeq.gui.se.pane.TextPaneWindow;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.common.ServiceProcess;

public class ProcessListPane
extends JPanel {
    private static final Class CLASS = ProcessListPane.class;
    private int selectedLine = -1;
    private boolean automaticRefresh = true;
    private ProcessListModel model = new ProcessListModel();
    private JTable list = new JTable(this.model){

        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            try {
                ServiceProcess process = ProcessListPane.this.model.getServiceProcess(row);
                switch (col) {
                    case 0: {
                        if (process.isBlocked()) {
                            tip = "Process is waiting";
                            break;
                        }
                        if (process.isRunning()) {
                            tip = "Process is running";
                            break;
                        }
                        if (process.wasFailure()) {
                            tip = "Process was stopped.";
                            break;
                        }
                        if (process.wasSuccess()) {
                            tip = "Process has finished";
                        }
                        break;
                    }
                    case 1: {
                        tip = process.getService().getPluginDescription();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        tip = process.getQedeq().getUrl();
                        break;
                    }
                    case 7: {
                        tip = "<html>" + StringUtility.replace((String)process.getExecutionActionDescription(), (String)"\n", (String)"<br>") + "</html>";
                        break;
                    }
                    case 8: {
                        tip = process.getParameterString() + "\n";
                        break;
                    }
                    default: {
                        tip = "";
                        break;
                    }
                }
            }
            catch (RuntimeException ex) {
                return super.getToolTipText(e);
            }
            return tip;
        }
    };
    private final SimpleAttributeSet errorAttrs = new SimpleAttributeSet();
    private JScrollPane scrollPane;

    public ProcessListPane() {
        super(false);
        this.setupView();
    }

    private void selectLine() {
        Trace.param((Class)CLASS, (Object)this, (String)"selectLine", (String)"selectedLine", (int)this.selectedLine);
    }

    private final void setupView() {
        this.list.setFont(new Font("Lucida Sans Unicode", 0, this.list.getFont().getSize()));
        FormLayout layout = new FormLayout("min:grow", "0:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setBorder(BorderFactory.createEmptyBorder());
        builder.setRowGroupingEnabled(true);
        CellConstraints cc = new CellConstraints();
        builder.appendRow(new RowSpec("0:grow"));
        this.list.setDefaultRenderer(Icon.class, new IconCellRenderer());
        ListSelectionModel rowSM = this.list.getSelectionModel();
        rowSM.setSelectionMode(0);
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ProcessListPane.this.selectedLine = ProcessListPane.this.list.getSelectionModel().getLeadSelectionIndex();
                Trace.param((Class)CLASS, (Object)this, (String)"setupView$valueChanged", (String)"selectedLine", (int)ProcessListPane.this.selectedLine);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"setupView$vmouseClicked", (Object)"doubleClick");
                }
                ProcessListPane.this.selectLine();
            }
        });
        this.list.getActionMap().put("selectNextRowCell", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                Trace.param((Class)CLASS, (Object)this, (String)"setupView$actionPerformed", (String)"event", (Object)event);
                ProcessListPane.this.selectLine();
            }
        });
        this.scrollPane = new JScrollPane(this.list);
        builder.add((Component)this.scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 1, 2, "fill, fill"));
        StyleConstants.setForeground(this.errorAttrs, Color.red);
        this.scrollPane.getViewport().setBackground(Color.white);
        StyleConstants.setBackground(this.errorAttrs, Color.white);
        JTableHeader header = this.list.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(2);
        header.setPreferredSize(new Dimension(this.list.getTableHeader().getWidth(), (int)(1.1 * (double)this.getFontMetrics(this.getFont()).getHeight())));
        this.changeHeaderWidth();
        Thread refresh = new Thread(){

            public void run() {
                while (ProcessListPane.this.automaticRefresh) {
                    ProcessListPane.this.updateView();
                    IoUtility.sleep((int)5000);
                }
            }
        };
        refresh.setDaemon(true);
        refresh.start();
    }

    private void changeHeaderWidth() {
        TableColumnModel columnModel = this.list.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(24);
        columnModel.getColumn(0).setMinWidth(24);
        columnModel.getColumn(1).setPreferredWidth(200);
        columnModel.getColumn(1).setMinWidth(150);
        columnModel.getColumn(2).setPreferredWidth(200);
        columnModel.getColumn(2).setMinWidth(150);
        columnModel.getColumn(3).setPreferredWidth(100);
        columnModel.getColumn(3).setMinWidth(100);
        columnModel.getColumn(4).setPreferredWidth(100);
        columnModel.getColumn(4).setMinWidth(100);
        columnModel.getColumn(5).setPreferredWidth(100);
        columnModel.getColumn(5).setMinWidth(100);
        columnModel.getColumn(6).setPreferredWidth(60);
        columnModel.getColumn(6).setMinWidth(60);
        columnModel.getColumn(7).setPreferredWidth(2000);
        columnModel.getColumn(7).setMinWidth(100);
        columnModel.getColumn(8).setPreferredWidth(200);
        columnModel.getColumn(8).setMinWidth(100);
    }

    public synchronized void updateView() {
        String method = "updateView";
        Trace.begin((Class)CLASS, (Object)this, (String)"updateView");
        ((AbstractTableModel)this.list.getModel()).fireTableDataChanged();
        this.list.invalidate();
        this.list.repaint();
        this.repaint();
    }

    public void refreshStates() {
        Runnable stateChanged = new Runnable(){

            public void run() {
                ProcessListPane.this.updateView();
            }
        };
        SwingUtilities.invokeLater(stateChanged);
    }

    public void stopSelected() {
        ServiceProcess process;
        if (this.selectedLine >= 0 && (process = this.model.getServiceProcess(this.selectedLine)) != null && process.isRunning()) {
            process.interrupt();
        }
    }

    public void stackTraceSelected() {
        if (this.selectedLine >= 0) {
            StringBuffer result = new StringBuffer();
            ServiceProcess process = this.model.getServiceProcess(this.selectedLine);
            if (process != null && process.isRunning() && YodaUtility.existsMethod((Class)Thread.class, (String)"getStackTrace", (Class[])new Class[0])) {
                StackTraceElement[] trace = new StackTraceElement[]{};
                try {
                    trace = (StackTraceElement[])YodaUtility.executeMethod((Object)process.getThread(), (String)"getStackTrace", (Class[])new Class[0], (Object[])new Object[0]);
                }
                catch (NoSuchMethodException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
                for (int i = 0; i < trace.length; ++i) {
                    System.out.println(trace[i]);
                    result.append(trace[i]);
                    result.append("\n");
                }
                new TextPaneWindow("Stacktrace", GuiHelper.readImageIcon("tango/16x16/devices/video-display.png"), result.toString()).setVisible(true);
            }
        }
    }

    private static class IconCellRenderer
    extends DefaultTableCellRenderer {
        private IconCellRenderer() {
        }

        protected void setValue(Object value) {
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                super.setValue(null);
            } else {
                this.setIcon(null);
                super.setValue(value);
            }
        }
    }
}

