/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.KernelContext;

public class PreferencesDialog
extends JDialog {
    private static final Class CLASS = PreferencesDialog.class;
    private JTextField connectionTimeoutTextField;
    private JTextField readTimeoutTextField;
    private JCheckBox automaticLogScrollCB;
    private JCheckBox autoReloadLastSessionCheckedCB;
    private JComboBox iconSizeCB;
    private JComboBox lookAndFeelCB;
    private JCheckBox autoStartHtmlBrowserCB;
    private JCheckBox traceOnCB;
    private JTextArea moduleBufferTextArea;
    private JTextArea generationPathTextArea;
    private JTextArea localModulesPathTextArea;
    private JTextField httpProxyHostTextField;
    private JTextField httpProxyPortTextField;
    private JTextField httpNonProxyHostsTextField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreferencesDialog(JFrame parent) {
        super((Frame)parent, "Preferences");
        String method = "Constructor";
        Trace.begin((Class)CLASS, (Object)this, (String)"Constructor");
        try {
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            this.setupView();
            this.updateView();
        }
        catch (Throwable e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"Initalization of PreferencesDialog failed.", (String)"Constructor", (Throwable)e);
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"Constructor");
        }
    }

    private JComponent buildTimeoutPanel() {
        FormLayout layout = new FormLayout("right:pref, 5dlu, fill:50dlu");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        builder.append("Connection Timeout");
        this.connectionTimeoutTextField = this.createTextField("" + QedeqGuiConfig.getInstance().getConnectTimeout(), true);
        this.connectionTimeoutTextField.setToolTipText("Sets a specified timeout value, in milliseconds, to be used when opening a communications link a remote QEDEQ module. If the timeout expires before the connection can be established, an error occurs. A timeout of zero is interpreted as an infinite timeout.");
        builder.append((Component)this.connectionTimeoutTextField);
        builder.append("Read Timeout");
        this.readTimeoutTextField = this.createTextField("" + QedeqGuiConfig.getInstance().getReadTimeout(), true);
        this.readTimeoutTextField.setToolTipText("Sets the read timeout to a specified timeout, in milliseconds. A non-zero value specifies the timeout when reading from Input stream when a connection is established to a resource. If the timeout expires before there is data available for read, an error occurs. A timeout of zero is interpreted as an infinite timeout.");
        builder.append((Component)this.readTimeoutTextField);
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), "Timeouts");
    }

    private JComponent buildProxyPanel() {
        if (IoUtility.isWebStarted()) {
            JPanel panel = new JPanel();
            JTextArea label = new JTextArea("This application is webstarted. For changing the proxy settings see for example \"Sun Java Plugin Control Panel / General / Network Settings\".");
            label.setWrapStyleWord(true);
            label.setLineWrap(true);
            label.setEditable(false);
            panel.add(label);
            panel.setLayout(new GridLayout(0, 1));
            JPanel withSpace = new JPanel();
            withSpace.add(panel);
            withSpace.setLayout(new GridLayout(0, 1));
            JPanel withTitle = new JPanel();
            withTitle.setBorder(BorderFactory.createTitledBorder("Proxy Settings"));
            withTitle.add(withSpace);
            withTitle.setLayout(new GridLayout(0, 1));
            return withTitle;
        }
        FormLayout layout = new FormLayout("left:pref, 5dlu, fill:pref:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        builder.append("HTTP proxy host");
        this.httpProxyHostTextField = this.createTextField(QedeqGuiConfig.getInstance().getHttpProxyHost(), true);
        this.httpProxyHostTextField.setToolTipText("Proxy server for the http protocol.");
        builder.append((Component)this.httpProxyHostTextField);
        builder.append("HTTP proxy port");
        this.httpProxyPortTextField = this.createTextField(QedeqGuiConfig.getInstance().getHttpProxyPort(), true);
        this.httpProxyPortTextField.setToolTipText("Proxy server port for the http protocol.");
        builder.append((Component)this.httpProxyPortTextField);
        builder.append("HTTP non proxy hosts");
        this.httpNonProxyHostsTextField = this.createTextField(StringUtility.replace((String)QedeqGuiConfig.getInstance().getHttpNonProxyHosts(), (String)"|", (String)","), true);
        builder.append((Component)this.httpNonProxyHostsTextField);
        this.httpNonProxyHostsTextField.setToolTipText("Lists the hosts which should be connected to directly and not through the proxy server. The value can be a comma separated list of hosts, and in addition a wildcard character (*) can be used for matching. For example: *.foo.com,localhost");
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), "Proxy Settings");
    }

    private JComponent buildPathsPanel() {
        FormLayout layout = new FormLayout("left:pref, fill:5dlu:grow, right:pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        builder.append("Path for QEDEQ module file buffer");
        this.moduleBufferTextArea = new JTextArea(QedeqGuiConfig.getInstance().getBufferDirectory().getPath());
        this.moduleBufferTextArea.setEditable(false);
        this.moduleBufferTextArea.setLineWrap(false);
        JButton chooseBufferLocation = new JButton("Choose");
        builder.append((Component)chooseBufferLocation);
        builder.append(this.wrapWithScrollPane(this.moduleBufferTextArea), 3);
        chooseBufferLocation.setEnabled(true);
        chooseBufferLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QedeqGuiConfig.getInstance().getBufferDirectory().mkdirs();
                    JFileChooser chooser = new JFileChooser(QedeqGuiConfig.getInstance().getBufferDirectory());
                    FileFilter filter = new FileFilter(){

                        public boolean accept(File f) {
                            return f.isDirectory();
                        }

                        public String getDescription() {
                            return "Directory";
                        }
                    };
                    chooser.setFileFilter(filter);
                    chooser.setFileSelectionMode(1);
                    int returnVal = chooser.showOpenDialog(PreferencesDialog.this);
                    if (returnVal == 0) {
                        PreferencesDialog.this.moduleBufferTextArea.setText(chooser.getSelectedFile().getPath());
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(PreferencesDialog.this, e.getMessage(), "Alert", 0);
                }
            }
        });
        builder.append("Path for generated files");
        this.generationPathTextArea = new JTextArea(QedeqGuiConfig.getInstance().getGenerationDirectory().getPath());
        this.generationPathTextArea.setEditable(false);
        JButton chooseGenerationLocation = new JButton("Choose");
        builder.append((Component)chooseGenerationLocation);
        builder.append(this.wrapWithScrollPane(this.generationPathTextArea), 3);
        chooseGenerationLocation.setEnabled(true);
        chooseGenerationLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QedeqGuiConfig.getInstance().getGenerationDirectory().mkdirs();
                    JFileChooser chooser = new JFileChooser(QedeqGuiConfig.getInstance().getGenerationDirectory());
                    FileFilter filter = new FileFilter(){

                        public boolean accept(File f) {
                            return f.isDirectory();
                        }

                        public String getDescription() {
                            return "Directory";
                        }
                    };
                    chooser.setFileFilter(filter);
                    chooser.setFileSelectionMode(1);
                    int returnVal = chooser.showOpenDialog(PreferencesDialog.this);
                    if (returnVal == 0) {
                        PreferencesDialog.this.generationPathTextArea.setText(chooser.getSelectedFile().getPath());
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(PreferencesDialog.this, e.getMessage(), "Alert", 0);
                }
            }
        });
        builder.append("Path for newly created module files");
        this.localModulesPathTextArea = new JTextArea(QedeqGuiConfig.getInstance().getLocalModulesDirectory().getPath());
        this.localModulesPathTextArea.setEditable(false);
        JButton chooselocalModulesLocation = new JButton("Choose");
        builder.append((Component)chooselocalModulesLocation);
        builder.append(this.wrapWithScrollPane(this.localModulesPathTextArea), 3);
        chooselocalModulesLocation.setEnabled(true);
        chooselocalModulesLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QedeqGuiConfig.getInstance().getLocalModulesDirectory().mkdirs();
                    JFileChooser chooser = new JFileChooser(QedeqGuiConfig.getInstance().getLocalModulesDirectory());
                    FileFilter filter = new FileFilter(){

                        public boolean accept(File f) {
                            return f.isDirectory();
                        }

                        public String getDescription() {
                            return "Directory";
                        }
                    };
                    chooser.setFileFilter(filter);
                    chooser.setFileSelectionMode(1);
                    int returnVal = chooser.showOpenDialog(PreferencesDialog.this);
                    if (returnVal == 0) {
                        PreferencesDialog.this.localModulesPathTextArea.setText(chooser.getSelectedFile().getPath());
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(PreferencesDialog.this, e.getMessage(), "Alert", 0);
                }
            }
        });
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), "Paths");
    }

    private JComponent buildBinaryOptionPanel() {
        FormLayout layout = new FormLayout("left:pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        this.autoReloadLastSessionCheckedCB = new JCheckBox(" Auto loading of in last session successfully checked modules", QedeqGuiConfig.getInstance().isAutoReloadLastSessionChecked());
        builder.append((Component)this.autoReloadLastSessionCheckedCB);
        this.automaticLogScrollCB = new JCheckBox(" Automatic Scroll of Log Window", QedeqGuiConfig.getInstance().isAutomaticLogScroll());
        builder.append((Component)this.automaticLogScrollCB);
        this.autoStartHtmlBrowserCB = new JCheckBox(" Auto start web browser after HTML generation", QedeqGuiConfig.getInstance().isAutoStartHtmlBrowser());
        builder.append((Component)this.autoStartHtmlBrowserCB);
        this.traceOnCB = new JCheckBox(" Enable trace output generation. Must be on to configure detailed log.", QedeqGuiConfig.getInstance().isTraceOn());
        builder.append((Component)this.traceOnCB);
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), "Miscellaneous Switches");
    }

    private JComponent buildSizeOptionPanel() {
        FormLayout layout = new FormLayout("right:pref, 5dlu, fill:50dlu");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        this.iconSizeCB = new JComboBox<String>(new String[]{"16x16", "22x22", "32x32"});
        this.iconSizeCB.setSelectedItem(QedeqGuiConfig.getInstance().getIconSize());
        builder.append("Icon size", (Component)this.iconSizeCB);
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), "Sizes");
    }

    private JComponent buildLookAndFeelPanel() {
        FormLayout layout = new FormLayout("right:pref, 5dlu, fill:150dlu");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        this.lookAndFeelCB = new JComboBox<String>(new String[]{"PlasticXP", "Plastic", "Plastic3D", "Windows", "Metal"});
        this.lookAndFeelCB.setEditable(true);
        this.lookAndFeelCB.setSelectedItem(QedeqGuiConfig.getInstance().getLookAndFeel());
        builder.append("Look & Feel", (Component)this.lookAndFeelCB);
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), "Look and Feel");
    }

    public final void setupView() {
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel allOptions = new JPanel();
        allOptions.setBorder(GuiHelper.getEmptyBorder());
        allOptions.setLayout(new BoxLayout(allOptions, 1));
        allOptions.add(this.buildBinaryOptionPanel());
        allOptions.add(Box.createVerticalStrut(GuiHelper.getEmptyBorderPixelsY()));
        allOptions.add(this.buildPathsPanel());
        allOptions.add(Box.createVerticalStrut(GuiHelper.getEmptyBorderPixelsY()));
        allOptions.add(this.buildTimeoutPanel());
        JComponent proxyPanel = this.buildProxyPanel();
        allOptions.add(Box.createVerticalStrut(GuiHelper.getEmptyBorderPixelsY()));
        allOptions.add(this.buildProxyPanel());
        JPanel graphicOptions = new JPanel();
        graphicOptions.setBorder(GuiHelper.getEmptyBorder());
        graphicOptions.setLayout(new BoxLayout(graphicOptions, 1));
        graphicOptions.add(new JLabel("Most options require a restart of the application!"));
        graphicOptions.add(this.buildLookAndFeelPanel());
        graphicOptions.add(Box.createVerticalStrut(GuiHelper.getEmptyBorderPixelsY()));
        graphicOptions.add(this.buildSizeOptionPanel());
        graphicOptions.add(Box.createVerticalGlue());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setOpaque(false);
        tabbedPane.addTab("Main Options", allOptions);
        tabbedPane.addTab("Gui Options", graphicOptions);
        content.add(tabbedPane);
        content.add(GuiHelper.addSpaceAndAlignRight(this.createButtonPanel()));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2, this.getWidth(), this.getHeight() + (IoUtility.isWebStarted() ? proxyPanel.getHeight() + 20 : 0));
    }

    private JPanel createButtonPanel() {
        ButtonBarBuilder bbuilder = ButtonBarBuilder.createLeftToRightBuilder();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.save();
                PreferencesDialog.this.dispose();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.dispose();
            }
        });
        bbuilder.addGriddedButtons(new JButton[]{cancel, ok});
        JPanel buttons = bbuilder.getPanel();
        return buttons;
    }

    public void updateView() {
        this.invalidate();
        this.repaint();
    }

    private JTextField createTextField(String selectedText, boolean editable) {
        JTextField combo = new JTextField(selectedText);
        combo.setEditable(editable);
        return combo;
    }

    private Component wrapWithScrollPane(Component c) {
        return new JScrollPane(c, 21, 31);
    }

    boolean changed() {
        boolean result = false;
        result = result || EqualsUtility.equals((Object)this.moduleBufferTextArea.getText(), (Object)QedeqGuiConfig.getInstance().getBufferDirectory());
        result = result || EqualsUtility.equals((Object)this.generationPathTextArea.getText(), (Object)QedeqGuiConfig.getInstance().getGenerationDirectory());
        result = result || EqualsUtility.equals((Object)this.localModulesPathTextArea.getText(), (Object)QedeqGuiConfig.getInstance().getLocalModulesDirectory());
        result = result || this.automaticLogScrollCB.isSelected() == QedeqGuiConfig.getInstance().isAutomaticLogScroll();
        result = result || this.autoReloadLastSessionCheckedCB.isSelected() == QedeqGuiConfig.getInstance().isAutoReloadLastSessionChecked();
        result = result || this.autoStartHtmlBrowserCB.isSelected() == QedeqGuiConfig.getInstance().isAutoStartHtmlBrowser();
        result = result || this.traceOnCB.isSelected() == QedeqGuiConfig.getInstance().isTraceOn();
        result = result || EqualsUtility.equals((Object)this.iconSizeCB.getSelectedItem(), (Object)QedeqGuiConfig.getInstance().getIconSize());
        boolean bl = result = result || EqualsUtility.equals((Object)this.lookAndFeelCB.getSelectedItem(), (Object)QedeqGuiConfig.getInstance().getLookAndFeel());
        if (KernelContext.getInstance().isSetConnectionTimeOutSupported()) {
            boolean bl2 = result = result || EqualsUtility.equals((Object)this.connectionTimeoutTextField.getText(), (Object)("" + QedeqGuiConfig.getInstance().getConnectTimeout()));
        }
        if (KernelContext.getInstance().isSetReadTimeoutSupported()) {
            boolean bl3 = result = result || EqualsUtility.equals((Object)this.readTimeoutTextField.getText(), (Object)("" + QedeqGuiConfig.getInstance().getReadTimeout()));
        }
        if (!IoUtility.isWebStarted()) {
            result = result || EqualsUtility.equals((Object)this.httpProxyHostTextField.getText(), (Object)QedeqGuiConfig.getInstance().getHttpProxyHost());
            result = result || EqualsUtility.equals((Object)this.httpProxyPortTextField.getText(), (Object)QedeqGuiConfig.getInstance().getHttpProxyPort());
            result = result || EqualsUtility.equals((Object)this.httpNonProxyHostsTextField.getText(), (Object)QedeqGuiConfig.getInstance().getHttpNonProxyHosts());
        }
        return result;
    }

    void save() {
        if (this.changed()) {
            try {
                QedeqGuiConfig.getInstance().setBufferDirectory(new File(this.moduleBufferTextArea.getText()));
                QedeqGuiConfig.getInstance().setGenerationDirectory(new File(this.generationPathTextArea.getText()));
                QedeqGuiConfig.getInstance().setLocalModulesDirectory(new File(this.localModulesPathTextArea.getText()));
                QedeqGuiConfig.getInstance().setAutomaticLogScroll(this.automaticLogScrollCB.isSelected());
                QedeqGuiConfig.getInstance().setAutoReloadLastSessionChecked(this.autoReloadLastSessionCheckedCB.isSelected());
                QedeqGuiConfig.getInstance().setAutoStartHtmlBrowser(this.autoStartHtmlBrowserCB.isSelected());
                QedeqGuiConfig.getInstance().setTraceOn(this.traceOnCB.isSelected());
                Trace.setTraceOn((boolean)this.traceOnCB.isSelected());
                if (KernelContext.getInstance().isSetConnectionTimeOutSupported()) {
                    QedeqGuiConfig.getInstance().setConnectionTimeout(Integer.parseInt(this.connectionTimeoutTextField.getText()));
                }
                if (KernelContext.getInstance().isSetReadTimeoutSupported()) {
                    QedeqGuiConfig.getInstance().setReadTimeout(Integer.parseInt(this.readTimeoutTextField.getText()));
                }
                if (!IoUtility.isWebStarted()) {
                    QedeqGuiConfig.getInstance().setHttpProxyHost(this.httpProxyHostTextField.getText().trim());
                    QedeqGuiConfig.getInstance().setHttpProxyPort(this.httpProxyPortTextField.getText().trim());
                    StringBuffer httpNonProxyHosts = new StringBuffer(this.httpNonProxyHostsTextField.getText().trim());
                    StringUtility.replace((StringBuffer)httpNonProxyHosts, (String)" ", (String)"|");
                    StringUtility.replace((StringBuffer)httpNonProxyHosts, (String)"\t", (String)"|");
                    StringUtility.replace((StringBuffer)httpNonProxyHosts, (String)"\r", (String)"|");
                    StringUtility.replace((StringBuffer)httpNonProxyHosts, (String)",", (String)"|");
                    StringUtility.replace((StringBuffer)httpNonProxyHosts, (String)";", (String)"|");
                    StringUtility.replace((StringBuffer)httpNonProxyHosts, (String)"||", (String)"|");
                    QedeqGuiConfig.getInstance().setHttpNonProxyHosts(httpNonProxyHosts.toString());
                }
                QedeqGuiConfig.getInstance().setIconSize(String.valueOf(this.iconSizeCB.getSelectedItem()));
                QedeqGuiConfig.getInstance().setLookAndFeel(String.valueOf(this.lookAndFeelCB.getSelectedItem()));
            }
            catch (RuntimeException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            }
            try {
                QedeqGuiConfig.getInstance().store();
            }
            catch (IOException e) {
                Trace.fatal((Class)CLASS, (Object)this, (String)"save", (String)"couldn't save preferences", (Throwable)e);
                JOptionPane.showMessageDialog(this, "Couldn't save preferences", "Error", 0);
            }
        }
    }
}

