/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.logic.model.FourDynamicModel;
import org.qedeq.kernel.bo.logic.model.SixDynamicModel;
import org.qedeq.kernel.bo.logic.model.ThreeDynamicModel;
import org.qedeq.kernel.bo.logic.model.UnaryDynamicModel;
import org.qedeq.kernel.bo.service.heuristic.DynamicHeuristicCheckerPlugin;
import org.qedeq.kernel.bo.service.latex.Qedeq2LatexPlugin;
import org.qedeq.kernel.bo.service.unicode.Qedeq2UnicodeTextPlugin;
import org.qedeq.kernel.bo.service.unicode.Qedeq2Utf8Plugin;
import org.qedeq.kernel.se.common.Plugin;

public class PluginPreferencesDialog
extends JDialog {
    private static final Class CLASS = PluginPreferencesDialog.class;
    private JTextField qedeq2Utf8ShowLanguageTF;
    private JCheckBox qedeq2Utf8ShowInfoCB;
    private JTextField qedeq2Utf8ShowMaximumColumnTF;
    private JCheckBox qedeq2LatexInfoCB;
    private JCheckBox qedeq2Utf8InfoCB;
    private JTextField qedeq2Utf8MaximumColumnTF;
    private final Qedeq2LatexPlugin qedeq2latex;
    private final Qedeq2Utf8Plugin qedeq2utf8;
    private final Qedeq2UnicodeTextPlugin qedeq2utf8Show;
    private DynamicHeuristicCheckerPlugin dynamicHeuristicChecker;
    private String dynamicHeuristicCheckerModel = "";

    public PluginPreferencesDialog(JFrame parent) {
        super((Frame)parent, "Plugin Preferences");
        String method = "Constructor";
        Trace.begin((Class)CLASS, (Object)this, (String)"Constructor");
        try {
            this.qedeq2latex = new Qedeq2LatexPlugin();
            this.qedeq2utf8 = new Qedeq2Utf8Plugin();
            this.qedeq2utf8Show = new Qedeq2UnicodeTextPlugin();
            this.dynamicHeuristicChecker = new DynamicHeuristicCheckerPlugin();
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            this.setupView();
            this.updateView();
        }
        catch (RuntimeException e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"Initalization of PreferencesDialog failed.", (String)"Constructor", (Throwable)e);
            throw e;
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"Constructor");
        }
    }

    public final void setupView() {
        JPanel content = new JPanel(new BorderLayout());
        this.getContentPane().add(content);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setOpaque(false);
        tabbedPane.addTab(this.qedeq2utf8Show.getPluginActionName(), this.qedeq2Utf8ShowConfig((Plugin)this.qedeq2utf8Show));
        tabbedPane.addTab(this.qedeq2latex.getPluginActionName(), this.qedeq2LatexConfig((Plugin)this.qedeq2latex));
        tabbedPane.addTab(this.qedeq2utf8.getPluginActionName(), this.qedeq2Utf8Config((Plugin)this.qedeq2utf8));
        tabbedPane.addTab(this.dynamicHeuristicChecker.getPluginActionName(), this.dynamicHeuristicCheckerConfig((Plugin)this.dynamicHeuristicChecker));
        tabbedPane.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 10, 10), tabbedPane.getBorder()));
        content.add((Component)tabbedPane, "Center");
        content.add((Component)GuiHelper.addSpaceAndAlignRight(this.buildButtonPanel()), "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = this.getWidth();
        if (2 * width < screenSize.width) {
            width = 2 * width;
        }
        this.setBounds((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2, width, this.getHeight());
    }

    private JComponent qedeq2LatexConfig(Plugin plugin) {
        FormLayout layout = new FormLayout("left:pref, 5dlu, fill:pref:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        this.qedeq2LatexInfoCB = new JCheckBox(" Also write reference labels (makes it easier for authors)", QedeqGuiConfig.getInstance().getPluginKeyValue(plugin, "info", true));
        builder.append((Component)this.qedeq2LatexInfoCB);
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), plugin.getPluginDescription());
    }

    private JComponent qedeq2Utf8Config(Plugin plugin) {
        FormLayout layout = new FormLayout("left:pref, 5dlu, fill:50dlu, fill:pref:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        this.qedeq2Utf8InfoCB = new JCheckBox(" Also write reference labels (makes it easier for authors)", QedeqGuiConfig.getInstance().getPluginKeyValue(plugin, "info", true));
        builder.append((Component)this.qedeq2Utf8InfoCB, 4);
        builder.nextLine();
        builder.append("Maximum row length");
        this.qedeq2Utf8MaximumColumnTF = new JTextField(QedeqGuiConfig.getInstance().getPluginKeyValue(plugin, "maximumColumn", "80"));
        this.qedeq2Utf8MaximumColumnTF.setToolTipText("After this character number the line is broken.0 means no break at all.");
        builder.append((Component)this.qedeq2Utf8MaximumColumnTF);
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), plugin.getPluginDescription());
    }

    private JComponent qedeq2Utf8ShowConfig(Plugin plugin) {
        FormLayout layout = new FormLayout("left:pref, 5dlu, fill:50dlu, fill:pref:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        builder.append("Default language");
        this.qedeq2Utf8ShowLanguageTF = new JTextField(QedeqGuiConfig.getInstance().getPluginKeyValue(plugin, "language", "en"));
        this.qedeq2Utf8ShowLanguageTF.setToolTipText("Default language for showing module contents.");
        builder.append((Component)this.qedeq2Utf8ShowLanguageTF);
        builder.nextLine();
        this.qedeq2Utf8ShowInfoCB = new JCheckBox(" Also write reference labels (makes it easier for authors)", QedeqGuiConfig.getInstance().getPluginKeyValue(plugin, "info", true));
        builder.append((Component)this.qedeq2Utf8ShowInfoCB, 4);
        builder.nextLine();
        builder.append("Maximum row length");
        this.qedeq2Utf8ShowMaximumColumnTF = new JTextField(QedeqGuiConfig.getInstance().getPluginKeyValue(plugin, "maximumColumn", "80"));
        this.qedeq2Utf8ShowMaximumColumnTF.setToolTipText("After this character number the line is broken.0 means no break at all.");
        builder.append((Component)this.qedeq2Utf8ShowMaximumColumnTF);
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), plugin.getPluginDescription());
    }

    private JComponent dynamicHeuristicCheckerConfig(Plugin plugin) {
        FormLayout layout = new FormLayout("left:pref, 5dlu, fill:pref:grow", "top:pref:grow, top:pref:grow, top:pref:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        ThreeDynamicModel modelThree = new ThreeDynamicModel();
        FourDynamicModel modelFour = new FourDynamicModel();
        SixDynamicModel modelSix = new SixDynamicModel();
        ButtonGroup dynamicHeuristicCheckerModelBG = new ButtonGroup();
        UnaryDynamicModel modelOne = new UnaryDynamicModel();
        this.dynamicHeuristicCheckerModel = QedeqGuiConfig.getInstance().getPluginKeyValue(plugin, "model", modelOne.getClass().getName());
        ActionListener modelSelectionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginPreferencesDialog.this.dynamicHeuristicCheckerModel = e.getActionCommand();
            }
        };
        JRadioButton dynamicHeuristicCheckerOneModelRB = new JRadioButton("One");
        if (this.dynamicHeuristicCheckerModel.equals(modelOne.getClass().getName())) {
            dynamicHeuristicCheckerOneModelRB.setSelected(true);
        }
        dynamicHeuristicCheckerOneModelRB.setActionCommand(modelOne.getClass().getName());
        dynamicHeuristicCheckerOneModelRB.addActionListener(modelSelectionListener);
        dynamicHeuristicCheckerModelBG.add(dynamicHeuristicCheckerOneModelRB);
        builder.append((Component)dynamicHeuristicCheckerOneModelRB);
        builder.append((Component)this.getDescription(modelOne.getDescription()));
        JRadioButton dynamicHeuristicCheckerThreeModelRB = new JRadioButton("Three");
        if (this.dynamicHeuristicCheckerModel.equals(modelThree.getClass().getName())) {
            dynamicHeuristicCheckerThreeModelRB.setSelected(true);
        }
        dynamicHeuristicCheckerThreeModelRB.setActionCommand(modelThree.getClass().getName());
        dynamicHeuristicCheckerThreeModelRB.addActionListener(modelSelectionListener);
        dynamicHeuristicCheckerModelBG.add(dynamicHeuristicCheckerThreeModelRB);
        builder.append((Component)dynamicHeuristicCheckerThreeModelRB);
        builder.append((Component)this.getDescription(modelThree.getDescription()));
        JRadioButton dynamicHeuristicCheckerFourModelRB = new JRadioButton("Four");
        if (this.dynamicHeuristicCheckerModel.equals(modelFour.getClass().getName())) {
            dynamicHeuristicCheckerFourModelRB.setSelected(true);
        }
        dynamicHeuristicCheckerFourModelRB.setActionCommand(modelFour.getClass().getName());
        dynamicHeuristicCheckerFourModelRB.addActionListener(modelSelectionListener);
        dynamicHeuristicCheckerModelBG.add(dynamicHeuristicCheckerFourModelRB);
        builder.append((Component)dynamicHeuristicCheckerFourModelRB);
        builder.append((Component)this.getDescription(modelFour.getDescription()));
        JRadioButton dynamicHeuristicCheckerSixModelRB = new JRadioButton("Six");
        if (this.dynamicHeuristicCheckerModel.equals(modelSix.getClass().getName())) {
            dynamicHeuristicCheckerSixModelRB.setSelected(true);
        }
        dynamicHeuristicCheckerSixModelRB.setActionCommand(modelSix.getClass().getName());
        dynamicHeuristicCheckerSixModelRB.addActionListener(modelSelectionListener);
        dynamicHeuristicCheckerModelBG.add(dynamicHeuristicCheckerSixModelRB);
        builder.append((Component)dynamicHeuristicCheckerSixModelRB);
        builder.append((Component)this.getDescription(modelSix.getDescription()));
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), plugin.getPluginDescription());
    }

    private JTextArea getDescription(String text) {
        JTextArea description = new JTextArea(text);
        description.setEditable(false);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        return description;
    }

    private JPanel buildButtonPanel() {
        ButtonBarBuilder bbuilder = ButtonBarBuilder.createLeftToRightBuilder();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginPreferencesDialog.this.save();
                PluginPreferencesDialog.this.dispose();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginPreferencesDialog.this.dispose();
            }
        });
        bbuilder.addGriddedButtons(new JButton[]{cancel, ok});
        JPanel buttons = bbuilder.getPanel();
        return buttons;
    }

    public void updateView() {
        this.invalidate();
        this.repaint();
    }

    void save() {
        try {
            Qedeq2UnicodeTextPlugin plugin = this.qedeq2utf8Show;
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "language", this.qedeq2Utf8ShowLanguageTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "info", this.qedeq2Utf8ShowInfoCB.isSelected());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "maximumColumn", this.qedeq2Utf8ShowMaximumColumnTF.getText());
            plugin = this.qedeq2latex;
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "info", this.qedeq2LatexInfoCB.isSelected());
            plugin = this.qedeq2utf8;
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "info", this.qedeq2Utf8InfoCB.isSelected());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "maximumColumn", this.qedeq2Utf8MaximumColumnTF.getText());
            plugin = this.dynamicHeuristicChecker;
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "model", this.dynamicHeuristicCheckerModel);
        }
        catch (RuntimeException e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"save", (String)"couldn't save preferences", (Throwable)e);
            JOptionPane.showMessageDialog(this, e.toString(), "Error", 0);
        }
        try {
            QedeqGuiConfig.getInstance().store();
        }
        catch (IOException e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"save", (String)"couldn't save preferences", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Couldn't save preferences", "Error", 0);
        }
    }
}

