/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.xml.parsers.ParserConfigurationException;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.ResourceLoaderUtility;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.base.utility.YodaUtility;
import org.qedeq.gui.se.element.CPTextArea;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.gui.se.pane.TextPaneWindow;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.ModuleLabels;
import org.qedeq.kernel.bo.parser.MathParser;
import org.qedeq.kernel.bo.parser.ParserException;
import org.qedeq.kernel.bo.parser.Term;
import org.qedeq.kernel.bo.service.Element2LatexImpl;
import org.qedeq.kernel.bo.service.Element2Utf8Impl;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.xml.handler.parser.LoadXmlOperatorListUtility;
import org.qedeq.kernel.xml.parser.BasicParser;
import org.xml.sax.SAXException;

public class ParserPane
extends JFrame {
    private static final Class CLASS = ParserPane.class;
    private CPTextArea source = new CPTextArea(true);
    private CPTextArea resultField = new CPTextArea(false);
    private CPTextArea error = new CPTextArea(false);
    private JScrollPane sourceScroller = new JScrollPane();
    private JSplitPane splitPane = new JSplitPane(0);
    private JMenuBar menu = new JMenuBar();
    private final List operators;
    private int errorPosition = -1;
    private JSplitPane globalPane;
    private final File resourceFile;
    private final MathParser parser;

    public ParserPane(String name, MathParser parser, String title, String resourceName, String sample) throws SourceFileExceptionList {
        super(title);
        this.parser = parser;
        this.source.setText(sample);
        String resourceDirectoryName = "config";
        try {
            this.resourceFile = ResourceLoaderUtility.getResourceFile((File)KernelContext.getInstance().getConfig().getBasisDirectory(), (String)"config", (String)resourceName).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.operators = LoadXmlOperatorListUtility.getOperatorList((InternalKernelServices)((InternalKernelServices)YodaUtility.getFieldValue((Object)KernelContext.getInstance(), (String)"services")), (File)this.resourceFile);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        this.setupView(name);
        this.updateView();
    }

    private final void setupView(String name) {
        Container pane = this.getContentPane();
        this.source.setDragEnabled(true);
        this.source.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.source.setAutoscrolls(true);
        this.source.setCaretPosition(0);
        this.source.setEditable(true);
        this.source.getCaret().setVisible(false);
        this.source.setLineWrap(true);
        this.source.setWrapStyleWord(true);
        this.source.setFocusable(true);
        this.resultField.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.resultField.setAutoscrolls(true);
        this.resultField.setCaretPosition(0);
        this.resultField.setEditable(false);
        this.resultField.getCaret().setVisible(false);
        this.resultField.setFocusable(true);
        JMenuItem item = new JMenuItem("Show as Text");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String text = ParserPane.this.resultField.getText().trim();
                if (text.length() == 0) {
                    return;
                }
                ModuleLabels labels = new ModuleLabels();
                Element2LatexImpl converter = new Element2LatexImpl(labels);
                Element2Utf8Impl textConverter = new Element2Utf8Impl(converter);
                Element[] elements = new Element[]{};
                try {
                    elements = BasicParser.createElements((String)text);
                }
                catch (ParserConfigurationException e1) {
                    Trace.fatal((Class)CLASS, (String)"setupView$actionPerformed", (String)"Parser configuration error", (Throwable)e1);
                    return;
                }
                catch (SAXException e1) {
                    return;
                }
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < elements.length; ++i) {
                    String[] parsed = textConverter.getUtf8(elements[i], 120);
                    for (int j = 0; j < parsed.length; ++j) {
                        result.append(parsed[j] + "\n");
                    }
                    result.append("\n\n");
                }
                TextPaneWindow window = new TextPaneWindow("QEDEQ formulas as unicode text", GuiHelper.readImageIcon("oil/" + QedeqGuiConfig.getInstance().getIconSize() + "/apps/education-mathematics.png"), result.toString());
                window.setVisible(true);
            }
        });
        this.resultField.addMenuItem(item);
        this.error.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.error.setForeground(Color.RED);
        this.error.setAutoscrolls(true);
        this.error.setCaretPosition(0);
        this.error.setEditable(false);
        this.error.getCaret().setVisible(false);
        this.error.setFocusable(true);
        this.error.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ParserPane.this.updateView();
            }
        });
        JViewport qedeqPort = this.sourceScroller.getViewport();
        qedeqPort.add(this.source);
        JScrollPane resultScroller = new JScrollPane();
        JViewport resultPort = resultScroller.getViewport();
        resultPort.add(this.resultField);
        JScrollPane errorScroller = new JScrollPane();
        JViewport errorPort = errorScroller.getViewport();
        errorPort.add(this.error);
        this.splitPane.setTopComponent(this.sourceScroller);
        this.splitPane.setBottomComponent(resultScroller);
        this.splitPane.setResizeWeight(0.0);
        this.splitPane.setOneTouchExpandable(true);
        this.error.setText("");
        this.globalPane = new JSplitPane(0);
        this.globalPane.setTopComponent(this.splitPane);
        this.globalPane.setBottomComponent(errorScroller);
        this.globalPane.setResizeWeight(1.0);
        this.globalPane.setOneTouchExpandable(true);
        pane.add(this.globalPane);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"componentHidden", (Object)e);
            }

            public void componentShown(ComponentEvent e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"componentShown", (Object)e);
            }
        });
        this.menu.removeAll();
        JMenu transformMenu = new JMenu("Transform");
        transformMenu.setMnemonic('T');
        JMenuItem transform = new JMenuItem(name + " to QEDEQ");
        transform.setMnemonic('Q');
        transform.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent action) {
                ParserPane.this.resultField.setText(ParserPane.this.printMath(ParserPane.this.source.getText()));
                ParserPane.this.updateView();
            }
        });
        transformMenu.add(transform);
        JMenuItem doSwitch = new JMenuItem("switch content");
        doSwitch.setMnemonic('S');
        doSwitch.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent action) {
                String text = ParserPane.this.source.getText();
                ParserPane.this.source.setText(ParserPane.this.resultField.getText());
                ParserPane.this.resultField.setText(text);
                ParserPane.this.updateView();
            }
        });
        transformMenu.add(doSwitch);
        this.menu.add(transformMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem about = new JMenuItem("About");
        about.setMnemonic('A');
        about.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent action) {
                JOptionPane.showMessageDialog(ParserPane.this, "This dialog enables to transform textual input into the QEDEQ format.\nThe operators and their QEDEQ counterparts are defined int the file:\n" + ParserPane.this.resourceFile, "About", 1);
            }
        });
        helpMenu.add(about);
        this.menu.add(helpMenu);
        this.setJMenuBar(this.menu);
        this.setSize(500, 800);
    }

    public void setLineWrap(boolean wrap) {
        this.source.setLineWrap(wrap);
    }

    public boolean getLineWrap() {
        return this.source.getLineWrap();
    }

    public synchronized void updateView() {
        String method = "updateView()";
        Trace.begin((Class)CLASS, (Object)this, (String)"updateView()");
        if (this.errorPosition >= 0) {
            this.globalPane.setDividerLocation(this.globalPane.getHeight() - this.globalPane.getDividerSize() - this.error.getFontMetrics(this.error.getFont()).getHeight() * 3 - 4);
        } else {
            this.error.setText("");
            this.globalPane.setDividerLocation(this.getHeight());
        }
        this.repaint();
    }

    private String printMath(String text) {
        StringBuffer buffer = new StringBuffer(text);
        TextInput input = new TextInput(buffer);
        this.parser.setParameters(text, this.operators);
        StringBuffer out = new StringBuffer();
        this.errorPosition = -1;
        try {
            Term term = null;
            do {
                if ((term = this.parser.readTerm()) == null) continue;
                out.append(term.getQedeqXml()).append("\n");
                System.out.println(term.getQedeqXml());
            } while (term != null || !this.parser.eof());
        }
        catch (ParserException e) {
            e.printStackTrace(System.out);
            StringBuffer result = new StringBuffer();
            this.errorPosition = input.getPosition();
            result.append(input.getRow() + ":" + input.getColumn() + ":" + "\n");
            result.append(e.getMessage() + "\n");
            result.append(input.getLine().replace('\t', ' ').replace('\r', ' ') + "\n");
            StringBuffer pointer = StringUtility.getSpaces((int)input.getColumn());
            pointer.append('^');
            result.append(pointer);
            System.out.println(result.toString());
            this.error.setText(result.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            StringBuffer result = new StringBuffer();
            this.errorPosition = input.getPosition();
            result.append(input.getRow() + ":" + input.getColumn() + ":" + "\n");
            result.append(e.getMessage() + "\n");
            result.append(input.getLine().replace('\t', ' ').replace('\r', ' ') + "\n");
            StringBuffer pointer = StringUtility.getSpaces((int)input.getColumn());
            pointer.append('^');
            result.append(pointer);
            System.out.println(result.toString());
            this.error.setText(result.toString());
        }
        IoUtility.close((InputStream)input);
        return out.toString();
    }
}

