/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.gui.se.control.SelectionListenerList;
import org.qedeq.gui.se.pane.ModuleErrorAndWarningListContextMenu;
import org.qedeq.gui.se.pane.ModuleErrorAndWarningListModel;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.log.ModuleEventListener;
import org.qedeq.kernel.se.common.SourceFileException;

public class ModuleErrorAndWarningListPane
extends JPanel
implements ModuleEventListener,
ActionListener {
    private static final Class CLASS = ModuleErrorAndWarningListPane.class;
    private int selectedLine = -1;
    private ModuleErrorAndWarningListModel model = new ModuleErrorAndWarningListModel();
    private JTable list = new JTable(this.model){

        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int row = this.rowAtPoint(p);
            SourceFileException sfe = null;
            if (row >= 0) {
                try {
                    sfe = ModuleErrorAndWarningListPane.this.model.getSourceFileException(row);
                }
                catch (RuntimeException ex) {
                    // empty catch block
                }
            }
            if (sfe != null) {
                int col = this.columnAtPoint(p);
                switch (col) {
                    case 0: {
                        tip = ModuleErrorAndWarningListPane.this.model.isWarning(row) ? "Warning" : "Error";
                        break;
                    }
                    case 1: {
                        tip = sfe.getMessage() + "\n";
                        break;
                    }
                    case 2: {
                        tip = sfe.getSourceArea() != null ? sfe.getSourceArea().getShortDescription() : "";
                        break;
                    }
                    case 3: {
                        tip = sfe.getPlugin().getPluginDescription();
                        break;
                    }
                    default: {
                        tip = sfe.getMessage() + "\n";
                    }
                }
                return tip;
            }
            return super.getToolTipText(e);
        }
    };
    private final ModuleErrorAndWarningListContextMenu contextMenu;
    private final SimpleAttributeSet errorAttrs = new SimpleAttributeSet();
    private QedeqBo prop;
    private JScrollPane scrollPane;
    private SelectionListenerList listener;

    public ModuleErrorAndWarningListPane(SelectionListenerList listener) {
        super(false);
        this.listener = listener;
        this.contextMenu = new ModuleErrorAndWarningListContextMenu(this);
        this.setModel(null);
        this.setupView();
    }

    private void selectLine() {
        Trace.param((Class)CLASS, (Object)this, (String)"selectLine", (String)"selectedLine", (int)this.selectedLine);
        if (this.model.isError(this.selectedLine)) {
            this.listener.selectError(this.model.getErrorNumber(this.selectedLine), this.model.getSourceFileException(this.selectedLine));
        } else if (this.model.isWarning(this.selectedLine)) {
            this.listener.selectWarning(this.model.getWarningNumber(this.selectedLine), this.model.getSourceFileException(this.selectedLine));
        }
    }

    private final void setupView() {
        FormLayout layout = new FormLayout("min:grow", "0:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setBorder(BorderFactory.createEmptyBorder());
        builder.setRowGroupingEnabled(true);
        CellConstraints cc = new CellConstraints();
        builder.appendRow(new RowSpec("0:grow"));
        this.list.setDefaultRenderer(Icon.class, new IconCellRenderer());
        ListSelectionModel rowSM = this.list.getSelectionModel();
        rowSM.setSelectionMode(0);
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ModuleErrorAndWarningListPane.this.selectedLine = ModuleErrorAndWarningListPane.this.list.getSelectionModel().getLeadSelectionIndex();
                Trace.param((Class)CLASS, (Object)this, (String)"setupView$valueChanged", (String)"selectedLine", (int)ModuleErrorAndWarningListPane.this.selectedLine);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    ModuleErrorAndWarningListPane.this.contextMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    super.mousePressed(evt);
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"setupView$vmouseClicked", (Object)"doubleClick");
                }
                ModuleErrorAndWarningListPane.this.selectLine();
            }
        });
        this.list.getActionMap().put("selectNextRowCell", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                Trace.param((Class)CLASS, (Object)this, (String)"setupView$actionPerformed", (String)"event", (Object)event);
                ModuleErrorAndWarningListPane.this.selectLine();
            }
        });
        this.scrollPane = new JScrollPane(this.list);
        builder.add((Component)this.scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 1, 2, "fill, fill"));
        this.scrollPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    ModuleErrorAndWarningListPane.this.contextMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    super.mousePressed(evt);
                }
            }
        });
        StyleConstants.setForeground(this.errorAttrs, Color.red);
        this.scrollPane.getViewport().setBackground(Color.white);
        StyleConstants.setBackground(this.errorAttrs, Color.white);
        JTableHeader header = this.list.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(2);
        header.setPreferredSize(new Dimension(this.list.getTableHeader().getWidth(), (int)(1.1 * (double)this.getFontMetrics(this.getFont()).getHeight())));
        this.changeColumnHeaderWidth();
    }

    private void changeColumnHeaderWidth() {
        TableColumnModel columnModel = this.list.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(24);
        columnModel.getColumn(0).setMinWidth(24);
        columnModel.getColumn(1).setPreferredWidth(2000);
        columnModel.getColumn(1).setMinWidth(100);
        columnModel.getColumn(2).setPreferredWidth(50);
        columnModel.getColumn(2).setMinWidth(50);
        columnModel.getColumn(3).setPreferredWidth(100);
        columnModel.getColumn(3).setMinWidth(100);
    }

    public synchronized void setModel(QedeqBo prop) {
        Trace.trace((Class)CLASS, (Object)this, (String)"setModel", (Object)prop);
        this.model.setQedeq(prop);
        if (!EqualsUtility.equals((Object)this.prop, (Object)prop)) {
            this.prop = prop;
            Runnable setModel = new Runnable(){

                public void run() {
                    ModuleErrorAndWarningListPane.this.updateView();
                }
            };
            SwingUtilities.invokeLater(setModel);
        }
    }

    public synchronized void updateView() {
        String method = "updateView";
        Trace.begin((Class)CLASS, (Object)this, (String)"updateView");
        ((AbstractTableModel)this.list.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this.list.getModel()).fireTableStructureChanged();
        this.changeColumnHeaderWidth();
        this.list.invalidate();
        this.list.repaint();
        this.repaint();
    }

    public void addModule(QedeqBo p) {
        if (this.prop != null && this.prop.equals(p)) {
            Runnable addModule = new Runnable(){

                public void run() {
                    ModuleErrorAndWarningListPane.this.updateView();
                }
            };
            SwingUtilities.invokeLater(addModule);
        }
    }

    public void stateChanged(QedeqBo p) {
        if (this.prop != null && this.prop.equals(p)) {
            Runnable stateChanged = new Runnable(){

                public void run() {
                    ModuleErrorAndWarningListPane.this.updateView();
                }
            };
            SwingUtilities.invokeLater(stateChanged);
        }
    }

    public void removeModule(QedeqBo p) {
        if (this.prop != null && this.prop.equals(p)) {
            this.prop = null;
            Runnable removeModule = new Runnable(){

                public void run() {
                    ModuleErrorAndWarningListPane.this.updateView();
                }
            };
            SwingUtilities.invokeLater(removeModule);
        }
    }

    public void actionPerformed(ActionEvent actionevent) {
        String s = actionevent.getActionCommand();
        if (s.equals("copy") && this.model.getQedeq() != null) {
            SourceFileException e;
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append("Kind\tType\tCode\tFrom\tTo\tDescription\n");
            for (i = 0; i < this.model.getQedeq().getErrors().size(); ++i) {
                e = this.model.getQedeq().getErrors().get(i);
                sb.append(e.getPlugin().getPluginActionName());
                sb.append("\t");
                sb.append("Error");
                sb.append("\t");
                sb.append(e.getErrorCode());
                sb.append("\t");
                sb.append(e.getSourceArea().getStartPosition());
                sb.append("\t");
                sb.append(e.getSourceArea().getEndPosition());
                sb.append("\t");
                sb.append(e.getMessage());
                sb.append("\n");
            }
            for (i = 0; i < this.model.getQedeq().getWarnings().size(); ++i) {
                e = this.model.getQedeq().getWarnings().get(i);
                sb.append(e.getPlugin().getPluginActionName());
                sb.append("\t");
                sb.append("Warning");
                sb.append("\t");
                sb.append(e.getErrorCode());
                sb.append("\t");
                sb.append(e.getSourceArea().getStartPosition());
                sb.append("\t");
                sb.append(e.getSourceArea().getEndPosition());
                sb.append("\t");
                sb.append(e.getMessage());
                sb.append("\n");
            }
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection sel = new StringSelection(sb.toString());
            cb.setContents(sel, null);
        }
    }

    private static class IconCellRenderer
    extends DefaultTableCellRenderer {
        private IconCellRenderer() {
        }

        protected void setValue(Object value) {
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                super.setValue(null);
            } else {
                this.setIcon(null);
                super.setValue(value);
            }
        }
    }
}

