/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.qedeq.gui.se.pane.ModuleErrorAndWarningListPane;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.se.common.SourceFileException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public class ModuleErrorAndWarningListModel
extends AbstractTableModel {
    private static ImageIcon errorIcon = new ImageIcon(ModuleErrorAndWarningListPane.class.getResource("/images/eclipse/error_tsk.gif"));
    private static ImageIcon warningIcon = new ImageIcon(ModuleErrorAndWarningListPane.class.getResource("/images/eclipse/warn_tsk.gif"));
    private QedeqBo qedeq;
    private SourceFileExceptionList errors;
    private SourceFileExceptionList warnings;
    private int maxErrors;
    private int maxEntries;

    public String getColumnName(int column) {
        if (this.qedeq == null) {
            return "";
        }
        if (column == 1) {
            return this.qedeq.getModuleAddress().getUrl();
        }
        if (column == 2) {
            return "Location";
        }
        if (column == 3) {
            return "Type";
        }
        return "";
    }

    public int getRowCount() {
        return this.maxEntries;
    }

    public int getColumnCount() {
        return 4;
    }

    public Object getValueAt(int row, int col) {
        if (this.qedeq == null) {
            return "";
        }
        SourceFileException e = this.getSourceFileException(row);
        if (e == null) {
            return "";
        }
        switch (col) {
            case 0: {
                if (this.isError(row)) {
                    return errorIcon;
                }
                if (!this.isWarning(row)) break;
                return warningIcon;
            }
            case 1: {
                if (this.getSourceFileException(row) == null) break;
                return this.getSourceFileException(row).getMessage();
            }
            case 2: {
                if (this.getSourceFileException(row) == null || this.getSourceFileException(row).getSourceArea() == null) break;
                return "line " + this.getSourceFileException(row).getSourceArea().getStartPosition().getRow();
            }
            case 3: {
                if (this.getSourceFileException(row) == null) break;
                return this.getSourceFileException(row).getPlugin().getPluginActionName();
            }
            default: {
                return "";
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
    }

    public Class getColumnClass(int col) {
        Class clazz = col == 0 ? Icon.class : Object.class;
        return clazz;
    }

    public void setQedeq(QedeqBo qedeq) {
        this.qedeq = qedeq;
    }

    public QedeqBo getQedeq() {
        return this.qedeq;
    }

    public void fireTableDataChanged() {
        if (this.qedeq != null) {
            this.errors = this.qedeq.getErrors();
            this.warnings = this.qedeq.getWarnings();
        } else {
            this.errors = null;
            this.warnings = null;
        }
        this.maxErrors = 0;
        if (this.errors != null) {
            this.maxErrors += this.errors.size();
        }
        this.maxEntries = this.maxErrors;
        if (this.warnings != null) {
            this.maxEntries += this.warnings.size();
        }
        super.fireTableDataChanged();
    }

    public SourceFileException getSourceFileException(int row) {
        if (this.isError(row)) {
            return this.errors.get(row);
        }
        if (this.isWarning(row)) {
            return this.warnings.get(row - this.maxErrors);
        }
        return null;
    }

    public int getErrorNumber(int row) {
        if (!this.isError(row)) {
            throw new IllegalArgumentException("This is not an error row: " + row);
        }
        return row;
    }

    public int getWarningNumber(int row) {
        if (!this.isWarning(row)) {
            throw new IllegalArgumentException("This is not an warning row: " + row);
        }
        return row - this.maxErrors;
    }

    public boolean isError(int row) {
        return row >= 0 && row < this.maxErrors;
    }

    public boolean isWarning(int row) {
        return row >= this.maxErrors && row < this.maxEntries;
    }
}

