/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.control;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.qedeq.gui.se.control.AboutAction;
import org.qedeq.gui.se.control.AddAction;
import org.qedeq.gui.se.control.AddAllModulesFromQedeqAction;
import org.qedeq.gui.se.control.AddFileAction;
import org.qedeq.gui.se.control.CheckLogicAction;
import org.qedeq.gui.se.control.ExitAction;
import org.qedeq.gui.se.control.HelpAction;
import org.qedeq.gui.se.control.LatexParserAction;
import org.qedeq.gui.se.control.MakeLatexAction;
import org.qedeq.gui.se.control.PluginAction;
import org.qedeq.gui.se.control.PluginPreferencesAction;
import org.qedeq.gui.se.control.PreferencesAction;
import org.qedeq.gui.se.control.ProcessViewAction;
import org.qedeq.gui.se.control.RemoveAllAction;
import org.qedeq.gui.se.control.RemoveLocalBufferAction;
import org.qedeq.gui.se.control.RemoveModuleAction;
import org.qedeq.gui.se.control.RemovePluginResultsAction;
import org.qedeq.gui.se.control.TextParserAction;
import org.qedeq.gui.se.tree.NothingSelectedException;
import org.qedeq.gui.se.tree.QedeqTreeCtrl;
import org.qedeq.gui.se.util.DataDictionary;
import org.qedeq.gui.se.util.MenuHelper;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.se.common.Plugin;

public class QedeqController {
    private QedeqTreeCtrl treeCtrl;
    private final Action aboutAction;
    private final Action helpAction;
    private final Action exitAction;
    private final Action addAction;
    private final Action addFileAction;
    private final Action removeAllAction;
    private final Action removeLocalBufferAction;
    private final Action removeModuleAction;
    private final Action addAllModulesFromQedeqAction;
    private final Action makeLatexAction;
    private final Action processViewAction;
    private final PluginAction[] pluginActions;
    private final Action checkLogicAction;
    private final Action removePluginResultsAction;
    private final Action preferencesAction;
    private final Action pluginPreferencesAction;
    private final Action latexParserAction;
    private final Action textParserAction;
    private final ArrayList moduleHistory;
    private final JFrame main;
    static final int MAXIMUM_MODULE_HISTORY = 20;

    public QedeqController(JFrame main) {
        this.main = main;
        this.aboutAction = new AboutAction(this);
        this.helpAction = new HelpAction(this);
        this.preferencesAction = new PreferencesAction(this);
        this.pluginPreferencesAction = new PluginPreferencesAction(this);
        this.latexParserAction = new LatexParserAction(this);
        this.textParserAction = new TextParserAction(this);
        this.exitAction = new ExitAction();
        this.addAction = new AddAction(this);
        this.addFileAction = new AddFileAction(this);
        this.addAllModulesFromQedeqAction = new AddAllModulesFromQedeqAction();
        this.removeAllAction = new RemoveAllAction();
        this.removeModuleAction = new RemoveModuleAction(this);
        this.removeLocalBufferAction = new RemoveLocalBufferAction(this);
        this.makeLatexAction = new MakeLatexAction(this);
        this.checkLogicAction = new CheckLogicAction(this);
        this.removePluginResultsAction = new RemovePluginResultsAction(this);
        this.processViewAction = new ProcessViewAction();
        Plugin[] plugins = KernelContext.getInstance().getPlugins();
        this.pluginActions = new PluginAction[plugins.length];
        for (int i = 0; i < plugins.length; ++i) {
            this.pluginActions[i] = new PluginAction(this, plugins[i]);
        }
        String[] list = KernelContext.getInstance().getConfig().getModuleHistory();
        this.moduleHistory = new ArrayList();
        for (int i = 0; i < list.length; ++i) {
            this.getModuleHistory().add(list[i]);
        }
        if (this.getModuleHistory().size() == 0) {
            String prefix = "http://wwww.qedeq.org/" + KernelContext.getInstance().getKernelVersionDirectory() + "/doc/";
            this.getModuleHistory().add(prefix + "math/qedeq_logic_v1.xml");
            this.getModuleHistory().add(prefix + "math/qedeq_propositional_v1.xml");
            this.getModuleHistory().add(prefix + "math/qedeq_set_theory_v1.xml");
            this.getModuleHistory().add(prefix + "project/qedeq_basic_concept.xml");
            this.getModuleHistory().add(prefix + "project/qedeq_logic_language.xml");
            this.getModuleHistory().add(prefix + "sample/qedeq_sample1.xml");
            this.getModuleHistory().add(prefix + "sample/qedeq_sample2.xml");
            this.getModuleHistory().add(prefix + "sample/qedeq_sample3.xml");
            this.getModuleHistory().add(prefix + "sample/qedeq_sample4.xml");
        }
    }

    public void setTreeCtrl(QedeqTreeCtrl treeCtrl) {
        this.treeCtrl = treeCtrl;
    }

    public QedeqBo[] getSelected() throws NothingSelectedException {
        return this.treeCtrl.getSelected();
    }

    public Action getAboutAction() {
        return this.aboutAction;
    }

    public Action getHelpAction() {
        return this.helpAction;
    }

    public Action getPreferencesAction() {
        return this.preferencesAction;
    }

    public Action getPluginPreferencesAction() {
        return this.pluginPreferencesAction;
    }

    public Action getLatexParserAction() {
        return this.latexParserAction;
    }

    public Action getTextParserAction() {
        return this.textParserAction;
    }

    public Action getExitAction() {
        return this.exitAction;
    }

    public Action getAddAction() {
        return this.addAction;
    }

    public Action getAddFileAction() {
        return this.addFileAction;
    }

    public Action getLatexAction() {
        return this.makeLatexAction;
    }

    public JMenuItem[] getPluginMenuEntries() {
        JMenuItem[] result = new JMenuItem[this.pluginActions.length];
        for (int i = 0; i < this.pluginActions.length; ++i) {
            JMenuItem item = MenuHelper.createMenuItem(this.pluginActions[i].getPlugin().getPluginActionName());
            item.addActionListener(this.pluginActions[i]);
            item.setIcon(this.pluginActions[i].getIcon());
            item.setToolTipText(this.pluginActions[i].getPlugin().getPluginDescription());
            result[i] = item;
        }
        return result;
    }

    public Action getCheckLogicAction() {
        return this.checkLogicAction;
    }

    public Action getRemovePluginResultsAction() {
        return this.removePluginResultsAction;
    }

    public Action getRemoveAllAction() {
        return this.removeAllAction;
    }

    public Action getRemoveModuleAction() {
        return this.removeModuleAction;
    }

    public Action getRemoveLocalBufferAction() {
        return this.removeLocalBufferAction;
    }

    public Action getAddAllModulesFromQedeqAction() {
        return this.addAllModulesFromQedeqAction;
    }

    public Action getProcessViewAction() {
        return this.processViewAction;
    }

    public String getString(String key) {
        return DataDictionary.getInstance().getString(key);
    }

    public char getMnemonic(String key) {
        return DataDictionary.getInstance().getMnemonic(key);
    }

    void addToModuleHistory(String url) {
        int i;
        this.getModuleHistory().add(0, url);
        for (i = 1; i < this.getModuleHistory().size(); ++i) {
            if (!url.equals(this.getModuleHistory().get(i))) continue;
            this.getModuleHistory().remove(i);
            --i;
        }
        for (i = this.getModuleHistory().size() - 1; i >= 20; --i) {
            this.getModuleHistory().remove(i);
        }
        KernelContext.getInstance().getConfig().saveModuleHistory((List)this.getModuleHistory());
    }

    ArrayList getModuleHistory() {
        return this.moduleHistory;
    }

    JFrame getMainFrame() {
        return this.main;
    }

    void selectionError() {
        JOptionPane.showMessageDialog(this.main, "No QEDEQ module selected! In the tree at least one QEDEQ module must be selected", "Error", 0, null);
    }
}

