/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.control;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.pane.ParserPane;
import org.qedeq.kernel.bo.parser.LatexMathParser;
import org.qedeq.kernel.bo.parser.MathParser;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

class LatexParserAction
extends AbstractAction {
    private static final Class CLASS = LatexParserAction.class;
    private final QedeqController controller;

    LatexParserAction(QedeqController controller) {
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        String resourceName = "latexMathOperators.xml";
        try {
            ParserPane pane = new ParserPane("LaTeX", (MathParser)new LatexMathParser(), "QEDEQ LaTeX Parser Sample", "latexMathOperators.xml", "x \\land (y \\lor z) \\leftrightarrow (x \\land y) \\lor (x \\land z)\n\n\\{ x | y \\in x \\} = \\{ z | y \\in x \\}");
            pane.setVisible(true);
        }
        catch (SourceFileExceptionList xl) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"actionPerformed", (String)"Parser Window can not be opened", (Throwable)xl);
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Parser Window can not be opened. There is a problem with \"latexMathOperators.xml\"\n\nJust deleting this file in the config directory should fix the error.\n\n" + xl.toString(), "Error", 0);
        }
        catch (RuntimeException ex) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"actionPerformed", (String)"unexpected problem", (Throwable)ex);
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Parser Window can not be opened\n" + ex.toString(), "Error", 0);
        }
    }
}

