/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import java.io.FileNotFoundException;
import java.io.InputStream;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.xml.parser.SaxDefaultHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SaxEntityResolver
implements EntityResolver {
    private static final Class CLASS = SaxEntityResolver.class;
    private final SaxDefaultHandler handler;

    public SaxEntityResolver(SaxDefaultHandler handler) {
        this.handler = handler;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws FileNotFoundException, SAXException {
        String method = "resolveEntity";
        Trace.param(CLASS, (Object)this, "resolveEntity", "systemId", systemId);
        Trace.param(CLASS, (Object)this, "resolveEntity", "publicId", publicId);
        if (systemId == null) {
            return null;
        }
        if (systemId.equals("http://www.qedeq.org/" + KernelContext.getInstance().getKernelVersionDirectory() + "/xml/qedeq.xsd")) {
            InputStream in = SaxEntityResolver.class.getResourceAsStream("/org/qedeq/kernel/xml/schema/qedeq.xsd");
            if (in == null) {
                throw new FileNotFoundException("/org/qedeq/kernel/xml/schema/qedeq.xsd");
            }
            InputSource inputSource = new InputSource(in);
            inputSource.setPublicId(publicId);
            inputSource.setSystemId(systemId);
            return inputSource;
        }
        if (systemId.equals("http://www.qedeq.org/" + KernelContext.getInstance().getKernelVersionDirectory() + "/xml/parser.xsd")) {
            InputStream in = SaxEntityResolver.class.getResourceAsStream("/org/qedeq/kernel/xml/schema/parser.xsd");
            if (in == null) {
                throw new FileNotFoundException("/org/qedeq/kernel/xml/schema/parser.xsd");
            }
            InputSource inputSource = new InputSource(in);
            inputSource.setPublicId(publicId);
            inputSource.setSystemId(systemId);
            return inputSource;
        }
        Trace.trace(CLASS, (Object)this, "resolveEntity", "unknown entity");
        SAXParseException sax = this.handler.createSAXParseException("this kernel supports only the following XSDs: \"http://www.qedeq.org/" + KernelContext.getInstance().getKernelVersionDirectory() + "/xml/qedeq.xsd\"" + " and \n" + "\"http://www.qedeq.org/" + KernelContext.getInstance().getKernelVersionDirectory() + "/xml/parser.xsd\" " + "\nbut the document \"" + this.handler.getUrl() + "\" referenced \n\"" + systemId + "\"");
        throw sax;
    }
}

