/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.handler.parser;

import java.io.File;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.xml.handler.parser.ParserHandler;
import org.qedeq.kernel.xml.parser.SaxDefaultHandler;
import org.qedeq.kernel.xml.parser.SaxParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class LoadXmlOperatorListUtility
implements Plugin {
    private static final Class CLASS = LoadXmlOperatorListUtility.class;

    private LoadXmlOperatorListUtility() {
    }

    public static List getOperatorList(InternalKernelServices services, File from) throws SourceFileExceptionList {
        String method = "List getOperatorList(String)";
        LoadXmlOperatorListUtility util = new LoadXmlOperatorListUtility();
        try {
            Trace.begin(CLASS, "List getOperatorList(String)");
            Trace.param(CLASS, "List getOperatorList(String)", "from", from);
            SaxDefaultHandler handler = new SaxDefaultHandler(util);
            ParserHandler simple = new ParserHandler(handler);
            handler.setBasisDocumentHandler(simple);
            SaxParser parser = new SaxParser(util, handler);
            parser.parse(from, null);
            List list = simple.getOperators();
            return list;
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, "Programming error.", "List getOperatorList(String)", e);
            throw services.createSourceFileExceptionList(754123000, "Parsing programming error.", "" + from, e);
        }
        catch (ParserConfigurationException e) {
            Trace.fatal(CLASS, "Parser configuration error.", "List getOperatorList(String)", e);
            throw services.createSourceFileExceptionList(754123010, "Parser configuration error.", "" + from, e);
        }
        catch (SAXParseException e) {
            Trace.fatal(CLASS, "Configuration error, file corrupt: " + from, "List getOperatorList(String)", e);
            throw services.createSourceFileExceptionList(754123020, "XML file parsing failed.", "" + from, e);
        }
        catch (SAXException e) {
            Trace.fatal(CLASS, "Configuration error, file corrupt: " + from, "List getOperatorList(String)", e);
            throw services.createSourceFileExceptionList(754123020, "XML file parsing failed.", "" + from, e);
        }
        catch (FactoryConfigurationError e) {
            Trace.trace(CLASS, "List getOperatorList(String)", e);
            throw services.createSourceFileExceptionList(754123030, "Probably SAX Parser not in classpath, add for example \"xercesImpl.jar\" and \"xml-apis.jar\".", "" + from, new RuntimeException("Probably SAX Parser not in classpath, add for example \"xercesImpl.jar\" and \"xml-apis.jar\".", e));
        }
        finally {
            Trace.end(CLASS, "List getOperatorList(String)");
        }
    }

    public String getPluginId() {
        return CLASS.getName();
    }

    public String getPluginName() {
        return "Operator Loader";
    }

    public String getPluginDescription() {
        return "loads XML descriptoin of mathematical operators";
    }
}

