/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.handler.module;

import org.qedeq.kernel.se.dto.module.SectionVo;
import org.qedeq.kernel.xml.common.XmlSyntaxException;
import org.qedeq.kernel.xml.handler.module.LatexListHandler;
import org.qedeq.kernel.xml.handler.module.SubsectionListHandler;
import org.qedeq.kernel.xml.parser.AbstractSimpleHandler;
import org.qedeq.kernel.xml.parser.SimpleAttributes;

public class SectionHandler
extends AbstractSimpleHandler {
    public static final String INTRODUCTION_TAG = "INTRODUCTION";
    public static final String SECTION_TAG = "SECTION";
    public static final String TITLE_TAG = "TITLE";
    private final LatexListHandler titleHandler = new LatexListHandler(this, "TITLE");
    private final LatexListHandler introductionHandler = new LatexListHandler(this, "INTRODUCTION");
    private final SubsectionListHandler subsectionListHandler = new SubsectionListHandler(this);
    private SectionVo section;

    public SectionHandler(AbstractSimpleHandler handler) {
        super(handler, SECTION_TAG);
    }

    public final void init() {
        this.section = null;
    }

    public final SectionVo getSection() {
        return this.section;
    }

    public final void startElement(String name, SimpleAttributes attributes) throws XmlSyntaxException {
        if (this.getStartTag().equals(name)) {
            this.section = new SectionVo();
            this.section.setNoNumber(attributes.getBoolean("noNumber"));
        } else if (TITLE_TAG.equals(name)) {
            this.changeHandler(this.titleHandler, name, attributes);
        } else if (INTRODUCTION_TAG.equals(name)) {
            this.changeHandler(this.introductionHandler, name, attributes);
        } else if ("SUBSECTIONS".equals(name)) {
            this.changeHandler(this.subsectionListHandler, name, attributes);
        } else {
            throw XmlSyntaxException.createUnexpectedTagException(name);
        }
    }

    public final void endElement(String name) throws XmlSyntaxException {
        if (!this.getStartTag().equals(name)) {
            if (TITLE_TAG.equals(name)) {
                this.section.setTitle(this.titleHandler.getLatexList());
            } else if (INTRODUCTION_TAG.equals(name)) {
                this.section.setIntroduction(this.introductionHandler.getLatexList());
            } else if ("SUBSECTIONS".equals(name)) {
                this.section.setSubsectionList(this.subsectionListHandler.getSubsectionList());
            } else {
                throw XmlSyntaxException.createUnexpectedTagException(name);
            }
        }
    }
}

