/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.common;

import java.io.IOException;
import org.qedeq.kernel.se.common.ErrorCodes;
import org.qedeq.kernel.se.common.QedeqException;
import org.xml.sax.SAXException;

public final class XmlSyntaxException
extends QedeqException
implements ErrorCodes {
    public static final int SAX_PARSER_EXCEPTION = 9001;
    public static final int UNEXPECTED_TAG_CODE = 9002;
    public static final String UNEXPECTED_TAG_TEXT = "XML structure problem. Unexpected tag: ";
    public static final int UNEXPECTED_DATA_CODE = 9003;
    public static final String UNEXPECTED_DATA_TEXT = "XML structure problem. Unexpected character data in tag: ";
    public static final int MISSING_ATTRIBUTE_CODE = 9004;
    public static final String MISSING_ATTRIBUTE_TEXT_1 = "XML structure problem. Missing neccessary attribute: ";
    public static final String MISSING_ATTRIBUTE_TEXT_2 = " in tag: ";
    public static final int EMPTY_ATTRIBUTE_CODE = 9004;
    public static final String EMPTY_ATTRIBUTE_TEXT_1 = "Missing attribute: ";
    public static final String EMPTY_ATTRIBUTE_TEXT_2 = " in tag: ";
    public static final int IO_ERROR_CODE = 9900;
    public static final String IO_ERROR_TEXT = "An IO error occurred.";
    public static final int SAX_ERROR_CODE = 9910;
    public static final String SAX_ERROR_TEXT = "A XML syntax error occurred.";
    public static final int PROGRAMMING_ERROR_CODE = 9999;
    public static final String PROGRAMMING_ERROR_TEXT = "A programming error occurred.";

    private XmlSyntaxException(int code, String message) {
        super(code, message);
    }

    private XmlSyntaxException(int code, String message, Exception e) {
        super(code, message, e);
    }

    public static final XmlSyntaxException createUnexpectedTagException(String name) {
        return new XmlSyntaxException(9002, UNEXPECTED_TAG_TEXT + name);
    }

    public static final XmlSyntaxException createUnexpectedTextDataException(String name, String value) {
        return new XmlSyntaxException(9003, UNEXPECTED_DATA_TEXT + name);
    }

    public static final XmlSyntaxException createMissingAttributeException(String name, String attribute) {
        return new XmlSyntaxException(9004, MISSING_ATTRIBUTE_TEXT_1 + attribute + " in tag: " + name);
    }

    public static final XmlSyntaxException createEmptyAttributeException(String name, String attribute) {
        return new XmlSyntaxException(9004, EMPTY_ATTRIBUTE_TEXT_1 + attribute + " in tag: " + name);
    }

    public static final XmlSyntaxException createByIOException(IOException e) {
        return new XmlSyntaxException(9999, PROGRAMMING_ERROR_TEXT, e);
    }

    public static final XmlSyntaxException createBySAXException(SAXException e) {
        return new XmlSyntaxException(9999, PROGRAMMING_ERROR_TEXT, e);
    }

    public static final XmlSyntaxException createByRuntimeException(RuntimeException e) {
        return new XmlSyntaxException(9999, PROGRAMMING_ERROR_TEXT, e);
    }
}

