/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.visitor;

import java.util.Stack;
import org.qedeq.kernel.se.base.list.Atom;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.list.ElementList;
import org.qedeq.kernel.se.base.module.Add;
import org.qedeq.kernel.se.base.module.Author;
import org.qedeq.kernel.se.base.module.AuthorList;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.Chapter;
import org.qedeq.kernel.se.base.module.ChapterList;
import org.qedeq.kernel.se.base.module.Existential;
import org.qedeq.kernel.se.base.module.FormalProof;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.FormalProofList;
import org.qedeq.kernel.se.base.module.Formula;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Header;
import org.qedeq.kernel.se.base.module.Import;
import org.qedeq.kernel.se.base.module.ImportList;
import org.qedeq.kernel.se.base.module.Latex;
import org.qedeq.kernel.se.base.module.LatexList;
import org.qedeq.kernel.se.base.module.LinkList;
import org.qedeq.kernel.se.base.module.LiteratureItem;
import org.qedeq.kernel.se.base.module.LiteratureItemList;
import org.qedeq.kernel.se.base.module.Location;
import org.qedeq.kernel.se.base.module.LocationList;
import org.qedeq.kernel.se.base.module.ModusPonens;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proof;
import org.qedeq.kernel.se.base.module.ProofList;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Qedeq;
import org.qedeq.kernel.se.base.module.Reason;
import org.qedeq.kernel.se.base.module.Rename;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.Section;
import org.qedeq.kernel.se.base.module.SectionList;
import org.qedeq.kernel.se.base.module.Specification;
import org.qedeq.kernel.se.base.module.Subsection;
import org.qedeq.kernel.se.base.module.SubsectionList;
import org.qedeq.kernel.se.base.module.SubstFree;
import org.qedeq.kernel.se.base.module.SubstFunc;
import org.qedeq.kernel.se.base.module.SubstPred;
import org.qedeq.kernel.se.base.module.Term;
import org.qedeq.kernel.se.base.module.Universal;
import org.qedeq.kernel.se.base.module.UsedByList;
import org.qedeq.kernel.se.base.module.VariableList;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.dto.module.FormulaVo;
import org.qedeq.kernel.se.dto.module.TermVo;
import org.qedeq.kernel.se.visitor.InterruptException;
import org.qedeq.kernel.se.visitor.LatexList2Text;
import org.qedeq.kernel.se.visitor.QedeqNumbers;
import org.qedeq.kernel.se.visitor.QedeqTraverser;
import org.qedeq.kernel.se.visitor.QedeqVisitor;

public class QedeqNotNullTraverser
implements QedeqTraverser {
    private final ModuleContext currentContext;
    private final Stack location = new Stack();
    private QedeqNumbers data;
    private final LatexList2Text transform = new LatexList2Text();
    private QedeqVisitor visitor;
    private boolean blocked;
    private Node node;

    public QedeqNotNullTraverser(ModuleAddress globalContext, QedeqVisitor visitor) {
        this.currentContext = globalContext.createModuleContext();
        this.visitor = visitor;
    }

    public void accept(Qedeq qedeq) throws ModuleDataException {
        this.setLocation("started");
        if (qedeq == null) {
            throw new NullPointerException("null QEDEQ module");
        }
        this.data = new QedeqNumbers(qedeq.getHeader() != null && qedeq.getHeader().getImportList() != null ? qedeq.getHeader().getImportList().size() : 0, qedeq.getChapterList() != null ? qedeq.getChapterList().size() : 0);
        this.getCurrentContext().setLocationWithinModule("");
        this.checkForInterrupt();
        this.blocked = false;
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(qedeq);
        if (qedeq.getHeader() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getHeader()");
            this.accept(qedeq.getHeader());
        }
        if (qedeq.getChapterList() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getChapterList()");
            this.accept(qedeq.getChapterList());
        }
        if (qedeq.getLiteratureItemList() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getLiteratureItemList()");
            this.accept(qedeq.getLiteratureItemList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(qedeq);
        this.setLocationWithinModule(context);
        this.setLocation("finished");
        this.data.setFinished(true);
    }

    private void checkForInterrupt() throws InterruptException {
        if (Thread.interrupted()) {
            throw new InterruptException(this.getCurrentContext());
        }
    }

    public void accept(Header header) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || header == null) {
            return;
        }
        this.setLocation("analyzing header");
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(header);
        if (header.getSpecification() != null) {
            this.setLocationWithinModule(context + ".getSpecification()");
            this.accept(header.getSpecification());
        }
        if (header.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            this.accept(header.getTitle());
        }
        if (header.getSummary() != null) {
            this.setLocationWithinModule(context + ".getSummary()");
            this.accept(header.getSummary());
        }
        if (header.getAuthorList() != null) {
            this.setLocationWithinModule(context + ".getAuthorList()");
            this.accept(header.getAuthorList());
        }
        if (header.getImportList() != null) {
            this.setLocationWithinModule(context + ".getImportList()");
            this.accept(header.getImportList());
        }
        if (header.getUsedByList() != null) {
            this.setLocationWithinModule(context + ".getUsedByList()");
            this.accept(header.getUsedByList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(header);
        this.setLocationWithinModule(context);
    }

    public void accept(UsedByList usedByList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || usedByList == null) {
            return;
        }
        this.location.push("working on used by list");
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(usedByList);
        for (int i = 0; i < usedByList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(usedByList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(usedByList);
        this.setLocationWithinModule(context);
        this.location.pop();
    }

    public void accept(ImportList importList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || importList == null) {
            return;
        }
        this.location.push("working on import list");
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(importList);
        for (int i = 0; i < importList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(importList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(importList);
        this.setLocationWithinModule(context);
        this.location.pop();
    }

    public void accept(Import imp) throws ModuleDataException {
        this.data.increaseImportNumber();
        this.checkForInterrupt();
        if (this.blocked || imp == null) {
            return;
        }
        this.location.push("import " + this.data.getImportNumber() + ": " + imp.getLabel());
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(imp);
        if (imp.getSpecification() != null) {
            this.setLocationWithinModule(context + ".getSpecification()");
            this.accept(imp.getSpecification());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(imp);
        this.setLocationWithinModule(context);
        this.location.pop();
    }

    public void accept(Specification specification) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || specification == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(specification);
        if (specification.getLocationList() != null) {
            this.setLocationWithinModule(context + ".getLocationList()");
            this.accept(specification.getLocationList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(specification);
        this.setLocationWithinModule(context);
    }

    public void accept(LocationList locationList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || locationList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(locationList);
        for (int i = 0; i < locationList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(locationList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(locationList);
        this.setLocationWithinModule(context);
    }

    public void accept(Location location) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || location == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(location);
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(location);
        this.setLocationWithinModule(context);
    }

    public void accept(AuthorList authorList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || authorList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(authorList);
        for (int i = 0; i < authorList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(authorList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(authorList);
        this.setLocationWithinModule(context);
    }

    public void accept(Author author) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || author == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(author);
        if (author.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            this.accept(author.getName());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(author);
        this.setLocationWithinModule(context);
    }

    public void accept(ChapterList chapterList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || chapterList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(chapterList);
        for (int i = 0; i < chapterList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(chapterList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(chapterList);
        this.setLocationWithinModule(context);
    }

    public void accept(Chapter chapter) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || chapter == null) {
            return;
        }
        this.data.increaseChapterNumber(chapter.getSectionList() != null ? chapter.getSectionList().size() : 0, chapter.getNoNumber() == null || chapter.getNoNumber() == false);
        if (this.data.isChapterNumbering()) {
            this.setLocation("Chapter " + this.data.getChapterNumber() + " " + this.transform.transform(chapter.getTitle()));
        } else {
            this.setLocation(this.transform.transform(chapter.getTitle()));
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(chapter);
        if (chapter.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            this.accept(chapter.getTitle());
        }
        if (chapter.getIntroduction() != null) {
            this.setLocationWithinModule(context + ".getIntroduction()");
            this.accept(chapter.getIntroduction());
        }
        if (chapter.getSectionList() != null) {
            this.setLocationWithinModule(context + ".getSectionList()");
            this.accept(chapter.getSectionList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(chapter);
        this.setLocationWithinModule(context);
    }

    public void accept(LiteratureItemList literatureItemList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || literatureItemList == null) {
            return;
        }
        this.setLocation("working on literature list");
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(literatureItemList);
        for (int i = 0; i < literatureItemList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(literatureItemList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(literatureItemList);
        this.setLocationWithinModule(context);
    }

    public void accept(LiteratureItem item) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || item == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(item);
        if (item.getItem() != null) {
            this.setLocationWithinModule(context + ".getItem()");
            this.accept(item.getItem());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(item);
        this.setLocationWithinModule(context);
    }

    public void accept(SectionList sectionList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || sectionList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(sectionList);
        for (int i = 0; i < sectionList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(sectionList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(sectionList);
        this.setLocationWithinModule(context);
    }

    public void accept(Section section) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || section == null) {
            return;
        }
        this.data.increaseSectionNumber(section.getSubsectionList() != null ? section.getSubsectionList().size() : 0, section.getNoNumber() == null || section.getNoNumber() == false);
        String title = "";
        if (this.data.isChapterNumbering()) {
            title = title + this.data.getChapterNumber();
        }
        if (this.data.isSectionNumbering()) {
            title = title + (title.length() > 0 ? "." : "") + this.data.getSectionNumber();
        }
        if (section.getTitle() != null) {
            title = title + " " + this.transform.transform(section.getTitle());
        }
        this.location.push(title);
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(section);
        if (section.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            this.accept(section.getTitle());
        }
        if (section.getIntroduction() != null) {
            this.setLocationWithinModule(context + ".getIntroduction()");
            this.accept(section.getIntroduction());
        }
        if (section.getSubsectionList() != null) {
            this.setLocationWithinModule(context + ".getSubsectionList()");
            this.accept(section.getSubsectionList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(section);
        this.setLocationWithinModule(context);
        this.location.pop();
    }

    public void accept(SubsectionList subsectionList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || subsectionList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(subsectionList);
        for (int i = 0; i < subsectionList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            if (subsectionList.get(i) instanceof Subsection) {
                this.accept((Subsection)subsectionList.get(i));
                continue;
            }
            if (subsectionList.get(i) instanceof Node) {
                this.accept((Node)subsectionList.get(i));
                continue;
            }
            if (subsectionList.get(i) == null) continue;
            throw new IllegalArgumentException("unexpected subsection type: " + subsectionList.get(i).getClass());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(subsectionList);
        this.setLocationWithinModule(context);
    }

    public void accept(Subsection subsection) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || subsection == null) {
            return;
        }
        this.data.increaseSubsectionNumber();
        String title = "";
        if (this.data.isChapterNumbering()) {
            title = title + this.data.getChapterNumber();
        }
        if (this.data.isSectionNumbering()) {
            title = title + (title.length() > 0 ? "." : "") + this.data.getSectionNumber();
        }
        title = title + (title.length() > 0 ? "." : "") + this.data.getSubsectionNumber();
        if (subsection.getTitle() != null) {
            title = title + " " + this.transform.transform(subsection.getTitle());
        }
        title = title + " [" + subsection.getId() + "]";
        this.location.push(title);
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(subsection);
        if (subsection.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            this.accept(subsection.getTitle());
        }
        if (subsection.getLatex() != null) {
            this.setLocationWithinModule(context + ".getLatex()");
            this.accept(subsection.getLatex());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(subsection);
        this.setLocationWithinModule(context);
        this.location.pop();
    }

    public void accept(Node node) throws ModuleDataException {
        this.checkForInterrupt();
        this.data.increaseNodeNumber();
        if (this.blocked || node == null) {
            return;
        }
        this.node = node;
        String title = "";
        if (node.getTitle() != null) {
            title = this.transform.transform(node.getTitle());
        }
        title = title + " [" + node.getId() + "]";
        this.location.push(title);
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(node);
        if (node.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            this.accept(node.getName());
        }
        if (node.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            this.accept(node.getTitle());
        }
        if (node.getPrecedingText() != null) {
            this.setLocationWithinModule(context + ".getPrecedingText()");
            this.accept(node.getPrecedingText());
        }
        if (node.getNodeType() != null) {
            this.setLocationWithinModule(context + ".getNodeType()");
            if (node.getNodeType() instanceof Axiom) {
                this.setLocationWithinModule(context + ".getNodeType().getAxiom()");
                this.accept((Axiom)node.getNodeType());
            } else if (node.getNodeType() instanceof PredicateDefinition) {
                this.setLocationWithinModule(context + ".getNodeType().getPredicateDefinition()");
                this.accept((PredicateDefinition)node.getNodeType());
            } else if (node.getNodeType() instanceof FunctionDefinition) {
                this.setLocationWithinModule(context + ".getNodeType().getFunctionDefinition()");
                this.accept((FunctionDefinition)node.getNodeType());
            } else if (node.getNodeType() instanceof Proposition) {
                this.setLocationWithinModule(context + ".getNodeType().getProposition()");
                this.accept((Proposition)node.getNodeType());
            } else if (node.getNodeType() instanceof Rule) {
                this.setLocationWithinModule(context + ".getNodeType().getRule()");
                this.accept((Rule)node.getNodeType());
            } else {
                throw new IllegalArgumentException("unexpected node type: " + node.getNodeType().getClass());
            }
        }
        if (node.getSucceedingText() != null) {
            this.setLocationWithinModule(context + ".getSucceedingText()");
            this.accept(node.getSucceedingText());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(node);
        this.setLocationWithinModule(context);
        this.location.pop();
        this.node = null;
    }

    public void accept(Axiom axiom) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || axiom == null) {
            return;
        }
        this.data.increaseAxiomNumber();
        this.location.set(this.location.size() - 1, "Axiom " + this.data.getAxiomNumber() + " " + (String)this.location.lastElement());
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(axiom);
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            this.accept(axiom.getFormula());
        }
        if (axiom.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            this.accept(axiom.getDescription());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(axiom);
        this.setLocationWithinModule(context);
    }

    public void accept(PredicateDefinition definition) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || definition == null) {
            return;
        }
        this.data.increasePredicateDefinitionNumber();
        this.location.set(this.location.size() - 1, "Definition " + (this.data.getPredicateDefinitionNumber() + this.data.getFunctionDefinitionNumber()) + " " + (String)this.location.lastElement());
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(definition);
        if (definition.getVariableList() != null) {
            this.setLocationWithinModule(context + ".getVariableList()");
            this.accept(definition.getVariableList());
        }
        if (definition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            this.accept(definition.getFormula());
        }
        if (definition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            this.accept(definition.getDescription());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(definition);
        this.setLocationWithinModule(context);
    }

    public void accept(FunctionDefinition definition) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || definition == null) {
            return;
        }
        this.data.increaseFunctionDefinitionNumber();
        this.location.set(this.location.size() - 1, "Definition " + (this.data.getPredicateDefinitionNumber() + this.data.getFunctionDefinitionNumber()) + " " + (String)this.location.lastElement());
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(definition);
        if (definition.getVariableList() != null) {
            this.setLocationWithinModule(context + ".getVariableList()");
            this.accept(definition.getVariableList());
        }
        if (definition.getTerm() != null) {
            this.setLocationWithinModule(context + ".getTerm()");
            this.accept(definition.getTerm());
        }
        if (definition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            this.accept(definition.getDescription());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(definition);
        this.setLocationWithinModule(context);
    }

    public void accept(Proposition proposition) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || proposition == null) {
            return;
        }
        this.data.increasePropositionNumber();
        this.location.set(this.location.size() - 1, "Proposition " + this.data.getPropositionNumber() + " " + (String)this.location.lastElement());
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(proposition);
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            this.accept(proposition.getFormula());
        }
        if (proposition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            this.accept(proposition.getDescription());
        }
        if (proposition.getProofList() != null) {
            this.setLocationWithinModule(context + ".getProofList()");
            this.accept(proposition.getProofList());
        }
        if (proposition.getFormalProofList() != null) {
            this.setLocationWithinModule(context + ".getFormalProofList()");
            this.accept(proposition.getFormalProofList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(proposition);
        this.setLocationWithinModule(context);
    }

    public void accept(Rule rule) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || rule == null) {
            return;
        }
        this.data.increaseRuleNumber();
        this.location.set(this.location.size() - 1, "Rule " + this.data.getRuleNumber() + " " + (String)this.location.lastElement());
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(rule);
        if (rule.getLinkList() != null) {
            this.setLocationWithinModule(context + ".getLinkList()");
            this.accept(rule.getLinkList());
        }
        if (rule.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            this.accept(rule.getDescription());
        }
        if (rule.getProofList() != null) {
            this.setLocationWithinModule(context + ".getProofList()");
            this.accept(rule.getProofList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(rule);
        this.setLocationWithinModule(context);
    }

    public void accept(LinkList linkList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || linkList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(linkList);
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(linkList);
        this.setLocationWithinModule(context);
    }

    public void accept(VariableList variableList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || variableList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(variableList);
        for (int i = 0; i < variableList.size(); ++i) {
            String piece = context + ".get(" + i + ")";
            this.setLocationWithinModule(piece);
            if (variableList.get(i) == null) continue;
            if (variableList.get(i).isList()) {
                this.setLocationWithinModule(piece + ".getList()");
                this.accept(variableList.get(i).getList());
                continue;
            }
            if (variableList.get(i).isAtom()) {
                this.setLocationWithinModule(piece + ".getAtom()");
                this.accept(variableList.get(i).getAtom());
                continue;
            }
            throw new IllegalArgumentException("unexpected element type: " + ((Object)variableList.get(i)).toString());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(variableList);
        this.setLocationWithinModule(context);
    }

    public void accept(ProofList proofList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || proofList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(proofList);
        for (int i = 0; i < proofList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(proofList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(proofList);
        this.setLocationWithinModule(context);
    }

    public void accept(Proof proof) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || proof == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(proof);
        if (proof.getNonFormalProof() != null) {
            this.setLocationWithinModule(context + ".getNonFormalProof()");
            this.accept(proof.getNonFormalProof());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(proof);
        this.setLocationWithinModule(context);
    }

    public void accept(FormalProofList proofList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || proofList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(proofList);
        for (int i = 0; i < proofList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(proofList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(proofList);
        this.setLocationWithinModule(context);
    }

    public void accept(FormalProof proof) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || proof == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(proof);
        if (proof.getPrecedingText() != null) {
            this.setLocationWithinModule(context + ".getPrecedingText()");
            this.accept(proof.getFormalProofLineList());
        }
        if (proof.getFormalProofLineList() != null) {
            this.setLocationWithinModule(context + ".getFormalProofLineList()");
            this.accept(proof.getFormalProofLineList());
        }
        if (proof.getSucceedingText() != null) {
            this.setLocationWithinModule(context + ".getSucceedingText()");
            this.accept(proof.getFormalProofLineList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(proof);
        this.setLocationWithinModule(context);
    }

    public void accept(FormalProofLineList proofLineList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || proofLineList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(proofLineList);
        for (int i = 0; i < proofLineList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(proofLineList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(proofLineList);
        this.setLocationWithinModule(context);
    }

    public void accept(FormalProofLine proofLine) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || proofLine == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(proofLine);
        if (proofLine.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            this.accept(proofLine.getFormula());
        }
        if (proofLine.getReason() != null) {
            Reason reason = proofLine.getReason();
            if (reason instanceof ModusPonens) {
                this.setLocationWithinModule(context + ".getModusPonens()");
                this.accept(proofLine.getModusPonens());
            } else if (reason instanceof Add) {
                this.setLocationWithinModule(context + ".getAdd()");
                this.accept(proofLine.getAdd());
            } else if (reason instanceof Rename) {
                this.setLocationWithinModule(context + ".getRename()");
                this.accept(proofLine.getRename());
            } else if (reason instanceof SubstFree) {
                this.setLocationWithinModule(context + ".getSubstFree()");
                this.accept(proofLine.getSubstFree());
            } else if (reason instanceof SubstFunc) {
                this.setLocationWithinModule(context + ".getSubstFunc()");
                this.accept(proofLine.getSubstFunc());
            } else if (reason instanceof SubstPred) {
                this.setLocationWithinModule(context + ".getSubstPred()");
                this.accept(proofLine.getSubstPred());
            } else if (reason instanceof Existential) {
                this.setLocationWithinModule(context + ".getExistential()");
                this.accept(proofLine.getExistential());
            } else if (reason instanceof Universal) {
                this.setLocationWithinModule(context + ".getUniversal()");
                this.accept(proofLine.getUniversal());
            } else {
                throw new IllegalArgumentException("unexpected reason type: " + reason.getClass());
            }
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(proofLine);
        this.setLocationWithinModule(context);
    }

    public void accept(ModusPonens reason) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || reason == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(reason);
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(reason);
        this.setLocationWithinModule(context);
    }

    public void accept(Add reason) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || reason == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(reason);
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(reason);
        this.setLocationWithinModule(context);
    }

    public void accept(Rename reason) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || reason == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(reason);
        if (reason.getOriginalSubjectVariable() != null) {
            this.setLocationWithinModule(context + ".getOriginalSubjectVariable()");
            this.accept(reason.getOriginalSubjectVariable());
        }
        if (reason.getReplacementSubjectVariable() != null) {
            this.setLocationWithinModule(context + ".getReplacementSubjectVariable()");
            this.accept(reason.getReplacementSubjectVariable());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(reason);
        this.setLocationWithinModule(context);
    }

    public void accept(SubstFree reason) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || reason == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(reason);
        if (reason.getSubjectVariable() != null) {
            this.setLocationWithinModule(context + ".getSubjectVariable()");
            this.accept(reason.getSubjectVariable());
        }
        if (reason.getSubstituteTerm() != null) {
            this.setLocationWithinModule(context + ".getSubstituteTerm()");
            this.accept(new TermVo(reason.getSubstituteTerm()));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(reason);
        this.setLocationWithinModule(context);
    }

    public void accept(SubstFunc reason) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || reason == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(reason);
        if (reason.getFunctionVariable() != null) {
            this.setLocationWithinModule(context + ".getFunctionVariable()");
            this.accept(reason.getFunctionVariable());
        }
        if (reason.getSubstituteTerm() != null) {
            this.setLocationWithinModule(context + ".getSubstituteTerm()");
            this.accept(new TermVo(reason.getSubstituteTerm()));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(reason);
        this.setLocationWithinModule(context);
    }

    public void accept(SubstPred reason) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || reason == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(reason);
        if (reason.getPredicateVariable() != null) {
            this.setLocationWithinModule(context + ".getPredicateVariable()");
            this.accept(reason.getPredicateVariable());
        }
        if (reason.getSubstituteFormula() != null) {
            this.setLocationWithinModule(context + ".getSubstituteFormula()");
            this.accept(new FormulaVo(reason.getSubstituteFormula()));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(reason);
        this.setLocationWithinModule(context);
    }

    public void accept(Existential reason) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || reason == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(reason);
        if (reason.getSubjectVariable() != null) {
            this.setLocationWithinModule(context + ".getSubjectVariable()");
            this.accept(reason.getSubjectVariable());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(reason);
        this.setLocationWithinModule(context);
    }

    public void accept(Universal reason) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || reason == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(reason);
        if (reason.getSubjectVariable() != null) {
            this.setLocationWithinModule(context + ".getSubjectVariable()");
            this.accept(reason.getSubjectVariable());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(reason);
        this.setLocationWithinModule(context);
    }

    public void accept(Formula formula) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || formula == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(formula);
        if (formula.getElement() != null) {
            this.setLocationWithinModule(context + ".getElement()");
            this.accept(formula.getElement());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(formula);
        this.setLocationWithinModule(context);
    }

    public void accept(Term term) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || term == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(term);
        if (term.getElement() != null) {
            this.setLocationWithinModule(context + ".getElement()");
            this.accept(term.getElement());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(term);
        this.setLocationWithinModule(context);
    }

    public void accept(Element element) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || element == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (element.isList()) {
            this.setLocationWithinModule(context + ".getList()");
            this.accept(element.getList());
        } else if (element.isAtom()) {
            this.setLocationWithinModule(context + ".getAtom()");
            this.accept(element.getAtom());
        } else {
            throw new IllegalArgumentException("unexpected element type: " + ((Object)element).toString());
        }
        this.setLocationWithinModule(context);
    }

    public void accept(Atom atom) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || atom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(atom);
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(atom);
        this.setLocationWithinModule(context);
    }

    public void accept(ElementList list) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || list == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(list);
        for (int i = 0; i < list.size(); ++i) {
            this.setLocationWithinModule(context + ".getElement(" + i + ")");
            this.accept(list.getElement(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(list);
        this.setLocationWithinModule(context);
    }

    public void accept(LatexList latexList) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || latexList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(latexList);
        for (int i = 0; i < latexList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(latexList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(latexList);
        this.setLocationWithinModule(context);
    }

    public void accept(Latex latex) throws ModuleDataException {
        this.checkForInterrupt();
        if (this.blocked || latex == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(latex);
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(latex);
        this.setLocationWithinModule(context);
    }

    public Node getNode() {
        return this.node;
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    public final ModuleContext getCurrentContext() {
        return this.currentContext;
    }

    public final boolean getBlocked() {
        return this.blocked;
    }

    public final void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public double getVisitPercentage() {
        if (this.data == null) {
            return 0.0;
        }
        return this.data.getVisitPercentage();
    }

    private void setLocation(String text) {
        this.location.setSize(0);
        this.location.push(text);
    }

    public String getVisitAction() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.location.size(); ++i) {
            if (i > 0) {
                buffer.append(" / ");
            }
            buffer.append(this.location.get(i));
        }
        return buffer.toString();
    }

    public QedeqNumbers getCurrentNumbers() {
        return new QedeqNumbers(this.data);
    }
}

