/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.common;

import org.qedeq.base.io.SourcePosition;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.kernel.se.common.ModuleAddress;

public class ModuleContext {
    private static final Class CLASS = ModuleContext.class;
    private ModuleAddress moduleLocation;
    private String locationWithinModule;
    private final SourcePosition startDelta;
    private final SourcePosition endDelta;

    public ModuleContext(ModuleAddress moduleLocation, String locationWithinModule, SourcePosition startDelta, SourcePosition endDelta) {
        if (moduleLocation == null) {
            throw new NullPointerException("module adress should not be null");
        }
        if (locationWithinModule == null) {
            throw new NullPointerException("location within module should not be null");
        }
        this.moduleLocation = moduleLocation;
        this.locationWithinModule = locationWithinModule;
        this.startDelta = startDelta;
        this.endDelta = endDelta;
    }

    public ModuleContext(ModuleAddress moduleLocation, String locationWithinModule) {
        this(moduleLocation, locationWithinModule, null, null);
    }

    public ModuleContext(ModuleAddress moduleLocation) {
        this(moduleLocation, "");
    }

    public ModuleContext(ModuleContext original) {
        this(original.getModuleLocation(), original.getLocationWithinModule(), original.getStartDelta(), original.getEndDelta());
    }

    public ModuleContext(ModuleContext main, String moduleLocation) {
        this(main.getModuleLocation(), moduleLocation);
    }

    public final ModuleAddress getModuleLocation() {
        return this.moduleLocation;
    }

    public final String getLocationWithinModule() {
        return this.locationWithinModule;
    }

    public final void setLocationWithinModule(String locationWithinModule) {
        String method = "setLocationWithinModule(String)";
        this.locationWithinModule = locationWithinModule;
        Trace.param(CLASS, (Object)this, "setLocationWithinModule(String)", "locationWithinModule", locationWithinModule);
    }

    public final SourcePosition getStartDelta() {
        return this.startDelta;
    }

    public final SourcePosition getEndDelta() {
        return this.endDelta;
    }

    public final int hashCode() {
        return this.getModuleLocation().hashCode() ^ this.getLocationWithinModule().hashCode() ^ (this.startDelta != null ? this.startDelta.hashCode() : 7) ^ (this.endDelta != null ? this.endDelta.hashCode() : 11);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof ModuleContext)) {
            return false;
        }
        ModuleContext other = (ModuleContext)obj;
        return this.getModuleLocation().equals(other.getModuleLocation()) && this.getLocationWithinModule().equals(other.getLocationWithinModule()) && EqualsUtility.equals(this.startDelta, other.startDelta) && EqualsUtility.equals(this.endDelta, other.endDelta);
    }

    public final String toString() {
        return this.getModuleLocation() + ":" + this.getLocationWithinModule() + ":" + this.startDelta + ":" + this.endDelta;
    }
}

