/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.common;

import org.qedeq.kernel.se.common.State;

public final class LoadingState
implements State {
    public static final LoadingState STATE_UNDEFINED = new LoadingState("undefined", false, 0);
    public static final LoadingState STATE_LOCATING_WITHIN_WEB = new LoadingState("locating within web", false, 1);
    public static final LoadingState STATE_LOCATING_WITHIN_WEB_FAILED = new LoadingState("locating within web failed", true, 2);
    public static final LoadingState STATE_LOADING_FROM_WEB = new LoadingState("loading from web", false, 3);
    public static final LoadingState STATE_LOADING_FROM_WEB_FAILED = new LoadingState("loading from web failed", true, 4);
    public static final LoadingState STATE_LOADING_FROM_LOCAL_FILE = new LoadingState("loading from local file", false, 5);
    public static final LoadingState STATE_LOADING_FROM_LOCAL_FILE_FAILED = new LoadingState("loading from web failed", true, 6);
    public static final LoadingState STATE_LOADING_FROM_BUFFER = new LoadingState("loading from local buffer", false, 7);
    public static final LoadingState STATE_LOADING_FROM_BUFFER_FAILED = new LoadingState("loading from local buffer failed", true, 8);
    public static final LoadingState STATE_LOADING_INTO_MEMORY = new LoadingState("loading into memory", false, 9);
    public static final LoadingState STATE_LOADING_INTO_MEMORY_FAILED = new LoadingState("loading into memory failed", true, 10);
    public static final LoadingState STATE_LOADED = new LoadingState("loaded", false, 11);
    public static final LoadingState STATE_DELETED = new LoadingState("deleted", false, -1);
    private final String text;
    private final boolean failure;
    private final int code;

    private LoadingState(String text, boolean failure, int code) {
        this.text = text;
        if (this.text == null) {
            throw new IllegalArgumentException("text==null");
        }
        this.failure = failure;
        this.code = code;
    }

    public String getText() {
        return this.text;
    }

    public boolean isFailure() {
        return this.failure;
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return this.text;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }
}

