/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.se.common;

import org.qedeq.kernel.se.common.State;

public final class DependencyState
implements State {
    public static final DependencyState STATE_UNDEFINED = new DependencyState("undefined", false, 0);
    public static final DependencyState STATE_LOADING_REQUIRED_MODULES = new DependencyState("loading required modules", false, 11);
    public static final DependencyState STATE_LOADING_REQUIRED_MODULES_FAILED = new DependencyState("loading required modules failed", true, 12);
    public static final DependencyState STATE_LOADED_REQUIRED_MODULES = new DependencyState("loaded required modules", false, 15);
    private final String text;
    private final boolean failure;
    private final int code;

    private DependencyState(String text, boolean failure, int code) {
        this.text = text;
        if (this.text == null) {
            throw new IllegalArgumentException("text==null");
        }
        this.failure = failure;
        this.code = code;
    }

    public String getText() {
        return this.text;
    }

    public boolean isFailure() {
        return this.failure;
    }

    public boolean areAllRequiredLoaded() {
        return this.code == STATE_LOADED_REQUIRED_MODULES.getCode();
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return this.text;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }
}

