/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.logic;

import java.util.Map;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.common.PluginExecutor;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.logic.FormulaCheckerFactoryImpl;
import org.qedeq.kernel.bo.logic.common.FormulaCheckerFactory;
import org.qedeq.kernel.bo.logic.common.Function;
import org.qedeq.kernel.bo.logic.common.LogicalCheckExceptionList;
import org.qedeq.kernel.bo.logic.common.Predicate;
import org.qedeq.kernel.bo.logic.wf.FormulaUtility;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelModuleReferenceList;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.service.logic.CheckRequiredModuleException;
import org.qedeq.kernel.bo.service.logic.ModuleConstantsExistenceCheckerImpl;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.Formula;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.Term;
import org.qedeq.kernel.se.base.module.VariableList;
import org.qedeq.kernel.se.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.se.common.IllegalModuleDataException;
import org.qedeq.kernel.se.common.LogicalState;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.list.ElementSet;

public final class QedeqBoFormalLogicCheckerExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = QedeqBoFormalLogicCheckerExecutor.class;
    private ModuleConstantsExistenceCheckerImpl existence;
    private FormulaCheckerFactory checkerFactory = null;
    private Map parameters;

    QedeqBoFormalLogicCheckerExecutor(Plugin plugin, KernelQedeqBo qedeq, Map parameters) {
        super(plugin, qedeq);
        String checkerFactoryClass;
        String method = "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)";
        this.parameters = parameters;
        String string = checkerFactoryClass = parameters != null ? (String)parameters.get("checkerFactory") : null;
        if (checkerFactoryClass != null && checkerFactoryClass.length() > 0) {
            try {
                Class<?> cl = Class.forName(checkerFactoryClass);
                this.checkerFactory = (FormulaCheckerFactory)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "FormulaCheckerFactory class not in class path: " + checkerFactoryClass, e);
            }
            catch (InstantiationException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "FormulaCheckerFactory class could not be instanciated: " + checkerFactoryClass, e);
            }
            catch (IllegalAccessException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "Programming error, access for instantiation failed for model: " + checkerFactoryClass, e);
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "QedeqBoFormalLogicChecker(Plugin, KernelQedeqBo, Map)", "Programming error, instantiation failed for model: " + checkerFactoryClass, e);
            }
        }
        if (this.checkerFactory == null) {
            this.checkerFactory = new FormulaCheckerFactoryImpl();
        }
    }

    private Map getParameters() {
        return this.parameters;
    }

    public Object executePlugin() {
        if (this.getQedeqBo().isChecked()) {
            return Boolean.TRUE;
        }
        QedeqLog.getInstance().logRequest("Check logical correctness for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"");
        KernelContext.getInstance().loadModule(this.getQedeqBo().getModuleAddress());
        if (!this.getQedeqBo().isLoaded()) {
            String msg = "Check of logical correctness failed for \"" + this.getQedeqBo().getUrl() + "\"";
            QedeqLog.getInstance().logFailureReply(msg, "Module could not even be loaded.");
            return Boolean.FALSE;
        }
        KernelContext.getInstance().loadRequiredModules(this.getQedeqBo().getModuleAddress());
        if (!this.getQedeqBo().hasLoadedRequiredModules()) {
            String msg = "Check of logical correctness failed for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            QedeqLog.getInstance().logFailureReply(msg, "Not all required modules could be loaded.");
            return Boolean.FALSE;
        }
        this.getQedeqBo().setLogicalProgressState(LogicalState.STATE_EXTERNAL_CHECKING);
        DefaultSourceFileExceptionList sfl = new DefaultSourceFileExceptionList();
        KernelModuleReferenceList list = (KernelModuleReferenceList)this.getQedeqBo().getRequiredModules();
        for (int i = 0; i < list.size(); ++i) {
            Trace.trace(CLASS, (Object)"check(DefaultQedeqBo)", "checking label", list.getLabel(i));
            QedeqBoFormalLogicCheckerExecutor checker = new QedeqBoFormalLogicCheckerExecutor(this.getPlugin(), list.getKernelQedeqBo(i), this.getParameters());
            checker.executePlugin();
            if (list.getKernelQedeqBo(i).isChecked()) continue;
            CheckRequiredModuleException md = new CheckRequiredModuleException(11231, "import check failed: " + list.getQedeqBo(i).getModuleAddress(), list.getModuleContext(i));
            ((SourceFileExceptionList)sfl).add(this.getQedeqBo().createSourceFileException(this.getPlugin(), md));
        }
        if (((SourceFileExceptionList)sfl).size() > 0) {
            this.getQedeqBo().setLogicalFailureState(LogicalState.STATE_EXTERNAL_CHECKING_FAILED, sfl);
            String msg = "Check of logical correctness failed for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            QedeqLog.getInstance().logFailureReply(msg, ((Throwable)sfl).getMessage());
            return Boolean.FALSE;
        }
        this.getQedeqBo().setLogicalProgressState(LogicalState.STATE_INTERNAL_CHECKING);
        this.getQedeqBo().setExistenceChecker(this.existence);
        try {
            this.traverse();
        }
        catch (SourceFileExceptionList e) {
            this.getQedeqBo().setLogicalFailureState(LogicalState.STATE_INTERNAL_CHECKING_FAILED, e);
            String msg = "Check of logical correctness failed for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
            QedeqLog.getInstance().logFailureReply(msg, ((Throwable)sfl).getMessage());
            return Boolean.FALSE;
        }
        this.getQedeqBo().setChecked(this.existence);
        QedeqLog.getInstance().logSuccessfulReply("Check of logical correctness successful for \"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"");
        return Boolean.TRUE;
    }

    public void traverse() throws SourceFileExceptionList {
        try {
            this.existence = new ModuleConstantsExistenceCheckerImpl(this.getQedeqBo());
        }
        catch (ModuleDataException me) {
            this.addError(me);
            throw this.getErrorList();
        }
        super.traverse();
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = axiom.getFormula();
            LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        Predicate predicate = new Predicate(definition.getName(), definition.getArgumentNumber());
        if (this.existence.predicateExists(predicate)) {
            this.addError(new IllegalModuleDataException(40400, "predicate was already defined for this argument number: " + predicate, this.getCurrentContext()));
        }
        if (definition.getFormula() != null) {
            Formula formula = definition.getFormula();
            VariableList variableList = definition.getVariableList();
            int size = variableList == null ? 0 : variableList.size();
            ElementSet free = FormulaUtility.getFreeSubjectVariables(formula.getElement());
            for (int i = 0; i < size; ++i) {
                this.setLocationWithinModule(context + ".getVariableList().get(" + i + ")");
                if (!FormulaUtility.isSubjectVariable(variableList.get(i))) {
                    this.addError(new IllegalModuleDataException(40500, "a subject variable was expected here, but we found: " + variableList.get(i), this.getCurrentContext()));
                }
                if (free.contains(variableList.get(i))) continue;
                this.addError(new IllegalModuleDataException(40510, "subject variable doesn't occur free in formula or term: " + variableList.get(i), this.getCurrentContext()));
            }
            this.setLocationWithinModule(context);
            if (size != free.size()) {
                this.addError(new IllegalModuleDataException(40520, "number of subject variables in definition not equal to number of free subject variables of formula or term", this.getCurrentContext()));
            }
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        }
        this.existence.add(definition);
        if ("2".equals(predicate.getArguments()) && "equal".equals(predicate.getName())) {
            this.existence.setIdentityOperatorDefined(predicate.getName(), this.getQedeqBo(), this.getCurrentContext());
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        Function function = new Function(definition.getName(), definition.getArgumentNumber());
        if (this.existence.functionExists(function)) {
            this.addError(new IllegalModuleDataException(40400, "function was already defined for this argument number: " + function, this.getCurrentContext()));
        }
        if (definition.getTerm() != null) {
            Term term = definition.getTerm();
            VariableList variableList = definition.getVariableList();
            int size = variableList == null ? 0 : variableList.size();
            ElementSet free = FormulaUtility.getFreeSubjectVariables(term.getElement());
            for (int i = 0; i < size; ++i) {
                this.setLocationWithinModule(context + ".getVariableList().get(" + i + ")");
                if (!FormulaUtility.isSubjectVariable(variableList.get(i))) {
                    this.addError(new IllegalModuleDataException(40500, "a subject variable was expected here, but we found: " + variableList.get(i), this.getCurrentContext()));
                }
                if (free.contains(variableList.get(i))) continue;
                this.addError(new IllegalModuleDataException(40510, "subject variable doesn't occur free in formula or term: " + variableList.get(i), this.getCurrentContext()));
            }
            this.setLocationWithinModule(context);
            if (size != free.size()) {
                this.addError(new IllegalModuleDataException(40520, "number of subject variables in definition not equal to number of free subject variables of formula or term", this.getCurrentContext()));
            }
            this.setLocationWithinModule(context + ".getTerm().getElement()");
            LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkTerm(term.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        }
        this.existence.add(definition);
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = proposition.getFormula();
            LogicalCheckExceptionList list = this.checkerFactory.createFormulaChecker().checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
            for (int i = 0; i < list.size(); ++i) {
                this.addError(list.get(i));
            }
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(Proposition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        if (rule == null) {
            return;
        }
        if (rule.getName() != null && "SET_DEFINION_BY_FORMULA".equals(rule.getName())) {
            this.existence.setClassOperatorModule(this.getQedeqBo(), this.getCurrentContext());
        }
        this.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.setBlocked(false);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }
}

