/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.latex;

import java.util.HashMap;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.service.latex.LatexListDataException;
import org.qedeq.kernel.se.base.module.Latex;
import org.qedeq.kernel.se.base.module.LatexList;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

public final class QedeqBoDuplicateLanguageChecker
extends ControlVisitor {
    public static void check(Plugin plugin, KernelQedeqBo prop) throws SourceFileExceptionList {
        QedeqBoDuplicateLanguageChecker checker = new QedeqBoDuplicateLanguageChecker(plugin, prop);
        checker.traverse();
    }

    private QedeqBoDuplicateLanguageChecker(Plugin plugin, KernelQedeqBo bo) {
        super(plugin, bo);
    }

    public final void visitEnter(LatexList list) throws ModuleDataException {
        if (list == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        HashMap<String, ModuleContext> languages = new HashMap<String, ModuleContext>();
        for (int i = 0; i < list.size(); ++i) {
            Latex latex = list.get(i);
            this.setLocationWithinModule(context + ".get(" + i + ")");
            if (latex == null) {
                throw new LatexListDataException(1000, "Null pointer not permitted.", this.getCurrentContext());
            }
            if (languages.containsKey(latex.getLanguage())) {
                throw new LatexListDataException(1001, "Language entry exists already", this.getCurrentContext(), (ModuleContext)languages.get(latex.getLanguage()));
            }
            languages.put(list.get(i).getLanguage(), this.getCurrentContext());
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public final void visitLeave(LatexList list) {
        this.setBlocked(false);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }
}

