/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service.heuristic;

import java.util.Map;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.common.PluginExecutor;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.logic.model.DynamicDirectInterpreter;
import org.qedeq.kernel.bo.logic.model.DynamicModel;
import org.qedeq.kernel.bo.logic.model.FourDynamicModel;
import org.qedeq.kernel.bo.logic.model.FunctionConstant;
import org.qedeq.kernel.bo.logic.model.HeuristicException;
import org.qedeq.kernel.bo.logic.model.PredicateConstant;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginBo;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Latex;
import org.qedeq.kernel.se.base.module.LatexList;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.base.module.VariableList;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.list.DefaultAtom;
import org.qedeq.kernel.se.dto.list.DefaultElementList;

public final class DynamicHeuristicCheckerExecutor
extends ControlVisitor
implements PluginExecutor {
    private static final Class CLASS = DynamicHeuristicCheckerExecutor.class;
    private final DynamicDirectInterpreter interpreter;

    DynamicHeuristicCheckerExecutor(PluginBo plugin, KernelQedeqBo qedeq, Map parameters) {
        super(plugin, qedeq);
        String method = "DynamicHeuristicChecker(PluginBo, QedeqBo, Map)";
        String modelClass = parameters != null ? (String)parameters.get("model") : null;
        DynamicModel model = null;
        if (modelClass != null && modelClass.length() > 0) {
            try {
                Class<?> cl = Class.forName(modelClass);
                model = (DynamicModel)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                Trace.fatal(CLASS, this, "DynamicHeuristicChecker(PluginBo, QedeqBo, Map)", "Model class not in class path: " + modelClass, e);
            }
            catch (InstantiationException e) {
                Trace.fatal(CLASS, this, "DynamicHeuristicChecker(PluginBo, QedeqBo, Map)", "Model class could not be instanciated: " + modelClass, e);
            }
            catch (IllegalAccessException e) {
                Trace.fatal(CLASS, this, "DynamicHeuristicChecker(PluginBo, QedeqBo, Map)", "Programming error, access for instantiation failed for model: " + modelClass, e);
            }
            catch (RuntimeException e) {
                Trace.fatal(CLASS, this, "DynamicHeuristicChecker(PluginBo, QedeqBo, Map)", "Programming error, instantiation failed for model: " + modelClass, e);
            }
        }
        if (model == null) {
            model = new FourDynamicModel();
        }
        this.interpreter = new DynamicDirectInterpreter(qedeq, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executePlugin() {
        String method = "executePlugin()";
        String ref = "\"" + IoUtility.easyUrl(this.getQedeqBo().getUrl()) + "\"";
        try {
            QedeqLog.getInstance().logRequest("Dynamic heuristic test for " + ref);
            try {
                KernelContext.getInstance().checkModule(this.getQedeqBo().getModuleAddress());
            }
            catch (Exception e) {
                Trace.trace(CLASS, "executePlugin()", e);
            }
            this.traverse();
            QedeqLog.getInstance().logSuccessfulReply("Heuristic test succesfull for " + ref);
        }
        catch (SourceFileExceptionList e) {
            String msg = "Test failed for " + ref;
            Trace.fatal(CLASS, this, "executePlugin()", msg, e);
            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "executePlugin()", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Test failed for " + ref, "unexpected problem: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        finally {
            this.getQedeqBo().addPluginErrorsAndWarnings(this.getPlugin(), this.getErrorList(), this.getWarningList());
        }
        return null;
    }

    private void test(Element test) {
        try {
            if (!this.isTautology(this.getCurrentContext(), test)) {
                this.addWarning(new HeuristicException(77007, "no tautology in our model (\"" + this.interpreter.getModel().getName() + "\")", this.getCurrentContext()));
            }
        }
        catch (HeuristicException h) {
            if (this.getCurrentContext().getModuleLocation().equals(h.getContext().getModuleLocation())) {
                this.addWarning(h);
            } else {
                this.addWarning(new HeuristicException(h.getErrorCode(), h.getMessage(), this.getCurrentContext()));
            }
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "test(Element)", "unexpected runtime exception", e);
            if (e.getCause() != null && e.getCause() instanceof HeuristicException) {
                HeuristicException h = (HeuristicException)e.getCause();
                this.addWarning(new HeuristicException(h.getErrorCode(), h.getMessage(), this.getCurrentContext()));
            }
            this.addWarning(new HeuristicException(77777, "runtime problem: " + e, this.getCurrentContext()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTautology(ModuleContext moduleContext, Element formula) throws HeuristicException {
        boolean result = true;
        ModuleContext context = moduleContext;
        try {
            while ((result &= this.interpreter.calculateValue(new ModuleContext(context), formula)) && this.interpreter.next()) {
            }
        }
        finally {
            this.interpreter.clearVariables();
        }
        return result;
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        System.out.println("\ttesting axiom");
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Element test = axiom.getFormula().getElement();
            this.test(test);
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        String method = "visitEnter(PredicateDefinition)";
        if (definition == null) {
            return;
        }
        System.out.println("\ttesting predicate definition");
        String context = this.getCurrentContext().getLocationWithinModule();
        try {
            PredicateConstant predicate = new PredicateConstant(definition.getName(), Integer.parseInt(definition.getArgumentNumber()));
            if (definition.getFormula() != null) {
                this.setLocationWithinModule(context + ".getFormula().getElement()");
                VariableList variableList = definition.getVariableList();
                int size = variableList == null ? 0 : variableList.size();
                Element[] elements = new Element[size + 1];
                elements[0] = new DefaultAtom(definition.getName());
                for (int i = 0; i < size; ++i) {
                    elements[i + 1] = variableList.get(i);
                }
                DefaultElementList left = new DefaultElementList("PREDCON", elements);
                Element[] compare = new Element[]{left, definition.getFormula().getElement()};
                this.setLocationWithinModule(context);
                this.test(new DefaultElementList("EQUI", compare));
            } else if (!this.interpreter.hasPredicateConstant(predicate)) {
                this.setLocationWithinModule(context + ".getName()");
                this.addWarning(new HeuristicException(77082, "unknown predicate constant: " + predicate, this.getCurrentContext()));
            }
        }
        catch (NumberFormatException e) {
            Trace.fatal(CLASS, this, "visitEnter(PredicateDefinition)", "not suported argument number: " + definition.getArgumentNumber(), e);
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            this.addWarning(new HeuristicException(77100, "unknown format for argument size: " + definition.getArgumentNumber(), this.getCurrentContext()));
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        String method = "visitEnter(FunctionDefinition)";
        if (definition == null) {
            return;
        }
        System.out.println("\ttesting function definition");
        String context = this.getCurrentContext().getLocationWithinModule();
        try {
            FunctionConstant function = new FunctionConstant(definition.getName(), Integer.parseInt(definition.getArgumentNumber()));
            if (definition.getTerm() != null) {
                this.setLocationWithinModule(context + ".getTerm().getElement()");
                VariableList variableList = definition.getVariableList();
                int size = variableList == null ? 0 : variableList.size();
                Element[] elements = new Element[size + 1];
                elements[0] = new DefaultAtom(definition.getName());
                for (int i = 0; i < size; ++i) {
                    elements[i + 1] = variableList.get(i);
                }
                DefaultElementList left = new DefaultElementList("FUNCON", elements);
                Element[] equal = new Element[3];
                equal[0] = new DefaultAtom("equal");
                if (this.getQedeqBo().getExistenceChecker() != null && this.getQedeqBo().getExistenceChecker().identityOperatorExists()) {
                    equal[0] = new DefaultAtom(this.getQedeqBo().getExistenceChecker().getIdentityOperator());
                }
                equal[1] = left;
                equal[2] = definition.getTerm().getElement();
                this.setLocationWithinModule(context);
                this.test(new DefaultElementList("PREDCON", equal));
            } else if (!this.interpreter.hasFunctionConstant(function)) {
                this.setLocationWithinModule(context + ".getName()");
                this.addWarning(new HeuristicException(77092, "unknown function constant: " + function, this.getCurrentContext()));
            }
        }
        catch (NumberFormatException e) {
            Trace.fatal(CLASS, this, "visitEnter(FunctionDefinition)", "not suported argument number: " + definition.getArgumentNumber(), e);
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            this.addWarning(new HeuristicException(77100, "unknown format for argument size: " + definition.getArgumentNumber(), this.getCurrentContext()));
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Node node) {
        System.out.println(this.getLatexListEntry(node.getTitle()) + " " + node.getId());
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        System.out.println("\ttesting proposition");
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Element test = proposition.getFormula().getElement();
            this.test(test);
        }
        this.setLocationWithinModule(context);
    }

    public void visitLeave(Proposition definition) {
    }

    public void visitEnter(FormalProofLine line) throws ModuleDataException {
        if (line == null) {
            return;
        }
        System.out.println("\t\ttesting line " + line.getLabel());
        String context = this.getCurrentContext().getLocationWithinModule();
        if (line.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Element test = line.getFormula().getElement();
            this.test(test);
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(FormalProofLine line) {
        this.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        this.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.setBlocked(false);
    }

    public String getExecutionActionDescription() {
        return super.getExecutionActionDescription() + "\n" + this.interpreter.toString();
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    private String getLatexListEntry(LatexList list) {
        int i;
        if (list == null) {
            return "";
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || !"en".equals(list.get(i).getLanguage())) continue;
            return this.getLatex(list.get(i));
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || list.get(i).getLanguage() != null) continue;
            return this.getLatex(list.get(i));
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            return this.getLatex(list.get(i));
        }
        return "";
    }

    private String getLatex(Latex latex) {
        String result = latex.getLatex();
        if (result == null) {
            result = "";
        }
        result = result.trim();
        result = result.replaceAll("\\\\index\\{.*\\}", "");
        return result.trim();
    }
}

