/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.common.PluginExecutor;
import org.qedeq.kernel.bo.common.ServiceProcess;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.PluginBo;
import org.qedeq.kernel.bo.service.ServiceProcessManager;

public class PluginManager {
    private static final Class CLASS = PluginManager.class;
    private final Map id2plugin = new HashMap();
    private final List plugins = new ArrayList();
    private ServiceProcessManager processManager;

    public PluginManager(ServiceProcessManager processManager) {
        this.processManager = processManager;
    }

    synchronized PluginBo[] getPlugins() {
        return this.plugins.toArray(new PluginBo[0]);
    }

    synchronized void addPlugin(String pluginClass) {
        String method = "addPlugin";
        PluginBo plugin = null;
        try {
            Class<?> cl = Class.forName(pluginClass);
            plugin = (PluginBo)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            Trace.fatal(CLASS, this, "addPlugin", "Plugin class not in class path: " + pluginClass, e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            Trace.fatal(CLASS, this, "addPlugin", "Plugin class could not be istanciated: " + pluginClass, e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            Trace.fatal(CLASS, this, "addPlugin", "Programming error, access for instantiation failed for plugin: " + pluginClass, e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "addPlugin", "Programming error, instantiation failed for plugin: " + pluginClass, e);
            throw new RuntimeException(e);
        }
        this.addPlugin(plugin);
    }

    synchronized void addPlugin(PluginBo plugin) {
        if (this.id2plugin.get(plugin.getPluginId()) != null) {
            PluginBo oldPlugin = (PluginBo)this.id2plugin.get(plugin.getPluginId());
            IllegalArgumentException e = new IllegalArgumentException("plugin with that name already added: " + oldPlugin.getPluginId() + ": " + plugin.getPluginDescription());
            Trace.fatal(CLASS, this, "addPlugin", "Programing error", e);
            throw e;
        }
        this.id2plugin.put(plugin.getPluginId(), plugin);
        this.plugins.add(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object executePlugin(String id, KernelQedeqBo qedeq, Map parameters) {
        PluginBo plugin = (PluginBo)this.id2plugin.get(id);
        if (plugin == null) {
            String message = "Kernel does not know about plugin: ";
            RuntimeException e = new RuntimeException("Kernel does not know about plugin: " + id);
            Trace.fatal(CLASS, this, "executePlugin", "Kernel does not know about plugin: " + id, e);
            throw e;
        }
        HashMap para = parameters;
        if (parameters == null) {
            para = new HashMap();
        }
        ServiceProcess process = this.processManager.createProcess(plugin, qedeq, para);
        process.setBlocked(true);
        KernelQedeqBo kernelQedeqBo = qedeq;
        synchronized (kernelQedeqBo) {
            Object object;
            process.setBlocked(false);
            try {
                PluginExecutor exe = plugin.createExecutor(qedeq, para);
                process.setExecutor(exe);
                Object result = exe.executePlugin();
                process.setSuccessState();
                object = result;
                if (process.isRunning()) {
                    process.setFailureState();
                }
                process.setExecutor(null);
            }
            catch (Throwable throwable) {
                if (process.isRunning()) {
                    process.setFailureState();
                }
                process.setExecutor(null);
                throw throwable;
            }
            return object;
        }
    }

    public void clearAllPluginResults(KernelQedeqBo qedeq) {
        qedeq.clearAllPluginErrorsAndWarnings();
    }
}

