/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.service;

import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.module.ControlVisitor;
import org.qedeq.kernel.bo.module.Element2Latex;
import org.qedeq.kernel.bo.module.Element2Utf8;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.ModuleLabels;
import org.qedeq.kernel.bo.service.Element2LatexImpl;
import org.qedeq.kernel.bo.service.Element2Utf8Impl;
import org.qedeq.kernel.se.base.module.Axiom;
import org.qedeq.kernel.se.base.module.FunctionDefinition;
import org.qedeq.kernel.se.base.module.Import;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.PredicateDefinition;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Rule;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.Plugin;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.module.NodeVo;

public final class ModuleLabelsCreator
extends ControlVisitor {
    private static final Class CLASS = ModuleLabelsCreator.class;
    private ModuleLabels labels;
    private Element2LatexImpl converter;
    private Element2Utf8Impl textConverter;

    public ModuleLabelsCreator(Plugin plugin, KernelQedeqBo prop) {
        super(plugin, prop);
    }

    public void visitEnter(Import imp) {
        try {
            this.labels.addLabel(this.getCurrentContext(), imp.getLabel());
        }
        catch (ModuleDataException me) {
            this.addError(me);
            Trace.trace(CLASS, (Object)this, "visitEnter(Import)", (Throwable)me);
        }
    }

    public void visitEnter(Axiom axiom) {
        this.setBlocked(true);
    }

    public void visitEnter(Proposition proposition) {
        this.setBlocked(true);
    }

    public void visitEnter(FunctionDefinition funcDef) {
        this.setBlocked(true);
        this.labels.addFunction(funcDef, this.getCurrentContext());
    }

    public void visitEnter(PredicateDefinition predDef) {
        this.setBlocked(true);
        this.labels.addPredicate(predDef, this.getCurrentContext());
    }

    public void visitEnter(Rule rule) {
        this.setBlocked(true);
    }

    public void visitLeave(Node node) {
        try {
            this.labels.addNode(this.getCurrentContext(), (NodeVo)node, this.getQedeqBo(), this.getCurrentNumbers());
        }
        catch (ModuleDataException me) {
            this.addError(me);
            Trace.trace(CLASS, (Object)this, "visitEnter(Node)", (Throwable)me);
        }
        this.setBlocked(false);
    }

    public void createLabels() throws SourceFileExceptionList {
        if (this.labels == null) {
            this.labels = new ModuleLabels();
            this.converter = new Element2LatexImpl(this.labels);
            this.textConverter = new Element2Utf8Impl(this.converter);
            this.traverse();
        }
    }

    public ModuleLabels getLabels() {
        return this.labels;
    }

    public Element2Latex getConverter() {
        return this.converter;
    }

    public Element2Utf8 getTextConverter() {
        return this.textConverter;
    }
}

